static char mainmenu_rcsid[]="mainmenu.c,v 1.2 1994/11/28 16:55:07 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  mainmenu.c,v
 * Revision 1.2  1994/11/28  16:55:07  kerce
 * *** empty log message ***
 *
 * Revision 1.6  1994/09/13  18:01:59  raju
 * prototyepe declarations
 *
 * Revision 1.5  1994/08/21  02:58:05  raju
 * *** empty log message ***
 *
 * Revision 1.4  1994/07/15  11:58:13  raju
 * Added preferences module
 *
 * Revision 1.3  1994/07/11  16:24:30  raju
 * masked off the rest of the unimplimented menus
 *
 * Revision 1.2  1994/07/11  16:00:24  raju
 * just changed qacct to XtNsensitive False
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 **********************************************************/

#include "globals.h"
#define LEGEND_INFO "R/A - Running/Available  Load - Load Average\nStates: a - Alarm  c - Suspend on Completion  d - Disabled  e - Enabled  h - Held\nn - No Hold  r - Running  s - Suspended  u - Unknown  x - Exiting"

struct optionstruct qusagemenu[]={
  0,NULL,NULL,(int)NULL,NULL,NULL
};


#ifdef NOPROTO
XtCallbackProc pb_mainmenu();
int closemainmenuwin();
int initmainmenu();
static void Quit ();
#else
XtCallbackProc pb_mainmenu(Widget ,caddr_t ,caddr_t );
int closemainmenuwin();
int initmainmenu(Widget );
static void Quit (void);
#endif


static Widget          command_menu;
static Widget          legend_menu;
static Widget          widget_qacct;
static Widget          widget_qalter;
static Widget          widget_qconf;
static Widget          widget_qdel;
static Widget          widget_qhold;
static Widget          widget_qmod;
static Widget          widget_qmove;
static Widget          widget_qmsg;
static Widget          widget_qrerun;
static Widget          widget_qrls;
static Widget          widget_qselect;
static Widget          widget_qsh;
static Widget          widget_qsig;
static Widget          widget_qstat;
static Widget          widget_qsub;
static Widget          widget_qusage;
static Widget          widget_cwd;
static Widget          widget_shell;
static Widget          widget_setup;
static Widget          widget_refresh;
static Widget          widget_redisplay;
static Widget          widget_preferences;
static Widget          widget_quit;
static Widget          widget_separator;
static Widget          widget_running;
static Widget          widget_idle;
static Widget          widget_suspended;
static Widget          widget_unknown;
static Widget          widget_alarm;
static Widget          openwidget=0;

static XtActionsRec actions[] = {
        {"quit", Quit},
        {NULL, NULL}
};

#ifdef NOPROTO
static void Quit ()
#else
static void Quit (void)
#endif
{
  exit(1);
}

/***********************************************************
 * pb_mainmenu - Activate callback
 */
XtCallbackProc pb_mainmenu(Widget w,caddr_t client_data,caddr_t call_data)
{
  Arg             args[32];
  int             ii;

  /*
   * If the user is clicking on the button and the window
   * is already open, then close it
   */
  if(openwidget==w) {
    closemainmenuwin();
  }
  /*
   * Else we need to open corresponding main menu window
   */
  else {
    /*
     * Close any other main menu if it is open unless we're
     * refreshing the screen or resiplaying the icons.
     */
    if(openwidget && w!=widget_refresh && w!=widget_redisplay) {
      closemainmenuwin();
    }
    
    if(w!=widget_refresh && w!=widget_redisplay) {
      ii=0;
      XtSetArg(args[ii],XtNforeground,defaultbackground(w)); ii++;
      XtSetArg(args[ii],XtNbackground,defaultforeground(w)); ii++;
      XtSetValues(w,args,ii);
    }

    if(w==widget_qacct) {
      openwidget=w;
      openwidget_qacct();
    }
    else if(w==widget_qalter) {
      openwidget=w;
      openwidget_qalter();
    }
    else if(w==widget_qconf) {
      openwidget=w;
      openwidget_qconf();
    }
    else if(w==widget_qdel) {
      openwidget=w;
      openwidget_qdel();
    }
    else if(w==widget_qhold) {
      openwidget=w;
      openwidget_qhold();
    }
    else if(w==widget_qmod) {
      openwidget=w;
      openwidget_qmod();
    }
    else if(w==widget_qmove) {
      openwidget=w;
      openwidget_qmove();
    }
    else if(w==widget_qmsg) {
      openwidget=w;
      openwidget_qmsg();
    }
    else if(w==widget_qrerun) {
      openwidget=w;
      openwidget_qrerun();
    }
    else if(w==widget_qrls) {
      openwidget=w;
      openwidget_qrls();
    }
    else if(w==widget_qselect) {
      openwidget=w;
      openwidget_qselect();
    }
    else if(w==widget_qsh) {
      openwidget=w;
      openwidget_qsh();
    }
    else if(w==widget_qsig) {
      openwidget=w;
      openwidget_qsig();
    }
    else if(w==widget_qstat) {
      openwidget=w;
      openwidget_qstat();
    }
    else if(w==widget_qsub) {
      openwidget=w;
      openwidget_qsub();
    }
    else if(w==widget_qusage) {
      openwidget=w;
       buildcommand(QUSAGE_BINARY,qusagemenu,0);
    }
    else if(w==widget_cwd) {
      openwidget=w;
      openwidget_cwd();
    }
    else if(w==widget_shell) {
      openwidget=w;
      openwidget_shell();
    }
    else if(w==widget_setup) {
      openwidget=w;
      openwidget_setup();
    }
    else if(w==widget_refresh) {
      printf("refreshing icons - "); fflush(stdout);
      refreshicons();
      printf("done at  ");
      printdate();
    }
    else if(w==widget_redisplay) {
      printf("redisplaying "); fflush(stdout);
      UnMapIconWin ();
      refreshicons ();
      MapIconWin ();
    }
    else if(w==widget_preferences) {
      printf("preferences\n "); fflush(stdout);
      openwidget=w;
      openwidget_preferences();
    }
    else if(w=widget_quit) {
      Quit();
    }
  }

}


/***********************************************************
 * closemainmenuwin - Close a menu for a main menu option
 */
int closemainmenuwin()
{
  Arg             args[32];
  int             ii;

  /*
   * If no main menu is open then just return
   */
  if(openwidget==0)
    return;

  if(openwidget!=widget_refresh) {
    ii=0;
    XtSetArg(args[ii],XtNforeground,defaultbackground(openwidget)); ii++;
    XtSetArg(args[ii],XtNbackground,defaultforeground(openwidget)); ii++;
    XtSetValues(openwidget,args,ii);
  }
/*
*/

  /*
   * Find out which main menu is open
   */
  if(openwidget==widget_qacct) {
    closewidget_qacct();
  }
  if(openwidget==widget_qalter) {
    closewidget_qalter();
  }
  else if(openwidget==widget_qconf) {
    closewidget_qconf();
  }
  else if(openwidget==widget_qdel) {
    closewidget_qdel();
  }
  if(openwidget==widget_qhold) {
    closewidget_qhold();
  }
  else if(openwidget==widget_qmod) {
    closewidget_qmod();
  }
  if(openwidget==widget_qmove) {
    closewidget_qmove();
  }
  if(openwidget==widget_qmsg) {
    closewidget_qmsg();
  }
  if(openwidget==widget_qrerun) {
    closewidget_qrerun();
  }
  if(openwidget==widget_qrls) {
    closewidget_qrls();
  }
  if(openwidget==widget_qselect) {
    closewidget_qselect();
  }
  else if(openwidget==widget_qsh) {
    closewidget_qsh();
  }
  if(openwidget==widget_qsig) {
    closewidget_qsig();
  }
  else if(openwidget==widget_qstat) {
    closewidget_qstat();
  }
  else if(openwidget==widget_qsub) {
    closewidget_qsub();
  }
  else if(openwidget==widget_qusage) {
	/*nothing*/
  }
  else if(openwidget==widget_cwd) {
    closewidget_cwd();
  }
  else if(openwidget==widget_shell) {
    closewidget_shell();
  }
  else if(openwidget==widget_setup) {
    closewidget_setup();
  }
  else if(openwidget==widget_preferences) {
    closewidget_preferences();
  }
  /*
   * Set to zero
   */
  openwidget=0;

}




/***********************************************************
 * initmainmenu - Setup the main menu and its buttons
 */
int initmainmenu(Widget paned)
{
  Arg             args[32];
  int             ii;
  
  ii=0;
  XtSetArg(args[ii],XtNorientation,XtorientVertical); ii++;
  command_menu=XtCreateManagedWidget("command_menu",boxWidgetClass,paned,args,ii);
  
  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qacct"); ii++;
  XtSetArg(args[ii],XtNsensitive,(Boolean)FALSE); ii++;
  widget_qacct=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
/*
  XtAddCallback(widget_qacct,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qacct_dialog (widget_qacct,NULL,NULL);
*/

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qalter"); ii++;
  widget_qalter=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_qalter,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qalter_dialog (widget_qalter,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qconf"); ii++;
  widget_qconf=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_qconf,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qconf_dialog(widget_qconf,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qdel"); ii++;
  widget_qdel=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_qdel,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qdel_dialog (widget_qdel,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qhold"); ii++;
  XtSetArg(args[ii],XtNsensitive,(Boolean)FALSE); ii++;
  widget_qhold=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
/*
  XtAddCallback(widget_qhold,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qhold_dialog (widget_qhold,NULL,NULL);
*/

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qmod"); ii++;
  widget_qmod=XtCreateManagedWidget("push",commandWidgetClass,
				command_menu,args,ii);
  XtAddCallback(widget_qmod,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qmod_dialog (widget_qmod,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qmove"); ii++;
  XtSetArg(args[ii],XtNsensitive,(Boolean)FALSE); ii++;
  widget_qmove=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
/*
  XtAddCallback(widget_qmove,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qmove_dialog (widget_qmove,NULL,NULL);
*/

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qmsg"); ii++;
  XtSetArg(args[ii],XtNsensitive,(Boolean)FALSE); ii++;
  widget_qmsg=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
/*
  XtAddCallback(widget_qmsg,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qmsg_dialog (widget_qmsg,NULL,NULL);
*/

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qrerun"); ii++;
  XtSetArg(args[ii],XtNsensitive,(Boolean)FALSE); ii++;
  widget_qrerun=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
/*
  XtAddCallback(widget_qrerun,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qrerun_dialog (widget_qrerun,NULL,NULL);
*/

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qrls"); ii++;
  XtSetArg(args[ii],XtNsensitive,(Boolean)FALSE); ii++;
  widget_qrls=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
/*
  XtAddCallback(widget_qrls,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qrls_dialog (widget_qrls,NULL,NULL);
*/

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qselect"); ii++;
  XtSetArg(args[ii],XtNsensitive,(Boolean)FALSE); ii++;
  widget_qselect=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
/*
  XtAddCallback(widget_qselect,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qselect_dialog (widget_qselect,NULL,NULL);
*/

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qsh"); ii++;
  XtSetArg(args[ii],XtNsensitive,(Boolean)FALSE); ii++;
  widget_qsh=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
/*
  XtAddCallback(widget_qsh,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qsh_dialog (widget_qsh,NULL,NULL);
*/

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qsig"); ii++;
  XtSetArg(args[ii],XtNsensitive,(Boolean)FALSE); ii++;
  widget_qsig=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
/*
  XtAddCallback(widget_qsig,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qsig_dialog (widget_qsig,NULL,NULL);
*/

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qstat"); ii++;
  widget_qstat=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_qstat,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qstat_dialog (widget_qstat,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qsub"); ii++;
  widget_qsub=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_qsub,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_qsub_dialog (widget_qsub,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"qusage"); ii++;
  widget_qusage=XtCreateManagedWidget("push",commandWidgetClass,
				command_menu,args,ii);
  XtAddCallback(widget_qusage,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"cwd"); ii++;
  widget_cwd=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_cwd,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_cwd_dialog (widget_cwd,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"shell"); ii++;
  widget_shell=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_shell,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_shell_dialog (widget_shell,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"setup"); ii++;
  widget_setup=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_setup,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_setup_dialog (widget_setup,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"refresh"); ii++;
  widget_refresh=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_refresh,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"redisplay"); ii++;
  widget_redisplay=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_redisplay,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"preferences"); ii++;
  widget_preferences=XtCreateManagedWidget("push",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_preferences,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  create_preferences_dialog (widget_preferences,NULL,NULL);

  ii=0;
  XtSetArg(args[ii],XtNlabel,(String)"quit"); ii++;
  widget_quit=XtCreateManagedWidget("quit",commandWidgetClass,
					command_menu,args,ii);
  XtAddCallback(widget_quit,XtNcallback,(XtCallbackProc)pb_mainmenu,(XtPointer)NULL);
  
  ii=0;
  XtSetArg(args[ii],XtNorientation,XtorientVertical); ii++;
  legend_menu=XtCreateManagedWidget("legend_menu",boxWidgetClass,paned,args,ii);
    
    ii=0;
    XtSetArg(args[ii],XtNbackground,getpixelval(getrunningcolor())); ii++;
    XtSetArg(args[ii],XtNforeground,getpixelval("black")); ii++;
    XtSetArg(args[ii],XtNlabel,(String)"Running"); ii++;
    widget_running=XtCreateManagedWidget("push",labelWidgetClass,
					legend_menu,args,ii);

    ii=0;
    XtSetArg(args[ii],XtNbackground,getpixelval(getidlecolor())); ii++;
    XtSetArg(args[ii],XtNforeground,getpixelval("black")); ii++;
    XtSetArg(args[ii],XtNlabel,(String)"Idle"); ii++;
    widget_idle=XtCreateManagedWidget("push",labelWidgetClass,
					legend_menu,args,ii);

    ii=0;
    XtSetArg(args[ii],XtNbackground,getpixelval(getsuspendedcolor())); ii++;
    XtSetArg(args[ii],XtNforeground,getpixelval("black")); ii++;
    XtSetArg(args[ii],XtNlabel,(String)"Suspended"); ii++;
    widget_suspended=XtCreateManagedWidget("push",labelWidgetClass,
					legend_menu,args,ii);

    ii=0;
    XtSetArg(args[ii],XtNbackground,getpixelval(getsuscompcolor())); ii++;
    XtSetArg(args[ii],XtNforeground,getpixelval("black")); ii++;
    XtSetArg(args[ii],XtNlabel,(String)"Suspend on Completion"); ii++;
    widget_unknown=XtCreateManagedWidget("push",labelWidgetClass,
					legend_menu,args,ii);
    ii=0;
    XtSetArg(args[ii],XtNbackground,getpixelval(getalarmcolor())); ii++;
    XtSetArg(args[ii],XtNforeground,getpixelval("black")); ii++;
    XtSetArg(args[ii],XtNlabel,(String)"Alarm"); ii++;
    widget_alarm=XtCreateManagedWidget("push",labelWidgetClass,
					legend_menu,args,ii);

    ii=0;
    XtSetArg(args[ii],XtNforeground,getpixelval("black")); ii++;
    XtSetArg(args[ii],XtNlabel,(String)LEGEND_INFO); ii++;
    widget_alarm=XtCreateManagedWidget("push",labelWidgetClass,
					legend_menu,args,ii);
    XtAppAddActions(get_app_context(), actions, XtNumber(actions));

}





