!/* SPIM S20 MIPS simulator.
   X interface to SPIM
   Copyright (C) 1990 by James Larus (larus@cs.wisc.edu), James R. Goodman,
   and Alan Yuen-wui Siow.

   SPIM is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   SPIM is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to James R.
   Larus, Computer Sciences Department, University of Wisconsin--Madison,
   1210 West Dayton Street, Madison, WI 53706, USA or to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */


/* $Header: /u/l/a/larus/Software/SPIM/src/RCS/xutils.c,v 3.3 1999/01/08 00:32:54 larus Exp $
 */


#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/TextP.h>

#include <stdio.h>

#include "xspim.h"


/* Exported functions: */

XawTextPosition TextGetLastPos ();
void writeText ();



void
writeText (w, s)
     Widget w;
     char *s;
{
  TextWidget ctx = (TextWidget) w;
  XawTextBlock textblock;
  XawTextPosition startPos;

  if (!s || strcmp (s, "") == 0) return;

  textblock.firstPos = 0;
  textblock.length = strlen (s);
  textblock.ptr = s;
  textblock.format = FMT8BIT;

  startPos = TextGetLastPos (w) + 1;

  XawTextReplace (w, startPos, startPos, &textblock);
  XawTextSetInsertionPoint (w, ctx->text.lastPos);
}


XawTextPosition
TextGetLastPos (w)
     Widget w;
{
  TextWidget ctx = (TextWidget) w;

  ctx->text.insertPos = ctx->text.lastPos;
  return (ctx->text.lastPos);
}
