/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdecIrange (const char String[], int *Ival1, int *Ival2)

Purpose:
  Decode a range specification for integer values

Description:
  This routine decodes a string specifying a range of integer values.  The
  range is specified in the form "Iv" or "Iv1:Iv2", for example "-23 : 45".
  Optional white-space (as defined by isspace) can surround the values.  For
  the case of a single value Iv, this is equivalent to the range "Iv:Iv".  If
  an error is encountered, neither output value is set.

Parameters:
  <-  int STdecIrange
      Error status, 0 for no error, 1 for error
   -> const char String[]
      Input string
  <-  int *Ival1
      First value
  <-  int *Ival2
      Second value

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.21 $  $Date: 1997/10/31 02:14:07 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecIrange.c 1.21 1997/10/31 libtsp-v3r0 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/STmsg.h>

#define MAXC	23


int
STdecIrange (String, Ival1, Ival2)

     const char String[];
     int *Ival1;
     int *Ival2;

{
  int status;
  int ival1, ival2;

  /* Decode the range values */
  status = STdecPair (String, ":", 'I', (void *) (&ival1), (void *) (&ival2));

  if (status == 0) {
    *Ival1 = ival1;
    *Ival2 = ival1;
  }
  else if (status == 3) {
    *Ival1 = ival1;
    *Ival2 = ival2;
  }
  else if (status >= 0) {
    UTwarn ("STdecIrange - %s: \"%s\"", STM_DataErr, STstrDots (String, MAXC));
    status = -1;
  }

  return (status < 0);
}
