.TH "IWT2D" 2 " 01 June 1997" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
IWT2D - 2D Inverse Disrete Wavelet Transform
.sp
Author: Bertrand Guiheneuf
.sp
This routine computes \fIinverse discrete wavelet transforms\fP of a 2D real signal. Two inverse transforms are possible : Orthogonal and Biorthogonal
.sp
.sp
.SH Usage
\f(CR[\fPresult\f(CR]\fP=IWT2D(wt,\f(CR[\fPf\f(CR]\fP)
.SH Input parameters


.RS

.TP
o 
\fBwt\fP : real unidimensional matrix \f(CR[\fPm,n\f(CR]\fP  
Contains the wavelet transform (obtained with FWT2D). 

.TP
o 
\fBf\fP : real unidimensional matrix \f(CR[\fPm,n\f(CR]\fP  
Synthesis filter. 
.RE

.SH Output parameters


.RS

.TP
o 
\fBresult\fP : real matrix 
Result of the reconstruction. 
.RE

.SH Description
.SH Introduction 
The wavelet transform is an invertible linear transform. This routines is the inverse transform. For details on the algorithm procedure, see FWT2D.
.SH Parameters  
\fIInput\fP must be a real matrix. It's generally obtained with FWT2D but can be created "by hand". In that case, it's strongly recommended to decompose a null signal with FWT2D.
\fIf\fP is the linear FIR filter to use for the reconstruction. It is only necessary if the analysis filter had been obtained with MakeCQF() and the reconstruction filter had not been passed to FWT2D. If not specified the filter given in the synthesis is used. (See FWT2D).
\fIresult\fP is the reconstructed signal. It has the same dimensions as the original one.
.SH Algorithm details 
Convolutions are computed through discrete linear convolutions in time domain. No FFT is used. 
The signal is mirrored at its boundaries. .SH Example
a=rand(256,256);
q=MakeQMF('daubechies',4);
wt,wti,wtl = FWT2D(a,8,q);
wt=abs(wt);
result=IWT2D(wt);.SH References
\fBMeyer Y.\fP : Wavelets, Algorithms & Applications, SIAM.
\fBMeyer Y.\fP : Ondelettes et Operateurs (I) : Hermann, Paris
\fBDaubechies I.\fP : Ten Lectures on Wavelets, CBMS-NSF Regional conference series in applied mathematics.
.SH See Also
FWT2D, MakeQMF, MakeCQF, WT2Dext, WT2DVisu 
