.TH time_id 4 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
time_id - SISO least square identification
.SH CALLING SEQUENCE
.nf
[H [,err]]=time_id(n,u,y)
.fi
.SH PARAMETERS
.TP 10
n 
: order of transfer
.TP 10
u  
: one of the following
.RS
.TP 12
u1 
: a vector of inputs to the system
.TP
"impuls"
: if y is an impulse response
.TP
"step"
: if y is a step response.
.RE
.TP 10
y 
: vector of response. 
.TP
H 
: rational function with degree n denominator and 
degree n-1 numerator if y(1)==0 or rational function with degree n
denominator and  numerator if y(1)<>0.
.TP
err
: \fV||y - impuls(H,npt)||^2\fR, where \fVimpuls(H,npt)\fR are
the \fVnpt\fR first coefficients of impulse response of \fVH\fR
.SH DESCRIPTION
Identification of discrete time response. If \fVy\fR is strictly
proper (\fVy(1)=0\fR) then \fVtime_id\fR computes the least square
solution of the linear equation:  \fVDen*y-Num*u=0\fR with the
constraint  \fVcoeff(Den,n):=1\fR. if \fVy(1)~=0\fR then the algorithm
first computes the proper part solution and then add  y(1) to the solution
.SH EXAMPLE
.nf
z=poly(0,'z');
h=(1-2*z)/(z^2-0.5*z+5)
rep=[0;ldiv(h('num'),h('den'),20)]; //impulse response
H=time_id(2,'impuls',rep)
//  Same example with flts and u
u=zeros(1,20);u(1)=1;
rep=flts(u,tf2ss(h));        //impulse response
H=time_id(2,u,rep)
//  step response
u=ones(1,20);
rep=flts(u,tf2ss(h));     //step response.
H=time_id(2,'step',rep)
H=time_id(3,u,rep)    //with u as input and too high order required
.fi
.SH AUTHOR
Serge Steer INRIA
.SH SEE ALSO
imrep2ss, arl2, armax, frep2tf
