.TH trzeros 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
trzeros - transmission zeros and normal rank
.SH CALLING SEQUENCE
.nf
[tr]=trzeros(Sl)
[nt,dt,rk]=trzeros(Sl)
.fi
.SH PARAMETERS
.TP
Sl
: linear system (\fVsyslin\fR list)
.TP
nt
: complex vectors
.TP
dt
: real vector
.TP
rk
: integer (normal rank of Sl)
.SH DESCRIPTION
Called with one output argument, \fVtrzeros(Sl)\fR returns the 
transmission zeros of the linear system \fVSl\fR.
.LP
\fVSl\fR may have a polynomial (but square) \fVD\fR matrix.
.LP 
Called with 2 output arguments, \fVtrzeros\fR returns the 
transmission zeros of the linear system \fVSl\fR as \fVtr=nt./dt\fR;
.LP
(Note that some components of \fVdt\fR may be zeros)
.LP
Called with 3 output arguments, \fVrk\fR  is the normal rank of \fVSl\fR
.LP
Transfer matrices are converted to state-space.
.LP
If \fVSl\fR is a (square) polynomial matrix \fVtrzeros\fR returns the 
roots of its determinant.
.LP
For usual state-space system \fVtrzeros\fR uses the state-space 
algorithm of Emami-Naeni & Van Dooren.
.LP
If \fVD\fR is invertible the transmission zeros are the eigenvalues
of the "\fVA\fR matrix" of the inverse system : \fVA - B*inv(D)*C\fR;
.LP
If \fVC*B\fR is invertible the transmission zeros are the eigenvalues
of \fVN*A*M\fR where \fVM*N\fR is a full rank factorization of 
\fVeye(A)-B*inv(C*B)*C\fR;
.LP
For systems with a polynomial \fVD\fR matrix zeros are 
calculated as the roots of the determinant of the system matrix.
.LP
Caution: the computed zeros are not always reliable, in particular
in case of repeated zeros.
.SH EXAMPLE
.nf
W1=ssrand(2,2,5);trzeros(W1)    //call trzeros
roots(det(systmat(W1)))         //roots of det(system matrix)
s=poly(0,'s');W=[1/(s+1);1/(s-2)];W2=(s-3)*W*W';[nt,dt,rk]=trzeros(W2);
St=systmat(tf2ss(W2));[Q,Z,Qd,Zd,numbeps,numbeta]=kroneck(St);
St1=Q*St*Z;rowf=(Qd(1)+Qd(2)+1):(Qd(1)+Qd(2)+Qd(3));
colf=(Zd(1)+Zd(2)+1):(Zd(1)+Zd(2)+Zd(3));
roots(St1(rowf,colf)), nt./dt     //By Kronecker form
.fi
.SH SEE ALSO
gspec, kroneck
