.TH diag 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
diag - diagonal including or extracting 
.SH CALLING SEQUENCE
.nf
[y]=diag(vm, [k])
.fi
.SH PARAMETERS
.TP 10
vm
: vector or matrix
.TP 10
k 
: integer (default value 0)
.TP 10
y
: vector or matrix
.SH DESCRIPTION
for \fVvm\fR a (row or column) n-vector \fVdiag(vm)\fR returns a diagonal
matrix with entries of \fVvm\fR along the main diagonal.
.LP
\fVdiag(vm,k)\fR is a  \fV(n+abs(k))x(n+abs(k))\fR matrix with the entries 
of \fVvm\fR  along the kth diagonal.  \fVk=0\fR  is the main diagonal \fVk>0\fR  
is for upper diagonals and \fVk<0\fR for lower diagonals.
.LP
For a matrix \fVvm\fR, \fVdiag(vm,k)\fR is the column vector made of entries
of the kth diagonal of \fVvm\fR.  \fVdiag(vm)\fR is the main diagonal of \fVvm\fR.
\fVdiag(diag(x))\fR  is a diagonal matrix.
.LP
To construct a diagonal linear system, use \fVsysdiag\fR.
.LP
Note that \fVeye(A).*A\fR returns a diagonal matrix made with the
diagonal entries of \fVA\fR. This is valid for any matrix (constant,
polynomial, rational, state-space linear system,...).

For example
.nf
diag(-m:m) +  diag(ones(2*m,1),1) +diag(ones(2*m,1),-1)
.fi
gives a tri-diagonal matrix of order \fV2*m+1\fR
.SH EXAMPLE
.nf
diag([1,2])
A=[1,2;3,4];
diag(A)
diag(A,1)
.fi
.SH SEE ALSO
sysdiag
