.TH colcomp 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
colcomp - column compression, kernel, nullspace
.SH CALLING SEQUENCE
.nf
[W,rk]=colcomp(A [,flag] [,tol])
.fi
.SH PARAMETERS
.TP 10
A
: real or complex matrix
.TP 10
flag
: character string
.TP 10
tol
:
real number
.TP
W
: square non-singular matrix (change of basis)
.TP
rk
: integer (rank of \fVA\fR)
.SH DESCRIPTION
Column compression of \fVA\fR: \fVAc = A*W\fR is 
column compressed i.e 
.LP
\fVAc=[0,Af]\fR with \fVAf\fR full column rank, 
rank(\fVAf\fR) = rank(\fVA\fR) = \fVrk\fR.
.LP
\fVflag\fR and \fVtol\fR are optional parameters: \fVflag = 'qr'\fR 
or \fV'svd'\fR (default is \fV'svd'\fR).
.LP
\fVtol\fR = tolerance parameter (of order \fV%eps\fR as default value).
.LP
The \fVma-rk\fR first columns of \fVW\fR span the kernel of \fVA\fR 
when \fVsize(A)=(na,ma)\fR
.SH EXAMPLE
.nf
A=rand(5,2)*rand(2,5);
[X,r]=colcomp(A);
norm(A*X(:,1:$-r),1)
.fi
.SH SEE ALSO
rowcomp, fullrf, fullrfk, kernel
.SH AUTHOR
F.D.

