.TH feval 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
feval - multiple evaluation
.SH CALLING SEQUENCE
.nf
[z]=feval(x,y,f)
[z]=feval(x,f)
.fi
.SH PARAMETERS
.TP 10
x,y
: two vectors
.TP 10
f
: function or character string (for Fortran call)
.SH DESCRIPTION
Multiple evaluation of a function for one or two arguments 
of vector type :
.TP 15
z=feval(x,f) 
returns the vector \fVz\fR defined by
.Vb z(i)=f(x(i))
.TP
z=feval(x,y,f) 
returns the matrix 
.Vb z, z(i,j)=f(x(i),y(j))

.LP
\fVf\fR is an external (function or routine) depending 
on one or two  arguments which are supposed to be real.
The result returned by \fVf\fR can be real or complex. 
In case of a Fortran call, the function \fV 'f' \fR must be defined 
in the subroutine \fVffeval.f\fR (in directory \fVSCIDIR/routines/default\fR)
.SH EXAMPLE
.nf
deff('[z]=f(x,y)','z=x^2+y^2');
feval(1:10,1:5,f)
deff('[z]=f(x,y)','z=x+%i*y');
feval(1:10,1:5,f)
feval(1:10,1:5,'parab')   //See ffeval.f file
feval(1:10,'parab')
// For dynamic link (see example ftest in ffeval.f)
// you can use the link command (the parameters depend on the machine):
// unix('make ftest.o');link('ftest.o','ftest); feval(1:10,1:5,'ftest') 
.fi
.SH SEE ALSO
evstr, horner, execstr, external, link
