.TH "get" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
get - get an UI object property value
.sp
Author: Bertrand Guiheneuf
.sp
Retrieve a property value from an User Interface object.
.sp
.sp
.SH Usage
val=get(h,prop)
.SH Input parameters
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
 \fBh\fP : integer
the handle of the object to retrieve a property
.nr bi 1
.TP
o 
 \fBprop\fP : character string
name of the property
.if \n(ll>1 .RE
.nr ll -1
.SH Output parameter
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
 \fBval\fP : scilab object
value of the property
.if \n(ll>1 .RE
.nr ll -1
.SH Description
This routine can be used to retrieve a specified property from a GUI object. 
Property name are character strings like 'style', 'position' ....
This routine returns the value associated to the specified property.
Obviously, the type of the returned object depends on the property
one aims at querying. For example, the 'style' property which represents
the kind of Object the UI control is (ie button, label, list, ..... ) will
be represented as a string. On the contrary, the 'position' property, which 
represents the geometrical aspect of the UI control, will be coded as 
a \f(CR[\fP1,4\f(CR]\fP vector. 
.SH EXAMPLE
.nf
h=uicontrol('string', 'Button');
// Opens a window with a  button.
p=get(h,'position');
// get the geometric qspect of the button
disp('Button width: ' + string(p(3)));
// print the width of the button
close();
// close figure
.fi 
.ec
.ft P
.sp
.SH See also
uicontrol, uimenu, set
