/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

#include "playlist_lists.h"


// ************************
//
// MEDIA STREAM LIST
//
// ************************

void MediaStreamList::SetUpStreamSSRCs()
{
	UInt32 			ssrc;
	MediaStream*	setMediaStreamPtr;	
	MediaStream*	aMediaStreamPtr;
	bool  			found;
		
	for (int i = 0; i < Size(); i++)
	{	found = true;
		setMediaStreamPtr = SetPos(i);
		ssrc = PlayListUtils::Random();	
		
		while (found)
		{	aMediaStreamPtr = Begin();
			found = false;
			
			while (aMediaStreamPtr)
			{				
				if (aMediaStreamPtr->fData.fInitSSRC == ssrc)
				{	found = true;
					break;
				}
				aMediaStreamPtr = Next();
			}
			
		}
		setMediaStreamPtr->fData.fInitSSRC = ssrc;
	}
}


void MediaStreamList::StreamStarted(SInt64 startTime)
{
	for ( MediaStream *theStreamPtr = Begin(); (theStreamPtr != NULL) ; theStreamPtr = Next() ) 
	{				
		theStreamPtr->StreamStart(startTime);
	} 	
}

void MediaStreamList::MovieStarted(SInt64 startTime)
{
	for ( MediaStream *theStreamPtr = Begin(); (theStreamPtr != NULL) ; theStreamPtr = Next() ) 
	{				
		theStreamPtr->MovieStart(startTime);
	} 
}

void MediaStreamList::MovieEnded(SInt64 endTime)
{
	for ( MediaStream *theStreamPtr = Begin(); (theStreamPtr != NULL) ; theStreamPtr = Next() ) 
	{				
		theStreamPtr->MovieEnd(endTime);
	} 
}


SInt16 MediaStreamList::UpdateStreams()
{
	SInt16 err = 0;
	for ( MediaStream *theStreamPtr = Begin(); (theStreamPtr != NULL) ; theStreamPtr = Next() ) 
	{				
		theStreamPtr->ReceiveOnPorts();
	};
	
	
	return err;
}

// ************************
//
// SocketList
//
// ************************
SInt16 SocketList::OpenAndBind(UInt16 basePort,char *destAddress) 
{
	SInt16 err = -1;
		
	UDPSocketPair *aPair = Begin();
	while (aPair != NULL)
	{
		err = aPair->Open();
		if (err != 0) break;
		
		err = aPair->Bind(INADDR_ANY);
		if (err != 0) break;
		
		err = aPair->SetDestination (destAddress, basePort, basePort+1);	
		if (err != 0) break;
		
		basePort +=2;		
		aPair = Next();
	}
	
	if (err)
	{	aPair = Begin();
		while (aPair != NULL)
		{	aPair->Close();
			aPair =  Next();
		}
	}
	
	return err;
};


