/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

#ifndef playlist_utils_H
#define playlist_utils_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#if (!__MACOS__)
	#include <sys/types.h>
	#include <sys/time.h>
	#include <sys/stat.h>
	#include <sys/socket.h>
	#include <netinet/in.h>
	#include <arpa/inet.h>

	#include <fcntl.h>
#endif

#if (__MACOS__)
	#include "bogusdefs.h"
#endif

#include "playlist_OSHeaders.h"
#include "playlist_timestamp.h"


#define Log_Enabled 0

#if Log_Enabled
	
	void LogFileOpen(void);
	void LogFileClose(void);
	bool TimeToSwitch(int len);
	void WriteToLog(void *data, int len);
	void WritePacketToLog(void *data, int len);
	void WritToBuffer(void *data, int len);
	void LogBuffer(void);
	void PrintLogBuffer(bool log);
	void LogNum(void);
	void LogFloat(char *str, float num, char *str2= "\0");
	void LogInt(char *str, long num, char *str2= "\0");
	void LogUInt (char *str, unsigned long num, char *str2 = "\0");
	void LogStr(char *str);
	
#else
	#define LogFileOpen()
	#define LogFileClose()
	#define TimeToSwitch(len)
	#define WriteToLog(data,len)
	#define WritePacketToLog(data,len)
	#define WritToBuffer(data, len)
	#define LogBuffer()
	#define PrintLogBuffer(log)
	#define LogFloat(str,num,str2)  
	#define LogInt(str,num,str2)
	#define LogUInt(str,num,str2) 
	#define LogStr(str) 
	#define LogNum() 
#endif


class PlayListUtils 
{
	public:
		PlayListUtils();
		
		enum {eMicro = 1000000, eMilli = 1000};
		
		static	void 	InitRandom();
		static 	void	InitMilliSeconds();
		static  UInt32 Random();
		static  SInt64 HostToNetworkSInt64(SInt64 hostOrdered) { return hostOrdered; };
		static  SInt64 ConvertMsecToFixed64Sec(SInt64 inMilliseconds) { return (SInt64)(.5 + inMilliseconds * 4294967.296L); };
		static  SInt64 ConvertToSecondsSince1900(SInt64 inMilliseconds) { return ConvertMsecToFixed64Sec(sMsecSince1900 + inMilliseconds); }

		static  SInt64 Milliseconds();
		static	SInt64 Microseconds();
		static  SInt64 sInitialMsec;
		static  SInt64 sMsecSince1900;
		static  double sDivisor;
		static  double sMicroDivisor;
};

#endif  //playlist_utils_H