/*
 * proxy.h
 * Written by Michael Kellner
 * Copyright 1999 by Apple Computer, Inc., all rights reserved.
 *
 * $Log: /StreamingServers/proxy3/proxy.h $
		
		3     4/2/99 2:53 PM Mike Kellner
		better copyright
		
		2     3/3/99 4:23 PM Mike Kellner
		Get rid of hashval for add and remove session
		
		1     2/26/99 10:36 AM Mike Kellner
		Adding subproject 'proxy3' to '$/StreamingServers'
		
		2     2/15/99 2:17 PM Mike Kellner
		use DOS LF/CR 'cause mac can deal and win can't.
		
		1     2/11/99 9:44 AM Mike Kellner
		Adding 'proxy.h' to '$/StreamingServers/proxy/'
 */

#ifndef __PROXY_H__
#define __PROXY_H__

#include "shared_udp.h"
/**********************************************/
enum {
	stIdle,
	stError,

	stRecvClientCommand,
	stWaitingForIPAddress,
	stParseClientCommand,
	stSendClientResponse,
	stServerTransactionSend,
	stServerTransactionRecv,
	stClientShutdown,
	stServerShutdown,
	stBadServerName,
	stCantConnectToServer,
	stDone
};		// rtsp session states

enum {
	ttNone,
	ttDescribe,
	ttSetup,
	ttPlay,
	ttPause,
	ttStop,
	ttTeardown
};		// rtsp command types

enum {
	kPermissionDenied,
	kTooManyUsers,
	kServerNotFound,
	kUnknownError
};		// refusal type

typedef struct {
	char	*cmd;
	int		type;
} t_cmd_map;

#define MAX_TRACKS	8

typedef struct {
	int		ID;
	shok	*RTP_S2P;
	shok	*RTCP_S2P;
	shok	*RTP_P2C;
	shok	*RTCP_P2C;
	int		ClientRTPPort;
	int		ServerRTPPort;
	trans_pb	RTP_S2C_tpb;
	trans_pb	RTCP_S2C_tpb;
	trans_pb	RTCP_C2S_tpb;
} track_info;

#define RTSP_SESSION_BUF_SIZE	1024
typedef struct rtsp_session {
	struct rtsp_session *next;
	int		die;
	int		newSession;
	int		client_skt;
	int		client_ip;
	char	*server_address;
	int		server_skt;
	int		server_ip;
	int		server_port;
	int		server_skt_pending_connection;
	int		state;
	int		transaction_type;
	char	*sessionID;

	int		cur_trk;
	int		numTracks;
	track_info	trk[MAX_TRACKS];

	char	cinbuf[RTSP_SESSION_BUF_SIZE];
	int		amtInClientInBuffer;
	char	coutbuf[RTSP_SESSION_BUF_SIZE];
	int		amtInClientOutBuffer;
	char	sinbuf[RTSP_SESSION_BUF_SIZE];
	int		amtInServerInBuffer;
	char	soutbuf[RTSP_SESSION_BUF_SIZE];
	int		amtInServerOutBuffer;

	int		tempIP;
} rtsp_session;

typedef struct subnet_allow {
	struct subnet_allow *next;
	int		ip;
	int		range;
} subnet_allow;

typedef struct rtsp_listener {
	struct rtsp_listener *next;
	int		port;
	int		skt;
} rtsp_listener;

/**********************************************/
int service_listeners();
int service_sessions();

void add_rtsp_port_listener(int port);
void cleanup_listeners(void);
void answer_new_connection(rtsp_listener *listener);
void add_session(rtsp_session *session);
void remove_session(rtsp_session *session);
rtsp_session *new_session(void);
void cleanup_sessions(void);
void cleanup_session(rtsp_session *session);
void service_session(rtsp_session *session);
void service_session_rtp(rtsp_session *session);
void read_config(void);
void add_allow_subnet(int ip, int range);
bool allow_ip(int ip);
void send_rtsp_error(int skt, int refusal);

#endif // __PROXY_H__

