/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPLoggingModule.h

	Contains:	An RTSP module that uses RTSPRollingLog to write RTSP events & general
				errors out to log files.

	$Log: RTSPLoggingModule.h,v $
	Revision 1.2  1999/02/19 23:08:28  ds
	Created
	

*/

#ifndef __RTSPLOGGINGMODULE_H__
#define __RTSPLOGGINGMODULE_H__

#include <stdio.h>
#include <time.h>

#include "RTSPModule.h"
#include "RTSPRollingLog.h"
#include "RTSPServerInterface.h"
#include "OSMutex.h"

class RTSPErrorLog;


class RTSPErrorLog : public RTSPRollingLog
{
	public:
		RTSPErrorLog() : RTSPRollingLog(false) {}
		virtual ~RTSPErrorLog() {}
	
		virtual char* GetLogName() 	{ return RTSPServerInterface::GetRTSPPrefs()->GetErrorLogName();}
		
		virtual char* GetLogDir() 	{ return RTSPServerInterface::GetRTSPPrefs()->GetErrorLogDir();}
		
		virtual UInt32 GetRollIntervalInDays()	{ return RTSPServerInterface::GetRTSPPrefs()->GetErrorRollIntervalInDays();}
		
		virtual UInt32 GetMaxLogBytes()	{ return RTSPServerInterface::GetRTSPPrefs()->GetMaxErrorLogBytes();}
	
};


class RTSPLoggingModule : public RTSPModule
{
	public:

		RTSPLoggingModule() : fLogMutex('lgmt'), fErrorLog(NULL) {}
		virtual ~RTSPLoggingModule()	{ delete fErrorLog; }
		
		virtual bool	Initialize();
		virtual void	Shutdown();
		
		
		virtual void	LogError(	const RTSPModule::Verbosity inVerbosity,
									const RTSPMessages::Message inMessage,
									const RTSPModule::ErrorNumber inErrorNumber);
		virtual void 	LogError(const RTSPModule::Verbosity inVerbosity, const char* inString);
		
		//because we don't have adequate module-module communication
		
		static void			RollErrorLog();
		
	private:
	
		static RTSPLoggingModule*	sLoggingModule;
		OSMutex						fLogMutex;//Log module isn't reentrant
		
		RTSPErrorLog*				fErrorLog;
		
		void CheckErrorLogState(bool forceEnable = false);
		

		void 	LogErrorPrivate(	const RTSPModule::Verbosity inVerbosity,
									const char* inMessageP,
									const RTSPModule::ErrorNumber inErrorNumber);

};
#endif // __RTSPLOGGINGMODULE_H__

