/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPRequest.h

	Contains:	This class encapsulates a single RTSP request. It stores the meta data
				associated with a request, and provides an interface (through its base
				class) for modules to access request information
				
				It divides the request into a series of states.
				
				State 1: At first, when the object is constructed or right after 
						 its Reset function is called, it is in an uninitialized state.
				State 2: Parse() parses an RTSP header. Once this function returns,
						 most of the request-related query functions have been setup.
						 (unless an error occurs)
				State 3: GetHandler() uses the request information to create the
						 proper request Handler object for this request. After that,
						 it is the Handler object's responsibilty to process the
						 request and send a response to the client.
					
	$Log: RTSPRequest.h,v $
	Revision 1.2  1999/02/19 23:08:32  ds
	Created
	

*/

#ifndef __RTSPREQUEST_H__
#define __RTSPREQUEST_H__

#include "RTSPRequestInterface.h"
#include "RTSPRequestStream.h"
#include "RTSPSessionInterface.h"
#include "RTSPModule.h"
#include "StringParser.h"


//HTTPRequest class definition
class RTSPRequest : public RTSPRequestInterface
{
public:

	//CONSTRUCTOR / DESTRUCTOR
	//these do very little. Just initialize / delete some member data.
	//
	//Arguments:		session: the session this request is on (massive cyclical dependency)
	RTSPRequest(RTSPRequestStream *stream, RTSPSessionInterface* session)
		: RTSPRequestInterface(stream, session) {}
	virtual ~RTSPRequest() {}
	
	//Parses the request. Returns an error handler if there was an error encountered
	//in parsing.
	RTSPProtocol::RTSPStatusCode Parse(StrPtrLen *stream);
	
private:

	//PARSING
	
	//Parsing the URI line (first line of request
	RTSPProtocol::RTSPStatusCode ParseFirstLine(StringParser &parser);
	
	//Utility functions called by above
	RTSPProtocol::RTSPStatusCode ParseURI(StringParser &parser);

	//Parsing the rest of the headers
	//This assumes that the parser is at the beginning of the headers. It will parse
	//the headers, fill out the data & HTTPParameters object.
	//
	//Returns:		A handler object signifying that a fatal syntax error has occurred
	RTSPProtocol::RTSPStatusCode ParseHeaders(StringParser& parser);
	
	//Functions to parse the contents of particuarly complicated headers (as a convienence
	//for modules)
	void  	ParseRangeHeader();
	void 	ParseTransportHeader();


	static UInt8	sURLStopConditions[];
};
#endif // __RTSPREQUEST_H__

