/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import netscape.security.UserAwtDialog;

class DialogCreator
extends Thread {
    private static Object lock = new Object();
    private static boolean dlgCreatorThreadStarted;
    private static UserAwtDialog theUserAwtDialog;
    private static Thread dlgCreatorThread;

    DialogCreator() {
        if (dlgCreatorThread == null) {
            dlgCreatorThread = this;
        }
    }

    static void createAwtDialogsInSeparateThread() {
        Object object = lock;
        synchronized (object) {
            if (dlgCreatorThread == null) {
                throw new NullPointerException("Dialog creator thread not created");
            }
            if (theUserAwtDialog == null && !dlgCreatorThreadStarted) {
                dlgCreatorThread.start();
                dlgCreatorThreadStarted = true;
            }
            while (theUserAwtDialog == null) {
                try {
                    lock.wait();
                }
                catch (Throwable throwable) {
                    System.out.println("interrupted during AWT based security dialog creation!");
                    throwable.printStackTrace(System.out);
                }
            }
            return;
        }
    }

    public void run() {
        if (theUserAwtDialog == null) {
            try {
                theUserAwtDialog = new UserAwtDialog();
            }
            catch (Exception exception) {
                System.err.println("Error: new UserAwtDialog() returned null object");
                exception.printStackTrace(System.out);
                throw new NullPointerException("Security Dialog not created");
            }
        }
        if (theUserAwtDialog != null) {
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
                return;
            }
        }
    }

    static UserAwtDialog getUserAwtDialog() {
        return theUserAwtDialog;
    }

    static {
        theUserAwtDialog = null;
        dlgCreatorThread = null;
    }
}

