/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPUrl;

public class LDAPReferralException
extends LDAPException {
    static final long serialVersionUID = 1771536577344289897L;
    private String[] m_referrals;

    public LDAPReferralException() {
    }

    public LDAPReferralException(String string) {
        super(string);
    }

    public LDAPReferralException(String string, int n, String string2) {
        super(string, n, string2);
    }

    public LDAPReferralException(String string, int n, String[] stringArray) {
        super(string, n, null);
        this.m_referrals = stringArray;
    }

    public LDAPUrl[] getURLs() {
        if (this.getLDAPErrorMessage() == null) {
            return this.constructsURL(this.m_referrals);
        }
        return this.constructsURL(this.extractReferrals(this.getLDAPErrorMessage()));
    }

    private LDAPUrl[] constructsURL(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        LDAPUrl[] lDAPUrlArray = new LDAPUrl[stringArray.length];
        if (lDAPUrlArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                lDAPUrlArray[n] = new LDAPUrl(stringArray[n]);
            }
            catch (Exception exception) {
                return null;
            }
            ++n;
        }
        return lDAPUrlArray;
    }

    private String[] extractReferrals(String string) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Vector<String[]> vector = new Vector<String[]>();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (bl) {
                vector.addElement(stringArray);
                continue;
            }
            if (!stringArray.startsWith("Referral:")) continue;
            bl = true;
        }
        if (vector.size() == 0) {
            return null;
        }
        stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }
}

