/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** clabstract.h
*/

# ifndef CLABSTRACT_H
# define CLABSTRACT_H

extern void setArgsUsed (void) /*@modifies internalState@*/ ;
extern void setSpecialFunction (qual qu) /*@modifies internalState@*/ ;
extern bool isFlipOldStyle(void) /*@*/ ;
extern bool isNewStyle(void) /*@*/ ;  
extern bool processingIterVars(void) /*@*/ ;

extern ctype declareEnum (/*@only@*/ cstring ename, /*@only@*/ enumNameList el);
extern ctype declareStruct (/*@temp@*/ cstring id, /*@only@*/ uentryList f);
extern ctype declareUnnamedStruct (/*@only@*/ uentryList f);

extern ctype declareUnion (/*@temp@*/ cstring id, /*@only@*/ uentryList f);
extern ctype declareUnnamedUnion (/*@only@*/ uentryList f);

extern void 
  setFunctionSpecialClause (lltok stok, /*@only@*/ sRefSet s, lltok etok);
extern void
  setFunctionStateSpecialClause (lltok stok, specialClauseKind kind, 
				 /*@only@*/ sRefSet s, lltok etok);

extern ctype declareUnnamedEnum (/*@only@*/ enumNameList el);
extern ctype handleEnum (/*@only@*/ cstring id);
extern ctype handleStruct (/*@only@*/ cstring id);
extern ctype handleUnion (/*@only@*/ cstring id);

extern uentryList handleParamIdList (/*@returned@*/ /*@dependent@*/ uentryList params);
extern uentryList handleParamTypeList (/*@dependent@*/ /*@returned@*/ uentryList params);

extern uentryList fixUentryList (/*@only@*/ idDeclList tl, qtype c);

extern /*@exposed@*/ uentry getCurrentIter(void);

extern void processNamedDecl (idDecl t);
extern /*@exposed@*/ uentry declareFunction (/*@only@*/ idDecl tid) 
   /*@globals internalState@*/ ;
extern void doVaDcl (void);
extern void doneParams (void);

extern void setCurrentParams (/*@dependent@*/ uentryList ue);
extern void clearCurrentParams (void);

extern /*@exposed@*/ sRef fixModifiesId (cstring s);
extern /*@exposed@*/ sRef fixSpecClausesId (cstring s);

extern void setFlipOldStyle(void);
extern void setNewStyle(void);
extern void unsetProcessingGlobals (void);
extern void setProcessingIterVars (uentry iter);
extern void setProcessingTypedef (/*@only@*/ qtype c);
extern void setProcessingVars (/*@only@*/ qtype c);
extern void setStorageClass (storageClassCode sc);
extern void storeLoc (void);
extern void unsetProcessingTypedef (void);
extern void unsetProcessingVars (void);

extern /*@only@*/ uentry makeCurrentParam (idDecl t);
extern void setProcessingGlobalsList (void);

extern /*@exposed@*/ sRef modListArrayFetch (sRef s, sRef mexp);
extern /*@exposed@*/ sRef modListPointer (sRef s);
extern /*@exposed@*/ sRef modListFieldAccess (sRef s, /*@only@*/ cstring f);
extern /*@exposed@*/ sRef modListArrowAccess (sRef s, /*@only@*/ cstring f);

extern sRef globListUnrecognized (cstring s);
extern void globListAdd (sRef s, qualList quals);

extern void setFunctionModifies (/*@only@*/ sRefSet s);

extern void checkDoneParams (void);

extern void exitParamsTemp (void);
extern void enterParamsTemp (void);

extern void clearProcessingGlobMods (void);
extern bool isProcessingGlobMods (void);
extern void setProcessingGlobMods (void);

extern void setFunctionNoGlobals (void);
extern int iterParamNo (void);
extern void nextIterParam (void);
extern void declareCIter (cstring name, /*@owned@*/ uentryList params);
extern void checkModifiesId (uentry ue);
extern /*@exposed@*/ sRef checkSpecClausesId (uentry ue);

extern void checkConstant (qtype t, idDecl id) ;
extern void checkValueConstant (qtype t, idDecl id, exprNode e) ;

# else
# error "Multiple include"
# endif








