/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef GENERAL_H
# define GENERAL_H

/* sgi's don't let you undef NULL */
# ifndef IRIX 
# ifdef NULL
# undef NULL
# endif
# endif

# include "forwardTypes.h"
# include "cstring.h"
# include "bool.h"

extern /*@out@*/ /*@only@*/ void *dimalloc  (size_t size, char *name, int line);
extern /*@only@*/ void *dicalloc  (size_t num, size_t size, char *name, int line);
extern /*@notnull@*/ /*@out@*/ /*@only@*/ void *
  direalloc (/*@returned@*/ /*@only@*/ /*@out@*/ /*@null@*/ void *x, 
	     size_t size, char *name, int line);

extern /*@out@*/ /*@only@*/ void *
  drealloc (/*@only@*/ /*@out@*/ /*@null@*/ /*@sef@*/ void *x,
	    /*@sef@*/ size_t size)
  /*@modifies *x@*/ ;

extern /*@out@*/ /*@only@*/ void *dmalloc  (/*@sef@*/ size_t size) /*@*/ ;

# ifdef USEDMALLOC
# define dmalloc(s)    (malloc(s))
# define drealloc(s,l) (realloc(s,l))
# else
# define dmalloc(s)    (dimalloc(s, __FILE__, __LINE__))
# define drealloc(s,l) (direalloc(s, l, __FILE__, __LINE__))
# endif

# include "system_constants.h"

# ifdef USEGC
# include <gc.h>
# define NOFREE
# define free(s) ; /* nothing */ 
# else
# endif

# ifdef USEDMALLOC
# include "dmalloc.h"
# endif

/*
** no file except general.c should use primitive
** memory operations:
*/

/*@-exportlocal@*/
# ifndef USEDMALLOC
# undef malloc
# undef realloc
# undef calloc
# define malloc(s)     (dimalloc(s, __FILE__, __LINE__))
# define calloc(n, s)  (dicalloc(n, s, __FILE__, __LINE__))
# define realloc(v, s) (direalloc(v, s, __FILE__, __LINE__))
# endif
/*@=exportlocal@*/

# ifndef NULL
# define NULL 0
# endif 

# ifdef USEDMALLOC
# define sfree(x) do { if (x != NULL) free(x); } while (FALSE)
# else
extern void sfree (/*@out@*/ /*@only@*/ /*@null@*/ void *x) /*@modifies *x@*/; 
# endif

extern void sfreeEventually (/*@owned@*/ /*@null@*/ void *x) 
   /*@modifies internalState@*/; 

extern /*@unused@*/ bool or (bool a, bool b);  
extern bool and (bool a, bool b);  

/*@constant int NOT_FOUND;@*/
# define NOT_FOUND (-23)

# else
# error "Multiple include"
# endif






