/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*       
** lctype.h
**
** renamed from ctype.h to avoid confusion with standard
** header file
*/      
        
# ifndef CTYPE_H
# define CTYPE_H

/*
** since this is the header file for the ctype module, we need
** to use an access comment to provide access to the representation.
*/

/* in forwardTypes: typedef int ctype; */
       
typedef enum 
{ 
  CT_UNKNOWN, 
  CT_PRIM, 
  CT_USER, 
  CT_ABST, 
  CT_ENUM, 
  CT_PTR, 
  CT_ARRAY, 
  CT_FCN, 
  CT_STRUCT, 
  CT_UNION,
  CT_ENUMLIST, /* bogus type for keeping unnamed enums around */
  CT_BOOL,     /* since booleans aren't really prim's but we don't
		  want them to be user or abst, they are a separate type */
  CT_CONJ,     /* conjunction */
  CT_EXPFCN
  } ctuid ;

/*@access ctype@*/

/* hack alert! */

/*@constant int CTK_ELIPS;@*/          
# define CTK_ELIPS -23         

/*@constant int CTK_MISSINGPARAMS;@*/          
# define CTK_MISSINGPARAMS -37

/*@constant int CT_FIRST;@*/          
# define CT_FIRST 0

/*@constant int CTK_PREDEFINED;@*/       
# define CTK_PREDEFINED   (CTX_LAST + 1)

/*@constant int CTK_PREDEFINED2;@*/       
# define CTK_PREDEFINED2  (CTK_PREDEFINED + CTK_PREDEFINED)

/*@constant int LAST_PREDEFINED;@*/       
# define LAST_PREDEFINED (CTK_PREDEFINED + CTK_PREDEFINED2)

/*@constant int CTP_VOID;@*/       
# define CTP_VOID (CTX_VOID + CTK_PREDEFINED)

/*@constant int CTP_CHAR;@*/       
# define CTP_CHAR (CTX_CHAR + CTK_PREDEFINED)
         
/*@constant int CTK_BASESIZE;@*/                
# define CTK_BASESIZE BIGBASESIZE
       
typedef enum 
{ 
  CTK_UNKNOWN = -3,
  CTK_INVALID = -2, 
  CTK_DNE = -1,
  CTK_PLAIN = 0, /* these must be in order */
  CTK_PTR = 1,
  CTK_ARRAY = 2,
  CTK_COMPLEX = 3 
  } ctkind ;

extern int ctkind_toInt (ctkind x);
# define ctkind_toInt(x) ((int)(x))

/*
** ctypes are integer indexes into ctype table
**
** the most common ctypes are hard wired (see cprim.h)
*/

/*@constant ctype ctype_undefined; @*/
# define ctype_undefined  ((ctype) CTK_INVALID)

/*@constant ctype ctype_dne; @*/
# define ctype_dne        ((ctype) CTK_DNE)

/*@constant ctype ctype_unknown; @*/
# define ctype_unknown    CTX_UNKNOWN

/*@constant ctype ctype_void; @*/
# define ctype_void       CTX_VOID

/*@constant ctype ctype_char; @*/
# define ctype_char       CTX_CHAR

/*@constant ctype ctype_uchar; @*/
# define ctype_uchar      CTX_UCHAR

/*@constant ctype ctype_double; @*/
# define ctype_double     CTX_DOUBLE

/*@constant ctype ctype_ldouble; @*/
# define ctype_ldouble    CTX_LDOUBLE

/*@constant ctype ctype_float; @*/
# define ctype_float      CTX_FLOAT

/*@constant ctype ctype_int; @*/
# define ctype_int        CTX_INT

/*@constant ctype ctype_uint; @*/
# define ctype_uint       CTX_UINT

/*@constant ctype ctype_sint; @*/
# define ctype_sint       CTX_SINT

/*@constant ctype ctype_lint; @*/
# define ctype_lint       CTX_LINT

/*@constant ctype ctype_usint; @*/
# define ctype_usint      CTX_USINT

/*@constant ctype ctype_ulint; @*/
# define ctype_ulint      CTX_ULINT

/*@constant ctype ctype_bool; @*/
# define ctype_bool       CTX_BOOL

/*@constant ctype ctype_string; @*/
# define ctype_string     CTP_CHAR

/*@constant ctype ctype_anyintegral @*/
# define ctype_anyintegral CTX_ANYINTEGRAL

/*@constant ctype ctype_voidPointer; @*/
# define ctype_voidPointer CTP_VOID

extern ctype ctype_forceRealType (ctype c);       
extern bool ctype_forceMatch (ctype c1, ctype c2);
extern bool ctype_genMatch (ctype c1, ctype c2, bool b1, bool b2, bool def);

extern bool ctype_isSimple (ctype c) /*@*/ ;
extern bool ctype_isAbstract (ctype c) /*@*/ ;
extern bool ctype_isArray (ctype c) /*@*/ ;
extern bool ctype_isArrayPtr (ctype c) /*@*/ ;
extern bool ctype_isBool (ctype c) /*@*/ ;
extern bool ctype_isChar (ctype c) /*@*/ ;
extern bool ctype_isConj (ctype c) /*@*/ ;
extern bool ctype_isDirectBool (ctype c) /*@*/ ;
extern bool ctype_isDirectInt(ctype c) /*@*/ ;
extern bool ctype_isEnum(ctype c) /*@*/ ;
extern bool ctype_isExpFcn (ctype c) /*@*/ ;
extern bool ctype_isFirstVoid (ctype c) /*@*/ ;
extern bool ctype_isForceRealBool (ctype *c) /*@*/ ;
extern bool ctype_isForceRealInt (ctype *c) /*@*/ ;
extern bool ctype_isForceRealNumeric (ctype *c) /*@*/ ;
extern bool ctype_isFunction (ctype c) /*@*/ ;
extern bool ctype_isArbitraryIntegral (ctype c) /*@*/ ;
extern bool ctype_isInt (ctype c) /*@*/ ;
extern bool ctype_isMutable (ctype t) /*@*/ ;
extern bool ctype_isNumeric (ctype c) /*@*/ ;
extern bool ctype_isPointer (ctype c) /*@*/ ;
extern bool ctype_isReal (ctype c) /*@*/ ;
extern /*@unused@*/ bool ctype_isFloat (ctype c) /*@*/ ;
extern bool ctype_isDouble (ctype c) /*@*/ ;
extern bool ctype_isSigned (ctype c) /*@*/ ;
extern bool ctype_isUnsigned (ctype c) /*@*/ ;
extern bool ctype_isRealAP (ctype c) /*@*/ ;
extern bool ctype_isRealAbstract(ctype c)  /*@*/ ;
extern bool ctype_isRealArray (ctype c) /*@*/ ;
extern bool ctype_isRealBool (ctype c) /*@*/ ;
extern bool ctype_isRealFunction (ctype c) /*@*/ ;
extern bool ctype_isRealInt (ctype c) /*@*/ ;
extern bool ctype_isRealNumeric (ctype c) /*@*/ ;
extern bool ctype_isRealPointer (ctype c) /*@*/ ;
extern bool ctype_isRealSU (ctype c) /*@*/ ;
extern bool ctype_isRealVoid (ctype c) /*@*/ ;
extern bool ctype_isStruct (ctype c) /*@*/ ;
extern bool ctype_isStructorUnion(ctype c)  /*@*/ ;
extern bool ctype_isUA (ctype c) /*@*/ ;
extern bool ctype_isUnion (ctype c) /*@*/ ;
extern bool ctype_isUserBool (ctype ct) /*@*/ ;
extern bool ctype_isVoid (ctype c) /*@*/ ;
extern bool ctype_isVoidPointer (ctype c) /*@*/ ;

extern bool ctype_isVisiblySharable (ctype t) /*@*/ ;
extern bool ctype_match (ctype c1, ctype c2) /*@*/ ;
extern bool ctype_matchArg (ctype c1, ctype c2) /*@*/ ;
extern bool ctype_sameName (ctype c1, ctype c2) /*@*/ ;         

extern /*@only@*/ cstring ctype_dump (ctype c) /*@*/ ;
extern /*@observer@*/ cstring ctype_enumTag (ctype c) /*@*/ ;           
extern /*@observer@*/ cstring ctype_unparse (ctype c) /*@*/ ;
extern /*@observer@*/ cstring ctype_unparseDeep (ctype c) /*@*/ ;       
extern /*@unused@*/ /*@observer@*/ cstring ctype_unparseSafe (ctype c) /*@*/ ;

extern ctkind ctkind_fromInt (int i) /*@*/ ;

extern bool ctype_matchDef (ctype c1, ctype c2) /*@*/ ;
extern ctype ctype_undump (char **c);
extern ctype ctype_adjustPointers(int np, ctype c);
extern ctype ctype_baseArrayPtr (ctype c) /*@*/ ;
extern ctype ctype_combine (ctype c1, ctype c2) ;

extern ctype ctype_createAbstract (typeId u)  /*@*/ ;
extern ctype 
  ctype_createEnum (/*@keep@*/ cstring tag, /*@keep@*/ enumNameList el);
extern ctype ctype_createForwardStruct (/*@only@*/ cstring n)  /*@*/ ;
extern ctype ctype_createForwardUnion (/*@only@*/ cstring n)  /*@*/ ;
extern ctype ctype_createStruct (/*@only@*/ cstring n, /*@only@*/ uentryList f);
extern ctype ctype_createUnion (/*@only@*/ cstring n, /*@only@*/ uentryList f);

extern ctype ctype_createUnnamedStruct (/*@only@*/ uentryList f) ;
extern ctype ctype_createUnnamedUnion (/*@only@*/ uentryList f) ;
extern ctype ctype_createUser (typeId u) ;

extern bool ctype_isUser (ctype c) /*@*/ ;
extern ctype ctype_expectFunction(ctype c) ;

extern ctype ctype_fixArrayPtr (ctype c);

extern ctype ctype_getBaseType (ctype c) /*@*/ ;

extern ctype ctype_makeArray (ctype c);
extern ctype ctype_makeConj (ctype c1, ctype c2);
extern ctype ctype_makeParamsFunction (ctype base, /*@only@*/ uentryList p);
extern ctype ctype_makeFunction (ctype base, /*@only@*/ uentryList p) /*@*/ ;
/* comment this out! */
extern ctype ctype_makeNFParamsFunction (ctype base, /*@only@*/ uentryList p);
extern ctype ctype_makePointer (ctype c);
extern ctype ctype_makeRealFunction (ctype base, /*@dependent@*/ uentryList p);

extern ctype ctype_newBase (ctype c, ctype p) /*@*/ ;
extern ctype ctype_realType (ctype c) /*@*/ ;
extern ctype ctype_realishType (ctype c) /*@*/ ;
extern ctype ctype_removePointers (ctype c) /*@*/ ;
extern ctype ctype_resolve (ctype c) /*@*/ ;
extern ctype ctype_resolveNumerics (ctype c1, ctype c2) /*@*/ ;
extern ctype ctype_returnValue (ctype c) /*@*/ ;

extern bool ctype_isRefCounted (ctype t) /*@*/ ;
extern /*@observer@*/ uentryList ctype_argsFunction (ctype c) /*@*/ ;
extern /*@observer@*/ uentryList ctype_getParams (ctype c) /*@*/ ;
# define ctype_getParams(c) ctype_argsFunction(c)

extern /*@observer@*/ enumNameList ctype_elist (ctype c) /*@*/ ;
extern /*@observer@*/ uentryList ctype_getFields (ctype c) /*@*/ ;

/*
** could do some run-time checks...
*/

extern cprim ctype_toCprim (ctype c) /*@*/ ;
/*@access cprim@*/
# define ctype_toCprim(c) ((cprim) (c))
/*@noaccess cprim@*/

extern int ctype_compare (ctype c1, ctype c2) /*@*/ ;
extern /*@unused@*/ int ctype_count (void);

extern ctype ctype_makeExplicitConj (ctype c1, ctype c2);

extern typeId ctype_typeId (ctype c);
extern void    ctype_convertTypeTable (ctype c, indxMap map);

extern ctype ctype_fromQual (qual q);
extern bool ctype_isAnyFloat (ctype ct);
extern bool ctype_isStackAllocated (ctype c);

/*@constant ctype ctype_missingParamsMarker; @*/
# define ctype_missingParamsMarker ((ctype)CTK_MISSINGPARAMS)

extern bool ctype_isMissingParamsMarker (ctype ct) /*@*/ ;
# define ctype_isMissingParamsMarker(ct) ((ct) == ctype_missingParamsMarker)

extern bool ctype_equal (ctype c1, ctype c2);
# define ctype_equal(c1,c2) ((c1) == (c2))

/*@constant ctype ctype_elipsMarker; @*/
# define ctype_elipsMarker ((ctype) CTK_ELIPS)

extern bool ctype_isElips (ctype ct) /*@*/;
# define ctype_isElips(ct) ((ct) == ctype_elipsMarker)

extern bool ctype_isAP (ctype c) /*@*/ ;
# define ctype_isAP(c) ctype_isArrayPtr(c)       

extern bool ctype_isDefined (ctype c) /*@*/ ;
# define ctype_isDefined(c)       ((c) != ctype_undefined)

extern bool ctype_isKnown (ctype c) /*@*/ ;
# define ctype_isKnown(c)         ((c) != CTX_UNKNOWN)

extern bool ctype_isSU (ctype c) /*@*/ ;
# define ctype_isSU(c)            ctype_isStructorUnion(c)

extern bool ctype_isUndefined (ctype c) /*@*/ ;
# define ctype_isUndefined(c)     ((c) == ctype_undefined)

extern bool ctype_isUnknown (ctype c) /*@*/;
# define ctype_isUnknown(c)       ((c) == CTX_UNKNOWN)

extern bool ctype_isBogus (/*@sef@*/ ctype c) /*@*/ ;
# define ctype_isBogus(c)         (ctype_isUndefined(c) || ctype_isUnknown(c))

extern cstring 
  ctype_unparseDeclaration (ctype ct, /*@only@*/ cstring name);

extern bool ctype_sameAltTypes (ctype c1, ctype c2) /*@*/ ;

extern void ctype_dumpTable (FILE *f);
extern void ctype_loadTable (FILE *f);
extern void ctype_destroyMod (void);
extern void ctype_initTable (void);
extern /*@only@*/ cstring ctype_unparseTable (void);
extern /*@unused@*/ void ctype_printTable (void);

# else
# error "Multiple include"
# endif
