/*
** multiVal.h
*/

# ifndef MULTIVAL_H
# define MULTIVAL_H

typedef enum { MVLONG, MVCHAR, MVDOUBLE, MVSTRING } mvkind;

typedef /*@null@*/ struct _multiVal
{
  mvkind   kind;
  union _mval
    {
      long int     ival;
      char         cval;
      double       fval;
      /*@only@*/ cstring sval;
    } value;
} *multiVal;

extern /*@falsenull@*/ bool multiVal_isDefined (multiVal m) /*@*/ ;
extern /*@truenull@*/ bool multiVal_isUndefined (multiVal m) /*@*/ ;
extern /*@truenull@*/ bool multiVal_isUnknown (multiVal m) /*@*/ ;

/*@constant null multiVal multiVal_undefined; @*/
# define multiVal_undefined      (multiVal)NULL
# define multiVal_isDefined(m)   ((m) != multiVal_undefined)
# define multiVal_isUndefined(m) ((m) == multiVal_undefined)
# define multiVal_isUnknown(m)   ((m) == multiVal_undefined)

extern /*@observer@*/ /*@dependent@*/ cstring multiVal_forceString (multiVal m) /*@*/ ;
extern /*@unused@*/ double multiVal_forceDouble (multiVal m) /*@*/ ;
extern char multiVal_forceChar (multiVal m) /*@*/ ;
extern long multiVal_forceInt (multiVal m) /*@*/ ;

extern /*@only@*/ multiVal multiVal_makeString (/*@only@*/ cstring s) /*@*/ ;
extern /*@only@*/ multiVal multiVal_makeDouble (double x) /*@*/ ;
extern /*@only@*/ multiVal multiVal_makeChar (char x) /*@*/ ;
extern /*@only@*/ multiVal multiVal_makeInt (long x) /*@*/ ;
extern /*@only@*/ multiVal multiVal_unknown (void) /*@*/ ;

extern /*@only@*/ multiVal multiVal_copy (multiVal m) /*@*/ ;
extern void multiVal_free (/*@only@*/ multiVal m);

extern multiVal multiVal_invert (multiVal m) /*@*/ ;

extern /*@falsenull@*/ bool multiVal_isInt (multiVal m) /*@*/ ;
extern /*@falsenull@*/ bool multiVal_isChar (multiVal m) /*@*/ ;
extern /*@falsenull@*/ bool multiVal_isDouble (multiVal m) /*@*/ ;
extern /*@falsenull@*/ bool multiVal_isString (multiVal m) /*@*/ ;

extern /*@only@*/ multiVal multiVal_undump (char **s) /*@modifies *s;@*/ ;
extern /*@only@*/ cstring multiVal_dump (multiVal m) /*@*/ ;

extern /*@only@*/ cstring multiVal_unparse (multiVal m) /*@*/ ;
extern int multiVal_compare (multiVal m1, multiVal m2) /*@*/ ;

extern bool multiVal_equiv (multiVal m1, multiVal m2) /*@*/ ;
# define multiVal_equiv(m1,m2) ((multiVal_compare(m1, m2)) == 0)

# else
# error "Multiple include"
# endif
