/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** interfaceNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ interfaceNodeList
interfaceNodeList_new ()
{
  interfaceNodeList s = (interfaceNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;
  s->nspacelow = interfaceNodeListGROWLOW;
  s->nspacehigh = interfaceNodeListGROWHI;
  s->elements = (interfaceNode *) dmalloc (sizeof (*s->elements)
					   * interfaceNodeListBASESIZE);
  s->elements += interfaceNodeListGROWLOW;

  return (s);
}

static void
interfaceNodeList_grow (interfaceNodeList s)
{
  int i;
  interfaceNode *newelements; 
  
   newelements = (interfaceNode *) dmalloc 
     (sizeof (*newelements) * (s->nelements + interfaceNodeListBASESIZE));

  newelements += interfaceNodeListGROWLOW;
    
  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }
  
  sfree (s->elements - s->nspacelow); 
  s->elements = newelements;
  s->nspacelow = interfaceNodeListGROWLOW;
  s->nspacehigh = interfaceNodeListGROWHI; 
}

interfaceNodeList
interfaceNodeList_addh (interfaceNodeList s, interfaceNode el)
{
  llassert (interfaceNodeListGROWHI > 0);

  if (s->nspacehigh <= 0)
    interfaceNodeList_grow (s);

  s->nspacehigh--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

void 
interfaceNodeList_addl (interfaceNodeList s, /*@keep@*/ interfaceNode el)
{
  llassert (interfaceNodeListGROWLOW > 0);

  if (s->nspacelow <= 0)
    interfaceNodeList_grow (s);

  s->nspacelow--;
  s->elements--;
  s->elements[0] = el;
  s->nelements++;
}

void
interfaceNodeList_free (interfaceNodeList s)
{
  int i;

  for (i = 0; i < s->nelements; i++)
    {
      interfaceNode_free (s->elements[i]);
    }

  sfree (s->elements - s->nspacelow);	 
  sfree (s);
}
