/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** varDeclarationNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

varDeclarationNodeList varDeclarationNodeList_new ()
{
  varDeclarationNodeList s = (varDeclarationNodeList) dmalloc (sizeof (*s));
   
  s->nelements = 0;
  s->nspace = varDeclarationNodeListBASESIZE;
  s->elements = (varDeclarationNode *) 
    dmalloc (sizeof (*s->elements) * varDeclarationNodeListBASESIZE);

  return (s);
}

static void
varDeclarationNodeList_grow (varDeclarationNodeList s)
{
  int i;
  varDeclarationNode *newelements; 

  s->nspace = varDeclarationNodeListBASESIZE + s->nspace;

  newelements = (varDeclarationNode *) dmalloc (sizeof (*newelements) 
						* (s->nelements + varDeclarationNodeListBASESIZE));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

void 
varDeclarationNodeList_addh (varDeclarationNodeList s, /*@keep@*/ varDeclarationNode el)
{
  if (s->nspace <= 0)
    varDeclarationNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;
}

/*@only@*/ cstring
varDeclarationNodeList_unparse (varDeclarationNodeList s)
{
  cstring st = cstring_undefined;

  varDeclarationNodeList_elements (s, current)
  {
    if (current->isPrivate)
      st = message ("%q private ", st);

    st = message ("%q%q %q;\n", st, lclTypeSpecNode_unparse (current->type),
		  initDeclNodeList_unparse (current->decls));
  } end_varDeclarationNodeList_elements;

  return st;
}


void
varDeclarationNodeList_free (varDeclarationNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      varDeclarationNode_free (s->elements[i]); 
    }

  sfree (s->elements);
  sfree (s);
}
