/*
 * read.c
 *
 * Read a line terminated with 0x0a or 0x0d from the voice modem device.
 *
 */

#include "../include/voice.h"

char *libvoice_read_c = "$Id: read.c,v 1.3 1996/08/06 19:50:27 marc Exp $";

int voice_read _P1((buffer), char *buffer)
     {
     TIO tio;
     TIO save_tio;
     char char_read;
     int number_chars = 0;

     lprintf(L_JUNK, "%s: ", voice_modem_name);
     tio_get(voice_fd, &tio);
     save_tio = tio;
     tio.c_cc[VMIN] = 0;
     tio.c_cc[VTIME] = cvd.port_timeout.d.i;
     tio_set(voice_fd, &tio);

     do
          {

          if (read(voice_fd, &char_read, 1) != 1)
               {
               lprintf(L_ERROR, "could not read from modem device");
               tio_set(voice_fd, &save_tio);
               return(FAIL);
               };

          if ((char_read != NL) && (char_read != CR))
               {
               *buffer = char_read;
               buffer++;
               number_chars++;
               lputc(L_JUNK, char_read);
               };

          }
     while (((char_read != NL) || (number_chars == 0)) &&
      (number_chars < (VOICE_BUF_LEN - 1)));

     tio_set(voice_fd, &save_tio);
     *buffer = 0x00;
     return(OK);
     };
