/* event.c
 *
 * This is the handle event routine for the VoiceModem program.
 *
 */

#include "vm.h"

char *vm_event_c = "$Id: event.c,v 1.2 1996/07/25 19:24:39 marc Exp $";

int handle_event _P2((event, data), int event, event_data data)
     {
     lprintf(L_JUNK, "%s: vm_handle_event got event 0x%x with data 0x%x",
      program_name, event, data.c);

     if (event == RECEIVED_DTMF)

          switch (dtmf_mode)
               {
               case IGNORE_DTMF:
                    return(FAIL);
               case READ_DTMF_DIGIT:
                    printf("%c\n", data.c);

                    switch (voice_modem_state)
                         {
                         case DIALING:
                              return(voice_stop_dialing());
                         case PLAYING:
                              return(voice_stop_playing());
                         case RECORDING:
                              return(voice_stop_recording());
                         case WAITING:
                              return(voice_stop_waiting());
                         };

                    return(FAIL);
               case READ_DTMF_STRING:

                    if (data.c == '*')
                         {
                         dtmf_string_buffer[0] = 0x00;
                         return(OK);
                         };

                    if (data.c != '#')
                         {
                         int length = strlen(dtmf_string_buffer);

                         dtmf_string_buffer[length + 1] = 0x00;
                         dtmf_string_buffer[length] = data.c;
                         return(OK);
                         };

                    printf("%s\n", dtmf_string_buffer);

                    switch (voice_modem_state)
                         {
                         case DIALING:
                              return(voice_stop_dialing());
                         case PLAYING:
                              return(voice_stop_playing());
                         case RECORDING:
                              return(voice_stop_recording());
                         case WAITING:
                              return(voice_stop_waiting());
                         };

                    return(FAIL);
               };

     return(FAIL);
     };
