# targets:  
#	testparser - builds a rudimentary test
#	clean - deletes non-source files	

#  	To configure for your system 
#
#	Specify the installation tree,
CXX = g++	
#	and the location of the AUIS Bison
BISON = bison
#	Add compiler flags here,
COMPILERFLAGS =
#	specify debug mode (often -O or -g),
CDEBUGFLAGS =
#	specify additional includes,
INCLUDES = -I. 
#	add any defines desired,
DEFINES =
#	and give flags for CXX when used for ld.
LOADFLAGS =
#

        CPPFLAGS = $(COMPILERFLAGS) $(CDEBUGFLAGS) $(INCLUDES) $(DEFINES)

.SUFFIXES:
.SUFFIXES:  .o .C 

.C.o:
	rm -f $@
	$(CXX) $(CPPFLAGS) -c $*.C

all: testparser

#
#rudimentary test:  make testparser;  ./testparser
#
foo.H foo.C: foo.gra
	${BISON} -b foo -k foo.gra
	mkparserclass foo
TESTOBJS =  foo.o testparser.o 
testparser.o: foo.H
testparser: ${TESTOBJS} Makefile
	$(CXX) $(CDEBUGFLAGS) ${LOADFLAGS} -o testparser ${TESTOBJS} -lparser


clean: 
	rm -f \#* ,* *~ *.CKP *.BAK *.bas errs core
	rm -f *.ln *.o *.dog tags TAGS make.log
	rm -f *.do *.eh *.ih *.a *.fwm *.snf *.pcf *.rtx *.fb
	rm -f install.time install.doc
	rm -f testparser
	rm -f foo.C foo.H foo.act *.tab.* *.output
