#!	/bin/sh
# Root Disk maker. Bruce Perens, December 1995
# This is free software under the GNU General Public License.

# Dumb GNU tar is broken at the moment.
set -e
# set -v
# set -x

(modprobe minix floppy; exit 0)

first () {
	echo $1
}

last () {
	eval 'echo $'$#
}

# Abort on any non-zero return.
umask 022

if [ $# != 3 ]; then
echo "Usage: "$0" archive floppy-drive blocks" 1>&2
	cat 1>&2 << EOF

	archive: the directory containing the Debian binary packages.
	floppy-drive: the block device file for the floppy drive.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440.

	/mnt must be available for mounting the floppy disk.

EOF

	exit -1
fi

# Set this to the location of the package archive.
archive=$1

# Set this to the block device for the floppy disk.
floppy=$2

# Set to the number of blocks per floppy.
blocks=$3
if [ ! -d $archive/. ]; then
	echo "Error: "$archive": not a directory." 1>&2
	exit -1
fi

if [ ! -b $floppy ]; then
	echo "Error: "$floppy": not a block device. Should be the floppy disk device." \
		1>&2
	exit -1
fi

# To build a rootdisc for an other architecture we need the name
export arch="`dpkg --print-architecture`"

(cd utilities; make)

# Try to unmount anything that should not be mounted.
(umount /mnt; umount $floppy; true)2>/dev/null >/dev/null

# Zero the entire disk, so that when I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=$floppy bs=1k count=${blocks}

# Make a Minix filesystem.
mkfs.minix -n30 -i 1024 $floppy ${blocks}

# Mount the disk.
mount -t minix $floppy /mnt

# Temporary directories
E=/var/tmp/extract-tmp-$$

# The home of the scripts used by this script.
scripts=`pwd`/scripts/rootdisk

exit=false

for i in \
	$scripts/EXTRACT_LIST \
	$scripts/SMALL_BASE_LIST \
	$scripts/LINKS \
	;do
	if [ ! -f $i ]; then
		echo "Can't open $i"
		exit=true
	fi
done
if $exit; then
	exit -1
fi

# A list of all the packages that are the source of files in the base archive.
EXTRACT="`cat $scripts/EXTRACT_LIST`"

# A list of all the hard links to make to the "busybox" program.
LINKS="`cat $scripts/LINKS`"

# Expand the package names into full pathnames.
PACKAGE_PATHS=""
for i in $EXTRACT; do
	p=`last $archive/$i""_*.deb`
	if [ ! -f $p ]; then
		echo "Can't find package" $p 1>& 2
		exit=true
	fi
	PACKAGE_PATHS=$PACKAGE_PATHS" "$p
done
if $exit; then
	exit -1
fi

if [ -d $E ]; then
	mv -f $E $E.old
	rm -f -r $E.old &
fi

mkdir -p -m 755 $E

for i in $PACKAGE_PATHS; do
	# echo Extracting $i 1>&2
	dpkg-deb --extract $i $E
done

# Bug:
# MAKEDEV-C doesn't take an argument to select the config file, so we are
# currently using the installed ones in /etc.

(mkdir /mnt/dev; cd /mnt/dev; $E/dev/MAKEDEV -c -I generic)

$scripts/strip_executables $E/bin/* $E/usr/bin/* $E/sbin/* $E/usr/sbin/* \
 $E/lib/* $E/usr/lib/*

(cd $scripts/prototype; tar clf - .)|(cd /mnt;tar xlpf -)
# Use tar to do the copying because it preserves hard links.
(cd $E/usr/lib/kbd/keytables; gzip -9 *)
(cd $E; tar --files-from=$scripts/SMALL_BASE_LIST -cf -)|(cd /mnt;tar xlpf -)
(cd $E/lib; cp \
	`last ld-linux.so.*` \
	`last libcom_err.so.*` \
	`last libe2p.so.*` \
	`last libext2fs.so.*` \
	`last libm.so.*` \
	`last libuuid.so.*` \
 /mnt/lib )

rm -f -r $E &

cp utilities/busybox/busybox /mnt/sbin/init
$scripts/strip_executables /mnt/sbin/init
(cd /mnt; for j in ${LINKS}; do { ln sbin/init $j }; done)
(cd /mnt/bin; ln ash sh)
(cd /mnt/bin; ln ae edit)
(cd /mnt/lib; ln `last ld-linux.*` ld-linux.so.1)
(cd /mnt/sbin; ln e2fsck fsck.ext2)

# Kludge - remove when this is fixed.
if [ "$arch" = "m68k" ]; then
#Until now linux-m68k has no fdisks in util-linux.deb
#I've only a beta version for atari und amiga from the
#programmer.
  cp /sbin/fdisk /sbin/cfdisk /sbin/atari-fdisk /sbin/afdisk /usr/bin/grep /mnt/sbin
#and same devices are missing in base.deb
  cp -a /dev/atarimouse /dev/amigamouse "/dev/fb0*" "/dev/ad*" $B/dev
fi

EXECUTABLES="/mnt/bin/* /mnt/sbin/* /mnt/usr/bin/* /mnt/lib/* /mnt/usr/lib/*"
$scripts/generate_library libncurses.so.3.0 /usr/lib/libncurses3.0_pic.a \
 /mnt/lib/libncurses.so.3.0 $EXECUTABLES

$scripts/generate_library libc.so.5 /usr/lib/libc5_pic.a /mnt/lib/libc.so.5 \
	$EXECUTABLES

chroot /mnt /sbin/ldconfig.new -v
rm -f /mnt/sbin/ldconfig.new &

# Replace symbolic links on the floppy with hard links! This saves one block
# per link.
(cd /mnt;find . -type l -printf '(cd `dirname %p`;if [ ! -d %l ]; then rm %f; ln %l %f; fi)\n')

echo "root">/mnt/type.txt

# Umount the floppy and copy it to a compressed raw disk image file.
df /mnt
umount $floppy
(rm -f -r root.bin;true)
dd if=$floppy bs=1k count=$blocks | gzip > root.bin
ls -l root.bin
exit 0
