#include "internal.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

const char	kill_usage[] = "kill [-signal] process-id [process-id ...]\n";

struct signal_name {
	const char *	name;
	int				number;
};

const struct signal_name signames[] = {
	{ "HUP",	SIGHUP },
	{ "INT",	SIGINT },
	{ "QUIT",	SIGQUIT },
	{ "ILL",	SIGILL },
	{ "TRAP",	SIGTRAP },
	{ "ABRT",	SIGABRT },
	{ "IOT",	SIGIOT },
	{ "BUS",	SIGBUS },
	{ "FPE",	SIGFPE },
	{ "KILL",	SIGKILL },
	{ "USR1",	SIGUSR1 },
	{ "SEGV",	SIGSEGV },
	{ "USR2",	SIGUSR2 },
	{ "PIPE",	SIGPIPE },
	{ "ALRM",	SIGALRM },
	{ "TERM",	SIGTERM },
	{ "STKFLT",	SIGSTKFLT },
	{ "CHLD",	SIGCHLD },
	{ "CONT",	SIGCONT },
	{ "STOP",	SIGSTOP },
	{ "TSTP",	SIGTSTP },
	{ "TTIN",	SIGTTIN },
	{ "TTOU",	SIGTTOU },
	{ "URG",	SIGURG },
	{ "XCPU",	SIGXCPU },
	{ "XFSZ",	SIGXFSZ },
	{ "VTALRM",	SIGVTALRM },
	{ "PROF",	SIGPROF },
	{ "WINCH",	SIGWINCH },
	{ "IO",		SIGIO },
	{ "POLL",	SIGPOLL },
	{ "PWR",	SIGPWR },
	{ "UNUSED",	SIGUNUSED },
	{ 0,		0		}
};

extern int
kill_main(struct FileInfo * i, int argc, char * * argv)
{
	int	had_error = 0;
	int	sig = SIGTERM;
	if ( argv[1][0] == '-' ) {
		if ( argv[1][1] >= '0' && argv[1][1] <= '9' ) {
			sig = atoi(&argv[1][1]);
			if ( sig < 0 || sig >= NSIG ) {
				usage(kill_usage);
				exit(-1);
			}
		}
		else {
			const struct signal_name *	s = signames;
			for ( ; ; ) {
				if ( strcmp(s->name, &argv[1][1]) == 0 ) {
					sig = s->number;
					break;
				}
				s++;
				if ( s->name == 0 ) {
					usage(kill_usage);
					exit(-1);
				}
			}
		}
		argv++;
		argc--;

	}
	while ( argc > 1 ) {
		int	pid;
		if ( argv[1][0] < '0' || argv[1][0] > '9' ) {
			usage(kill_usage);
			exit(-1);
		}
		pid = atoi(argv[1]);
		if ( kill(pid, sig) != 0 ) {
			had_error = 1;
			perror(argv[1]);
		}
		argv++;
		argc--;
	}
	if ( had_error )
		return -1;
	else
		return 0;
}
