------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                   A D A . C A L E N D A R . D E L A Y S                  --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--    Copyright (C) 1991, 92, 93, 94, 1995 Free Software Foundation, Inc.   --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This implemetation is a version where no tasking supports provided.

with Interfaces.C.POSIX_Error; use Interfaces.C.POSIX_Error;

with System.Task_Timer;
--  Used for, Timer

package body Ada.Calendar.Delays is

   procedure Put_Character (C : Integer);
   pragma Import (C, Put_Character, "putchar");

   procedure Prog_Exit (Status : Integer);
   pragma Import (C, Prog_Exit, "exit");

   procedure Write_Character (C : Character);
   procedure Write_EOL;
   procedure Write_String (S : String);
   --  Debugging procedures used for assertion output

   procedure Unimplemented (Feature : String);
   --  This procedure writes out a message to the effect that the
   --  feature specified by the Feature string is unimplemented,
   --  and halts the program.

   ---------------------
   -- Write_Character --
   ---------------------

   procedure Write_Character (C : Character) is
   begin
      Put_Character (Character'Pos (C));
   end Write_Character;

   ---------------
   -- Write_Eol --
   ---------------

   procedure Write_EOL is
   begin
      Write_Character (Ascii.LF);
   end Write_EOL;

   ------------------
   -- Write_String --
   ------------------

   procedure Write_String (S : String) is
   begin
      for J in S'Range loop
         Write_Character (S (J));
      end loop;
   end Write_String;

   -------------------
   -- Unimplemented --
   -------------------

   procedure Unimplemented (Feature : String) is
   begin
      Write_String (Feature);
      Write_String (" is unimplemented in this version of GNARL.");
      Write_EOL;
      Prog_Exit (1);
   end Unimplemented;

   ------------------
   -- Delay_Object --
   ------------------

   protected body Delay_Object is
      entry Wait (T : Duration; D : access System.Task_Timer.Delay_Block)
        when True is

      begin
         Unimplemented ("Tasking");
      end Wait;
   end Delay_Object;

   ------------------------
   -- Delay_Until_Object --
   ------------------------

   protected body Delay_Until_Object is
      entry Wait (T : Time; D : access System.Task_Timer.Delay_Block)
        when True is

      begin
         Unimplemented ("Tasking");
      end Wait;
   end Delay_Until_Object;

   function sleep (How_Long : Natural) return  Return_Code;
   pragma Import (C, sleep, "sleep");

   ---------------
   -- Delay_For --
   ---------------

   procedure Delay_For (D : Duration) is
      Result : Return_Code;
   begin
      if D > 0.0 then
         Result := sleep (Natural (D));
      end if;
   end Delay_For;

   -----------------
   -- Delay_Until --
   -----------------

   procedure Delay_Until (T : Time) is
      Result : Return_Code;
      Current_Time : Time := Clock;
   begin
      if T > Current_Time then
         Result := sleep (Natural (T - Current_Time));
      end if;
   end Delay_Until;

end Ada.Calendar.Delays;
