------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                     S Y S T E M . I N T E R R U P T S                    --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.3 $                            --
--                                                                          --
--     Copyright (C) 1992,1993,1994,1995 Free Software Foundation, Inc.     --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This implemetation is a version where no tasking supports provided.

package body System.Interrupts is

   procedure Put_Character (C : Integer);
   pragma Import (C, Put_Character, "putchar");

   procedure Prog_Exit (Status : Integer);
   pragma Import (C, Prog_Exit, "exit");

   procedure Write_Character (C : Character);
   procedure Write_EOL;
   procedure Write_String (S : String);
   --  Debugging procedures used for assertion output

   procedure Unimplemented (Feature : String);
   --  This procedure writes out a message to the effect that the
   --  feature specified by the Feature string is unimplemented,
   --  and halts the program.

   ---------------------
   -- Write_Character --
   ---------------------

   procedure Write_Character (C : Character) is
   begin
      Put_Character (Character'Pos (C));
   end Write_Character;

   ---------------
   -- Write_Eol --
   ---------------

   procedure Write_EOL is
   begin
      Write_Character (Ascii.LF);
   end Write_EOL;

   ------------------
   -- Write_String --
   ------------------

   procedure Write_String (S : String) is
   begin
      for J in S'Range loop
         Write_Character (S (J));
      end loop;
   end Write_String;

   -------------------
   -- Unimplemented --
   -------------------

   procedure Unimplemented (Feature : String) is
   begin
      Write_String (Feature);
      Write_String (" is unimplemented in this version of GNARL.");
      Write_EOL;
      Prog_Exit (1);
   end Unimplemented;

   -----------------
   -- Is_Reserved --
   -----------------

   function Is_Reserved (Interrupt : Ada.Interrupts.Interrupt_ID)
     return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end Is_Reserved;

   -----------------
   -- Is_Attached --
   -----------------

   function Is_Attached (Interrupt : Ada.Interrupts.Interrupt_ID)
     return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end Is_Attached;

   ---------------------
   -- Current_Handler --
   ---------------------

   function Current_Handler (Interrupt : Ada.Interrupts.Interrupt_ID)
     return Ada.Interrupts.Parameterless_Handler is
   begin
      Unimplemented ("Tasking");
      return null;
   end Current_Handler;

   --------------------
   -- Attach_Handler --
   --------------------

   procedure Attach_Handler
     (New_Handler : Ada.Interrupts.Parameterless_Handler;
      Interrupt   : Ada.Interrupts.Interrupt_ID;
      Static      : boolean := false) is
   begin
      Unimplemented ("Tasking");
   end Attach_Handler;

   ----------------------
   -- Exchange_Handler --
   ----------------------

   procedure Exchange_Handler
     (Old_Handler : out Ada.Interrupts.Parameterless_Handler;
      New_Handler : Ada.Interrupts.Parameterless_Handler;
      Interrupt   : Ada.Interrupts.Interrupt_ID;
      Static      : boolean := false) is
   begin
      Unimplemented ("Tasking");
   end Exchange_Handler;

   --------------------
   -- Detach_Handler --
   --------------------

   procedure Detach_Handler
     (Interrupt : Ada.Interrupts.Interrupt_ID;
      Static    : boolean := false) is
   begin
      Unimplemented ("Tasking");
   end Detach_Handler;

   ---------------
   -- Reference --
   ---------------

   function Reference (Interrupt : Ada.Interrupts.Interrupt_ID)
     return System.Address is
   begin
      Unimplemented ("Tasking");
      return System.Null_Address;
   end Reference;

   --------------------------------
   -- Register_Interrupt_Handler --
   --------------------------------

   procedure Register_Interrupt_Handler
     (Handler : Ada.Interrupts.Parameterless_Handler) is
   begin
      Unimplemented ("Tasking");
   end Register_Interrupt_Handler;

   -----------------------------
   -- Bind_Interrupt_To_Entry --
   -----------------------------

   procedure Bind_Interrupt_To_Entry
     (T       : System.Tasking.Task_ID;
      E       : System.Tasking.Task_Entry_Index;
      Int_Ref : System.Address) is
   begin
      Unimplemented ("Tasking");
   end Bind_Interrupt_To_Entry;

   ------------------------------
   -- Detach_Interrupt_Entries --
   ------------------------------

   procedure Detach_Interrupt_Entries (T : Tasking.Task_ID) is
   begin
      Unimplemented ("Tasking");
   end Detach_Interrupt_Entries;

   ---------------------
   -- Block_Interrupt --
   ---------------------

   procedure Block_Interrupt (Interrupt : Ada.Interrupts.Interrupt_ID) is
   begin
      Unimplemented ("Tasking");
   end Block_Interrupt;

   -----------------------
   -- Unblock_Interrupt --
   -----------------------

   procedure Unblock_Interrupt (Interrupt : Ada.Interrupts.Interrupt_ID) is
   begin
      Unimplemented ("Tasking");
   end Unblock_Interrupt;

   ----------------
   -- Is_Blocked --
   ----------------

   function Is_Blocked (Interrupt : Ada.Interrupts.Interrupt_ID)
      return boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end Is_Blocked;

end System.Interrupts;
