------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                  ADA.TEXT_IO.WIDE_TEXT_IO.TEXT_STREAMS                   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.1 $                              --
--                                                                          --
-- This specification is adapted from the Ada Reference Manual for use with --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------

--  This is the RM package Ada.Wide_Text_IO.Text_Streams. Since in GNAT the
--  parent Ada.Wide_Text_IO is a child of Ada.Text_IO, this package must be
--  a child of Ada.Text_IO.Wide_Text_IO. The library level renaming of the
--  package Ada.Text_IO.Wide_Text_IO as Ada.Wide_Text_IO will automatically
--  make this package visible as Ada.Wide_Text_IO.Text_Streams.

with Ada.Streams;

private package Ada.Text_IO.Wide_Text_IO.Text_Streams is

   type Stream_Access is access all Streams.Root_Stream_Type'Class;

   function Stream (File : in File_Type) return Stream_Access;

end Ada.Text_IO.Wide_Text_IO.Text_Streams;
