/**
 *
 * $Id: ListP.h,v 1.6 1996/01/08 06:27:45 toshok Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef LIST_PRIVATE_INCLUDED
#define LIST_PRIVATE_INCLUDED

#include <Xm/List.h>
#include <Xm/PrimitiveP.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>

#ifdef __cplusplus
extern "C" {
#endif

/* internal structure used to lay out the
   list elements. */

typedef struct {
    _XmString name;
    Dimension height;
    Dimension width;
    Dimension CumHeight; /* the cumulative height, including this widget */
    Boolean selected;
    Boolean last_selected;
    Boolean LastTimeDrawn;
    unsigned short NumLines;
    int length;
} Element, *ElementPtr;

/* Define the list instance part */

typedef struct {       
    Dimension spacing;
    short ItemSpacing;   
    Dimension margin_width;
    Dimension margin_height;
    XmFontList font;
    XmString *items;
    int itemCount;
    XmString *selectedItems;
    int *selectedIndices; /* new */
    int selectedItemCount;
    int visibleItemCount;
    int LastSetVizCount; /* new */
    unsigned char SelectionPolicy;
    unsigned char ScrollBarDisplayPolicy;
    unsigned char SizePolicy;
    XmStringDirection StrDir;

    Boolean AutoSelect;
    Boolean DidSelection; /* new */
    Boolean FromSetSB; /* new */
    Boolean FromSetNewSize; /* new */
    Boolean AddMode;
    unsigned char LeaveDir; /* new */
    unsigned char HighlightThickness;
    int                ClickInterval;
    XtIntervalId DragID; /* new */
    XtCallbackList     SingleCallback;
    XtCallbackList     MultipleCallback;
    XtCallbackList     ExtendCallback;
    XtCallbackList     BrowseCallback;
    XtCallbackList     DefaultCallback;

    GC NormalGC;
    GC InverseGC;
    GC HighlightGC;
    Pixmap DashTile;          /* new */
    ElementPtr *InternalList; /* new */
    int LastItem;             /* new */
    int FontHeight;           /* new */
    int                top_position;
    char Event;               /* new */
    int LastHLItem;
    int StartItem;            /* new */
    int OldStartItem;         /* new */
    int EndItem;              /* new */
    int OldEndItem;           /* new */
    Position BaseX;           /* new */
    Position BaseY;           /* new */
    Boolean MouseMoved;       /* new */
    Boolean AppendInProgress; /* new */
    Boolean Traversing;       /* new */
    Boolean KbdSelection;     /* new */
    
    short DownCount;          /* new */
    Time DownTime;            /* new */
    int CurrentKbdItem;       /* new */
    unsigned char SelectionType; /* new */
    GC InsensitiveGC;         /* new */

    int vmin; /* new */
    int vmax; /* new */
    int vOrigin; /* new */
    int vExtent; /* new */

    int hmin; /* new */
    int hmax; /* new */
    int hOrigin; /* new */
    int hExtent; /* new */

    Dimension MaxWidth; /* new */
    Dimension CharWidth; /* new */
    Position XOrigin; /* new */

    XmScrollBarWidget             hScrollBar;
    XmScrollBarWidget             vScrollBar;
    XmScrolledWindowWidget Mom; /* new */
    Dimension MaxItemHeight;
} XmListPart;

/* Define the full instance record */
typedef struct _XmListRec {
    CorePart core;
    XmPrimitivePart primitive;
    XmListPart list;
} XmListRec;

/* Define class part structure */
typedef struct {
    XtPointer extension;
} XmListClassPart;

/* Define the full class record */
typedef struct _XmListClassRec {
    CoreClassPart core_class;
    XmPrimitiveClassPart primitive_class;
    XmListClassPart list_class;
} XmListClassRec;

/* External definition for class record */
extern XmListClassRec xmListClassRec;

#ifdef __cplusplus
};
#endif

#define List_InternalList(w) \
    (((XmListWidget)(w))->list.InternalList)

#define List_Event(w) \
    (((XmListWidget)(w))->list.Event)

#define List_LastItem(w) \
    (((XmListWidget)(w))->list.LastItem)

#define List_FontHeight(w) \
    (((XmListWidget)(w))->list.FontHeight)

#define List_AutoSelect(w) \
    (((XmListWidget)(w))->list.AutoSelect)

#define List_DidSelection(w) \
    (((XmListWidget)(w))->list.DidSelection)

#define List_FromSetSB(w) \
    (((XmListWidget)(w))->list.FromSetSB)

#define List_FromSetNewSize(w) \
    (((XmListWidget)(w))->list.FromSetNewSize)

#define List_LeaveDir(w) \
    (((XmListWidget)(w))->list.LeaveDir)

#define List_BrowseCallback(w) \
    (((XmListWidget)(w))->list.BrowseCallback)

#define List_ExtendCallback(w) \
    (((XmListWidget)(w))->list.ExtendCallback)

#define List_DefaultCallback(w) \
    (((XmListWidget)(w))->list.DefaultCallback)

#define List_ClickInterval(w) \
    (((XmListWidget)(w))->list.ClickInterval)

#define List_DragID(w) \
    (((XmListWidget)(w))->list.DragID)

#define List_Font(w) \
    (((XmListWidget)(w))->list.font)

#define List_ItemCount(w) \
    (((XmListWidget)(w))->list.itemCount)

#define List_SelectedItemCount(w) \
    (((XmListWidget)(w))->list.selectedItemCount)

#define List_VisibleItemCount(w) \
    (((XmListWidget)(w))->list.visibleItemCount)

#define List_LastSetVizCount(w) \
    (((XmListWidget)(w))->list.LastSetVizCount)

#define List_Items(w) \
    (((XmListWidget)(w))->list.items)

#define List_SelectedItems(w) \
    (((XmListWidget)(w))->list.selectedItems)

#define List_SelectedIndices(w) \
    (((XmListWidget)(w))->list.selectedIndices)

#define List_MarginHeight(w) \
    (((XmListWidget)(w))->list.margin_height)

#define List_MarginWidth(w) \
    (((XmListWidget)(w))->list.margin_width)

#define List_SizePolicy(w) \
    (((XmListWidget)(w))->list.SizePolicy)

#define List_ItemSpacing(w) \
    (((XmListWidget)(w))->list.ItemSpacing)

#define List_Spacing(w) \
    (((XmListWidget)(w))->list.spacing)

#define List_MultipleCallback(w) \
    (((XmListWidget)(w))->list.MultipleCallback)

#define List_SingleCallback(w) \
    (((XmListWidget)(w))->list.SingleCallback)

#define List_SBDisplayPolicy(w) \
    (((XmListWidget)(w))->list.ScrollBarDisplayPolicy)

#define List_SelectionPolicy(w) \
    (((XmListWidget)(w))->list.SelectionPolicy)

#define List_StrDir(w) \
    (((XmListWidget)(w))->list.StrDir)

#define List_TopPosition(w) \
    (((XmListWidget)(w))->list.top_position)

#define List_AddMode(w) \
    (((XmListWidget)(w))->list.AddMode)

#define List_NormalGC(w) \
    (((XmListWidget)(w))->list.NormalGC)

#define List_InsensitiveGC(w) \
    (((XmListWidget)(w))->list.InsensitiveGC)

#define List_InverseGC(w) \
    (((XmListWidget)(w))->list.InverseGC)

#define List_HighlightGC(w) \
    (((XmListWidget)(w))->list.HighlightGC)

#define List_DashTile(w) \
    (((XmListWidget)(w))->list.DashTile)

#define List_HighlightThickness(w) \
    (((XmListWidget)(w))->list.HighlightThickness)

#define List_LastHLItem(w) \
    (((XmListWidget)(w))->list.LastHLItem)

#define List_StartItem(w) \
    (((XmListWidget)(w))->list.StartItem)

#define List_OldStartItem(w) \
    (((XmListWidget)(w))->list.OldStartItem)

#define List_EndItem(w) \
    (((XmListWidget)(w))->list.EndItem)

#define List_OldEndItem(w) \
    (((XmListWidget)(w))->list.OldEndItem)

#define List_BaseX(w) \
    (((XmListWidget)(w))->list.BaseX)

#define List_BaseY(w) \
    (((XmListWidget)(w))->list.BaseY)

#define List_MouseMoved(w) \
    (((XmListWidget)(w))->list.MouseMoved)

#define List_AppendInProgress(w) \
    (((XmListWidget)(w))->list.AppendInProgress)

#define List_Traversing(w) \
    (((XmListWidget)(w))->list.Traversing)

#define List_KbdSelection(w) \
    (((XmListWidget)(w))->list.KbdSelection)

#define List_DownCount(w) \
    (((XmListWidget)(w))->list.DownCount)

#define List_DownTime(w) \
    (((XmListWidget)(w))->list.DownTime)

#define List_CurrentKbdItem(w) \
    (((XmListWidget)(w))->list.CurrentKbdItem)

#define List_SelectionType(w) \
    (((XmListWidget)(w))->list.SelectionType)

#define List_MaxWidth(w) \
    (((XmListWidget)(w))->list.MaxWidth)

#define List_CharWidth(w) \
    (((XmListWidget)(w))->list.CharWidth)

#define List_XOrigin(w) \
    (((XmListWidget)(w))->list.XOrigin)

#define List_MaxItemHeight(w) \
    (((XmListWidget)(w))->list.MaxItemHeight)

#define List_IsScrolledList(w) \
    (((XmListWidget)(w))->list.Mom != NULL)

#define List_HSB(w) \
    (((XmListWidget)(w))->list.hScrollBar)

#define List_Hmax(w) \
    (((XmListWidget)(w))->list.hmax)

#define List_Horigin(w) \
    (((XmListWidget)(w))->list.hOrigin)

#define List_Hextent(w) \
    (((XmListWidget)(w))->list.hExtent)

#define List_Hmin(w) \
    (((XmListWidget)(w))->list.hmin)

#define List_Mom(w) \
    (((XmListWidget)(w))->list.Mom)

#define List_VSB(w) \
    (((XmListWidget)(w))->list.vScrollBar)

#define List_Vmax(w) \
    (((XmListWidget)(w))->list.vmax)

#define List_Vmin(w) \
    (((XmListWidget)(w))->list.vmin)

#define List_Vorigin(w) \
    (((XmListWidget)(w))->list.vOrigin)

#define List_Vextent(w) \
    (((XmListWidget)(w))->list.vExtent)

#endif /* LIST_PRIVATE_INCLUDED */
