/**
 *
 * $Id: ScrollBarP.h,v 1.3 1996/02/21 03:58:22 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_SCROLLBAR_P_H
#define XM_SCROLLBAR_P_H

#include <Xm/ScrollBar.h>
#include <Xm/PrimitiveP.h>

#define MIN_SLIDER_THICKNESS	1
#define MIN_SLIDER_LENGTH	6

#ifdef __cplusplus
extern "C" {
#endif

/* define the instance record */
typedef struct {
    int value;
    int minimum;
    int maximum;
    int slider_size;

    unsigned char orientation;
    unsigned char processing_direction;
    Boolean show_arrows;

    int increment;
    int page_increment;

    int initial_delay;
    int repeat_delay;

    XtCallbackList value_changed_callback;
    XtCallbackList increment_callback;
    XtCallbackList decrement_callback;
    XtCallbackList page_increment_callback;
    XtCallbackList page_decrement_callback;
    XtCallbackList to_top_callback;
    XtCallbackList to_bottom_callback;
    XtCallbackList drag_callback;

    /* Obsolete M*tif compatability */
    GC unhighlight_GC;
    /********************************/

    GC foreground_GC;
    Pixel trough_color;

    /* private instance variables... don't look here for a good time*/
    Pixmap pixmap;
    Boolean sliding_on;
    Boolean etched_slider;
    int saved_value;

    unsigned char flags;

    unsigned char change_type;
    XtIntervalId timer;

    short initial_x;
    short initial_y;
    short separation_x;
    short separation_y;

    int slider_x;
    int slider_y;
    int slider_width;
    int slider_height;

    int slider_area_x;
    int slider_area_y;
    int slider_area_width;
    int slider_area_height;

    int arrow1_x;
    int arrow1_y;
    unsigned char arrow1_orientation;
    Boolean arrow1_selected;
    
    int arrow2_x;
    int arrow2_y;
    unsigned char arrow2_orientation;
    Boolean arrow2_selected;

    int arrow_width;
    int arrow_height;

    /* obsolescent fields that M*tif has, but apparently doesn't use */
    short arrow1_top_count;
    short arrow1_cent_count;
    short arrow1_bot_count;

    XRectangle * arrow1_top;
    XRectangle * arrow1_cent;
    XRectangle * arrow1_bot;

    short arrow2_top_count;
    short arrow2_cent_count;
    short arrow2_bot_count;

    XRectangle * arrow2_top;
    XRectangle * arrow2_cent;
    XRectangle * arrow2_bot;
    /***********/

    GC unavailable_GC;
} XmScrollBarPart;

/* define the full instance record */
typedef struct _XmScrollBarRec {
    CorePart core;
    XmPrimitivePart primitive;
    XmScrollBarPart scrollBar;
} XmScrollBarRec;

/* Define class part structure */
typedef struct {
    XtPointer extension;
} XmScrollBarClassPart;

/* define the full class record */

typedef struct _XmScrollBarClassRec {
    CoreClassPart core_class;
    XmPrimitiveClassPart primitive_class;
    XmScrollBarClassPart scrollBar_class;
} XmScrollBarClassRec;

/* External definition for class record */

extern XmScrollBarClassRec xmScrollBarClassRec;

/* Private function declaration */

extern void _XmSetEtchedSlider(XmScrollBarWidget);


/*
 * easy access macros
 */
#define SCB_Value(w) \
    (((XmScrollBarWidget)(w))->scrollBar.value)

#define SCB_Minimum(w) \
    (((XmScrollBarWidget)(w))->scrollBar.minimum)

#define SCB_Maximum(w) \
    (((XmScrollBarWidget)(w))->scrollBar.maximum)

#define SCB_SliderSize(w) \
    (((XmScrollBarWidget)(w))->scrollBar.slider_size)

#define SCB_Orientation(w) \
    (((XmScrollBarWidget)(w))->scrollBar.orientation)

#define SCB_ProcessingDirection(w) \
    (((XmScrollBarWidget)(w))->scrollBar.processing_direction)

#define SCB_ShowArrows(w) \
    (((XmScrollBarWidget)(w))->scrollBar.show_arrows)

#define SCB_Increment(w) \
    (((XmScrollBarWidget)(w))->scrollBar.increment)

#define SCB_PageIncrement(w) \
    (((XmScrollBarWidget)(w))->scrollBar.page_increment)

#define SCB_InitialDelay(w) \
    (((XmScrollBarWidget)(w))->scrollBar.initial_delay)

#define SCB_RepeatDelay(w) \
    (((XmScrollBarWidget)(w))->scrollBar.repeat_delay)

#define SCB_ValueChangedCallback(w) \
    (((XmScrollBarWidget)(w))->scrollBar.value_changed_callback)

#define SCB_IncrementCallback(w) \
    (((XmScrollBarWidget)(w))->scrollBar.increment_callback)

#define SCB_DecrementCallback(w) \
    (((XmScrollBarWidget)(w))->scrollBar.decrement_callback)

#define SCB_PageIncrementCallback(w) \
    (((XmScrollBarWidget)(w))->scrollBar.page_increment_callback)

#define SCB_PageDecrementCallback(w) \
    (((XmScrollBarWidget)(w))->scrollBar.page_decrement_callback)

#define SCB_ToTopCallback(w) \
    (((XmScrollBarWidget)(w))->scrollBar.to_top_callback)

#define SCB_ToBottomCallback(w) \
    (((XmScrollBarWidget)(w))->scrollBar.to_bottom_callback)

#define SCB_DragCallback(w) \
    (((XmScrollBarWidget)(w))->scrollBar.drag_callback)

#define SCB_ForegroundGC(w) \
    (((XmScrollBarWidget)(w))->scrollBar.foreground_GC)

#define SCB_TroughColor(w) \
    (((XmScrollBarWidget)(w))->scrollBar.trough_color)

#define SCB_Pixmap(w) \
    (((XmScrollBarWidget)(w))->scrollBar.pixmap)

#define SCB_SlidingOn(w) \
    (((XmScrollBarWidget)(w))->scrollBar.sliding_on)

#define SCB_EtchedSlider(w) \
    (((XmScrollBarWidget)(w))->scrollBar.etched_slider)

#define SCB_SavedValue(w) \
    (((XmScrollBarWidget)(w))->scrollBar.saved_value)

#define SCB_Flags(w) \
    (((XmScrollBarWidget)(w))->scrollBar.flags)

#define SCB_ChangeType(w) \
    (((XmScrollBarWidget)(w))->scrollBar.change_type)

#define SCB_Timer(w) \
    (((XmScrollBarWidget)(w))->scrollBar.timer)

#define SCB_InitialX(w) \
    (((XmScrollBarWidget)(w))->scrollBar.initial_x)

#define SCB_InitialY(w) \
    (((XmScrollBarWidget)(w))->scrollBar.initial_y)

#define SCB_SeparationX(w) \
    (((XmScrollBarWidget)(w))->scrollBar.separation_x)

#define SCB_SeparationY(w) \
    (((XmScrollBarWidget)(w))->scrollBar.separation_y)

#define SCB_SliderX(w) \
    (((XmScrollBarWidget)(w))->scrollBar.slider_x)

#define SCB_SliderY(w) \
    (((XmScrollBarWidget)(w))->scrollBar.slider_y)

#define SCB_SliderWidth(w) \
    (((XmScrollBarWidget)(w))->scrollBar.slider_width)

#define SCB_SliderHeight(w) \
    (((XmScrollBarWidget)(w))->scrollBar.slider_height)

#define SCB_SliderAreaX(w) \
    (((XmScrollBarWidget)(w))->scrollBar.slider_area_x)

#define SCB_SliderAreaY(w) \
    (((XmScrollBarWidget)(w))->scrollBar.slider_area_y)

#define SCB_SliderAreaWidth(w) \
    (((XmScrollBarWidget)(w))->scrollBar.slider_area_width)

#define SCB_SliderAreaHeight(w) \
    (((XmScrollBarWidget)(w))->scrollBar.slider_area_height)

#define SCB_Arrow1X(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow1_x)

#define SCB_Arrow1Y(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow1_y)

#define SCB_Arrow1Orientation(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow1_orientation)

#define SCB_Arrow1Selected(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow1_selected)

#define SCB_Arrow2X(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow2_x)

#define SCB_Arrow2Y(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow2_y)

#define SCB_Arrow2Orientation(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow2_orientation)

#define SCB_Arrow2Selected(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow2_selected)

#define SCB_ArrowWidth(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow_width)

#define SCB_ArrowHeight(w) \
    (((XmScrollBarWidget)(w))->scrollBar.arrow_height)

#define SCB_UnavailableGC(w) \
    (((XmScrollBarWidget)(w))->scrollBar.unavailable_GC)

#define SCB_Offset(w) \
    (((XmScrollBarWidget)(w))->scrollBar.offset)

#ifdef __cplusplus
};
#endif

#endif /* XM_SCROLLBAR_P_H */
