/**
 *
 * $Id: ArrowB.c,v 1.19 1996/04/22 22:54:15 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: ArrowB.c,v 1.19 1996/04/22 22:54:15 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/ArrowBP.h>
#include <Xm/DebugUtil.h>
#include <Xm/TransltnsP.h>
#include <stdio.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static XtGeometryResult query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);

/*
 * Resources for the ArrowButton class
 */
#define Offset(field) XtOffsetOf(XmArrowButtonRec, arrowbutton.field)
static XtResource resources[] = {
    {
	XmNmultiClick, XmCMultiClick, XmRMultiClick,
	sizeof(unsigned char), Offset(multiClick),
	XmRImmediate, (XtPointer)XmMULTICLICK_KEEP
    },
    {
	XmNarrowDirection, XmCArrowDirection, XmRArrowDirection,
	sizeof(unsigned char), Offset(direction),
	XmRImmediate, (XtPointer)XmARROW_UP
    },
    {
	XmNactivateCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(activate_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNarmCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(arm_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNdisarmCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(disarm_callback),
	XmRPointer, (XtPointer)NULL
    }
};


static void Activate(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Arm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ArmAndActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Cancel(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Disarm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void EnterWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Help(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void LeaveWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MultiActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MultiArm(Widget w, XEvent *event, String *params, Cardinal *num_params);

char _XmArrowB_defaultTranslations[] =
    "<Btn1Down>:            Arm()\n\
     <Btn1Down>,<Btn1Up>:   Activate() Disarm()\n\
     <Btn1Down>(2+):        MultiArm()\n\
     <Btn1Up>(2+):          MultiActivate()\n\
     <Btn1Up>:              Activate() Disarm()\n\
     <EnterWindow>:         Enter()\n\
     <LeaveWindow>:         Leave()\n\
     :<Key>osfActivate:     PrimitiveParentActivate()\n\
     :<Key>osfCancel:       PrimitiveParentCancel()\n\
     :<Key>osfSelect:       ArmAndActivate()\n\
     :<Key>osfHelp:         Help()\n\
     ~s ~m ~a <Key>Return:  PrimitiveParentActivate()\n\
     ~s ~m ~a <Key>space:   ArmAndActivate()";

static XtActionsRec actions[] = {
    {"Activate",                Activate},
    {"Arm",                     Arm},
    {"ArmAndActivate",          ArmAndActivate},
    {"Cancel",                  Cancel},
    {"Disarm",                  Disarm},
    {"Enter",                   EnterWindow},
    {"Help",                    Help},
    {"Leave",                   LeaveWindow},
    {"MultiActivate",           MultiActivate},
    {"MultiArm",                MultiArm},
    {"PrimitiveParentActivate", _XmPrimitiveParentActivate},
    {"PrimitiveParentCancel",   _XmPrimitiveParentCancel}
};

static XmBaseClassExtRec _XmArrowBCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ NULL, /* FIXME */
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

XmPrimitiveClassExtRec _XmArrowBPrimClassExtRec = {
    /* next_extension      */ NULL,
    /* record_type         */ NULLQUARK,
    /* version             */ XmPrimitiveClassExtVersion,
    /* record_size         */ sizeof(XmPrimitiveClassExtRec),
    /* widget_baseline     */ NULL, /* FIX ME */
    /* widget_display_rect */ NULL, /* FIX ME */
    /* widget_margins      */ NULL  /* FIX ME */
};

XmArrowButtonClassRec xmArrowButtonClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmPrimitiveClassRec,
        /* class_name            */ "XmArrowButton",
	/* widget_size           */ sizeof(XmArrowButtonRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ XtInheritRealize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ TRUE,
	/* compress_exposure     */ XtExposeCompressMaximal,
	/* compress_enterleave   */ TRUE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ NULL,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ _XmArrowB_defaultTranslations,
	/* query_geometry        */ query_geometry,
	/* display_accelerator   */ XtInheritDisplayAccelerator,
	/* extension             */ (XtPointer)&_XmArrowBCoreClassExtRec
    },
    /* Primitive Class part */
    {
	/* border_highlight      */ XmInheritBorderHighlight,
        /* border_unhighlight    */ XmInheritBorderUnhighlight,
        /* translations          */ _XmArrowB_defaultTranslations,
        /* arm_and_activate_proc */ XmInheritArmAndActivate,
        /* synthetic resources   */ NULL,
	/* num syn res           */ 0,
        /* extension             */ (XtPointer)&_XmArrowBPrimClassExtRec,
    },
    /* ArrowButton Class part */
    {
	/* extension */ NULL
    }
};

WidgetClass xmArrowButtonWidgetClass = (WidgetClass)&xmArrowButtonClassRec;

static void
class_initialize()
{
    _XmArrowBCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmARROW_BUTTON_BIT);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    if (XtWidth(request) == (Dimension)0)
	XtWidth(new) = 20;
    if (XtHeight(request) == (Dimension)0)
	XtHeight(new) = 20;

    AB_Armed(new) = False;
    AB_ArrowGC(new) = XtAllocateGC(new,
				   0,0,
				   NULL,
				   0,0);
    AB_InsensitiveGC(new) = XtAllocateGC(new,
					 0,0,
					 NULL,
					 0,0);
    XSetFillStyle(XtDisplay(new),
		  AB_InsensitiveGC(new),
		  FillStippled);

    /* FIXME -- if the parent is a rc in a menu, need to set
       multiClick to XmMULTICLICK_DISCARD */

}

static void
destroy(Widget w)
{
    XtReleaseGC(w, AB_ArrowGC(w));
    XtReleaseGC(w, AB_InsensitiveGC(w));
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmArrowButtonWidget lw = (XmArrowButtonWidget) new;
    XmArrowButtonWidget ow = (XmArrowButtonWidget) old;
    Boolean refresh_needed = False;

    if (lw->arrowbutton.direction != ow->arrowbutton.direction)
	refresh_needed = True;

    return refresh_needed;
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
    Boolean State;
    int x,y;
    int xsize;
    int ysize;
    int margin = Prim_ShadowThickness(w) + Prim_HighlightThickness(w) + 1;
    GC myGC;
    

    x = margin;
    y = margin;
    xsize = XtWidth(w) - margin * 2;
    ysize = XtHeight(w) - margin * 2;

    if (XtSensitive(w))
	myGC = AB_ArrowGC(w);
    else
	myGC = AB_InsensitiveGC(w);

    XSetForeground(XtDisplay(w),
		   myGC,
		   Prim_Foreground(w));

    _XmDrawShadows(XtDisplay(w), 
		   XtWindow(w), 
		   Prim_TopShadowGC(w),
		   Prim_BottomShadowGC(w),
		   Prim_HighlightThickness(w),
		   Prim_HighlightThickness(w),
		   XtWidth(w) - 2 * Prim_HighlightThickness(w), 
		   XtHeight(w) - 2 * Prim_HighlightThickness(w),
		   Prim_ShadowThickness(w),
		   XmSHADOW_OUT);
		   
    State = AB_Armed(w);
    if (State) {
	_XmDrawArrow(XtDisplay(w),
		     XtWindow(w),
		     Prim_TopShadowGC(w),
		     Prim_BottomShadowGC(w),
		     myGC,
		     x, y,
		     xsize, ysize,
		     /* Per tegla@katalin.csoma.elte.hu, M*tif ignores
		        this
		     Prim_ShadowThickness(w),
		      */
		     1,
		     AB_Direction(w));
    }
    else {
	_XmDrawArrow(XtDisplay(w),
		     XtWindow(w),
		     Prim_BottomShadowGC(w),
		     Prim_TopShadowGC(w),
		     myGC,
		     x, y,
		     xsize, ysize,
		     /* Per tegla@katalin.csoma.elte.hu, M*tif ignores
		        this
		     Prim_ShadowThickness(w),
		      */
		     1,
		     AB_Direction(w));
    }

#define superclass (&xmPrimitiveClassRec)
    (*superclass->core_class.expose)(w, event, region);
#undef superclass
}

static XtGeometryResult 
query_geometry(Widget w, 
	       XtWidgetGeometry *proposed, 
	       XtWidgetGeometry *answer)
{
    XmArrowButtonWidget aw = (XmArrowButtonWidget)w;
    answer->request_mode = CWWidth | CWHeight;

    answer->width = XtWidth(w);

    answer->height = XtHeight(w);
    
    if (((proposed->request_mode & (CWWidth | CWHeight))
	 == (CWWidth | CWHeight)) &&
	proposed->width == answer->width &&
	proposed->height == answer->height)

	return XtGeometryYes;
    else if (answer->width == XtWidth(aw) &&
	     answer->height == XtHeight(aw))
	return XtGeometryNo;
    else 
	return XtGeometryAlmost;    
}


static void
Arm(Widget w,
    XEvent *event,
    String *params,
    Cardinal *num_params)
{
    XmArrowButtonCallbackStruct cbs;

    XdbDebug(__FILE__, w, "Arm\n");

    AB_Armed(w) = True;

    cbs.reason = XmCR_ARM;
    cbs.event = event;
    cbs.click_count = AB_ClickCount(w);
    XtCallCallbackList(w,
		       AB_ArmCallback(w),
		       (XtPointer)&cbs);

    expose(w, event, (Region)NULL);
}

static void 
Activate(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    XmArrowButtonCallbackStruct cbs;
    XButtonEvent *ev = (XButtonEvent *)event;

    XdbDebug(__FILE__, w, "Activate\n");

    if ((ev->x >= 0 && ev->x < XtWidth(w)) &&
	(ev->y >= 0 && ev->y < XtHeight(w))) {
	cbs.reason = XmCR_ACTIVATE;
	cbs.event = event;
	cbs.click_count = AB_ClickCount(w);
	XtCallCallbackList(w,
			   AB_ActivateCallback(w),
			   (XtPointer)&cbs);
    }
}

static void 
Disarm(Widget w,
       XEvent *event,
       String *params,
       Cardinal *num_params)
{
    XmArrowButtonCallbackStruct cbs;
    
    XdbDebug(__FILE__, w, "Disarm\n");

    cbs.reason = XmCR_DISARM;
    cbs.event = event;
    cbs.click_count = AB_ClickCount(w);
    XtCallCallbackList(w,
		       AB_DisarmCallback(w),
		       (XtPointer)&cbs);

    AB_Armed(w) = False;
    expose(w, event, (Region)NULL);
}

static void
ArmAndActivate(Widget w,
	       XEvent *event,
	       String *params,
	       Cardinal *num_params)
{
    Arm(w, event, params, num_params);
    Activate(w, event, params, num_params);
}

static void
EnterWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    int margin = Prim_ShadowThickness(w) + Prim_HighlightThickness(w) + 1;
    int xsize = XtWidth(w) - margin * 2;
    int ysize = XtHeight(w) - margin * 2;

    XtCallActionProc(w, "PrimitiveEnter", event, params, *num_params);

    if (AB_Armed(w)) 
        _XmDrawArrow(XtDisplay(w),
                     XtWindow(w),
                     Prim_TopShadowGC(w),
                     Prim_BottomShadowGC(w),
		     AB_ArrowGC(w),
                     margin, margin,
                     xsize, ysize,
                     /* Per tegla@katalin.csoma.elte.hu, M*tif ignores
                        this
                     Prim_ShadowThickness(w),
                      */
                     1,
                     AB_Direction(w));
}

static void
LeaveWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    int margin = Prim_ShadowThickness(w) + Prim_HighlightThickness(w) + 1;
    int xsize = XtWidth(w) - margin * 2;
    int ysize = XtHeight(w) - margin * 2;

    XtCallActionProc(w, "PrimitiveLeave", event, params, *num_params);

    if (AB_Armed(w))
	_XmDrawArrow(XtDisplay(w),
		     XtWindow(w),
		     Prim_BottomShadowGC(w),
		     Prim_TopShadowGC(w),
		     AB_ArrowGC(w),
		     margin, margin,
		     xsize, ysize,
		     /* Per tegla@katalin.csoma.elte.hu, M*tif ignores
		        this
		     Prim_ShadowThickness(w),
		      */
		     1,
		     AB_Direction(w));
}

static void
MultiArm(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MultiArm\n");
}

static void
MultiActivate(Widget w,
	      XEvent *event,
	      String *params,
	      Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "MultiActivate\n");
}

static void
Cancel(Widget w,
       XEvent *event,
       String *params,
       Cardinal *num_params)
{
}

static void
Help(Widget w,
       XEvent *event,
       String *params,
       Cardinal *num_params)
{
}

Widget
XmCreateArrowButton(Widget parent,
	            char *name,
                    Arg *arglist,
                    Cardinal argcount)
{
  return XtCreateWidget(name,
                        xmArrowButtonWidgetClass,
                        parent, arglist, argcount);
}
