/**
 *
 * $Id: Form.c,v 1.31 1996/05/02 07:10:56 u27113 Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: Form.c,v 1.31 1996/05/02 07:10:56 u27113 Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/DebugUtil.h>
#include <Xm/FormP.h>
#include <Xm/DialogS.h>
#include <Xm/XmI.h>
#include <stdio.h>

/* Don't touch these !! Danny */
#undef	DO_PREFERRED_STUFF
#undef	DO_BOGUS_STUFF
/* End touch stuff */

#undef	DEBUG
#undef	PRINT_ATTACHMENT
#undef	PRINT_ATTACHMENT_REPORT
#define	PRINT_REPORT
#define	PRINT_ASSIGNMENTS
#undef	PRINT_PREFERRED
#define	PRINT_LINENO

/* Behaviour of XmFormLayout */
#define	Mode_Normal	0x00
#define	Mode_Test	0x01
#define	Mode_Resize	0x02

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void resize(Widget w);
static void realize(Widget w, XtValueMask *value_mask, XSetWindowAttributes *attributes);
static XtGeometryResult query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static XtGeometryResult geometry_manager(Widget w, XtWidgetGeometry *request, XtWidgetGeometry *reply);
static void ChangeManaged(Widget w);
static void XmFormLayout(XmFormWidget f, int mode, Widget cw, XtWidgetGeometry *cg);
static void XmFormFindPreferred(XmFormWidget f);

static void form_constraint_initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static Boolean form_constraint_set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void FormInsertChild(Widget w);

void XmFormPrintAttachmentReport(XmFormWidget f);

/*
 * Resources for the Form class
 */
#define Offset(field) XtOffsetOf(XmFormRec, form.field)
static XtResource resources[] = {
    {
	XmNmarginWidth, XmCMarginWidth, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmFormRec, bulletin_board.margin_width),
	XmRImmediate, (XtPointer)10
	/* FIXME: should be XmRImmediate, (XtPointer)XmINVALID_DIMENSION */
    },
    {
	XmNmarginHeight, XmCMarginHeight, XmRVerticalDimension,
	sizeof(Dimension), XtOffsetOf(XmFormRec, bulletin_board.margin_height),
	XmRImmediate, (XtPointer)10
	/* FIXME: should be XmRImmediate, (XtPointer)XmINVALID_DIMENSION */
    },
    {
	XmNhorizontalSpacing, XmCSpacing, XmRHorizontalDimension,
	sizeof(Dimension), Offset(horizontal_spacing),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNverticalSpacing, XmCSpacing, XmRVerticalDimension,
	sizeof(Dimension), Offset(vertical_spacing),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNfractionBase, XmCMaxValue, XmRInt,
	sizeof(int), Offset(fraction_base),
	XmRImmediate, (XtPointer)100
    },
    {
	XmNrubberPositioning, XmCRubberPositioning, XmRBoolean,
	sizeof(Boolean), Offset(rubber_positioning),
	XmRImmediate, (XtPointer)False
    }
};

static XmSyntheticResource syn_resources[] = {
    {
	XmNmarginWidth,
	sizeof(Dimension), XtOffsetOf(XmFormRec, bulletin_board.margin_width),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNmarginHeight,
	sizeof(Dimension), XtOffsetOf(XmFormRec, bulletin_board.margin_height),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNhorizontalSpacing,
	sizeof(Dimension), Offset(horizontal_spacing),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNverticalSpacing,
	sizeof(Dimension), Offset(vertical_spacing),
	_XmFromVerticalPixels, _XmToVerticalPixels
    }
};

#undef Offset

#define Offset(field) XtOffsetOf(XmFormConstraintRec, form.field)

#define LEFT 0
#define RIGHT 1
#define TOP 2
#define BOTTOM 3

#define	BOGUS_BORDER	20000		/* I've never seen a screen this large */

static XtResource formConstraintResources[] = {
    {
	XmNtopAttachment, XmCAttachment, XmRAttachment,
	sizeof(unsigned char), Offset(atta[TOP].type),
	XmRImmediate, (XtPointer)XmATTACH_NONE
    },
    {
	XmNbottomAttachment, XmCAttachment, XmRAttachment,
	sizeof(unsigned char), Offset(atta[BOTTOM].type),
	XmRImmediate, (XtPointer)XmATTACH_NONE
    },
    {
	XmNleftAttachment, XmCAttachment, XmRAttachment,
	sizeof(unsigned char), Offset(atta[LEFT].type),
	XmRImmediate, (XtPointer)XmATTACH_NONE
    },
    {
	XmNrightAttachment, XmCAttachment, XmRAttachment,
	sizeof(unsigned char), Offset(atta[RIGHT].type),
	XmRImmediate, (XtPointer)XmATTACH_NONE
    },
    {
	XmNtopWidget, XmCWidget, XmRWidget,
	sizeof(Widget), Offset(atta[TOP].w),
	XtRImmediate, (XtPointer)NULL
    },
    {
	XmNbottomWidget, XmCWidget, XmRWidget,
	sizeof(Widget), Offset(atta[BOTTOM].w),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNleftWidget, XmCWidget, XmRWidget,
	sizeof(Widget), Offset(atta[LEFT].w),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNrightWidget, XmCWidget, XmRWidget,
	sizeof(Widget), Offset(atta[RIGHT].w),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNtopPosition, XmCPosition, XmRInt,
	sizeof(int), Offset(atta[TOP].value),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNbottomPosition, XmCPosition, XmRInt,
	sizeof(int), Offset(atta[BOTTOM].value),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNleftPosition, XmCPosition, XmRInt,
	sizeof(int), Offset(atta[LEFT].value),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNrightPosition, XmCPosition, XmRInt,
	sizeof(int), Offset(atta[RIGHT].value),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNtopOffset, XmCOffset, XmRVerticalInt,
	sizeof(int), Offset(atta[TOP].offset),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNbottomOffset, XmCOffset, XmRVerticalInt,
	sizeof(int), Offset(atta[BOTTOM].offset),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNleftOffset, XmCOffset, XmRHorizontalInt,
	sizeof(int), Offset(atta[LEFT].offset),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNrightOffset, XmCOffset, XmRHorizontalInt,
	sizeof(int), Offset(atta[RIGHT].offset),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNresizable, XmCBoolean, XmRBoolean,
	sizeof(Boolean), Offset(resizable),
	XmRImmediate, (XtPointer)True
    }
};

static XmSyntheticResource constraint_syn_resources[] = {
    {
	XmNtopOffset,
	sizeof(int), Offset(atta[TOP].offset),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNbottomOffset,
	sizeof(int), Offset(atta[BOTTOM].offset),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNleftOffset,
	sizeof(int), Offset(atta[LEFT].offset),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNrightOffset,
	sizeof(int), Offset(atta[RIGHT].offset),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    }
};

static XmBaseClassExtRec _XmFormCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ NULL, /* FIXME */
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL, /* FIXME */
    /* class_part_init_posthook  */ NULL, /* FIXME */
    /* ext_resources             */ NULL, /* FIXME */
    /* compiled_ext_resources    */ NULL, /* FIXME */
    /* num_ext_resources         */ 0, /* FIXME */
    /* use_sub_resources         */ FALSE, /* FIXME */
    /* widget_navigable          */ NULL, /* FIXME */
    /* focus_change              */ NULL, /* FIXME */
    /* wrapper_data              */ NULL
};

static XmManagerClassExtRec _XmFormMClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmManagerClassExtVersion,
    /* record_size               */ sizeof(XmManagerClassExtRec),
    /* traversal_children        */ NULL /* FIXME */
};

XmFormClassRec xmFormClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmBulletinBoardClassRec,
        /* class_name            */ "XmForm",
	/* widget_size           */ sizeof(XmFormRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ realize,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ TRUE,
	/* compress_exposure     */ XtExposeCompressMultiple,
	/* compress_enterleave   */ TRUE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ resize,
	/* expose                */ XtInheritExpose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ query_geometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmFormCoreClassExtRec
    },
    /* Composite class part */
    {
	/* geometry manager */ geometry_manager, 
        /* change_managed   */ ChangeManaged, 
        /* insert_child     */ FormInsertChild,
        /* delete_child     */ XtInheritDeleteChild,
        /* extension        */ NULL,
    },
    /* Constraint class part */
    {
	/* subresources      */ formConstraintResources,
        /* subresource_count */ XtNumber(formConstraintResources),
        /* constraint_size   */ sizeof(XmFormConstraintRec),
        /* initialize        */ form_constraint_initialize,
        /* destroy           */ NULL,  /* FIX ME */
        /* set_values        */ form_constraint_set_values,
        /* extension         */ NULL,   /* FIX ME */
    },
    /* XmManager class part */
    {
	/* translations                 */ XmInheritTranslations,
        /* syn_resources                */ syn_resources,
        /* num_syn_resources            */ XtNumber(syn_resources),
        /* syn_constraint_resources     */ constraint_syn_resources,
        /* num_syn_constraint_resources */ XtNumber(constraint_syn_resources),
        /* parent_process               */ XmInheritParentProcess,
	/* extension                    */ (XtPointer)&_XmFormMClassExtRec
    },
    /* XmBulletinBoard part */
    {
	/* always_install_accelerators  */ FALSE,
	/* geo_matrix_create            */ NULL,
	/* focus_moved_proc             */ NULL,
	/* extension */ NULL
    },
    /* XmForm part */
    {
	/* extension */ NULL
    }
};

WidgetClass xmFormWidgetClass = (WidgetClass)&xmFormClassRec;

static void 
class_initialize()
{
    _XmFormCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmFORM_BIT);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
	XmFormWidget	nw = (XmFormWidget) new;

	nw->form.bogus_border = -1;
}

/*
 * These are just to save typing and make things readable
 * Note: most of these will only work in a loop over form's children,
 * in which a couple of variables are set correctly :
 *
 */

#define	FFB	f->form.fraction_base

#define	CON	constraints->form
#define	C_TOP		CON.atta[TOP]
#define	C_BOTTOM	CON.atta[BOTTOM]
#define	C_LEFT		CON.atta[LEFT]
#define	C_RIGHT		CON.atta[RIGHT]

/* Set the geometry fields of the current child widget */
#if	defined(DEBUG) || defined(PRINT_ASSIGNMENTS)
#define	SETX(p)		{ SetX(f, child, p, __LINE__); changed = True; }
#define	SETY(p)		{ SetY(f, child, p, __LINE__); changed = True; }
#define	SETW(p)		{ SetW(f, child, p, __LINE__); changed = True; }
#define	SETH(p)		{ SetH(f, child, p, __LINE__); changed = True; }

/* Set geometry of a widget referred to with XmATTACH_WIDGET or so */
/* x is something like C_BOTTOM, p is the value to be set */
#define	SETWX(x,p)	{ SetX(f, (x).w, p, __LINE__); changed = True; }
#define	SETWY(x,p)	{ SetY(f, (x).w, p, __LINE__); changed = True; }
#define	SETWW(x,p)	{ SetW(f, (x).w, p, __LINE__); changed = True; }
#define	SETWH(x,p)	{ SetH(f, (x).w, p, __LINE__); changed = True; }

#define	SETFW(v)	{ if (ParentChangeMode) { SetFW(f, child, v); fw = v; changed = True; } }
#define	SETFH(v)	{ if (ParentChangeMode) { SetFH(f, child, v); fh = v; changed = True; } }
#else
#define	SETX(p)		{ constraints->form.x = p; changed = True; }
#define	SETY(p)		{ constraints->form.y = p; changed = True; }
#define	SETW(p)		{ constraints->form.w = p; changed = True; }
#define	SETH(p)		{ constraints->form.h = p; changed = True; }

/* Set geometry of a widget referred to with XmATTACH_WIDGET or so */
/* q is something like C_BOTTOM, p is the value to be set */
#define	SETWX(q,p)	{ ((XmFormConstraints)((q).w->core.constraints))->form.x = p; changed = True; }
#define	SETWY(q,p)	{ ((XmFormConstraints)((q).w->core.constraints))->form.y = p; changed = True; }
#define	SETWW(q,p)	{ ((XmFormConstraints)((q).w->core.constraints))->form.w = p; changed = True; }
#define	SETWH(q,p)	{ ((XmFormConstraints)((q).w->core.constraints))->form.h = p; changed = True; }

#define	SETFW(v)	{ if (ParentChangeMode) { fw = v; changed = True; } }
#define	SETFH(v)	{ if (ParentChangeMode) { fh = v; changed = True; } }
#endif

/* Lookup the geometry fields of the current child widget */
#define	CX		constraints->form.x
#define	CY		constraints->form.y
#define	CW		constraints->form.w
#define	CH		constraints->form.h

/* For widget attachments : same stuff but not for current widget */
#define	W_X(p)		((XmFormConstraints)p->core.constraints)->form.x
#define	W_Y(p)		((XmFormConstraints)p->core.constraints)->form.y
#define	W_W(p)		((XmFormConstraints)p->core.constraints)->form.w
#define	W_H(p)		((XmFormConstraints)p->core.constraints)->form.h

/* Form's current size */
#define	FW		fw
#define	FH		fh

/*
 *
 */
#if	defined(DEBUG) || defined(PRINT_ASSIGNMENTS)
void SetW(XmFormWidget f, Widget child, int p, int line)
{
	XmFormConstraints	constraints = (XmFormConstraints) child->core.constraints;

#ifdef	PRINT_ASSIGNMENTS
#ifdef	PRINT_LINENO
	XdbDebug2(__FILE__, (Widget)f, child, "set width to %d (line %d)\n", p, line);
#else
	XdbDebug2(__FILE__, (Widget)f, child, "set width to %d\n", p);
#endif
#endif
	constraints->form.w = p;
}

void SetH(XmFormWidget f, Widget child, int p, int line)
{
	XmFormConstraints	constraints = (XmFormConstraints) child->core.constraints;

#ifdef	PRINT_ASSIGNMENTS
#ifdef	PRINT_LINENO
	XdbDebug2(__FILE__, (Widget)f, child, "set height to %d (line %d)\n", p, line);
#else
	XdbDebug2(__FILE__, (Widget)f, child, "set height to %d\n", p);
#endif
#endif
	constraints->form.h = p;
}

void SetX(XmFormWidget f, Widget child, int p, int line)
{
	XmFormConstraints	constraints = (XmFormConstraints) child->core.constraints;

#ifdef	PRINT_ASSIGNMENTS
#ifdef	PRINT_LINENO
	XdbDebug2(__FILE__, (Widget)f, child, "set x to %d (line %d)\n", p, line);
#else
	XdbDebug2(__FILE__, (Widget)f, child, "set x to %d\n", p);
#endif
#endif
	constraints->form.x = p;
}

void SetY(XmFormWidget f, Widget child, int p, int line)
{
	XmFormConstraints	constraints = (XmFormConstraints) child->core.constraints;

#ifdef	PRINT_ASSIGNMENTS
#ifdef	PRINT_LINENO
	XdbDebug2(__FILE__, (Widget)f, child, "set y to %d (line %d)\n", p, line);
#else
	XdbDebug2(__FILE__, (Widget)f, child, "set y to %d\n", p);
#endif
#endif
	constraints->form.y = p;
}

void SetFW(XmFormWidget f, Widget child, int p)
{
#ifdef	PRINT_ASSIGNMENTS
	XdbDebug2(__FILE__, (Widget)f, child, "set form width to %d\n", p);
#endif
}

void SetFH(XmFormWidget f, Widget child, int p)
{
#ifdef	PRINT_ASSIGNMENTS
	XdbDebug2(__FILE__, (Widget)f, child, "set form height to %d\n", p);
#endif
}

#endif

/*
 * Called in the process of adding a child
 */
static void 
form_constraint_initialize(Widget request, Widget new, ArgList args, Cardinal *num_args)
{
    XmFormConstraints constraints = (XmFormConstraints)new->core.constraints;
    XmFormWidget f = (XmFormWidget)XtParent(new);
    int i;
    XtGeometryResult	res;
    XtWidgetGeometry	geo;

    XdbDebug2(__FILE__, (Widget)f, new, "FormConstraintInitialize\n");

    for (i=0; i<4; i++)  /* do this for all four contraints (TOP, BOTTOM, LEFT, RIGHT) */
    {
	switch (constraints->form.atta[i].type)
	{
	case XmATTACH_FORM:
	case XmATTACH_WIDGET:
	case XmATTACH_NONE:
	    _XmMoveObject(new, 0, 0);
	    CON.atta[i].percent = 0;
	    break;
	case XmATTACH_POSITION:
	    CON.atta[i].percent = (int)(((float)CON.atta[i].value 
					/ (float)f->form.fraction_base) * 100.0);
	    break;
	}
    }
#ifdef	notdef
/*
 * This is not the right time to do this !! Must happen only just before layout,
 * so in practice we'll do this in the layout process.
 *
 * Every child of a form needs to have a left or a right attachment.  If they have
 * neither, fix it based on XmNrubberPositioning
 */

    if (C_LEFT.type == XmATTACH_NONE && C_RIGHT.type == XmATTACH_NONE) {
	XdbDebug2(__FILE__, (Widget)f, new, "ConstraintInitialize: left & right were NONE\n");
	if (f->form.rubber_positioning == True) {
	    C_LEFT.type = XmATTACH_POSITION;
	    C_LEFT.value = XtX(new);
	    C_LEFT.percent = (C_LEFT.value / f->form.fraction_base);
	} else {
	    C_LEFT.type = XmATTACH_FORM;
	    C_LEFT.offset = XtX(new);
	}
    }

    /* every child of a form needs to have a top or a bottom attachment.  If they have
       neither, fix it based on XmNrubberPositioning */

    if (C_TOP.type == XmATTACH_NONE && C_BOTTOM.type == XmATTACH_NONE) {
	XdbDebug2(__FILE__, (Widget)f, new, "ConstraintInitialize: top & bottom were NONE\n");
	if (f->form.rubber_positioning == True) {
	    C_TOP.type = XmATTACH_POSITION;
	    C_TOP.value = XtY(new);
	    C_TOP.percent = (C_TOP.value / f->form.fraction_base);
	} else {
	    C_TOP.type = XmATTACH_FORM;
	    C_TOP.offset = XtY(new);
	}
    }
#endif	/* notdef */

/* Is this just a silly special case ??? */
    if (C_TOP.type == XmATTACH_FORM && C_BOTTOM.type == XmATTACH_FORM && XtHeight(f) == 0) {
	res = XtQueryGeometry(new, NULL, &geo);
	if (res != XtGeometryYes) {
	    XtHeight(f) = geo.height;
	}
    }
    if (C_LEFT.type == XmATTACH_FORM && C_RIGHT.type == XmATTACH_FORM && XtWidth(f) == 0) {
	res = XtQueryGeometry(new, NULL, &geo);
	if (res != XtGeometryYes) {
	    XtWidth(f) = geo.width;
        }
    }

    /* XmATTACH_SELF */
    /* Should probably also query preferred geometry and then set it */
    /* FIX ME */
}


static Boolean 
form_constraint_set_values(Widget current, 
			   Widget request, 
			   Widget new, 
			   ArgList args, 
			   Cardinal *num_args)
{
    XmFormConstraints new_constraints = (XmFormConstraints)new->core.constraints;
    XmFormConstraints old = (XmFormConstraints)current->core.constraints;
    XmFormWidget f = (XmFormWidget)XtParent(new);
    Boolean changed = False,
	DirtyTrick = False;
    int i;
    
    if (! new_constraints->form.resizable) {
	XtWidth(new) = XtWidth(current);	/* refuse request */
	XtHeight(new) = XtHeight(current);
    XdbDebug2(__FILE__, (Widget)f, new, "ConstraintSetValues - refused resize\n");
    }

    XdbDebug2(__FILE__, (Widget)f, new, "ConstraintSetValues\n");

    for (i=0; i<4; i++) {
	if (new_constraints->form.atta[i].value != old->form.atta[i].value) {
	    if (i == TOP || i == BOTTOM) {
		if (XtHeight(f) != 0)
		    new_constraints->form.atta[i].percent =
			(new_constraints->form.atta[i].value / XtHeight(f));
		else
		    new_constraints->form.atta[i].percent = 100;
	    }
	    else {
		if (XtWidth(f) != 0)
		    new_constraints->form.atta[i].percent =
			(new_constraints->form.atta[i].value / XtWidth(f));
		else
		    new_constraints->form.atta[i].percent = 100;
	    }

	    DirtyTrick = True;
	    changed = True;
	}

	if (new_constraints->form.atta[i].type != old->form.atta[i].type
	 || new_constraints->form.atta[i].w != old->form.atta[i].w
	 || new_constraints->form.atta[i].offset != old->form.atta[i].offset)
	{
	    DirtyTrick = True;
	    changed = True;
	}
    }
#ifdef	DO_BOGUS_STUFF
/*
 * According to Asente & Swick p. 250 - if a constraint resource change will affect
 * child geometry, then parent will only perform resize if you tell the Intrinsics
 * to perform a resize by changing one of its traditional geometry fields...
 */
    if (DirtyTrick) {
	f->form.bogus_border = f->core.border_width;
	f->core.border_width = BOGUS_BORDER;
	XdbDebug2(__FILE__, (Widget)f, new, "Bogus borderwidth %d instead of %d\n",
		BOGUS_BORDER, f->form.bogus_border);
    }
#endif
    return changed;
}

static void
destroy(Widget w)
{
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
	Boolean		r = False,
			relayout = False;
	XmFormWidget	ow = (XmFormWidget) old,
			nw = (XmFormWidget) new;

/* FIX ME */
	relayout = r = True;

	if (XtWidth(nw) != XtWidth(ow) || XtHeight(nw) != XtHeight(ow)) {
		XdbDebug(__FILE__, new, "SetValues: changed size to %d %d\n", XtWidth(nw), XtHeight(nw));

		r = True;
		relayout = True;
	} else {
		XdbDebug(__FILE__, new, "SetValues\n");
	}


	if (relayout)
		XmFormLayout(nw, Mode_Normal, NULL, NULL);

	return	r;
}

static void
resize(Widget w)
{
	XdbDebug(__FILE__, w, "Resize\n");
	XmFormLayout((XmFormWidget)w, Mode_Resize, NULL, NULL);
} 

static void 
realize(Widget w, 
	XtValueMask *value_mask, 
	XSetWindowAttributes *attributes)
{
#define superclass (&xmBulletinBoardClassRec)
    (*superclass->core_class.realize)(w, value_mask, attributes);
#undef superclass

	XdbDebug(__FILE__, w, "Realize\n");
	XmFormLayout((XmFormWidget)w, Mode_Normal, NULL, NULL);
}

/*
 * QueryGeometry
 *
 * The purpose of this method is for other widgets to ask what the preferred
 *	geometry of this one is.
 * The other widget (the parent, usually) can either propose a geometry, to
 * 	which we answer, or call XtQueryGeometry(w, NULL, ___). In that case,
 *	we'll get a proposed which has no entries filled out. (Xt does some
 *	magic so we'll never see the NULL).
 * It is possible, and even common practice, to call this with the second and
 *	third parameter being identical. We must be prepared for this.
 *	That's why we copy the contents of *proposed.
 */
static XtGeometryResult 
query_geometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *desired)
{
	XtGeometryResult	r = XtGeometryYes;
	XmFormWidget		f = (XmFormWidget)w;
	XtWidgetGeometry	pp;

	pp = *proposed;		/* A statement, not an initializer, due to
				   suspected bug in GCC_BOUNDS_CHECKING */

	if (proposed != desired)
		*desired = *proposed;

	XmFormLayout(f, Mode_Test, (Widget)f, desired);

	if (desired->width != XtWidth(f) || desired->height != XtHeight(f))
		r = XtGeometryAlmost;

	desired->request_mode = CWWidth | CWHeight;

	if ((pp.request_mode & (CWWidth | CWHeight)) == 0) {
	    XdbDebug(__FILE__, (Widget)f, "QueryGeometry NULL => %d %d, answer %s\n",
		desired->width, desired->height,
		XdbGeometryResult2String(r));
	    r = XtGeometryAlmost;
	} else
	    XdbDebug(__FILE__, (Widget)f, "QueryGeometry %d %d => %d %d, answer %s\n",
		pp.width, pp.height,
		desired->width, desired->height,
		XdbGeometryResult2String(r));

	return r;
}

/*
 * GeometryManager Method
 *
 * If request is unacceptable and we have no compromise, return XtGeometryNo.
 * If request is acceptable, return XtGeometryYes or XtGeometryDone (depending on
 *    whether LessTif wants widgets to do this by themselves).
 * If we propose a compromise, return XtGeometryAlmost.
 * If XtCWQueryOnly is set, don't change anything.
 *
 * According to Asente & Swick, do not resize the calling widget from here (p. 734).
 */
static XtGeometryResult
geometry_manager(Widget w, XtWidgetGeometry *request, XtWidgetGeometry *reply)
{
	XmFormWidget		f = (XmFormWidget) XtParent(w);
	XtWidgetGeometry	mr, a;
	int			good = 0, ask = 0;

#define       Wants(x)        (request->request_mode & x)

	if (XdbInDebug(__FILE__, (Widget)f)) {
		XdbDebug2(__FILE__, (Widget)f, w, "GeometryManager : request ");
		if (Wants(CWX))		XdbDebug0(__FILE__, (Widget)f,  "X %d ", request->x);
		if (Wants(CWY))		XdbDebug0(__FILE__, (Widget)f,  "Y %d ", request->y);
		if (Wants(CWWidth))	XdbDebug0(__FILE__, (Widget)f,  "W %d ", request->width);
		if (Wants(CWHeight))	XdbDebug0(__FILE__, (Widget)f,  "H %d ", request->height);
		XdbDebug0(__FILE__, (Widget)f,  "\n");
	}

#ifdef DO_BOGUS_STUFF
/* Bogus border width treatment */
	if (f->form.bogus_border != -1) {
		f->core.border_width = f->form.bogus_border;
		f->form.bogus_border = -1;	/* reset the damned thing */
		XdbDebug(__FILE__, (Widget)f, "Unset Bogus Border -> %d\n", f->core.border_width);
	}
#endif
	mr = *request;

/* Ask form's layout algorithm what it thinks about this */
	XmFormLayout(f, Mode_Test, w, &mr);

/* Now that form has looked at the geometry, tell our caller what happened */
	if (Wants(CWX)) {
	    ask++;
	    if ((mr.request_mode & CWX) && mr.x == request->x) {
		a.request_mode |= CWX;
		a.x = request->x;
		good++;
	    }
	}
	if (Wants(CWY)) {
	    ask++;
	    if ((mr.request_mode & CWY) && mr.y == request->y) {
		a.request_mode |= CWY;
		a.y = request->y;
		good++;
	    }
	}
	if (Wants(CWWidth)) {
	    ask++;
	    if ((mr.request_mode & CWWidth) && mr.width == request->width) {
		a.request_mode |= CWWidth;
		a.width = request->width;
		good++;
	    }
	}
	if (Wants(CWHeight)) {
	    ask++;
	    if ((mr.request_mode & CWHeight) && mr.height == request->height) {
		a.request_mode |= CWHeight;
		a.height = request->height;
		good++;
	    }
	}

	if (reply != NULL)
		*reply = mr;

	if (good == ask) {
		XdbDebug2(__FILE__, (Widget)f, w, "GeometryManager => YES\n");
		return XtGeometryYes;
	}
	if (good == 0) {
		XdbDebug2(__FILE__, (Widget)f, w, "GeometryManager => NO\n");
		return XtGeometryNo;
	}

	XdbDebug2(__FILE__, (Widget)f, w, "GeometryManager => Almost\n");

	return XtGeometryAlmost;
#undef        Wants
}


/* define the maximum iterations of the layout routine to
   be the same as Motif's */

#if 0
/* Motif says 10000 here */
#define MAX_ITERATIONS 10000
#else
#define	MAX_ITERATIONS	200
#endif

/*
 * Find Preferred Geometry for the form's children
 *
 * Note: currently we're not called efficiently. We should find out when exactly
 *	we need to update this information !
 * Doing all this over and over again is useless and sloooow.
 *
 * FIX ME
 */
static void
XmFormFindPreferred(XmFormWidget f)
{
    int		i;
    Boolean	changed;	/* is needed because of SETX macros */

    for (i=0; i<f->composite.num_children; i++) {
	XtWidgetGeometry        pref;
	Widget			child = f->composite.children[i];
	XmFormConstraints	constraints = (XmFormConstraints)child->core.constraints;

	SETX(XtX(child));
	SETY(XtY(child));
	SETW(XtWidth(child));
	SETH(XtHeight(child));

/* Sanity check */
#if	1
	if (XtWidth(child) > 32767)
		SETW(100);
	if (XtHeight(child) > 32767)
		SETH(100);
#endif

	constraints->form.preferred_height = constraints->form.preferred_width = 0;

	if (! XtIsManaged(f->composite.children[i]))
	    continue;

	if (XtQueryGeometry(f->composite.children[i], NULL, &pref) != XtGeometryYes) {
#ifdef	PRINT_PREFERRED
	    XdbDebug2(__FILE__, f, child, "Preferred w %d h %d\n", pref.width, pref.height);
#endif
	    if (pref.request_mode & CWWidth) {
		SETW(pref.width);
		constraints->form.preferred_width = pref.width;
	    }
	    if (pref.request_mode & CWHeight) {
		SETH(pref.height);
		constraints->form.preferred_height = pref.height;
	    }
	    if (pref.request_mode & CWX)	SETX(pref.x);
	    if (pref.request_mode & CWY)	SETY(pref.y);
	} else {
#ifdef	PRINT_PREFERRED
	    XdbDebug2(__FILE__, f, child, "XmFormFindPreferred : no preferences\n");
#endif
	}
    }
}

void
XmFormPrintAttachmentReport(XmFormWidget f)
{
    int	i;

    XdbDebug(__FILE__, (Widget)f, "Attachment Report : (Top,Bottom,Left,Right)\n");

    for (i=0; i<f->composite.num_children; i++) {
	Widget			child = f->composite.children[i];
	XmFormConstraints	constraints = (XmFormConstraints)child->core.constraints;

	XdbDebug0(__FILE__, (Widget)f,  "child %s\t\t", XtName(child));

#define	PRINTIT(x)								\
	if (CON.atta[x].type == XmATTACH_WIDGET ||				\
			CON.atta[x].type == XmATTACH_OPPOSITE_WIDGET) {		\
		if (CON.atta[x].w == NULL)					\
		    XdbDebug0(__FILE__, (Widget)f,  "%s(%s)\t",			\
			XdbAttachment2String(CON.atta[x].type),			\
			"(null)");						\
		else								\
		    XdbDebug0(__FILE__, (Widget)f,  "%s(%s)\t",			\
			XdbAttachment2String(CON.atta[x].type),			\
			XtName(CON.atta[x].w));					\
	} else if (CON.atta[x].type == XmATTACH_POSITION)			\
		XdbDebug0(__FILE__, (Widget)f, "%s(%d/%d)\t",			\
			XdbAttachment2String(CON.atta[x].type),			\
			CON.atta[x].value, FFB);				\
	else									\
		XdbDebug0(__FILE__, (Widget)f,  "%s(%d)\t",			\
			XdbAttachment2String(CON.atta[x].type),			\
			CON.atta[x].offset);

	PRINTIT(TOP);
	PRINTIT(BOTTOM);
	XdbDebug0(__FILE__, (Widget)f,  "\n\t\t\t\t");
	PRINTIT(LEFT);
	PRINTIT(RIGHT);

	XdbDebug0(__FILE__, (Widget)f,  "\n");
#undef	PRINTIT
    }
}

/*
 * XmFormLayout() - run the XmForm layout algorithm
 *
 * If Mode_Test is set, then the cw and cg parameters must be valid, and the
 *	cw widget must be a managed child of form.
 *
 * Mode_Test : used by GeometryManager to see whether a geometry change is ok.
 *	In this case, a widget and its proposed geometry are passed.
 *	XmFormLayout will apply the changes temporarily, and after the layout
 *	algorithm it'll return the resulting geometry of that widget.
 *	GeometryManager will draw its own conclusions.
 *
 * Testmode can also be run with the form itself as widget being observed.
 *
 * ParentChangeMode : allow the thing to change the parent's geometry.
 *	Currently always true.
 *
 * For this routine, the fields x, y, w, h, preferred_width, and preferred_height
 *	were added to the constraint record, in FormP.h.
 */
static void
XmFormLayout(XmFormWidget f, int mode, Widget cw, XtWidgetGeometry *cg)
{
    int		number_of_iterations = 0;
    Boolean	changed;
    int		i, this_child = 0;
    Dimension	fw, fh;				/* Form dimensions */
    Boolean	ParentChangeMode = ((mode & Mode_Resize) == 0),
		TestMode = ((mode & Mode_Test) == Mode_Test);

    if (! TestMode)
	XdbDebug(__FILE__, (Widget)f, "XmFormLayout - width %d height %d\n",
		XtWidth(f), XtHeight(f));

    fw = XtWidth(f);
    fh = XtHeight(f);

/* Find all preferred sizes */
    XmFormFindPreferred(f);

/* Check whether we should test geometry change for form itself ! */
    if (TestMode && cw == (Widget)f) {
#define	Wants(x)	(cg->request_mode & x)
	if (Wants(CWWidth))	fw = cg->width;
	if (Wants(CWHeight))	fh = cg->height;

	if (XdbInDebug(__FILE__, (Widget)f)) {
	    XdbDebug(__FILE__, (Widget)f, "XmFormLayout TestMode ");
	    if (Wants(CWWidth)) XdbDebug0(__FILE__, (Widget)f, "width %d ", fw);
	    if (Wants(CWHeight)) XdbDebug0(__FILE__, (Widget)f, "height %d ", fh);
	    XdbDebug0(__FILE__, (Widget)f, "\n");
	}
#undef	Wants
    }

#ifdef	PRINT_ATTACHMENT_REPORT
    XmFormPrintAttachmentReport(f);
#endif

    for (i=0; i<f->composite.num_children; i++) {
	/* These two variables are needed to make the macros work ! */
	Widget			child = f->composite.children[i];
	XmFormConstraints	constraints = (XmFormConstraints)child->core.constraints;

	if (! XtIsManaged(f->composite.children[i]))
	    continue;

/* Initialize */
	constraints->form.width_from_side = False;
	constraints->form.height_from_side = False;

	if (TestMode && cw == f->composite.children[i]) {
	    this_child = i;
	    XdbDebug2(__FILE__, (Widget)f, cw, "Test Geometry : ");
	    if (cg->request_mode & CWX) {
		SETX(cg->x);
		XdbDebug0(__FILE__, (Widget)f,  "x %d ", cg->x);
	    }
	    if (cg->request_mode & CWY) {
		SETY(cg->y);
		XdbDebug0(__FILE__, (Widget)f,  "y %d ", cg->y);
	    }
	    if (cg->request_mode & CWWidth) {
		SETW(cg->width);
		constraints->form.preferred_width = cg->width;
		XdbDebug0(__FILE__, (Widget)f,  "w %d ", cg->width);
	    }
	    if (cg->request_mode & CWHeight) {
		SETH(cg->height);
		constraints->form.preferred_height = cg->height;
		XdbDebug0(__FILE__, (Widget)f,  "h %d ", cg->height);
	    }
	    XdbDebug0(__FILE__, (Widget)f,  "\n");
	}
/* Start of piece stolen from FormConstraintInitialize */
/*
 * Every child of a form needs to have a left or a right attachment.
 * If they have neither, fix it based on XmNrubberPositioning.
 */

    if (C_LEFT.type == XmATTACH_NONE && C_RIGHT.type == XmATTACH_NONE) {
	XdbDebug2(__FILE__, (Widget)f, child, "left & right were NONE\n");
	if (f->form.rubber_positioning == True) {
	    C_LEFT.type = XmATTACH_POSITION;
	    C_LEFT.value = XtX(child);
	    C_LEFT.percent = (C_LEFT.value / f->form.fraction_base);
	} else {
	    C_LEFT.type = XmATTACH_FORM;
	    C_LEFT.offset = XtX(child);
	}
    }

/*
 * Every child of a form needs to have a top or a bottom attachment.
 * If they have neither, fix it based on XmNrubberPositioning.
 */

    if (C_TOP.type == XmATTACH_NONE && C_BOTTOM.type == XmATTACH_NONE) {
	XdbDebug2(__FILE__, (Widget)f, child, "ConstraintInitialize : top & bottom were NONE\n");
	if (f->form.rubber_positioning == True) {
	    C_TOP.type = XmATTACH_POSITION;
	    C_TOP.value = XtY(child);
	    C_TOP.percent = (C_TOP.value / f->form.fraction_base);
	} else {
	    C_TOP.type = XmATTACH_FORM;
	    C_TOP.offset = XtY(child);
	}
    }
/* End piece stolen from FormConstraintInitialize */

    }

#ifdef PRINT_REPORT
    XdbDebug(__FILE__, (Widget)f, "Initial geometry : %d %d\n", FW, FH);
    XdbDebug0(__FILE__, (Widget)f,  "Initial child geometry :\n");
	for (i=0; i<f->composite.num_children; i++) {
		Widget child = f->composite.children[i];
		XmFormConstraints constraints = (XmFormConstraints)child->core.constraints;

		XdbDebug0(__FILE__, (Widget)f,  "Child #%d (%s)\tx %d y %d w %d h %d\n",
			i, XtName(child), CX, CY, CW, CH);
	}
#endif

/*
 * In these two nested loops we repeatedly try to fix all geometries for all
 * children, and for the form itself.
 *
 * The outer loop runs until either nothing has changed, or MAX_ITERATIONS times.
 *
 * The inner loop goes over all children.
 */
    do {
	changed = False;
/*
 * Inner loop
 */
	for (i=0; i<f->composite.num_children; i++) {
	    Widget		child = f->composite.children[i];
	    XmFormConstraints	constraints = (XmFormConstraints)child->core.constraints;

	    if (!XtIsManaged(child))
		continue;

/*
 * First use a couple of rules to try to fix form's size.
 */
	    if (ParentChangeMode &&
		(BB_ResizePolicy(f) == XmRESIZE_GROW
		 || BB_ResizePolicy(f) == XmRESIZE_ANY)) {
/* Form width */
#if 0
/* This was supposed to make Form smaller if none of its children reach the edges.
   A bit too drastic, though ... */
		if (FW != CX + CW && BB_ResizePolicy(f) == XmRESIZE_ANY) {
		    if (! constraints->form.width_from_side)
			SETFW(CX + CW);
		} else
#endif
		if (FW < CX + CW) {
		    if (! constraints->form.width_from_side)
			SETFW(CX + CW);
		}
/* Form height */
#if 0
/* This was supposed to make Form smaller if none of its children reach the edges.
   A bit too drastic, though ... */
		if (FH != CY + CH && BB_ResizePolicy(f) == XmRESIZE_ANY) {
		    if (! constraints->form.height_from_side)
			SETFH(CY + CH);
		} else
#endif
		if (FH < CY + CH) {
		    if (! constraints->form.height_from_side)
			SETFH(CY + CH);
		}
/* Two POSITION attachments */
		if (C_TOP.type == XmATTACH_POSITION && C_BOTTOM.type == XmATTACH_POSITION
			&& C_TOP.value != C_BOTTOM.value) {
		    if (FH < (int)(CH * FFB / (C_BOTTOM.value - C_TOP.value)))
			SETFH(CH * FFB / (C_BOTTOM.value - C_TOP.value));
		}
		if (C_LEFT.type == XmATTACH_POSITION && C_RIGHT.type == XmATTACH_POSITION
			&& C_LEFT.value != C_RIGHT.value) {
		    if (FW < (int)(CW * FFB / (C_RIGHT.value - C_LEFT.value)))
			SETFW(CW * FFB / (C_RIGHT.value - C_LEFT.value));
		}

/* Child preferred width */
#ifdef DO_PREFERRED_STUFF
 		if (constraints->form.preferred_width != 0 &&
		    constraints->form.preferred_width != CW) {
 		    if (C_RIGHT.type == XmATTACH_FORM && C_LEFT.type != XmATTACH_FORM) {
			if (! constraints->form.width_from_side)
			    SETFW(FW + constraints->form.preferred_width - CW);
 		    } else if (C_RIGHT.type == XmATTACH_WIDGET && C_LEFT.type != XmATTACH_WIDGET) {
/* Tryout - see around line 1254 */
			if (C_LEFT.type != XmATTACH_NONE)
 			SETW(constraints->form.preferred_width);
 		    } else {
 			XdbDebug2(__FILE__, f, child, "Case (child preferred width) not treated yet (line %d)\n",
 				__LINE__);
  			/* FIX ME */
 		    }
		}
/* Child preferred height */
 		if (constraints->form.preferred_height != 0 &&
 				constraints->form.preferred_height != CH) {
  		    if (C_TOP.type == XmATTACH_POSITION && C_BOTTOM.type == XmATTACH_POSITION) {
 			if (CH == 0) {
			    if (! constraints->form.height_from_side)
				SETFH(FH + 1);
 			} else
			    if (! constraints->form.height_from_side)
				SETFH(FH * constraints->form.preferred_height / CH);
 		    } else if (C_BOTTOM.type == XmATTACH_FORM) {
 /* FIX ME - this breaks testXm/form/test1 if vertically resized  - maybe better now */
 			if ((BB_ResizePolicy(f) == XmRESIZE_GROW
 				&& FH < CY + constraints->form.preferred_height + C_BOTTOM.offset)
 			 || (BB_ResizePolicy(f) == XmRESIZE_ANY)) {
			    if (! constraints->form.height_from_side)
				SETFH(CY + constraints->form.preferred_height + C_BOTTOM.offset);
 			}
 		    } else if (C_TOP.type == XmATTACH_WIDGET && C_BOTTOM.type == XmATTACH_WIDGET) {
 			SETH(constraints->form.preferred_height);
 		    } else {
  			XdbDebug2(__FILE__, f, child, "Case (child preferred height) not treated yet (line %d)\n",
 				__LINE__);
			/* FIX ME */
		    }
		}
#endif /* DO_PREFERRED_STUFF */
	    }

/*
 * Now treat the attachments
 *
 * We see more or less the same code four times (TOP, BOTTOM, LEFT, RIGHT) here.
 */

#ifdef	PRINT_ATTACHMENT
	    XdbDebug0(__FILE__, f,  "TOP for child %s is %s\n",
 		XtName(child), XdbAttachment2String(C_TOP.type));
#endif
	    switch (C_TOP.type)
	    {
/* TOP */    case XmATTACH_FORM:
		if (CY != C_TOP.offset) {
		    SETY(C_TOP.offset);
		}
		break;
/* TOP */    case XmATTACH_OPPOSITE_FORM:
		if (CY != FH + C_TOP.offset) {
		    SETY(FH + C_TOP.offset);
		}
		break;
/* TOP */    case XmATTACH_WIDGET:
		if (! (C_TOP.w)) {
		    XdbDebug2(__FILE__, (Widget)f, child, "XmATTACH_WIDGET but no widget was specified\n");
		    C_TOP.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (XtParent(C_TOP.w) != (Widget)f) {
		    XdbDebug2(__FILE__, (Widget)f, child, "Attachments should be to children of Form.\n");
		    C_TOP.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (CY != (W_Y(C_TOP.w) + W_H(C_TOP.w) + C_TOP.offset)) {
		    int yy = W_Y(C_TOP.w) + W_H(C_TOP.w) + C_TOP.offset;
		    if (yy < 0) {
			yy = CY - W_H(C_TOP.w) - C_TOP.offset;	/* Danny 27/4 */
			if (yy < 0) {
			    SETWH(C_TOP, CY - W_Y(C_TOP.w) - C_TOP.offset);	/* Danny 27/4 */
			} else {
			    SETWY(C_TOP, yy);				/* Danny 27/4 */
			}
		    } else {
			SETY(yy);
		    }
		}
		break;
/* TOP */    case XmATTACH_OPPOSITE_WIDGET:
		if (! (C_TOP.w)) {
		    XdbDebug2(__FILE__, (Widget)f, child, "XmATTACH_OPPOSITE_WIDGET but no widget was specified\n");
		    C_TOP.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (XtParent(C_TOP.w) != (Widget)f) {
		    XdbDebug2(__FILE__, (Widget)f, child, "Attachments should be to children of Form.\n");
		    C_TOP.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (CY != (W_Y(C_TOP.w) + C_TOP.offset)) {
		    int	yy = W_Y(C_TOP.w) + C_TOP.offset;

		    if (yy < 0) {
			SETWY(C_TOP, CY - C_TOP.offset);		/* Danny 27/4 */
		    } else
			SETY(W_Y(C_TOP.w) + C_TOP.offset);
		}
		break;
/* TOP */    case XmATTACH_POSITION:
		if (CY != C_TOP.value * FH / FFB) {
		    SETY(C_TOP.value * FH / FFB);
		}
		break;
/* TOP */   case XmATTACH_NONE:
		break;
/* TOP */   case XmATTACH_SELF:
		    if (C_TOP.value != CY / FH)
		    {
			C_TOP.value = CY / FH;
			changed = True;
			C_TOP.type = XmATTACH_POSITION;
		    }
		    break;
	    default:
		XdbDebug2(__FILE__, (Widget)f, child, "Illegal top attachment\n");
	    }
#ifdef	PRINT_ATTACHMENT
	    XdbDebug0(__FILE__, (Widget)f,  "BOTTOM for child %s is %s\n",
		XtName(child), XdbAttachment2String(C_BOTTOM.type));
#endif
	    switch (C_BOTTOM.type)
	    {
/* BOTTOM */    case XmATTACH_FORM:
		if (FH == 0) {
		    FH = CH + CY + C_BOTTOM.offset;
		} else if (CH != FH - CY - C_BOTTOM.offset) {
		    if (C_TOP.type == XmATTACH_NONE) {
			SETY(FH - C_BOTTOM.offset - CH);
		    } else {
			SETH(FH - CY - C_BOTTOM.offset);
			constraints->form.height_from_side = True;
		    }
		}
		break;
/* BOTTOM */    case XmATTACH_OPPOSITE_FORM:
		if (CH + CY != - C_BOTTOM.offset) {
		    if (C_TOP.type == XmATTACH_NONE) {
			SETY(0 - C_BOTTOM.offset - CH);
		    } else {
			SETH(0 - CY - C_BOTTOM.offset);
			constraints->form.height_from_side = True;
		    }
		}
		break;
/* BOTTOM */    case XmATTACH_WIDGET:
		if (! (C_BOTTOM.w)) {
		    XdbDebug2(__FILE__, (Widget)f, child, "XmATTACH_WIDGET but no widget was specified\n");
		    C_BOTTOM.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (XtParent(C_BOTTOM.w) != (Widget)f) {
		    XdbDebug2(__FILE__, (Widget)f, child, "Attachments should be to children of Form.\n");
		    C_BOTTOM.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (CY != (W_Y(C_BOTTOM.w) - CH - C_BOTTOM.offset)) {
		    if (C_TOP.type == XmATTACH_NONE) {
			SETY(W_Y(C_BOTTOM.w) - CH - C_BOTTOM.offset);
		    } else {
			int hh = W_Y(C_BOTTOM.w) - CY - C_BOTTOM.offset;

			if (hh < 0) {
				/* Force the other widget away */
#ifdef	notdef
				W_Y(C_BOTTOM.w) = CY + CH + C_BOTTOM.offset;
				changed = True;
				XdbDebug(__FILE__, (Widget)f, "Child %s forced down to %d by child %s\n",
					XtName(C_BOTTOM.w), W_Y(C_BOTTOM.w), XtName(child));
#else
				SETWY(C_BOTTOM, CY + CH + C_BOTTOM.offset);	/* Danny 27/4 */
#endif
			} else
			    SETH(hh);
			constraints->form.height_from_side = True;
		    }
		}
		break;
/* BOTTOM */    case XmATTACH_POSITION:
		if (CH + CY != C_BOTTOM.value * FH / FFB) {
		    if (C_TOP.type == XmATTACH_NONE) {
			SETY(C_BOTTOM.value * FH / FFB - CH);
		    } else {
			SETH(C_BOTTOM.value * FH / FFB - CY);
			constraints->form.height_from_side = True;
		    }
		}
		break;
/* BOTTOM */    case XmATTACH_NONE:
		break;
/* BOTTOM */    case XmATTACH_OPPOSITE_WIDGET:		/* FIX ME */
		if (! (C_BOTTOM.w)) {
		    XdbDebug2(__FILE__, (Widget)f, child, "XmATTACH_OPPOSITE_WIDGET but no widget was specified\n");
		    C_BOTTOM.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (XtParent(C_BOTTOM.w) != (Widget)f) {
		    XdbDebug2(__FILE__, (Widget)f, child, "Attachments should be to children of Form.\n");
		    C_BOTTOM.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (CY + CH != (W_Y(C_BOTTOM.w) + W_H(C_BOTTOM.w) - C_BOTTOM.offset)) {
		    if (C_TOP.type == XmATTACH_NONE) {
			SETY(W_Y(C_BOTTOM.w) + W_H(C_BOTTOM.w) - CH - C_BOTTOM.offset);
		    } else {
			SETH(W_Y(C_BOTTOM.w) + W_H(C_BOTTOM.w) - CY - C_BOTTOM.offset);
			constraints->form.height_from_side = True;
		    }
		}
		break;
/* Now for the illegal cases */
	    default:
	    case XmATTACH_SELF:
		XdbDebug2(__FILE__, (Widget)f, child, "Illegal bottom attachment\n");
	    }
#ifdef	PRINT_ATTACHMENT
	    XdbDebug0(__FILE__, (Widget)f,  "LEFT for child %s is %s\n",
		XtName(child), XdbAttachment2String(C_LEFT.type));
#endif
	    switch (C_LEFT.type)
	    {
/* LEFT */    case XmATTACH_FORM:
		if (CX != C_LEFT.offset) {
		    SETX(C_LEFT.offset);
		}
		break;
/* LEFT */    case XmATTACH_POSITION:
		if (CX != C_LEFT.value * FW / FFB) {
		    SETX(C_LEFT.value * FW / FFB);
		}
		break;
/* LEFT */    case XmATTACH_WIDGET:
		if (! (C_LEFT.w)) {
		    XdbDebug2(__FILE__, (Widget)f, child, "XmATTACH_WIDGET but no widget was specified\n");
		    C_LEFT.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (XtParent(C_LEFT.w) != (Widget)f) {
		    XdbDebug2(__FILE__, (Widget)f, child, "Attachments should be to children of Form.\n");
		    C_LEFT.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (CX != (W_X(C_LEFT.w) + W_W(C_LEFT.w) + C_LEFT.offset)) {
		    SETX(W_X(C_LEFT.w) + W_W(C_LEFT.w) + C_LEFT.offset);
		}
		break;
/* LEFT */    case XmATTACH_OPPOSITE_WIDGET:
		if (! (C_LEFT.w)) {
		    XdbDebug2(__FILE__, (Widget)f, child, "XmATTACH_OPPOSITE_WIDGET but no widget was specified\n");
		    C_LEFT.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (XtParent(C_LEFT.w) != (Widget)f) {
		    XdbDebug2(__FILE__, (Widget)f, child, "Attachments should be to children of Form.\n");
		    C_LEFT.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (CX != C_LEFT.offset + W_X(C_LEFT.w)) {
		    SETX(C_LEFT.offset + W_X(C_LEFT.w));
		} 
		break;
/* LEFT */    case XmATTACH_NONE:
		break;
/* LEFT */    case XmATTACH_OPPOSITE_FORM:
		if (CX + C_LEFT.offset != FW) {
		    SETX(FW - C_LEFT.offset);
		}
		break;
/* Now for the illegal cases */
	    case XmATTACH_SELF:
	    default:
		XdbDebug2(__FILE__, (Widget)f, child, "Illegal left attachment\n");
	    }
#ifdef	PRINT_ATTACHMENT
	    XdbDebug0(__FILE__, (Widget)f,  "RIGHT for child %s is %s\n",
		XtName(child), XdbAttachment2String(C_RIGHT.type));
#endif
	    switch (C_RIGHT.type)
	    {
/* RIGHT */    case XmATTACH_FORM:
		if (FW == 0) {
		    FW = CW + CX + C_RIGHT.offset;
		} else if (CW != FW - CX - C_RIGHT.offset) {
		    if (C_LEFT.type == XmATTACH_NONE) {
			SETX(FW - CW - C_RIGHT.offset);
		    } else {
			SETW(FW - CX - C_RIGHT.offset);
			constraints->form.width_from_side = True;
		    }
		}
		break;
/* RIGHT */    case XmATTACH_WIDGET:
		if (! (C_RIGHT.w)) {
		    XdbDebug2(__FILE__, (Widget)f, child, "XmATTACH_WIDGET but no widget was specified\n");
		    C_RIGHT.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (XtParent(C_RIGHT.w) != (Widget)f) {
		    XdbDebug2(__FILE__, (Widget)f, child, "Attachments should be to children of Form.\n");
		    C_RIGHT.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (CW != (W_X(C_RIGHT.w) - CX - C_RIGHT.offset)) {
		    if (C_LEFT.type == XmATTACH_NONE) {
			SETX(W_X(C_RIGHT.w) - CW - C_RIGHT.offset);
		    } else {
			SETW(W_X(C_RIGHT.w) - CX - C_RIGHT.offset);
			constraints->form.width_from_side = True;
		    }
		}
		break;
/* RIGHT */    case XmATTACH_OPPOSITE_WIDGET:
		if (! (C_RIGHT.w)) {
		    XdbDebug2(__FILE__, (Widget)f, child, "XmATTACH_OPPOSITE_WIDGET but no widget was specified\n");
		    C_RIGHT.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (XtParent(C_RIGHT.w) != (Widget)f) {
		    XdbDebug2(__FILE__, (Widget)f, child, "Attachments should be to children of Form.\n");
		    C_RIGHT.type = XmATTACH_NONE;
		    changed = True;
		    break;
		}
		if (W_X(C_RIGHT.w) + W_W(C_RIGHT.w) !=
				CW + CX + C_RIGHT.offset) {
		    if (C_LEFT.type == XmATTACH_NONE) {
			SETX(W_X(C_RIGHT.w) + W_W(C_RIGHT.w)
				- CW - C_RIGHT.offset);
		    } else {
			SETW(W_X(C_RIGHT.w) + W_W(C_RIGHT.w)
				- CX - C_RIGHT.offset);
			constraints->form.width_from_side = True;
		    }
		}
		break;
/* RIGHT */    case XmATTACH_POSITION:
		if (CX + CW != C_RIGHT.value * FW / FFB) {
		    if (C_LEFT.type == XmATTACH_NONE) {
			SETX(C_RIGHT.value * FW / FFB - CW);
		    } else {
			SETW(C_RIGHT.value * FW / FFB - CX);
			constraints->form.width_from_side = True;
		    }
		}
		break;
	    case XmATTACH_NONE:
		break;
/* RIGHT */ case XmATTACH_OPPOSITE_FORM:
		if (CX + CW != C_RIGHT.offset) {
		    if (C_LEFT.type == XmATTACH_NONE) {
			SETX(C_RIGHT.offset - CW);
		    } else {
			SETW(C_RIGHT.offset - CX);
			constraints->form.width_from_side = True;
		    }
		}
/* Now for the illegal cases */
	    case XmATTACH_SELF:
	    default:
		XdbDebug2(__FILE__, (Widget)f, child, "Illegal right attachment\n");
	    }

/*
 * End of the two nested loops
 */
	}	/* End of the loop over all children */
	number_of_iterations ++;
    } while (changed && number_of_iterations < MAX_ITERATIONS);

/*
 * After loops ...
 *
 * Print a warning if necessary.
 *
 * Then depending on our parameters either copy back information,
 * or try to modify the widgets involved.
 */
    if (number_of_iterations == MAX_ITERATIONS) {
	String	pp[2];
	Cardinal np = 2;

	pp[0] = XtName(f);
	pp[1] = (String)MAX_ITERATIONS;

	XtAppWarningMsg(XtWidgetToApplicationContext((Widget)f), "formGeometry", "formBailOut",
		"LessTifError",
		"XmForm %s Layout algorithm bailing out after %d iterations",
		pp, &np);
    }

#ifdef	PRINT_REPORT
    for (i=0; i<f->composite.num_children; i++) {
	Widget child = f->composite.children[i];
	XmFormConstraints constraints = (XmFormConstraints)child->core.constraints;

	XdbDebug0(__FILE__, (Widget)f,  "Child #%d (%s)\tx %d y %d w %d h %d\n",
		i, XtName(child), CX, CY, CW, CH);
    }
#endif

/* If in test mode for a child widget, copy back the answer */
    if (TestMode) {
	if (cw != (Widget)f) {
	    XmFormConstraints constraints =
		(XmFormConstraints)f->composite.children[this_child]->core.constraints;

	    cg->x = constraints->form.x;
	    cg->y = constraints->form.y;
	    cg->width = constraints->form.w;
	    cg->height = constraints->form.h;
	    cg->request_mode = CWX | CWY | CWWidth | CWHeight;
	} else { /* TestMode for form itself */
	    cg->width = fw;
	    cg->height = fh;
	    cg->request_mode = CWWidth | CWHeight;
	} 
    } else {	/* If not in test mode, change all widget geometries */
	XtWidgetGeometry	request;
	XtGeometryResult	result;

	/* Children first */
	for (i=0; i<f->composite.num_children; i++) {
	    Widget child = f->composite.children[i];
	    XmFormConstraints constraints =
			(XmFormConstraints)child->core.constraints;

	    _XmConfigureObject(child,
		constraints->form.x,
		constraints->form.y,
		constraints->form.w <= 0 ? 1 : constraints->form.w,
		constraints->form.h <= 0 ? 1 : constraints->form.h,
		child->core.border_width);
	}

	/* Myself */
	request.request_mode = CWWidth | CWHeight;
	request.width = FW;
	request.height = FH;

	if (BB_ResizePolicy(f) == XmRESIZE_ANY) {
	    if (FW != XtWidth(f) || FH != XtHeight(f)) {
		request.width = FW;
		request.height = FH;
	    }
	} else if (BB_ResizePolicy(f) == XmRESIZE_GROW) {
	    if (FW != XtWidth(f))
		request.width = FW;
	    if (FH != XtHeight(f))
		request.height = FH;
	}


/*
 * MLM: 960403 the if statement below keeps the form from making resize
 * requests before it is realized, when that path is followed: the
 * second test below is the reason why.  This may have been necessary
 * when objects were capricious about how and when they set their
 * size requirements -- that's mostly no longer valid (see form/test4
 * for an example of one - my ScrolledWindow:().
 */
#if 0
	if (! XtIsRealized((Widget)f)) {
		if (XtWidth(f) != 0) request.width = XtWidth(f);
		if (XtHeight(f) != 0) request.height = XtHeight(f);
	}
#endif
	if (XtWidth(f) != request.width || XtHeight(f) != request.height) {
	    do {
		result = XtMakeGeometryRequest((Widget)f, &request, &request);

		XdbDebug(__FILE__, (Widget)f, "XtMakeGeometryRequest (w %d h %d) => %s\n",
			request.width, request.height,
			XdbGeometryResult2String(result));
	    } while (result == XtGeometryAlmost);
	}
    }
}

/*
 * ChangeManaged method
 *
 * Called when adding a managed child, or by managing/unmanaging an
 *	existing child.
 *
 * Before Realize, ChangeManaged is called only once (just before realize).
 *	At that time, we should do the layout algorithm to determine the
 *	form's initial size depending on the children.
 */
static void
ChangeManaged(Widget w)
{
	XmFormWidget	f = (XmFormWidget) w;

/*
 * Must also redo layout when not realized to make up initial
 * sizing calculations
 */
#ifdef notdef
        if (! XtIsRealized(w)) {
                XdbDebug(__FILE__, (Widget)f, "ChangeManaged: not realized\n");
                return;
        }
#endif

        XdbDebug(__FILE__, (Widget)f, "ChangeManaged: initially w %d h %d\n",
                XtWidth(f), XtHeight(f));
        XmFormLayout(f, Mode_Normal, NULL, NULL);

/* FIX ME */
	_XmNavigChangeManaged(w);
}

Widget 
XmCreateForm(Widget parent,
	     char *name,
	     Arg *arglist,
	     Cardinal argCount)
{
    return XtCreateWidget(name, xmFormWidgetClass, parent, arglist, argCount);
}

Widget 
XmCreateFormDialog(Widget parent,
		   char *name,
		   Arg *arglist,
		   Cardinal argcount)
{
    Widget shell;
    char *shell_name;
    Arg		args[10];
    int		nargs;

    nargs=0;
    XtSetArg(args[nargs], XmNallowShellResize, True); nargs++;

    shell_name = _XmMakeDialogName(name);

    shell = XmCreateDialogShell(parent, shell_name, args, nargs);

    XtManageChild(shell);
    XtFree(shell_name);

    return XmCreateForm(shell, name, arglist, argcount);
}

static void
FormInsertChild(Widget w)
{
    Widget f = XtParent(w);

    XdbDebug2(__FILE__, (Widget)f, w, "InsertChild\n");

#define superclass (&xmBulletinBoardClassRec)
    (*superclass->composite_class.insert_child)(w);
#undef superclass
}
