/**
 *
 * $Id: Gadget.c,v 1.27 1996/04/22 22:54:54 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: Gadget.c,v 1.27 1996/04/22 22:54:54 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/DebugUtil.h>
#include <Xm/GadgetP.h>
#include <Xm/ExtObjectP.h>
#include <Xm/RepType.h>
#include <string.h>
#include <stdio.h>

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);

static void input_dispatch(Widget w, XEvent *event, Mask event_mask);
static Boolean visual_change(Widget w, Widget parent, Widget n);
static void focus_change(Widget w, XmFocusChange fevent);
static void secondary_object_create(Widget req, Widget new, ArgList args,
				    Cardinal *num_args);
static XmNavigability widget_navigable(Widget w);

#define Offset(field) XtOffsetOf(XmGadgetRec, gadget.field)

static void gadget_border_unhighlight(Widget w);
static void gadget_border_highlight(Widget w);
static void _XmGetParentHighlightColor(Widget w, int offset, XtArgVal *value);
static void _XmGetParentTopShadowColor(Widget w, int offset, XtArgVal *value);
static void _XmGetParentBottomShadowColor(Widget w, int offset, XtArgVal *value);

/* Resources for the Gadget class */
static XtResource resources[] = {
    {
	XmNx, XmCPosition, XmRHorizontalPosition,
	sizeof(Dimension), XtOffsetOf(XmGadgetRec, rectangle.x),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNy, XmCPosition, XmRVerticalPosition,
	sizeof(Dimension), XtOffsetOf(XmGadgetRec, rectangle.y),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNwidth, XmCDimension, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmGadgetRec, rectangle.width),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNheight, XmCDimension, XmRVerticalDimension,
	sizeof(Dimension), XtOffsetOf(XmGadgetRec, rectangle.height),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNborderWidth, XmCBorderWidth, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmGadgetRec, rectangle.border_width),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), Offset(traversal_on),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNhighlightOnEnter, XmCHighlightOnEnter, XmRBoolean,
	sizeof(Boolean), Offset(highlight_on_enter),
	XmRImmediate, (XtPointer)False
    }, 
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
	sizeof(Dimension), Offset(highlight_thickness),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), Offset(shadow_thickness),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNunitType, XmCUnitType, XmRUnitType,
	sizeof(unsigned char), Offset(unit_type),
	XmRCallProc, (XtPointer)_XmUnitTypeDefault
    }, 
    {
	XmNnavigationType, XmCNavigationType, XmRNavigationType,
	sizeof(unsigned char), Offset(navigation_type),
	XmRImmediate, (XtPointer)XmNONE
    },
    {
	XmNhelpCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(help_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNuserData, XmCUserData, XmRPointer,
	sizeof(XtPointer), Offset(user_data),
	XmRPointer, NULL
    }
};

#define GOffset(field)	XtOffset(XmGadget, gadget.field)
#define ROffset(field)	XtOffset(XmGadget, rectangle.field)
#define OOffset(field)	XtOffset(XmGadget, object.field)
static XmSyntheticResource syn_resources[] = {
    /* rectangle part */
    {
	XmNx, 
	sizeof(Position), ROffset(x),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNy, 
	sizeof(Position), ROffset(y),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    {
	XmNwidth, 
	sizeof(Dimension), ROffset(width),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNheight, 
	sizeof(Dimension), ROffset(height),
	_XmFromVerticalPixels, _XmToVerticalPixels
    },
    /* gadget */
    {
	XmNhighlightThickness, 
	sizeof(Dimension), GOffset(highlight_thickness),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNshadowThickness, 
	sizeof(Dimension), GOffset(shadow_thickness),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    /* object */
    {
	XmNhighlightColor, 
	sizeof(Pixel), OOffset(parent),
	_XmGetParentHighlightColor, NULL
    },
    {
	XmNtopShadowColor, 
	sizeof(Pixel), OOffset(parent),
	_XmGetParentTopShadowColor, NULL
    },
    {
	XmNbottomShadowColor, 
	sizeof(Pixel), OOffset(parent),
	_XmGetParentBottomShadowColor, NULL
    }
};

static XmBaseClassExtRec _XmGadgetRectClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL,
    /* set_values_prehook        */ NULL,
    /* initialize_posthook       */ NULL,
    /* set_values_posthook       */ NULL,
    /* secondary_object_class    */ NULL,
    /* secondary_object_create   */ secondary_object_create,
    /* get_secondary_resources   */ NULL,
    /* fast_subclass             */ { 0 },
    /* get_values_prehook        */ NULL,
    /* get_values_posthook       */ NULL,
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ widget_navigable,
    /* focus_change              */ focus_change,
    /* wrapper_data              */ NULL
};

static XmGadgetClassExtRec _XmGadgetClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmGadgetClassExtVersion,
    /* size                      */ sizeof(XmGadgetClassExtRec),
    /* widget_baseline_proc      */ NULL, /* FIXME */
    /* display_rect_proc         */ NULL, /* FIXME */
};

XmGadgetClassRec xmGadgetClassRec = {
    /* RectObj class part */
    {
	/* superclass            */ (WidgetClass) &rectObjClassRec,
        /* class_name            */ "XmGadget",
	/* widget_size           */ sizeof(XmGadgetRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ FALSE,
	/* compress_exposure     */ XtExposeNoCompress,
	/* compress_enterleave   */ FALSE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ NULL,
	/* expose                */ NULL,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ _XmGadgetGetValuesHook,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ NULL,
        /* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmGadgetRectClassExtRec
    },
    /* XmGadget part */
    {
	/* border_highlight   */ gadget_border_highlight,
        /* border_unhighlight */ gadget_border_unhighlight,
        /* arm_and_activate   */ NULL, /* fix me */
        /* input_dispatch     */ input_dispatch, 
        /* visual_change      */ visual_change,
        /* syn_resources      */ syn_resources,
        /* num_syn_resources  */ XtNumber(syn_resources),
        /* extension          */ (XtPointer)&_XmGadgetClassExtRec
    }

};

WidgetClass xmGadgetClass = (WidgetClass)&xmGadgetClassRec;

static void
class_initialize()
{
    _XmInitializeExtensions();
    _XmGadgetRectClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    XmGadgetClass gc;

    gc = (XmGadgetClass)widget_class;

    if (gc->gadget_class.border_highlight == XmInheritBorderHighlight)
	gc->gadget_class.border_highlight = gadget_border_highlight;
    if (gc->gadget_class.border_unhighlight == XmInheritBorderUnhighlight)
	gc->gadget_class.border_unhighlight = gadget_border_unhighlight;
    if (gc->gadget_class.visual_change == XmInheritVisualChange)
	gc->gadget_class.visual_change = visual_change;
    if (gc->gadget_class.input_dispatch == XmInheritInputDispatch)
	gc->gadget_class.input_dispatch = input_dispatch;

    _XmBaseClassPartInitialize(widget_class);
    _XmFastSubclassInit(widget_class, XmGADGET_BIT);

    /* compile the resources */
    if (widget_class == xmGadgetClass) {
	_XmSortResourceList((XrmResource **)gc->rect_class.resources,
			    gc->rect_class.num_resources);
    }

    _XmBuildGadgetResources(widget_class);
}

static void
secondary_object_create(Widget req, Widget new,
			ArgList args, Cardinal *num_args)
{
    XmBaseClassExt *bce;
    Arg argl[1];
    ArgList merged;

    XtSetArg(argl[0], XmNlogicalParent, new);

    if (*num_args) {
	merged = XtMergeArgLists(args, *num_args, argl, XtNumber(args));
	bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
	XtCreateWidget(XtName(new), (*bce)->secondaryObjectClass,
		       XtParent(new)
			? XtParent(new)
			: new,
		       merged, *num_args + 1);
	XtFree((char *)merged);
    }
    else {
	bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
	XtCreateWidget(XtName(new), (*bce)->secondaryObjectClass,
		       XtParent(new)
			? XtParent(new)
			: new,
		       argl, 1);
    }
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmBaseClassExt bce;

    if (!XmRepTypeValidValue(XmRepTypeGetId(XmRNavigationType),
			     G_NavigationType(new),
			     new))
	G_NavigationType(new) = XmNONE; 

#if 0
/* this should be here, but doesn't work */
    if (!XmRepTypeValidValue(XmRepTypeGetId(XmRUnitType),
			     G_UnitType(new),
			     new))
	G_UnitType(new) = XmPIXELS;
#endif

    if (XtWidth(request) == (Dimension)0)
	XtWidth(new) = (G_HighlightThickness(new) * 2
			+ G_ShadowThickness(new) * 2);
    if (XtHeight(request) == (Dimension)0)
	XtHeight(new) = (G_HighlightThickness(new) * 2
			 + G_ShadowThickness(new) * 2);
    XtBorderWidth(new) = 0;

    _XmGadgetImportArgs(new, args, num_args);
    /* BaseClass stuff provides this */
    _XmGadgetImportSecondaryArgs(new, args, num_args);

    bce = *(XmBaseClassExt *)_XmGetBaseClassExtPtr(XtClass(new), XmQmotif);

    if (bce && bce->secondaryObjectClass) {
	if (bce->secondaryObjectCreate)
	    (bce->secondaryObjectCreate)(request, new, args, num_args);
    }

    G_EventMask(new) = 0;
    G_HaveTraversal(new) = False;
    G_Highlighted(new) = False;
    G_HighlightDrawn(new) = False;
}

static void
destroy(Widget w)
{
}

static Boolean
set_values(Widget current,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    _XmGadgetImportArgs(new, args, num_args);

    return True; /* FIX ME */
}

static void 
input_dispatch(Widget w, 
	       XEvent *event, 
	       Mask event_mask)
{
    XdbDebug(__FILE__, w, "Inside base Gadget input_dispatch() routine (you really should write one for this gadget... :)\n");

    if (event_mask & XmENTER_EVENT)
        XdbDebug(__FILE__, w, "Enter event sent to gadget %d\n", w);
    else if (event_mask & XmLEAVE_EVENT)
        XdbDebug(__FILE__, w, "Leave event sent to gadget %d\n", w);
    else if (event_mask & XmFOCUS_IN_EVENT)
        XdbDebug(__FILE__, w, "Focus in event sent to gadget %d\n", w);
    else if (event_mask & XmFOCUS_OUT_EVENT)
        XdbDebug(__FILE__, w, "Focus out event sent to gadget %d\n", w);
    else if (event_mask & XmMOTION_EVENT)
        XdbDebug(__FILE__, w, "Motion event sent to gadget %d\n", w);
    else if (event_mask & XmARM_EVENT)
        XdbDebug(__FILE__, w, "Arm event sent to gadget %d\n", w);
    else if (event_mask & XmACTIVATE_EVENT)
        XdbDebug(__FILE__, w, "Activate event sent to gadget %d\n", w);
    else if (event_mask & XmHELP_EVENT)
        XdbDebug(__FILE__, w, "Help event sent to gadget %d\n", w);
    else if (event_mask & XmKEY_EVENT)
        XdbDebug(__FILE__, w, "Key event sent to gadget %d\n", w);
    else if (event_mask & XmMULTI_ARM_EVENT)
        XdbDebug(__FILE__, w, "Multi arm event sent to gadget %d\n", w);
    else if (event_mask & XmMULTI_ACTIVATE_EVENT)
        XdbDebug(__FILE__, w, "Multi activate event sent to gadget %d\n", w);
    else if (event_mask & XmBDRAG_EVENT)
        XdbDebug(__FILE__, w, "BDrag event sent to gadget %d\n", w);
}

static Boolean 
visual_change(Widget w, 
	      Widget parent, 
	      Widget n)
{
    return False;
}

/*
 * ENTER/LEAVE should only happen when mwm is in pointer-follows-mouse mode.
 * FOCUS_IN/FOCUS_OUT otherwise.
 */
void
focus_change(Widget w, XmFocusChange change)
{
    XmGadgetClass gc = (XmGadgetClass)XtClass(w);

    switch(change) {
    case XmENTER:
	if (!G_HighlightOnEnter(w))
	    break;
	if (gc->gadget_class.border_highlight)
	    (gc->gadget_class.border_highlight)(w);
	break;

    case XmFOCUS_IN:
	G_HaveTraversal(w) = True;
	if (gc->gadget_class.border_highlight)
	    (gc->gadget_class.border_highlight)(w);
	break;

    case XmLEAVE:
	if (!G_HighlightOnEnter(w))
	    break;
	if (gc->gadget_class.border_unhighlight)
	    (gc->gadget_class.border_unhighlight)(w);
	break;

    case XmFOCUS_OUT:
	G_HaveTraversal(w) = True;
	if (gc->gadget_class.border_unhighlight)
	    (gc->gadget_class.border_unhighlight)(w);
	break;
    }
}

static XmNavigability
widget_navigable(Widget w)
{   
    if (XtSensitive(w) && G_TraversalOn(w))
    {
	if ((G_NavigationType(w) == XmSTICKY_TAB_GROUP ||
	     G_NavigationType(w) == XmEXCLUSIVE_TAB_GROUP ||
	     G_NavigationType(w) == XmTAB_GROUP) && !_XmShellIsExclusive(w))
	{
	    return XmTAB_NAVIGABLE;
	}
	return XmCONTROL_NAVIGABLE;
    }
    return XmNOT_NAVIGABLE;
}

static void
gadget_border_unhighlight(Widget w)
{

    XdbDebug(__FILE__, w, "gadget_border_unhighlight\n");

    if (G_HighlightThickness(w) == 0) /* with zero width, we don't need this... */
	return;

    if (XmIsManager(XtParent(w)))
    {
	XSetForeground(XtDisplay(w), XmParentHighlightGC(w), XmParentBackground(w));

	_XmDrawHighlight(XtDisplayOfObject(w), XtWindowOfObject(w),
			 XmParentHighlightGC(w),
			 XtX(w), XtY(w), XtWidth(w), XtHeight(w),
			 G_HighlightThickness(w), LineSolid);

	XSetForeground(XtDisplay(w), XmParentHighlightGC(w), XmParentHighlightColor(w));
    }
    else
	_XmClearBorder(XtDisplay(w),
		       XtWindow(w),
		       XtX(w),XtY(w),
		       XtWidth(w), XtHeight(w),
		       G_HighlightThickness(w));

    G_Highlighted(w) = False;
    G_HighlightDrawn(w) = False;
}

static void
gadget_border_highlight(Widget w)
{

    XdbDebug(__FILE__, w, "gadget_border_highlight\n");

    if (G_HighlightThickness(w) == 0) /* with zero width, we don't need this... */
	return; 

    _XmDrawHighlight(XtDisplayOfObject(w), XtWindowOfObject(w),
		     XmParentHighlightGC(w),
		     XtX(w), XtY(w), XtWidth(w), XtHeight(w),
		     G_HighlightThickness(w), LineSolid);

    G_Highlighted(w) = True;
    G_HighlightDrawn(w) = True;
}

static void
_XmGetParentHighlightColor(Widget w, int offset, XtArgVal *value) {
    *value = XmParentHighlightColor(w);
}

static void
_XmGetParentTopShadowColor(Widget w, int offset, XtArgVal *value) {
    *value = XmParentTopShadowColor(w);
}

static void
_XmGetParentBottomShadowColor(Widget w, int offset, XtArgVal *value) {
    *value = XmParentBottomShadowColor(w);
}

/*
 * initialize the synthetic resource crap.  The only way I know to get the
 * CachePart stuff for Gadget subclasses is via the baseclass extension
 * (secondary stuff); unfortunately, I don't know how that works yet.
 */
void
_XmBuildGadgetResources(WidgetClass c)
{
    XmGadgetClass super;
    XmGadgetClass gc = (XmGadgetClass)c;
    XmBaseClassExt *bce = NULL;
    XmExtObjectClass subpclass, esuper;


    _XmInitializeSyntheticResources(gc->gadget_class.syn_resources,
				    gc->gadget_class.num_syn_resources);

    /*
     * if we're the Gadget, our super doesn't have synthetic resources
     * nor do we have an extension, so we can bail here.
     */
    if (c == xmGadgetClass)
	return;

    super = ((XmGadgetClass)c->core_class.superclass);
    _XmBuildResources(&gc->gadget_class.syn_resources,
		      &gc->gadget_class.num_syn_resources,
		      super->gadget_class.syn_resources,
		      super->gadget_class.num_syn_resources);

    /*
     * we can get the subpart stuff from the baseclass extension, now that
     * it's there.
     */
    bce = (XmBaseClassExt *)_XmGetBaseClassExtPtr(c, XmQmotif);

    if (!*bce || !(subpclass = (XmExtClassRec *)(*bce)->secondaryObjectClass))
	return;

    _XmInitializeSyntheticResources(subpclass->ext_class.syn_resources,
				    subpclass->ext_class.num_syn_resources);

    /* core dump avoidance overkill */
    esuper = (XmExtObjectClass)subpclass->object_class.superclass;
    if (subpclass == &xmExtClassRec || esuper == &xmExtClassRec)
	return;

    _XmBuildResources(&subpclass->ext_class.syn_resources,
		      &subpclass->ext_class.num_syn_resources,
		      esuper->ext_class.syn_resources,
		      esuper->ext_class.num_syn_resources);
}
