/**
 *
 * $Id: MenuUtil.c,v 1.20 1996/04/22 22:55:19 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: MenuUtil.c,v 1.20 1996/04/22 22:55:19 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/DebugUtil.h>
#include <Xm/RowColumnP.h>
#include <Xm/MenuUtilP.h>
#include <Xm/Screen.h>
#include <Xm/ScreenP.h>
#include <Xm/XmosP.h>
#include <stdio.h>

extern XtPointer _XmGetScreenInfo(Widget scr);
extern void CleanupMenuBar(Widget w, XEvent *event, String *params, Cardinal *num_params);

Boolean 
_XmGetInDragMode(Widget w)
{
    Widget scr = XmGetXmScreen(XtScreen(w));

    XmScreenInfo *info = (XmScreenInfo*)_XmGetScreenInfo(scr);
    XmMenuState state = (XmMenuState)info->menu_state;

    return state->MU_InDragMode;
}

void
_XmSetInDragMode(Widget w, Boolean flag)
{
    /* first we update the perscreen menu info, and then we grab the pointer/keyboard */
    Widget scr = XmGetXmScreen(XtScreen(w));
    XmScreenInfo *info = (XmScreenInfo*)_XmGetScreenInfo(scr);
    XmMenuState state = (XmMenuState)info->menu_state;

    state->MU_InDragMode = flag;
}

/* This internal method returns the shell widget containing
   a popup.  The argument is the */

extern Widget 
_XmGetRC_PopupPosted(Widget rc)
{
    if (!XmIsRowColumn(rc))
	return NULL;

    return RC_PopupPosted(rc);
}

void
_XmRecordEvent(XEvent *event)
{
}

Boolean
_XmIsEventUnique(XEvent *event)
{
    return False; /* FIX ME */
}

/*
 * A wrapper around the Xt Intrinsic's pointer grabbing. This
 * one retries a failing grab for several times and if all fails
 * spits out a warning message.
 */
int 
_XmGrabPointer(Widget w,
	       int owner_events,
	       unsigned int event_mask,
	       int pointer_mode,
	       int keyboard_mode,
	       Window confine_to,
	       Cursor cursor,
	       Time time)
{
    int result, retries;

    XdbDebug(__FILE__, w, "_XmGrabPointer()\n");

    for ( retries = 4; retries >= 0; retries-- ) {
        result = XtGrabPointer(XmIsGadget(w) ? XtParent(w) : w,
			       owner_events, event_mask,
			       pointer_mode, keyboard_mode,
			       confine_to, cursor, time);
	if ( result == GrabSuccess )
	    return result;
	if ( retries ) _XmMicroSleep(1);
    }
    _XmWarning(w, "Can't grab the pointer.");
    return result;
}

void
_XmUngrabPointer(Widget w, Time t)
{
	XdbDebug(__FILE__, w, "_XmUngrabPointer\n");

	XtUngrabPointer(XmIsGadget(w) ? XtParent(w) : w, t);
}

/*
 * Same as the _XmGrabPointer wrapper above, but this time for grabbing
 * the keyboard.
 */
int
_XmGrabKeyboard(Widget widget,
		int owner_events,
		int pointer_mode,
		int keyboard_mode,
		Time time)
{
   int result, retries;

    XdbDebug(__FILE__, widget, "_XmGrabKeyboard()\n");
    
    for ( retries = 4; retries >= 0; retries-- ) {
        result = XtGrabKeyboard(XmIsGadget(widget) ? XtParent(widget) : widget,
			        owner_events,
			        pointer_mode, keyboard_mode,
			        time);
	if ( result == GrabSuccess )
	    return result;
	if ( retries ) _XmMicroSleep(1);
    }
    _XmWarning(widget, "Can't grab the keyboard.");
    return result;
}

void
_XmUngrabKeyboard(Widget w, Time t)
{
	XdbDebug(__FILE__, w, "_XmUngrabKeyboard\n");

	XtUngrabKeyboard(XmIsGadget(w) ? XtParent(w) : w, t);
}

void 
_XmMenuEscape(Widget w, 
	      XEvent *ev, 
	      String *params, 
	      Cardinal *num_params)
{
    Widget	cb;
    XmRowColumnWidget	rc;

    XdbDebug(__FILE__, w, "_XmMenuEscape()\n");

    if (XmIsRowColumn(w))
	rc = (XmRowColumnWidget)w;
    else
	rc = (XmRowColumnWidget) XtParent(w);

    cb = rc->row_column.cascadeBtn;

    CleanupMenuBar(cb, ev, params, num_params);
}

void 
_XmMenuTraverseLeft(Widget w, 
		    XEvent *ev, 
		    String *params, 
		    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmMenuTraverseLeft()\n");
}

void 
_XmMenuTraverseRight(Widget w, 
		     XEvent *ev, 
		     String *params, 
		     Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmMenuTraverseTight()\n");
}

void 
_XmMenuTraverseUp(Widget w, 
		  XEvent *ev, 
		  String *params, 
		  Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmMenuTraverseUp()\n");
}

void 
_XmMenuTraverseDown(Widget w, 
		    XEvent *ev, 
		    String *params, 
		    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmMenuTraverseDown()\n");
}

void 
_XmRC_GadgetTraverseDown(Widget w, 
			 XEvent *ev, 
			 String *params, 
			 Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmRC_GadgetTraverseRight()\n");
}

void 
_XmRC_GadgetTraverseUp(Widget w, 
		       XEvent *ev, 
		       String *params, 
		       Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmRC_GadgetTraverseUp()\n");
}

void 
_XmRC_GadgetTraverseLeft(Widget w, 
			 XEvent *ev, 
			 String *params, 
			 Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmRC_GadgetTraverseLeft()\n");
}

void 
_XmRC_GadgetTraverseRight(Widget w, 
			  XEvent *ev, 
			  String *params, 
			  Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmRC_GadgetTraverseRight()\n");
}

/*
 * I don't know, but I'm willing to bet on XContexts...
 */
XtPointer
_XmGetMenuProcContext(void)
{
    return NULL;
}

void
_XmSaveCoreClassTranslations(Widget widget)
{
}

void
_XmRestoreCoreClassTranslations(Widget widget)
{
}

void
XmSetMenuCursor(Display *display, Cursor cursorId)
{
    XmScreen scr = (XmScreen)XmGetXmScreen(DefaultScreenOfDisplay(display));
    Screen_MenuCursor(scr) = cursorId;
}

Cursor
XmGetMenuCursor(Display *display)
{
	return _XmGetMenuCursorByScreen(DefaultScreenOfDisplay(display));
}
