#include <Xm/XmP.h>
#include <stdio.h>

#define ASN_LENGTH_MODIFIER	0x80U

typedef struct __XmStringRec {
    unsigned char tag;
    unsigned char len;
    unsigned char data[1];
} XmStringRec;

typedef struct _XmtStringContextRec {
    struct _XmStringRec *string;
    int current_segment;
} XmStringContextRec;

int
asn1_dump(unsigned char *string) {
    unsigned length, i, nlen;
    struct __XmStringRec *str = (struct __XmStringRec *)string;
    unsigned char *next;

    printf("STRING: TAG: %02x LEN: %02x\n", str->tag, str->len);

    length = 0;
    /* indefinite length ? */
    if (str->len != ASN_LENGTH_MODIFIER) {

	if (str->len > ASN_LENGTH_MODIFIER) {

	    for (i = 0; i < (str->len & ~ASN_LENGTH_MODIFIER); i++) {
		length <<= 8;
		length |= str->data[i];
		if (i > sizeof(unsigned)) {
		    fprintf(stderr, "Invalid XmString\n");
		    exit (0);
		}
	    }
	}
	else {
	    i = 0;
	    length = str->len & ~ASN_LENGTH_MODIFIER;
	}
	next = &str->data[i];

	/* primitive type -- doesn't recurse */
	switch (str->tag) {
	case XmSTRING_COMPONENT_UNKNOWN:
	    printf("UNKNOWN COMPONENT: length %d\n", length);
	    return length + i + 2;
	case XmSTRING_COMPONENT_CHARSET:
	    printf("CHARSET:\n");
	    for (nlen = 0; nlen < length; nlen++)
		putchar(str->data[i + nlen]);
	    putchar('\n');
	    return length + i + 2;
	case XmSTRING_COMPONENT_TEXT:
	    printf("TEXT: %d\n", length);
	    for (nlen = 0; nlen < length; nlen++)
		putchar(str->data[i + nlen]);
	    putchar('\n');
	    return length + i + 2;
	case XmSTRING_COMPONENT_DIRECTION:
	    printf("DIRECTION: %d\n", length);
	    for (nlen = 0; nlen < length; nlen++)
		printf("%d ", str->data[i + nlen]);
	    putchar('\n');
	    return length + i + 2;
	case XmSTRING_COMPONENT_SEPARATOR:
	    printf("SEPARATOR: %d\n", length);
	    for (nlen = 0; nlen < length; nlen++)
		printf("%d ", str->data[i + nlen]);
	    putchar('\n');
	    return length + i + 2;
	case XmSTRING_COMPONENT_LOCALE_TEXT:
	    printf("LOCALE TEXT: %d\n", length);
	    for (nlen = 0; nlen < length; nlen++)
		putchar(str->data[i + nlen]);
	    putchar('\n');
	    return length + i + 2;
	case (XmSTRING_COMPONENT_LOCALE_TEXT+1):
	    i += length + 2;
	    while (length > 0) {
		nlen = asn1_dump(next);
		next += nlen;
		length -= nlen;
	    }
	    return 0;
	default:
	    printf("invalid tag: %02x\n", str->tag);
	    return 1;
	}
    }
    else { /* it's indefinite */
	next = str->data;
	str = (struct __XmStringRec *)next;
	while (str->tag != 0 && str->len != 0) {
	    nlen = asn1_dump(next);
	    if (nlen == 0)
		break;
	    next += nlen;
	    str = (struct __XmStringRec *)next;
	}
    }
}

int 
main(int argc,
     char **argv)
{
    Widget toplevel;
    XtAppContext app;
    Dimension width, height;
    XmFontList fl;
    XmString xmstr, xmstr2, xmstr3, xmstr4, xmstr5, xmstr6;

    toplevel = XtVaAppInitialize(&app, "XmString", NULL, 0, &argc, argv, NULL, NULL);

    fl = _XmGetDefaultFontList(toplevel, XmTEXT_FONTLIST);

    xmstr3 = XmStringSeparatorCreate();
    asn1_dump((unsigned char *)xmstr3);
    printf("*************************************************\n");

    xmstr = XmStringCreateSimple("Hello World this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test this is a long test");
    asn1_dump((unsigned char *)xmstr);
    printf("*************************************************\n");

    xmstr2 = XmStringCreateLtoR("Hello\nWorld", XmFONTLIST_DEFAULT_TAG);
    asn1_dump((unsigned char *)xmstr2);
    printf("*************************************************\n");

    xmstr4 = XmStringDirectionCreate(XmSTRING_DIRECTION_R_TO_L);
    asn1_dump((unsigned char *)xmstr4);
    printf("*************************************************\n");

    xmstr5 = XmStringSegmentCreate("Hello World", XmFONTLIST_DEFAULT_TAG,
				   XmSTRING_DIRECTION_R_TO_L, True);
    asn1_dump((unsigned char *)xmstr5);
    printf("*************************************************\n");

#if 1
    xmstr6 = XmStringCreate("Hello World", XmFONTLIST_DEFAULT_TAG);
    asn1_dump((unsigned char *)xmstr6);
#endif

    XmStringExtent(fl, xmstr, &width, &height);

    printf ("String 'Hello World' has dimensions %dx%d\n", width, height);

    XmStringExtent(fl, xmstr2, &width, &height);

    printf ("String 'Hello\\nWorld' has dimensions %dx%d\n", width, height);
}
