/* pam_end.c */

/*
 * $Id: pam_end.c,v 1.3 1996/07/07 23:56:01 morgan Exp $
 *
 * $Log: pam_end.c,v $
 * Revision 1.3  1996/07/07 23:56:01  morgan
 * added some debugging info
 *
 * Revision 1.2  1996/03/16 21:47:12  morgan
 * added RCS info and also overwriting of passwords before liberating
 * memory.
 *
 *
 */

#include <stdlib.h>

#include "pam_private.h"

#ifdef DEBUG
#define D(x) _pam_debug x
#else
#define D(x)
#endif

int pam_end(pam_handle_t *pamh, int pam_status)
{
    int ret;

    IF_NO_PAMH("pam_end",pamh,PAM_SYSTEM_ERR);

    D(("entering pam_end()"));

    /* first liberate the modules (it is not inconcevible that the
       modules may need to use the service_name etc. to clean up) */

    _pam_free_data(pamh, pam_status);

    if ((ret = _pam_free_handlers(pamh)) != PAM_SUCCESS) {
	return ret;                 /* error occurred */
    }

    /* from this point we cannot call the modules any more. Free the remaining
       memory used by the Linux-PAM interface */

    DROP(pamh->service_name);
    DROP(pamh->user);
    DROP(pamh->tuser);            /* temp user name for pam_get_user() */
    DROP(pamh->prompt);           /* temp user name for pam_get_user() */
    DROP(pamh->pam_conversation);
    DROP(pamh->tty);
    DROP(pamh->rhost);
    DROP(pamh->ruser);
    _pam_overwrite(pamh->authtok);             /* blank out old token */
    DROP(pamh->authtok);
    _pam_overwrite(pamh->oldauthtok);          /* blank out old token */
    DROP(pamh->oldauthtok);

    /* and finally liberate the memory for the pam_handle structure */

    DROP(pamh);

    D(("exiting pam_end() successfully"));

    return PAM_SUCCESS;
}
