/* solve.c
 $Header: /al/acs/src/RCS/solve.cc,v 9.26 95/10/31 16:12:47 al Exp $
 * LU decomposition and fwd-back substitution for real numbers
 * 2 modules:  lu() and solve()
 * lu() does LU decomposition using the Crout algorithm (modified)
 * solve() does forward and back substitution after calling lu() if necessary
 */
#include "error.h"
#include "m_matrix.h"
#include "e_node.h"
#include "u_opt.h"
#include "u_status.h"
#include "s__.h"
#include "util.h"
#include "declare.h"	/* self */
/*--------------------------------------------------------------------------*/
	void	solve(void);
static	void	lu_decomp(void);
static	void	lu_partial(void);
static	void	lu_full(void);
static	double	dotprod(int,int,int);
/*--------------------------------------------------------------------------*/
extern NODE* nstat;
/*--------------------------------------------------------------------------*/
void solve(void)
{
 lu_decomp();
}
/*--------------------------------------------------------------------------*/
static void lu_decomp(void)
{
 if (OPT::lubypass && SIM::inc_mode){
    lu_partial();
 }else{
    lu_full();
 }
}
/*--------------------------------------------------------------------------*/
static void lu_partial(void)
{
 int ii, jj, mm;
 int bn;
 int prop = 0;
 
 STATUS::lud.start();
 for (mm = 1;   mm <= SIM::aa.size();   ++mm){
    bn = SIM::aa.lownode(mm);
    if (nstat[mm].needslu  ||  bn <= prop){
       nstat[mm].needslu = FALSE;
       prop = mm;
       if (bn < mm){
	  prop = mm;
	  SIM::lu.u(bn,mm) = SIM::aa.u(bn,mm) / SIM::lu.d(bn,bn);
	  for (ii = bn+1;  ii<mm;  ii++){
	     SIM::lu.u(ii,mm) = (SIM::aa.u(ii,mm) - dotprod(ii,mm,ii)) / SIM::lu.d(ii,ii);
	  }
	  SIM::lu.l(mm,bn) = SIM::aa.l(mm,bn);
	  for (jj = bn+1;  jj<mm;  jj++){
	     SIM::lu.l(mm,jj) = SIM::aa.l(mm,jj) - dotprod(mm,jj,jj);
	  }
	  /* jj == mm */{
	     SIM::lu.d(mm,mm) = SIM::aa.d(mm,mm) - dotprod(mm,mm,mm);
	     if (OPT::gmin > SIM::lu.d(mm,mm)  &&  SIM::lu.d(mm,mm) > -OPT::gmin){
		error(bWARNING, "open circuit: internal node %u\n", mm);
		SIM::lu.d(mm,mm) = OPT::gmin;
	     }
	  }
       }else{    /* bn == mm */
	  SIM::lu.d(mm,mm) = SIM::aa.d(mm,mm);
	  if (OPT::gmin > SIM::lu.d(mm,mm)  &&  SIM::lu.d(mm,mm) > -OPT::gmin){
	     error(bWARNING, "open circuit: internal node %u\n", mm);
	     SIM::lu.d(mm,mm) = OPT::gmin;
	  }
       }
    }
 }
 STATUS::lud.stop();
}
/*--------------------------------------------------------------------------*/
static void lu_full(void)
{
 int ii, jj, mm;
 int bn;

 STATUS::lud.start();
 for (mm = 1;   mm <= SIM::aa.size();   ++mm){
    bn = SIM::aa.lownode(mm);
    if (bn < mm){
       SIM::lu.u(bn,mm) = SIM::aa.u(bn,mm) / SIM::lu.d(bn,bn);
       for (ii = bn+1;  ii<mm;  ii++){
	  SIM::lu.u(ii,mm) = (SIM::aa.u(ii,mm) - dotprod(ii,mm,ii)) / SIM::lu.d(ii,ii);
       }
       SIM::lu.l(mm,bn) = SIM::aa.l(mm,bn);
       for (jj = bn+1;  jj<mm;  jj++){
	  SIM::lu.l(mm,jj) = SIM::aa.l(mm,jj) - dotprod(mm,jj,jj);
       }
       /* jj == mm */{
	  SIM::lu.d(mm,mm) = SIM::aa.d(mm,mm) - dotprod(mm,mm,mm);
	  if (OPT::gmin > SIM::lu.d(mm,mm)  &&  SIM::lu.d(mm,mm) > -OPT::gmin){
	     error(bWARNING, "open circuit: internal node %u\n", mm);
	     SIM::lu.d(mm,mm) = OPT::gmin;
	  }
       }
    }else{    /* bn == mm */
       SIM::lu.d(mm,mm) = SIM::aa.d(mm,mm);
       if (OPT::gmin > SIM::lu.d(mm,mm)  &&  SIM::lu.d(mm,mm) > -OPT::gmin){
	  error(bWARNING, "open circuit: internal node %u\n", mm);
	  SIM::lu.d(mm,mm) = OPT::gmin;
       }
    }
 }
 STATUS::lud.stop();
}
/*--------------------------------------------------------------------------*/
static double dotprod(int ii, int jj, int mm)
{
 int ind, len;
 int kk;
 double *row, *col;
 double dot = 0.;

 kk = max(SIM::aa.lownode(ii), SIM::aa.lownode(jj));
 len = mm - kk;
 if (len > 0){
    row = &(SIM::lu.l(ii,kk));
    col = &(SIM::lu.u(kk,jj));
    /* for (i = kk;   i < mm;   i++) */
    for (ind = 0;   ind < len;   ind++)
        dot += row[-ind] * col[ind];
 }
 return dot;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
