.\" X-BASED DINOSAUR CUBE
.\"
.\" xdino.man
.\"
.\" ##
.\"
.\" Copyright (c) 1995 - 96	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XDINO 6 "8 January 1996" "V5.2"
.SH NAME
xdino \- Dino X widgets
.SH SYNOPSIS
.B /usr/games/xdino
[-display <display>] [-geometry <geometry>]
[-{foreground | fg} <color>] [-{background | bg} <color>]
[-{border | bd} <color>] [-mono] [-[no]orient] [-{mode <int> | both}]
[-face{0|1|2|3|4|5} <color>]
.SH DESCRIPTION
.LP
Use "\fBmouse-left\fP" to move ccw.
.LP
Use "\fBmouse-center\fP", "\fBP\fP", or "\fBp\fP" to toggle the practice
mode (in practice mode the record should be "practice").  One must double
click on "\fBmouse-center\fP" if the puzzle is being worked on.
.LP
"\fBmouse-right\fP", "\fBR\fP", or "\fBr\fP", to randomize (this must be
done first to set a new record).  One must double click on
"\fBmouse-right\fP" if the puzzle is being worked on.
.LP
"\fBO\fP" or "\fBo\fP" keys toggle the orient mode.
.LP
"\fB2\fP", "\fB3\fP", "\fBB\fP", or "\fBb\fP" keys change modes to
Period 2, Period 3, or Both.
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (unimplemented).
.LP
"\fBU\fP" or "\fBu\fP" keys to undo move.
.LP
"\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
"\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
"\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys kill program.
.LP
Use the arrows, key pad or, "R" keys to move other than CCW.
.LP
Use the control key and the keypad, or arrow keys to move the whole cube.
.SH OPTIONS
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the dino window (resource
name "\fIgeometry\fP").
.TP 8
.B \-{foreground | fg} \fIcolor\fP
This option specifies the foreground of the dino window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background | bg} \fIcolor\fP
This option specifies the background of the dino window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border | bd} \fIcolor\fP
This option specifies the border color of the cubelets in the dino window
(resource name "\fIborderColor\fP").
.TP 8
.B \-mono
This option allows you to access the mono mode on a color monitor
(resource name "\fImono\fP").
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-mode <\fIint\fP>
This option allows you to set the turning mode (resource name
"\fImode\fP").
.TP 8
.B \-both
This option allows you to set the turning mode to both period 2 and
period 3 (resource name "\fImode\fP" set at 4).
.TP 8
.B \-face{0|1|2|3|4|5} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono-mode, color is represented as the first letter
of the color name. On the 2-D version, the faces are ordered top to bottom
and left to right on the "t" configuration. The "+-" configuration is
physically consistent with the former, so it is ordered "0, 1, 2, 3, 5, 4".
If you has two colors that begin with the same letter you should have one
in uppercase and one in lowercase to distinguish them in mono-mode. You can
change the colors of the faces to make a stupid cube (i.e. all White or in
mono-mode all "W"). Unfortunately, it will not normally say its solved when
its randomized. This would be cheating.
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xpyraminx(6), xoct(6), xmball(6), xmlink(6),
xcubes(6), xtriangles(6), xhexagons(6), xoct(6), xabacus(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1995-96, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author
.RS
David Albert Bagley,	<\fIbagleyd@hertz.njit.edu\fP>
.RE
.LP
The most updated source could be found on \fIftp.x.org\fP under
\fI/contrib/games/puzzles\fP.
