#include "message.h"
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

void Message::debugmsg (char const *fmt, ...) const
{
    va_list
	args;
    static int
	debug = -1;

    if (debug == -1)
    {
	register char
	    *cp = getenv ("KISSDEBUG");
	debug = cp ? 1 : 0;
    }

    if (debug)
    {
	va_start (args, fmt);
	fflush (stdout);
	fflush (stderr);

	vfprintf (stderr, fmt, args);
	fflush (stderr);
    }
}
