.\" $NCDId: @(#)AuGrNEvt.man,v 1.1 1994/09/27 00:29:31 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuGrabNotifyEvent.man,v 1.3 1994/08/11 17:59:14 sking Exp $
.TH AuGrabNotifyEvent 3 "1.2" "audiolib - events"
.SH \fBName\fP
\fBAuGrabNotifyEvent\fP \- grab notify event structure
.SH \fBStructures\fP
#include <audio/audiolib.h>
.sp 1
typedef union _AuEvent
.br
{
.br
    . . .
.br
    \fBAuGrabNotifyEvent\fP \fIaugrabnotify\fP;
.br
    . . .
.br
}\fBAuEvent\fP;
.sp 1
typedef struct _AuGrabNotifyEvent
.br
{
.br
    int \fItype\fP;
.br
    \fBAuUint32\fP \fIserial\fP;
.br
    \fBAuBool\fP \fIsend_event\fP;
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuTime\fP \fItime\fP;
.br
    \fBAuID\fP \fIid\fP;
.br
    unsigned char \fIkind\fP;
.br
    unsigned char \fIpad1\fP;
.br
    unsigned short \fIpad2\fP;
.br
    \fBAuID\fP \fIclient\fP;
.br
}\fBAuGrabNotifyEvent\fP;
.SH \fBMembers\fP
.IP \fItype\fP 1i
The event type.
GrabNotify events are type \fBAuEventTypeGrabNotify\fP.
.IP \fIserial\fP 1i
The serial ID of the event expanded from the 16 bit value sent by the server.
.IP \fIsend_event\fP 1i
\fBAuTrue\fP if the event came from a \fBSendEvent\fP protocol request.
.IP \fIserver\fP 1i
The connection to the audio server that the event was read from.
.IP \fItime\fP 1i
The server time in milliseconds when the event was generated.
.IP \fIid\fP 1i
The ID of the component grabbed.
.IP \fIkind\fP 1i
Either \fBAuGrabNotifyKindRequested\fP or \fBAuGrabNotifyKindReleased\fP.
.IP \fIpad1\fP 1i
.IP \fIpad2\fP 1i
.IP \fIclient\fP 1i
The client making the grab.
.SH \fBDescription\fP
GrabNotify events are sent to client applications to notify them that a component has been grabbed or released.
.SH \fBNotes\fP
\fBNot implemented\fP.
So this is all just speculation.
.SH \fBSee Also\fP
\fBAuAnyEvent\fP,
\fBAuElementNotifyEvent\fP,
\fBAuErrorEvent\fP,
\fBAuMonitorNotifyEvent\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
