.\" $NCDId: @(#)AuMElExC.man,v 1.1 1994/09/27 00:31:26 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuMakeElementExportClient.man,v 1.3 1994/08/11 17:59:14 sking Exp $
.TH AuMakeElementExportClient 3 "1.2" "audiolib - element initialization"
.SH \fBName\fP
\fBAuMakeElementExportClient\fP \- initialize an ExportClient element
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
\fBAuMakeElementExportClient\fP(\fIelement\fP, \fIinput\fP, \fIsample_rate\fP, \fIformat\fP, \fInum_tracks\fP, \fIdiscard\fP, \fImax_samples\fP, \fIhigh_water_mark\fP, \fInum_actions\fP, \fIactions\fP)
.br
    \fBAuElement\fP *\fIelement\fP; /* \fBRETURN\fP */
.br
    unsigned short \fIinput\fP;
.br
    unsigned short \fIsample_rate\fP;
.br
    unsigned char \fIformat\fP;
.br
    unsigned char \fInum_tracks\fP;
.br
    unsigned char \fIdiscard\fP;
.br
    \fBAuUint32\fP \fImax_samples\fP;
.br
    \fBAuUint32\fP \fIhigh_water_mark\fP;
.br
    int \fInum_actions\fP;
.br
    \fBAuElementAction\fP *\fIactions\fP;
.SH \fBArguments\fP
.IP \fIelement\fP 1i
Returns the initialized element.
.IP \fIinput\fP 1i
Specifies the index of the element to supply the audio data to this element.
.IP \fIsample_rate\fP 1i
Specifies the sample rate of the audio data.
.IP \fIformat\fP 1i
Specifies the format of the audio data.
Currently, the following formats are defined: \fBAuFormatULAW8\fP, \fBAuFormatLinearUnsigned8\fP, \fBAuFormatLinearSigned8\fP, \fBAuFormatLinearSigned16MSB\fP, \fBAuFormatLinearUnsigned16MSB\fP, \fBAuFormatSignedLinear16LSB\fP, and \fBAuFormatLinearUnsigned16LSB\fP.
.IP \fInum_tracks\fP 1i
Specifies the number of tracks in the audio data.
.IP \fIdiscard\fP 1i
Specifies if the flow should pause initially.
Normally \fBAuTrue\fP.
.IP \fImax_samples\fP 1i
Specifies the maximum number of samples to send to the client in a single write.
Ignored for "trivial" flows.
.IP \fIhigh_water_mark\fP 1i
Specifies when to tell the client application to read the audio data from the server.
When this number of samples is reached in the buffer, an ElementNotify event with \fIkind\fP set to \fBAuElementNotifyKindHighWater\fP will be sent to the client application.
.IP \fInum_actions\fP 1i
Specifies the number of actions in \fIactions\fP.
.IP \fIactions\fP 1i
Specifies the list of actions to associate with this element.
Entries in this list can be initialized with \fBAuMakeChangeStateAction\fP, \fBAuMakeSendNotifyAction\fP, and \fBAuMakeNoopAction\fP.
May be NULL.
.SH \fBDescription\fP
\fBAuMakeElementExportClient\fP sets the \fItype\fP member of \fIelement\fP to \fBAuElementTypeExportClient\fP and initializes the \fIexportclient\fP member of \fIelement\fP with the remaining arguments.
.LP
\fBAuMakeElementExportClient\fP is implemented as a macro.
.SH \fBSee Also\fP
\fBAuElementNotifyEvent\fP,
\fBAuMakeElementAddConstant\fP,
\fBAuMakeElementBundle\fP,
\fBAuMakeElementExportBucket\fP,
\fBAuMakeElementExportDevice\fP,
\fBAuMakeElementExportMonitor\fP,
\fBAuMakeElementImportBucket\fP,
\fBAuMakeElementImportClient\fP,
\fBAuMakeElementImportDevice\fP,
\fBAuMakeElementImportWaveForm\fP,
\fBAuMakeElementMultiplyConstant\fP,
\fBAuMakeElementSum\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
