#include "FvwmIconMan.h"
#include "readconfig.h"

#ifdef COMPILE_STANDALONE
#include "module.h"
#else
#include "../../fvwm/module.h"
#endif

static int fd_width;
static FILE *console = NULL;
static char *VERSION = "0.5";

char *copy_string (char **target, char *src)
{
  int len = strlen (src);

  if (*target)
    Free (*target);
  
  *target = (char *)safemalloc ((len + 1) * sizeof (char));
  strcpy (*target, src);
  return *target;
}

#ifdef TRACE_MEMUSE

long MemUsed = 0;

void Free (void *p)
{
  struct malloc_header *head = (struct malloc_header *)p;

  if (p != NULL) {
    head--;
    if (head->magic != MALLOC_MAGIC) {
      fprintf (stderr, "Corrupted memory found in Free\n");
      return;
    }
    if (head->len > MemUsed) {
      fprintf (stderr, "Free block too big\n");
      return;
    }
    MemUsed -= head->len;
    free (head);
  }
}

void PrintMemuse (void)
{
  ConsoleDebug ("Memory used: %d\n", MemUsed);
}
    
#else

void Free (void *p)
{
  if (p != NULL)
    free (p);
}

void PrintMemuse (void)
{
}

#endif

int OpenConsole()
{
#ifdef OUTPUT_FILE
  if ((console=fopen(OUTPUT_FILE, "w"))==NULL) {
    fprintf(stderr,"%s: cannot open %s\n", Module, OUTPUT_FILE);
    return 0;
  }
#endif
  return 1;
}

void ShutMeDown (int flag)
{
  ConsoleDebug ("Bye Bye\n");
  exit (flag);
}

void ConsoleMessage(char *fmt, ...)
{
  va_list args;
  FILE *filep;

  if (console==NULL) 
    filep=stderr;
  else 
    filep=console;
  
  fprintf (filep, "FvwmIconMan: ");
  va_start(args,fmt);
  vfprintf(filep,fmt,args);
  va_end(args);
}

#if defined(PRINT_DEBUG) || !defined(__GNUC__)
void ConsoleDebug (char *fmt, ...) {
#ifdef PRINT_DEBUG
  va_list args;
  FILE *filep;
  if (console==NULL) 
    filep=stderr;
  else 
    filep=console;
  va_start(args,fmt);
  vfprintf(filep,fmt,args);
  va_end(args);
#endif
}
#endif

void DeadPipe (int nothing)
{
  ConsoleDebug ("Bye Bye\n");
  ShutMeDown (0);
}

void SendFvwmPipe (char *message,unsigned long window)
{
  char *hold,*temp,*temp_msg;
  hold=message;

  while(1) {
    temp=strchr(hold,',');
    if (temp!=NULL) {
      temp_msg= (char *)safemalloc(temp-hold+1);
      strncpy(temp_msg,hold,(temp-hold));
      temp_msg[(temp-hold)]='\0';
      hold=temp+1;
    } else temp_msg=hold;

    SendText(Fvwm_fd, temp_msg, window);

    if(temp_msg!=hold) Free(temp_msg);
    else break;
  }
}

static void main_loop (void)
{
  fd_set readset;
  struct timeval tv;

  while(1) {
    FD_ZERO( &readset);
    FD_SET (Fvwm_fd[1],&readset);
    FD_SET (x_fd,&readset);
    tv.tv_sec=0;
    tv.tv_usec=0;
    if (!select(fd_width,&readset,NULL,NULL,&tv)) {
      FD_ZERO (&readset);
      FD_SET (Fvwm_fd[1],&readset);
      FD_SET (x_fd, &readset);
      select(fd_width,&readset,NULL,NULL,NULL);
    }

    if (FD_ISSET (x_fd, &readset) || XPending (theDisplay)) {
      xevent_loop();
    }
    if (FD_ISSET(Fvwm_fd[1],&readset)) {
      ReadFvwmPipe();
    }
  }
}
int main (int argc, char **argv)
{
  char *temp, *s;

  OpenConsole();
  init_globals();
  init_winlists();
  
  temp = argv[0];
  s = strrchr (argv[0], '/');
  if (s != NULL)
    temp = s + 1;

  if((argc != 6) && (argc != 7)) {
    fprintf(stderr,"%s Version %s should only be executed by fvwm!\n",Module,
      VERSION);
    ShutMeDown (1);
  }

  Fvwm_fd[0] = atoi(argv[1]);
  Fvwm_fd[1] = atoi(argv[2]);
  init_display();
  init_boxes();
  
  signal (SIGPIPE, DeadPipe);  

  read_in_resources (argv[3]);
  
  assert (globals.managers);
  fd_width = sysconf(_SC_OPEN_MAX);

  SetMessageMask(Fvwm_fd,M_CONFIGURE_WINDOW | M_RES_CLASS | M_RES_NAME |
                 M_ADD_WINDOW | M_DESTROY_WINDOW | M_ICON_NAME |
                 M_DEICONIFY | M_ICONIFY | M_END_WINDOWLIST |
                 M_NEW_DESK | M_NEW_PAGE | M_FOCUS_CHANGE | M_WINDOW_NAME |
		 M_STRING);

  SendInfo (Fvwm_fd, "Send_WindowList", 0);
  
  main_loop();

  ConsoleMessage ("Shouldn't be here\n");
  
  return 0;
}
