/*--------------------------------*-C-*---------------------------------*
 * File:	main.c
 *
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 * You can do what you like with this source code as long as
 * you don't try to make money out of it and you include an
 * unaltered copy of this message (including the copyright).
 *
 * This module has been heavily modified by R. Nation
 * <nation@rocket.sanders.lockheed.com>
 * No additional restrictions are applied
 *
 * Additional modifications by Garrett D'Amore <garrett@netcom.com>
 * No additional restrictions are applied.
 *
 * Extensive modifications by mj olesen <olesen@me.QueensU.CA>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#include "main.h"

#include <X11/cursorfont.h>
#include <X11/keysym.h>

#include "command.h"
#include "debug.h"
#include "graphics.h"
#include "sbar.h"
#include "screen.h"
#include "xdefaults.h"
#include "defaults.h"

/*----------------------------------------------------------------------*
 * extern functions referenced
 */
#ifdef DISPLAY_IS_IP
extern char * network_display (const char * display);
#endif

/*----------------------------------------------------------------------*
 * extern variables referenced
 */
/*----------------------------------------------------------------------*
 * extern variables declared here
 */
TermWin_t	TermWin;
Display		*Xdisplay;	/* display */

const char *rs_color [NCOLORS + NCURSOR + NBOLDULINE + NSCROLLCOLORS];
Pixel PixColors [NCOLORS + NCURSOR + NBOLDULINE + NSCROLLCOLORS];

unsigned long Options = (Opt_scrollBar);

const char *display_name = NULL;
const char *rs_name = NULL;	/* client instance (resource name) */

#ifdef USE_BOLDFONT
const char * rs_boldFont = NULL;
#endif
const char *rs_font [NFONTS];
#ifdef KANJI
const char *rs_kfont [NFONTS];
#endif
KeySym ks_bigfont = KS_BIGFONT;
KeySym ks_smallfont = KS_SMALLFONT;

#ifdef PRINTPIPE
const char *rs_print_pipe = NULL;
KeySym ks_printscreen = KS_PRINTSCREEN;
#endif

#ifdef PASTE_KEY
KeySym ks_paste = KS_PASTE;
#endif

#ifndef NO_MULTIPLE_CLICK
const char *rs_cutchars = NULL;
#endif

/*----------------------------------------------------------------------*
 * local variables
 */
static Cursor TermWin_cursor;	/* cursor for vt window */

static XSizeHints szHint = {
   PMinSize | PResizeInc | PBaseSize | PWinGravity,
   0, 0, 80, 24,	/* x, y, width, height */
   1, 1,		/* Min width, height */
   0, 0,		/* Max width, height - unused*/
   1, 1,		/* increments: width, height */
   {1, 1},		/* increments: x, y */
   {0, 0},		/* Aspect ratio - unused */
   0, 0,		/* base size: width, height */
   NorthWestGravity	/* gravity */
};

static const char *def_colorName [] = {
   "Black", "White",		/* fg/bg */
#ifdef NO_BRIGHTCOLOR
     "Black",			/* 0: black		(#000000) */
     "Red",			/* 1: red		(#FF0000) */
     "Green",			/* 2: green		(#00FF00) */
     "Yellow",			/* 3: yellow		(#FFFF00) */
     "Blue",			/* 4: blue		(#0000FF) */
     "Magenta",			/* 5: magenta		(#FF00FF) */
     "Cyan",			/* 6: cyan		(#00FFFF) */
     "White",			/* 7: white		(#FFFFFF) */
#else	/* NO_BRIGHTCOLOR */
     /* low-intensity colors */
     "Black",			/* 0: black		(#000000) */
     "Red3",			/* 1: red		(#CD0000) */
     "Green3",			/* 2: green		(#00CD00) */
     "Yellow3",			/* 3: yellow		(#CDCD00) */
     "Blue3",			/* 4: blue		(#0000CD) */
     "Magenta3",		/* 5: magenta		(#CD00CD) */
     "Cyan3",			/* 6: cyan		(#00CDCD) */
     "AntiqueWhite",		/* 7: white		(#FAEBD7) */
     /* high-intensity colors */
     "Grey25",			/* 10: bright black	(#404040) */
     "Red",			/* 11: bright red	(#FF0000) */
     "Green",			/* 12: bright green	(#00FF00) */
     "Yellow",			/* 13: bright yellow	(#FFFF00) */
     "Blue",			/* 14: bright blue	(#0000FF) */
     "Magenta",			/* 15: bright magenta	(#FF00FF) */
     "Cyan",			/* 16: bright cyan	(#00FFFF) */
     "White",			/* 17: bright white	(#FFFFFF) */
#endif	/* NO_BRIGHTCOLOR */
#ifndef NO_CURSORCOLOR
     NULL, NULL,
#endif	/* NO_CURSORCOLOR */
#ifndef NO_BOLDUNDERLINE
     NULL, NULL,
#endif	/* NO_BOLDUNDERLINE */
     "#B2B2B2"			/* scrollColor: match Netscape color */
};

#ifdef KANJI
/* Kanji font names, roman fonts sized to match */
static const char *def_kfontName [] = {
   KFONT0, KFONT1, KFONT2, KFONT3, KFONT4
};
#endif	/* KANJI */
static const char *def_fontName [] = {
   FONT0, FONT1, FONT2, FONT3, FONT4
};

#ifdef XTERM_SCROLLBAR
# define SB_BORDER	1
#else
# define SB_BORDER	0
# ifndef SCROLLBAR_BGFILL
#  undef SB_SHADOW
#  define SB_SHADOW 0
# endif
#endif

#define SB_FULLWIDTH	(SB_WIDTH + 2 * (SB_SHADOW + SB_BORDER))

/*----------------------------------------------------------------------*
 * local functions referenced
 */

/*----------------------------------------------------------------------*/
const char *
my_basename (const char * str)
{
   const char * base = strrchr (str, '/');
   return (base ? base + 1 : str);
}

static XErrorHandler
xerror_handler (Display *display, XErrorEvent *event)
{
   exit (EXIT_FAILURE);
   return 0;
}

static inline void
color_aliases (int idx)
{
   if (rs_color [idx] && isdigit (*rs_color [idx]))
     {
	int i = atoi (rs_color [idx]);
	if (i >= 8 && i <= 15)	/* bright colors */
	  {
	     i -= 8;
#ifndef NO_BRIGHTCOLOR
	     rs_color [idx] = rs_color [minBright + i];
	     return;
#endif
	  }
	if (i >= 0 && i <= 7)		/* normal colors */
	  rs_color [idx] = rs_color [minColor + i];
     }
}

/*
 * find if fg/bg matches any of the normal (low-intesity) colors
 */
#ifndef NO_BRIGHTCOLOR
static inline void
set_color_fgbg (void)
{
   unsigned int i;

   color_fgbg = SET_RSTYLE (RS_None, fgColor, bgColor);
   for (i = minColor; i <= maxColor; i++)
     {
	if (PixColors [fgColor] == PixColors [i]
# ifndef NO_BOLDUNDERLINE
	    && PixColors [fgColor] == PixColors [colorBD]
# endif	/* NO_BOLDUNDERLINE */
	    /* if we wanted boldFont to have precedence */
# if 0	/* ifdef USE_BOLDFONT */
	    && TermWin.boldFont == NULL
# endif	/* USE_BOLDFONT */
	    )
	  color_fgbg = SET_FGCOLOR (color_fgbg, i);
	if (PixColors [bgColor] == PixColors [i])
	  color_fgbg = SET_BGCOLOR (color_fgbg, i);
     }
}
#endif	/* NO_BRIGHTCOLOR */

/*
 * Open and map the window
 */
static void
Create_Windows (int argc, char * argv [])
{
   Cursor cursor;

   XClassHint classHint;
   XWMHints wmHint;
   int i, x, y, flags;
   unsigned int width, height;

   /*
    * grab colors before netscape does
    */
   for (i = 0;
	i < (Xdepth <= 2 ? 2 : (NCOLORS + NCURSOR + NBOLDULINE + NSCROLLCOLORS));
	i++)
     {
	const char * const color_msg = "can't load color \"%s\"";
	XColor xcol;

	if (!rs_color [i]) continue;

	if (!XParseColor (Xdisplay, Xcmap, rs_color [i], &xcol) ||
	    !XAllocColor (Xdisplay, Xcmap, &xcol))
	  {
	     print_error (color_msg, rs_color [i]);
	     rs_color [i] = def_colorName [i];
	     if (!rs_color [i]) continue;
	     if (!XParseColor (Xdisplay, Xcmap, rs_color [i], &xcol) ||
		 !XAllocColor (Xdisplay, Xcmap, &xcol))
	       {
		  print_error (color_msg, rs_color [i]);
		  switch (i) {
		   case fgColor:
		   case bgColor:
		     print_error ("aborting");	/* fatal: need bg/fg color */
		     exit (EXIT_FAILURE);
		     break;
#ifndef NO_CURSORCOLOR
		   case cursorColor:
		     xcol.pixel = PixColors [bgColor];
		     break;
		   case cursorColor2:
		     xcol.pixel = PixColors [fgColor];
		     break;
#endif	/* NO_CURSORCOLOR */
		   default:
		     xcol.pixel = PixColors [bgColor];	/* None */
		  }
	       }
	  }
	PixColors [i] = xcol.pixel;
     }

#ifndef NO_CURSORCOLOR
   if (Xdepth <= 2 || !rs_color [cursorColor])
     PixColors [cursorColor] = PixColors [bgColor];
   if (Xdepth <= 2 || !rs_color [cursorColor2])
     PixColors [cursorColor2] = PixColors [fgColor];
#endif	/* NO_CURSORCOLOR */

#ifndef NO_BOLDUNDERLINE
   if (Xdepth <= 2 || !rs_color [colorBD])
     PixColors [colorBD] = PixColors [fgColor];
   if (Xdepth <= 2 || !rs_color [colorUL])
     PixColors [colorUL] = PixColors [fgColor];
#endif	/* NO_BOLDUNDERLINE */

   szHint.base_width  = (2 * TermWin_internalBorder);
   szHint.base_height = (2 * TermWin_internalBorder);

   if (Options & Opt_scrollBar)
     szHint.base_width += SB_FULLWIDTH;

   flags = (rs_geometry ?
	    XParseGeometry (rs_geometry, &x, &y, &width, &height) : 0);

   if (flags & WidthValue)
     {
	szHint.width = width;
	szHint.flags |= USSize;
     }
   if (flags & HeightValue)
     {
	szHint.height = height;
	szHint.flags |= USSize;
     }

   TermWin.ncol = szHint.width;
   TermWin.nrow = szHint.height;

   change_font (0);

   if (flags & XValue)
     {
	if (flags & XNegative)
	  {
	     x += (DisplayWidth (Xdisplay, Xscreen)
		   - (szHint.width + TermWin_internalBorder));
	     szHint.win_gravity = NorthEastGravity;
	  }
	szHint.x = x;
	szHint.flags |= USPosition;
     }
   if (flags & YValue)
     {
	if (flags & YNegative)
	  {
	     y += (DisplayHeight (Xdisplay, Xscreen)
		   - (szHint.height + TermWin_internalBorder));
	     szHint.win_gravity = (szHint.win_gravity == NorthEastGravity ?
				   SouthEastGravity : SouthWestGravity);
	  }
	szHint.y = y;
	szHint.flags |= USPosition;
     }

   /* create parent - reverse video so we can see placement errors */
   TermWin.parent = XCreateSimpleWindow (Xdisplay,
					 DefaultRootWindow (Xdisplay),
					 szHint.x, szHint.y,
					 szHint.width, szHint.height,
 					 BORDERWIDTH,
					 PixColors [bgColor],
					 PixColors [fgColor]);

   xterm_seq (NEW_title, rs_title);
   xterm_seq (NEW_iconName, rs_iconName);
   /* ignore warning about discarded `const' */
   classHint.res_name  = rs_name;
   classHint.res_class = APL_CLASS;
   wmHint.input = True;
   wmHint.initial_state = (Options & Opt_iconic ? IconicState : NormalState);
   wmHint.flags = (InputHint | StateHint);

   XSetWMProperties (Xdisplay, TermWin.parent, NULL, NULL, argv, argc,
		     &szHint, &wmHint, &classHint);

   XSelectInput (Xdisplay, TermWin.parent,
		 (KeyPressMask|FocusChangeMask|
		  StructureNotifyMask|VisibilityChangeMask)
		 );

   if (Options & Opt_scrollBar)
     {
	sBar.beg = 0;
	sBar.end = szHint.height - 2 * (SB_SHADOW + SB_BORDER);

	sBar.parent = XCreateSimpleWindow (Xdisplay, TermWin.parent,
					   -SB_BORDER, -SB_BORDER,
					   SB_FULLWIDTH,
					   szHint.height,
					   SB_BORDER,
					   PixColors [fgColor],
					   PixColors [bgColor]);

	XSelectInput (Xdisplay, sBar.parent, ExposureMask);

	sBar.win = XCreateSimpleWindow (Xdisplay, sBar.parent,
					(SB_BORDER + SB_SHADOW),
					(SB_BORDER + SB_SHADOW),
					SB_WIDTH, sBar.end,
					0,
					PixColors [fgColor],
					PixColors [bgColor]);

	XSelectInput (Xdisplay, sBar.win,
		      (ExposureMask|ButtonPressMask|ButtonReleaseMask|
		       Button1MotionMask|Button2MotionMask|Button3MotionMask)
		      );

	/* cursor: Black-on-White */
	cursor = XCreateFontCursor (Xdisplay, XC_left_ptr);
	XDefineCursor (Xdisplay, sBar.win, cursor);

# ifndef XTERM_SCROLLBAR
	sBar.beg += SB_WIDTH;
	sBar.end -= SB_WIDTH;
# endif
	XMapWindow (Xdisplay, sBar.win);
	XMapWindow (Xdisplay, sBar.parent);
     }

   /* correct placement now, do size in resize_windows() */
# ifndef SCROLLBAR_RIGHT
   if (Options & Opt_scrollBar)
     x = SB_BORDER + SB_FULLWIDTH;
   else
#endif
     x = 0;

   TermWin.vt = XCreateSimpleWindow (Xdisplay, TermWin.parent,
				     x, 0,
				     szHint.width, szHint.height,
				     0,
				     PixColors [fgColor],
				     PixColors [bgColor]);
   XSelectInput (Xdisplay, TermWin.vt,
		 (ExposureMask|ButtonPressMask|ButtonReleaseMask|
		  Button1MotionMask|Button3MotionMask));

   TermWin_cursor = XCreateFontCursor (Xdisplay, XC_xterm);
   XDefineCursor (Xdisplay, TermWin.vt, TermWin_cursor);

   /* cursor: Black-on-White is standard, but this is more popular */
     {
	XColor fg, bg;
	fg.pixel = PixColors [fgColor]; XQueryColor (Xdisplay, Xcmap, &fg);
	bg.pixel = PixColors [bgColor]; XQueryColor (Xdisplay, Xcmap, &bg);
	XRecolorCursor (Xdisplay, TermWin_cursor, &fg, &bg);
     }

   XMapWindow (Xdisplay, TermWin.vt);
   XMapWindow (Xdisplay, TermWin.parent);

   /* Create the graphics context */
     {
	XGCValues gcvalue;
	gcvalue.font = TermWin.font->fid;
	gcvalue.foreground = PixColors [fgColor];
	gcvalue.background = PixColors [bgColor];
	TermWin.gc = XCreateGC (Xdisplay, TermWin.vt,
				GCForeground|GCBackground|GCFont,
				&gcvalue);
     }
}

/*
 * Redraw window
 */
static void
resize_windows (int width, int height)
{
   int old_width  = TermWin.width;
   int old_height = TermWin.height;

   TermWin.width  = TermWin.ncol * TermWin.fwidth;
   TermWin.height = TermWin.nrow * TermWin.fheight;

   if (Options & Opt_scrollBar)
     {
	sBar.end = height - 2 * (SB_SHADOW + SB_BORDER);
# ifndef XTERM_SCROLLBAR
	sBar.end -= SB_WIDTH;
# endif

	XResizeWindow (Xdisplay, sBar.parent,
		       SB_FULLWIDTH, height);

	XResizeWindow (Xdisplay, sBar.win,
		       SB_WIDTH, (height - 2 * (SB_SHADOW + SB_BORDER)));

	width -= SB_FULLWIDTH;
#ifdef SCROLLBAR_RIGHT
	width -= SB_BORDER;
	XMoveWindow (Xdisplay, sBar.parent, width, -SB_BORDER);
#endif
     }

   XResizeWindow (Xdisplay, TermWin.vt, width, height + 1);
   if (old_width)
     Gr_Resize (old_width, old_height);
   XClearWindow (Xdisplay, TermWin.vt);
   XSync (Xdisplay, 0);
}

/*
 * Redraw window after exposure or size change
 */
static void
resize_window1 (unsigned int width, unsigned int height)
{
   static int first_time = 1;
   int new_ncol = (width  - szHint.base_width)  / TermWin.fwidth;
   int new_nrow = (height - szHint.base_height) / TermWin.fheight;

   if (first_time ||
       (new_ncol != TermWin.ncol) ||
       (new_nrow != TermWin.nrow))
     {
	int curr_screen = -1;

	/* scr_reset only works on the primary screen */
	if (!first_time)	/* this is not the first time thru */
	  {
	     selection_clear ();
	     curr_screen = scr_change_screen (PRIMARY);
	  }

	TermWin.ncol = new_ncol;
	TermWin.nrow = new_nrow;

	resize_windows (width, height);
	scr_reset ();

	if (curr_screen >= 0)	/* this is not the first time thru */
	  scr_change_screen (curr_screen);
	first_time = 0;
     }
}

/*
 * good for toggling 80/132 columns
 */
void
set_width (unsigned int width)
{
   unsigned int height = TermWin.nrow;

   if (width != TermWin.ncol)
     {
	width  = szHint.base_width  + width  * TermWin.fwidth;
	height = szHint.base_height + height * TermWin.fheight;

	XResizeWindow (Xdisplay, TermWin.parent, width, height);
	resize_window1 (width, height);
     }
}

/*
 * Redraw window after exposure or size change
 */
void
resize_window (void)
{
   Window root;
   XEvent dummy;
   int x, y;
   unsigned int border, depth, width, height;

   while (XCheckTypedWindowEvent (Xdisplay, TermWin.parent,
				  ConfigureNotify, &dummy));
   XGetGeometry (Xdisplay, TermWin.parent,
		 &root, &x, &y, &width, &height, &border, &depth);

   resize_window1 (width, height);
}

/*
 * Print an error message
 */
void
print_error (const char *fmt, ...)
{
   va_list arg_ptr;

   va_start (arg_ptr, fmt);
   fprintf (stderr, "%s: ", rs_name);
   vfprintf (stderr, fmt, arg_ptr);
   fprintf (stderr, "\n");
   va_end (arg_ptr);
}

#ifdef SMART_WINDOW_TITLE
static void
set_title (const char *str)
{
   char * name;
   if (XFetchName (Xdisplay, TermWin.parent, &name)) name = NULL;
   if (name == NULL || strcmp (name, str))
     XStoreName (Xdisplay, TermWin.parent, str);
   if (name) XFree (name);
}
#else
# define set_title(str)  XStoreName (Xdisplay, TermWin.parent, str)
#endif

#ifdef SMART_WINDOW_TITLE
static void
set_iconName (const char * str)
{
   char * name;
   if (XGetIconName (Xdisplay, TermWin.parent, &name)) name = NULL;
   if (name == NULL || strcmp (name, str))
     XSetIconName (Xdisplay, TermWin.parent, str);
   if (name) XFree (name);
}
#else
# define set_iconName(str) XSetIconName (Xdisplay, TermWin.parent, str)
#endif

#ifdef XTERM_COLOR_CHANGES
static void
change_window_color (int idx, const char * color)
{
   const char * const color_msg = "can't load color \"%s\"";
   XColor xcol;
   int i;

   /* handle color aliases */
   if (color && isdigit (*color))
     {
	i = atoi (color);
	if (i >= 8 && i <= 15)	/* bright colors */
	  {
	     i -= 8;
# ifndef NO_BRIGHTCOLOR
	     PixColors [idx] = PixColors [minBright + i];
	     goto Done;
# endif
	  }
	if (i >= 0 && i <= 7)	/* normal colors */
	  {
	     PixColors [idx] = PixColors [minColor + i];
	     goto Done;
	  }
     }

   if (!XParseColor (Xdisplay, Xcmap, color, &xcol) ||
       !XAllocColor (Xdisplay, Xcmap, &xcol))
     {
	print_error (color_msg, color);
	return;
     }

   /* XStoreColor (Xdisplay, Xcmap, XColor*); */

   /*
    * FIXME: should free colors here, but no idea how to do it so instead,
    * so just keep gobbling up the colormap
    */
# if 0
   for (i = blackColor; i <= whiteColor; i++)
     if (PixColors [idx] == PixColors [i])
       break;
   if (i > whiteColor)
     {
	/* fprintf (stderr, "XFreeColors: PixColors [%d] = %lu\n", idx, PixColors [idx]); */
	XFreeColors (Xdisplay, Xcmap, (PixColors + idx), 1,
		     DisplayPlanes(Xdisplay, Xscreen));
     }
# endif

   PixColors [idx] = xcol.pixel;

   /* XSetWindowAttributes xwattr; */
   /* Cursor cursor; */
   Done:
   if (idx == bgColor)
     XSetWindowBackground (Xdisplay, TermWin.vt, PixColors [bgColor]);

   /* handle colorBD, scrollbar background, etc. */

# ifndef NO_BRIGHTCOLOR
   set_color_fgbg ();
# endif
     {
	XColor fg, bg;
	fg.pixel = PixColors [fgColor]; XQueryColor (Xdisplay, Xcmap, &fg);
	bg.pixel = PixColors [bgColor]; XQueryColor (Xdisplay, Xcmap, &bg);
	XRecolorCursor (Xdisplay, TermWin_cursor, &fg, &bg);
     }
   /* the only reasonable way to enforce a clean update */
   scr_poweron ();
}
#else
# define change_window_color(idx,color) ((void)0)
#endif	/* XTERM_COLOR_CHANGES */

/*
 * change title/icon name
 */
void
xterm_seq (int op, const char *str)
{
   if (str && *str)
     switch (op) {
      case NEW_name:	set_title (str);	/* drop */
      case NEW_iconName: set_iconName (str);	break;
      case NEW_title:	set_title (str);	break;
      case RestoreFG:	change_window_color (fgColor, str);	break;
      case RestoreBG:	change_window_color (bgColor, str);	break;
     }
}

/*
 * Switch to a new font
 *
 * dirn = 0	- initialize
 * dirn = UP	- switch to bigger font
 * dirn = DOWN	- switch to smaller font
 */

void
change_font (int dirn)
{
#ifdef USE_BOLDFONT
   static XFontStruct * boldFont = NULL;
#endif
   static int fnum = FONT0_IDX;		/* logical font number */
   int idx;				/* actual index into rs_font[] */

   switch (dirn) {
    case 0:			/* initial load font */
      fnum = FONT0_IDX;
      break;
    case UP:
      if (++fnum >= NFONTS)
	{
	   fnum = (NFONTS - 1);
	   return;
	}
      break;

    case DOWN:
      if (--fnum < 0)
	{
	   fnum = 0;
	   return;
	}
      break;
   }

   idx = fnum;
   /* re-position around the normal font */
   if (idx == FONT0_IDX) idx = 0; else if (idx < FONT0_IDX) idx++;

     {
	const char * const font_msg = "can't load font \"%s\"";
	XFontStruct * xfont;

#ifdef KANJI
	if (dirn)
	  XFreeFont (Xdisplay, TermWin.kanji);
	xfont = XLoadQueryFont (Xdisplay, rs_kfont [idx]);
	if (!xfont)
	  {
	     print_error (font_msg, rs_kfont [idx]);
	     /* provide substitute */
	     rs_kfont [idx] = (dirn ? rs_kfont [0] : "k14");
	     xfont = XLoadQueryFont (Xdisplay, rs_kfont [idx]);
	     if (!dirn && !xfont)
	       {
		  print_error (font_msg, rs_kfont [idx]);
		  goto Abort;
	       }
	  }
	TermWin.kanji = xfont;
#endif	/* KANJI */
	if (dirn)
	  XFreeFont (Xdisplay, TermWin.font);

	xfont = XLoadQueryFont (Xdisplay, rs_font [idx]);
	if (!xfont)
	  {
	     print_error (font_msg, rs_font [idx]);
	     /* provide substitute */
	     rs_font [idx] = (dirn ? rs_font [0] : "fixed");
	     xfont = XLoadQueryFont (Xdisplay, rs_font [idx]);
	     if (!dirn && !xfont)
	       {
		  print_error (font_msg, rs_font [idx]);
		  goto Abort;
	       }
	  }
	TermWin.font = xfont;

#ifdef USE_BOLDFONT
	if (!dirn && rs_boldFont != NULL)
	  {
	     xfont = XLoadQueryFont (Xdisplay, rs_boldFont);
	     if (!xfont)
	       print_error (font_msg, rs_boldFont);
	     else
	       boldFont = xfont;
	  }
#endif
     }

   /* alter existing GC */
   if (dirn)
     XSetFont (Xdisplay, TermWin.gc, TermWin.font->fid);

   /* set the sizes */
     {
	int fw = XTextWidth (TermWin.font, "MMMMMMMMMM", 10) / 10;
	int fh = TermWin.font->ascent + TermWin.font->descent;

	/* not the first time thru and sizes haven't changed */
	if (TermWin.fwidth == fw && TermWin.fheight == fh)
	  return;

	szHint.width_inc  = TermWin.fwidth  = fw;
	szHint.height_inc = TermWin.fheight = fh;
     }

   /* check that size of boldFont is okay */
#ifdef USE_BOLDFONT
   if (boldFont != NULL &&
       TermWin.fwidth == (XTextWidth (boldFont, "MMMMMMMMMM", 10) / 10) &&
       TermWin.fheight == (boldFont->ascent + boldFont->descent))
     TermWin.boldFont = boldFont;
   else
     TermWin.boldFont = NULL;
#endif	/* USE_BOLDFONT */

#ifndef NO_BRIGHTCOLOR
   set_color_fgbg ();
#endif	/* NO_BRIGHTCOLOR */

   TermWin.width  = TermWin.ncol * TermWin.fwidth;
   TermWin.height = TermWin.nrow * TermWin.fheight;

   szHint.min_width  = szHint.base_width  + szHint.width_inc;
   szHint.min_height = szHint.base_height + szHint.height_inc;

   szHint.width  = szHint.base_width  + TermWin.width;
   szHint.height = szHint.base_height + TermWin.height;

   szHint.flags = PMinSize|PResizeInc|PBaseSize|PWinGravity;

   if (!dirn)
     return;

   XSetWMNormalHints (Xdisplay, TermWin.parent, &szHint);
   XResizeWindow (Xdisplay, TermWin.parent, szHint.width, szHint.height);

   resize_windows (szHint.width, szHint.height);

   return;
   Abort:
   print_error ("aborting");	/* fatal problem */
   exit (EXIT_FAILURE);
}

int
main (int argc, char * argv [])
{
   int i;
   char * val, **cmd_argv = NULL;
   /* "WINDOWID=\0" = 10 chars, UINT_MAX = 10 chars */
   static char windowid_string [20], * display_string;

   for (i = 0; i < argc; i++)
     {
	if (!strcmp (argv [i], "-e"))
	  {
	     argc = i;
	     argv [argc] = NULL;
	     if (argv [argc + 1] != NULL)
	       {
		  cmd_argv = (argv + argc + 1);
		  if (cmd_argv [0] != NULL)
		    rs_iconName = rs_title = my_basename (cmd_argv [0]);
	       }
	     break;
	  }
     }

   rs_name = my_basename (argv [0]);

   /*
    * Open display, get options/resources and create the window
    */
   if ((display_name = getenv ("DISPLAY")) == NULL)
     display_name = ":0";

   get_options (argc, argv);

   Xdisplay = XOpenDisplay (display_name);
   if (!Xdisplay)
     {
	print_error ("can't open display %s", display_name);
	exit (EXIT_FAILURE);
     }
   extract_resources (Xdisplay, rs_name);

   /*
    * set any defaults not already set
    */
   if (!rs_title) rs_title = rs_name;
   if (!rs_iconName) rs_iconName = rs_name;
   if (!rs_saveLines || (TermWin.saveLines = atoi (rs_saveLines)) < 0)
     TermWin.saveLines = SAVELINES;

#ifdef PRINTPIPE
   if (!rs_print_pipe) rs_print_pipe = PRINTPIPE;
#endif
#ifndef NO_MULTIPLE_CLICK
   if (!rs_cutchars) rs_cutchars = CUTCHARS;
#endif

#ifdef USE_BOLDFONT
   if (rs_font [0] == NULL && rs_boldFont != NULL)
     {
	rs_font [0] = rs_boldFont;
	rs_boldFont = NULL;
     }
#endif
   for (i = 0; i < NFONTS; i++)
     {
	if (!rs_font [i])  rs_font [i]  = def_fontName [i];
#ifdef KANJI
	if (!rs_kfont [i]) rs_kfont [i] = def_kfontName [i];
#endif
     }

#ifdef XTERM_REVERSE_VIDEO
   /* this is how xterm implements reverseVideo */
   if (Options & Opt_reverseVideo)
     {
	if (!rs_color [fgColor]) rs_color [fgColor] = def_colorName [bgColor];
	if (!rs_color [bgColor]) rs_color [bgColor] = def_colorName [fgColor];
     }
#endif

   for (i = 0; i < (NCOLORS + NCURSOR + NBOLDULINE + NSCROLLCOLORS); i++)
     if (!rs_color [i]) rs_color [i] = def_colorName [i];

#ifndef XTERM_REVERSE_VIDEO
   /* this is how we implement reverseVideo */
   if (Options & Opt_reverseVideo)
     {
	const char * name;
	/* swap foreground/background colors */

	name = rs_color [fgColor];
	rs_color [fgColor] = rs_color [bgColor];
	rs_color [bgColor] = name;

	name = def_colorName [fgColor];
	def_colorName [fgColor] = def_colorName [bgColor];
	def_colorName [bgColor] = name;
     }
#endif

   /* convenient aliases for setting fg/bg to colors */
   color_aliases (fgColor);
   color_aliases (bgColor);
#ifndef NO_CURSORCOLOR
   color_aliases (cursorColor);
   color_aliases (cursorColor2);
#endif	/* NO_CURSORCOLOR */
#ifndef NO_BOLDUNDERLINE
   color_aliases (colorBD);
   color_aliases (colorUL);
#endif	/* NO_BOLDUNDERLINE */

   Create_Windows (argc, argv);
   scr_reset ();		/* initialize screen */
   Gr_reset ();

   sbar_init ();		/* initialize scrollbar */

#ifdef DEBUG_X
   XSynchronize (Xdisplay, True);
   XSetErrorHandler ((XErrorHandler)abort);
#else
   XSetErrorHandler ((XErrorHandler)xerror_handler);
#endif

#ifdef DISPLAY_IS_IP
   /* Fixup display_name for export over pty to any interested terminal
    * clients via "ESC[7n" (e.g. shells).  Note we use the pure IP number
    * (for the first non-loopback interface) that we get from
    * network_display().  This is more "name-resolution-portable", if you
    * will, and probably allows for faster x-client startup if your name
    * server is beyond a slow link or overloaded at client startup.  Of
    * course that only helps the shell's child processes, not us.
    *
    * Giving out the display_name also affords a potential security hole
    */
   val = display_name = network_display (display_name);
   if (val == NULL)
#endif	/* DISPLAY_IS_IP */
     val = XDisplayString (Xdisplay);
   if (display_name == NULL)
     display_name = val;	/* use broken `:0' value */

   i = strlen (val);
   display_string = MALLOC ((i+9)*sizeof(char), "display_string");

   sprintf (display_string, "DISPLAY=%s", val);
   sprintf (windowid_string, "WINDOWID=%u", (unsigned int)TermWin.parent);

   /* add entries to the environment:
    * @ DISPLAY:   in case we started with -display
    * @ WINDOWID:  X window id number of the window
    * @ COLORTERM: terminal sub-name and also indicates its color
    * @ TERM:      terminal name
    */
   putenv (display_string);
   putenv (windowid_string);
   if (Xdepth <= 2)
     {
	putenv ("COLORTERM=" COLORTERMENV "-mono");
	putenv ("TERM=" TERMENV);
     }
   else
     {
	putenv ("COLORTERM=" COLORTERMENV);
#ifdef DEFINE_XTERM_COLOR
	putenv ("TERM=" TERMENV "-color");
#else
	putenv ("TERM=" TERMENV);
#endif
     }

   init_command (cmd_argv);
   main_loop ();		/* main processing loop */
   return EXIT_SUCCESS;
}
/*----------------------- end-of-file (C source) -----------------------*/
