
#ifndef lint
static char sccsid[] = "@(#)cartoon.c	3.11h 96/09/30 xlockmore";

#endif

/*-
 * cartoon.c - A bouncing cartoon for xlock, the X Window System lockscreen.
 *
 * Copyright (c) 1988 by Sun Microsystems
 *
 * See xlock.c for copying information.
 *
 * Revision History:
 * 20-Sep-94: I done this file starting from the previous bounce.c
 *	      I draw the 8 cartoons like they are.
 *	      (patol@info.isbiel.ch)
 *        David monkeyed around with the cmap stuff to get it to work.
 * 2-Sep-93: xlock version (David Bagley bagleyd@source.asset.com)
 * 1986: Sun Microsystems
 */

/* original copyright
   ******************************************************************************
   Copyright 1988 by Sun Microsystems, Inc. Mountain View, CA.

   All Rights Reserved

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided that
   the above copyright notice appear in all copies and that both that copyright
   notice and this permission notice appear in supporting documentation, and that
   the names of Sun or MIT not be used in advertising or publicity pertaining to
   distribution of the software without specific prior written permission. Sun and 


   M.I.T. make no representations about the suitability of this software for any
   purpose. It is provided "as is" without any express or implied warranty.

   SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN
   NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES 


   OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
   IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
   **************************************************************************** */

#ifdef HAS_XPM

#include <X11/xpm.h>
#include <stdlib.h>
#include <stdio.h>
#include "xlock.h"
#include <math.h>

#include "pixmaps/calvin.xpm"
#include "pixmaps/calvin2.xpm"
#include "pixmaps/calvin3.xpm"
#include "pixmaps/gravity.xpm"
#include "pixmaps/dragon.xpm"
#include "pixmaps/marino2.xpm"
#include "pixmaps/calvin4.xpm"
#include "pixmaps/calvinf.xpm"
#include "pixmaps/hobbes.xpm"
#include "pixmaps/cal&hob.xpm"


#define MAX_STRENGTH 10
#define FRICTION 24
#define PENETRATION 0.1
#define SLIPAGE 20
#define TIME 10
#define VARIANCE 40

#define BETWEEN 10		/* number of image included */
#define ORIENTS 1
#define ORIENTCYCLE 1
#define CCW 1
#define CW (ORIENTS-1)
#define DIR(x)	(((x)>=0)?CCW:CW)
#define SIGN(x)	(((x)>=0)?1:-1)

ModeSpecOpt cartoon_opts =
{0, NULL, 0, NULL, NULL};

typedef struct {
	int         x, y, xlast, ylast;
	int         spincount, spindelay, spindir, orient, olast;
	int         vx, vy, vang;
	int         mass, size;
	unsigned long color;
} cartoonstruct;

typedef struct {
	int         width, height;
	int         ncartoons;
	cartoonstruct *cartoons;
	GC          draw_GC, erase_GC;
} bouncestruct;

static bouncestruct bounces[MAXSCREENS];

static void drawcartoons(ModeInfo * mi, cartoonstruct * cartoon);
static void movecartoon(ModeInfo * mi, cartoonstruct * cartoon);
static void XEraseImage(Display * display, Window win, GC gc, int x, int y, int xl, int yl, int xsize, int ysize, int xlsize, int ylsize);
static void changefigure(ModeInfo * mi);

static XpmAttributes attrib;
static XImage *logo[ORIENTS] =
{NULL};
static int  tbx[ORIENTS] =
{0};
static int  tby[ORIENTS] =
{0};
static int  choise = 0;

/* static Colormap cmap; */

void
init_cartoon(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	Window      window = MI_WINDOW(mi);
	bouncestruct *bp = &bounces[MI_SCREEN(mi)];
	XGCValues   gcv;
	int         i;

	changefigure(mi);

	bp->width = MI_WIN_WIDTH(mi);
	bp->height = MI_WIN_HEIGHT(mi);

	gcv.background = MI_WIN_BLACK_PIXEL(mi);
	bp->draw_GC = XCreateGC(display, window, GCForeground | GCBackground, &gcv);
	bp->erase_GC = XCreateGC(display, window, GCForeground | GCBackground, &gcv);
	bp->ncartoons = MI_BATCHCOUNT(mi);
	if (bp->ncartoons < 1)
		bp->ncartoons = 6;
	bp->ncartoons = 1;
	if (!bp->cartoons)
		bp->cartoons = (cartoonstruct *) malloc(bp->ncartoons * sizeof (cartoonstruct));
	i = 0;
	while (i < bp->ncartoons) {
		if (logo[0]->width > bp->width / 2 || logo[0]->height > bp->height / 2)
			bp->cartoons[i].size = 5;
		else
			bp->cartoons[i].size = MAX(logo[0]->width, logo[0]->height);
		bp->cartoons[i].vx = ((LRAND() & 1) ? -1 : 1) *
			(NRAND(MAX_STRENGTH) + 1);
		bp->cartoons[i].x = (bp->cartoons[i].vx >= 0) ?
			0 : bp->width - bp->cartoons[i].size;
		bp->cartoons[i].y = NRAND(bp->height / 2);
		/*if (i == collide(i)) { */
		if (MI_NPIXELS(mi) > 2) {
			bp->cartoons[i].color = NRAND(MI_NPIXELS(mi));
			if (bp->cartoons[i].color == MI_WIN_BLACK_PIXEL(mi))
				bp->cartoons[i].color = MI_WIN_WHITE_PIXEL(mi);
		} else
			bp->cartoons[i].color = MI_WIN_WHITE_PIXEL(mi);
		bp->cartoons[i].xlast = -1;
		bp->cartoons[i].ylast = 0;
		bp->cartoons[i].spincount = 1;
		bp->cartoons[i].spindelay = 1;
		bp->cartoons[i].vy = ((LRAND() & 1) ? -1 : 1) * (NRAND(MAX_STRENGTH));
		bp->cartoons[i].spindir = 0;
		bp->cartoons[i].vang = 0;
		bp->cartoons[i].orient = NRAND(ORIENTS);
		i++;
		/*} else
		   bp->ncartoons--; */
	}
	XClearWindow(display, window);
	XSetForeground(display, bp->erase_GC, MI_WIN_BLACK_PIXEL(mi));
#if 0
	{
		Screen     *scr;
		int         screen = MI_SCREEN(mi);

		scr = ScreenOfDisplay(display, screen);
		cmap = DefaultColormapOfScreen(scr);
		XSetWindowColormap(display, RootWindow(display, screen), cmap);
	}
#endif
}



void
draw_cartoon(ModeInfo * mi)
{
	bouncestruct *bp = &bounces[MI_SCREEN(mi)];
	int         i;

	for (i = 0; i < bp->ncartoons; i++) {
		drawcartoons(mi, &bp->cartoons[i]);
		movecartoon(mi, &bp->cartoons[i]);
	}

}

static void
drawcartoons(ModeInfo * mi, cartoonstruct * cartoon)
{
	bouncestruct *bp = &bounces[MI_SCREEN(mi)];

	if (logo[cartoon->orient] != NULL)
		XPutImage(MI_DISPLAY(mi), MI_WINDOW(mi), bp->draw_GC,
			  logo[cartoon->orient], 0, 0,
			  cartoon->x - tbx[cartoon->orient], cartoon->y - tby[cartoon->orient],
		logo[cartoon->orient]->width, logo[cartoon->orient]->height);
	if (cartoon->xlast != -1)
		if ((logo[cartoon->orient] != NULL) && (logo[cartoon->olast] != NULL))
			XEraseImage(MI_DISPLAY(mi), MI_WINDOW(mi), bp->erase_GC,
				    cartoon->x - tbx[cartoon->orient],
				    cartoon->y - tby[cartoon->orient],
				    cartoon->xlast, cartoon->ylast,
				    logo[cartoon->orient]->width, logo[cartoon->orient]->height,
				    logo[cartoon->olast]->width, logo[cartoon->olast]->height);

}

static void
movecartoon(ModeInfo * mi, cartoonstruct * cartoon)
{
	bouncestruct *bp = &bounces[MI_SCREEN(mi)];

	cartoon->xlast = cartoon->x - tbx[cartoon->orient];
	cartoon->ylast = cartoon->y - tby[cartoon->orient];
	cartoon->olast = cartoon->orient;

	cartoon->x += cartoon->vx;
	if (cartoon->x > (bp->width - cartoon->size)) {
		/* Bounce off the right edge */
		cartoon->x = 2 * (bp->width - cartoon->size) - cartoon->x;
		cartoon->vx = -cartoon->vx /*+ cartoon->vx / FRICTION */ ;
		/*cartoon->x = -cartoon->size; */
	} else if (cartoon->x < 0 /*-cartoon->size*/ ) {
		/* Bounce off the left edge */
		cartoon->x = -cartoon->x;
		cartoon->vx = -cartoon->vx /*+ cartoon->vx / FRICTION */ ;
		/*cartoon->x = bp->width; */
	}
	cartoon->vy++;
	cartoon->y += cartoon->vy;
	if (cartoon->y >= (bp->height + cartoon->size)) {
		/* Bounce off the bottom edge */
		/*cartoon->y = (bp->height - cartoon->size); */
		cartoon->vy = -cartoon->vy - 1 /*+ cartoon->vy / FRICTION */ ;
		cartoon->vx = NRAND(VARIANCE * 100) / 100 - VARIANCE / 2;
		/*if(cartoon->vx>20)cartoon->vx = 20;
		   if(cartoon->vx<-20)cartoon->vx = -20; */
		changefigure(mi);
	}
}

static void
changefigure(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	XImage     *dummy;
	int /*test, */ old;

	old = choise;
	while (old == choise)
		choise = NRAND(BETWEEN * 100) / 100;
#if 0
	attrib.valuemask = XpmReturnPixels | XpmColorKey | XpmColormap;
	attrib.color_key = XPM_COLOR;
	attrib.colormap = cmap;
	if (logo[0] != NULL) {
		XFreeColors(display, cmap, attrib.pixels, attrib.npixels, 0);
		XDestroyImage(logo[0]);
	}
#endif
	switch (choise) {
		case 0:
			/*if((test = */
			XpmCreateImageFromData(display, calvin, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"calvin error %d\n",test);
			   } */
			break;
		case 1:
			/*if((test = */
			XpmCreateImageFromData(display, calvin2, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"calvin2 error %d\n",test);
			   } */
			break;
		case 2:
			/*if((test = */
			XpmCreateImageFromData(display, calvin3, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"calvin3 error %d\n",test);
			   } */
			break;
		case 3:
			/*if((test = */
			XpmCreateImageFromData(display, gravity, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"gravity error %d\n",test);
			   } */
			break;
		case 4:
			/*if((test = */
			XpmCreateImageFromData(display, dragon, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"dragon error %d\n",test);
			   } */
			break;
		case 5:
			/*if((test = */
			XpmCreateImageFromData(display, marino2, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"dragon error %d\n",test);
			   } */
			break;
		case 6:
			/*if((test = */
			XpmCreateImageFromData(display, calvin4, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"dragon error %d\n",test);
			   } */
			break;
		case 7:
			/*if((test = */
			XpmCreateImageFromData(display, calvinf, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"dragon error %d\n",test);
			   } */
			break;
		case 8:
			/*if((test = */
			XpmCreateImageFromData(display, hobbes, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"dragon error %d\n",test);
			   } */
			break;
		case 9:
			/*if((test = */
			XpmCreateImageFromData(display, calhob, &logo[0], &dummy, &attrib);
			/*)!=0){
			   (void) fprintf(stderr,"dragon error %d\n",test);
			   } */
			break;
	}

}


/* This stops some flashing, could be more efficient */
static void
XEraseImage(Display * display, Window win, GC gc, int x, int y, int xl, int yl, int xsize, int ysize, int xlsize, int ylsize)
{

	if (y < 0)
		y = 0;
	if (x < 0)
		x = 0;
	if (xl < 0)
		xl = 0;
	if (yl < 0)
		yl = 0;

	if (xlsize - xsize + xl - x > 0)
		XFillRectangle(display, win, gc, x + xsize, yl, xlsize - xsize + xl - x, ylsize);
	if (ylsize - ysize + yl - y > 0)
		XFillRectangle(display, win, gc, xl, y + ysize, xlsize, ylsize - ysize + yl - y);
	if (y - yl > 0)
		XFillRectangle(display, win, gc, xl, yl, xlsize, y - yl);
	if (x - xl > 0)
		XFillRectangle(display, win, gc, xl, yl, x - xl, ylsize);
}

void
release_cartoon(ModeInfo * mi)
{
}

#endif
