;;- Machine description for the Hitachi SH.
;;  Copyright (C) 1993, 1994, 1995, 1996, 1997 Free Software Foundation, Inc.
;;  Contributed by Steve Chamberlain (sac@cygnus.com).
;;  Improved by Jim Wilson (wilson@cygnus.com).

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;; ??? Should prepend a * to all pattern names which are not used.
;; This will make the compiler smaller, and rebuilds after changes faster.

;; ??? Should be enhanced to include support for many more GNU superoptimizer
;; sequences.  Especially the sequences for arithmetic right shifts.

;; ??? Should check all DImode patterns for consistency and usefulness.

;; ??? The MAC.W and MAC.L instructions are not supported.  There is no
;; way to generate them.

;; ??? The cmp/str instruction is not supported.  Perhaps it can be used
;; for a str* inline function.

;; BSR is not generated by the compiler proper, but when relaxing, it
;; generates .uses pseudo-ops that allow linker relaxation to create
;; BSR.  This is actually implemented in bfd/{coff,elf32}-sh.c

;; Special constraints for SH machine description:
;;
;;    t -- T
;;    x -- mac
;;    l -- pr
;;    z -- r0
;;
;; Special formats used for outputting SH instructions:
;;
;;   %.  --  print a .s if insn needs delay slot
;;   %@  --  print rte/rts if is/isn't an interrupt function
;;   %#  --  output a nop if there is nothing to put in the delay slot
;;   %O  --  print a constant without the #
;;   %R  --  print the lsw reg of a double
;;   %S  --  print the msw reg of a double
;;   %T  --  print next word of a double REG or MEM
;;
;; Special predicates:
;;
;;  arith_operand          -- operand is valid source for arithmetic op
;;  arith_reg_operand      -- operand is valid register for arithmetic op
;;  general_movdst_operand -- operand is valid move destination
;;  general_movsrc_operand -- operand is valid move source
;;  logical_operand        -- operand is valid source for logical op
;; -------------------------------------------------------------------------
;; Attributes
;; -------------------------------------------------------------------------

;; Target CPU.

(define_attr "cpu"
 "sh1,sh2,sh3,sh3e"
  (const (symbol_ref "sh_cpu_attr")))

(define_attr "endian" "big,little"
 (const (if_then_else (symbol_ref "TARGET_LITTLE_ENDIAN")
		      (const_string "little") (const_string "big"))))

;; cbranch	conditional branch instructions
;; jump		unconditional jumps
;; arith	ordinary arithmetic
;; arith3	a compound insn that behaves similarly to a sequence of
;;		three insns of type arith
;; arith3b	like above, but might end with a redirected branch
;; load		from memory
;; load_si	Likewise, SImode variant for general register.
;; store	to memory
;; move		register to register
;; fmove	register to register, floating point
;; smpy		word precision integer multiply
;; dmpy		longword or doublelongword precision integer multiply
;; return	rts
;; pload	load of pr reg, which can't be put into delay slot of rts
;; pstore	store of pr reg, which can't be put into delay slot of jsr
;; pcload	pc relative load of constant value
;; pcload_si	Likewise, SImode variant for general register.
;; rte		return from exception
;; sfunc	special function call with known used registers
;; call		function call
;; fp		floating point
;; fdiv		floating point divide (or square root)
;; gp_fpul	move between general purpose register and fpul
;; nil		no-op move, will be deleted.

(define_attr "type"
 "cbranch,jump,jump_ind,arith,arith3,arith3b,dyn_shift,other,load,load_si,store,move,fmove,smpy,dmpy,return,pload,pstore,pcload,pcload_si,rte,sfunc,call,fp,fdiv,gp_fpul,nil"
  (const_string "other"))

; If a conditional branch destination is within -252..258 bytes away
; from the instruction it can be 2 bytes long.  Something in the
; range -4090..4100 bytes can be 6 bytes long.  All other conditional
; branches are initially assumed to be 16 bytes long.
; In machine_dependent_reorg, we split all branches that are longer than
; 2 bytes.

;; The maximum range used for SImode constant pool entrys is 1018.  A final
;; instruction can add 8 bytes while only being 4 bytes in size, thus we
;; can have a total of 1022 bytes in the pool.  Add 4 bytes for a branch
;; instruction around the pool table, 2 bytes of alignment before the table,
;; and 30 bytes of alignment after the table.  That gives a maximum total
;; pool size of 1058 bytes.
;; Worst case code/pool content size ratio is 1:2 (using asms).
;; Thus, in the worst case, there is one instruction in front of a maximum
;; sized pool, and then there are 1052 bytes of pool for every 508 bytes of
;; code.  For the last n bytes of code, there are 2n + 36 bytes of pool.
;; If we have a forward branch, the initial table will be put after the
;; unconditional branch.
;;
;; ??? We could do much better by keeping track of the actual pcloads within
;; the branch range and in the pcload range in front of the branch range.

;; ??? This looks ugly because genattrtab won't allow if_then_else or cond
;; inside an le.
(define_attr "short_cbranch_p" "no,yes"
  (cond [(ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 252)) (const_int 506))
	 (const_string "yes")
	 (ne (symbol_ref "NEXT_INSN (PREV_INSN (insn)) != insn") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 252)) (const_int 508))
	 (const_string "yes")
         ] (const_string "no")))

(define_attr "med_branch_p" "no,yes"
  (cond [(leu (plus (minus (match_dup 0) (pc)) (const_int 990))
	      (const_int 1988))
	 (const_string "yes")
	 (ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 4092))
	      (const_int 8186))
	 (const_string "yes")
	 ] (const_string "no")))

(define_attr "med_cbranch_p" "no,yes"
  (cond [(leu (plus (minus (match_dup 0) (pc)) (const_int 988))
	      (const_int 1986))
	 (const_string "yes")
	 (ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 4090))
	       (const_int 8184))
	 (const_string "yes")
	 ] (const_string "no")))

(define_attr "braf_branch_p" "no,yes"
  (cond [(ne (symbol_ref "! TARGET_SH2") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 10330))
	      (const_int 20660))
	 (const_string "yes")
	 (ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 32764))
	      (const_int 65530))
	 (const_string "yes")
	 ] (const_string "no")))

(define_attr "braf_cbranch_p" "no,yes"
  (cond [(ne (symbol_ref "! TARGET_SH2") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 10328))
	      (const_int 20658))
	 (const_string "yes")
	 (ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 32762))
	      (const_int 65528))
	 (const_string "yes")
	 ] (const_string "no")))

; An unconditional jump in the range -4092..4098 can be 2 bytes long.
; For wider ranges, we need a combination of a code and a data part.
; If we can get a scratch register for a long range jump, the code
; part can be 4 bytes long; otherwise, it must be 8 bytes long.
; If the jump is in the range -32764..32770, the data part can be 2 bytes
; long; otherwise, it must be 6 bytes long.

; All other instructions are two bytes long by default.

;; ??? This should use something like *branch_p (minus (match_dup 0) (pc)),
;; but getattrtab doesn't understand this.
(define_attr "length" ""
  (cond [(eq_attr "type" "cbranch")
	 (cond [(eq_attr "short_cbranch_p" "yes")
		(const_int 2)
		(eq_attr "med_cbranch_p" "yes")
		(const_int 6)
		(eq_attr "braf_cbranch_p" "yes")
		(const_int 12)
;; ??? using pc is not computed transitively.
		(ne (match_dup 0) (match_dup 0))
		(const_int 14)
		] (const_int 16))
	 (eq_attr "type" "jump")
	 (cond [(eq_attr "med_branch_p" "yes")
		(const_int 2)
		(and (eq (symbol_ref "GET_CODE (PREV_INSN (insn))")
			 (symbol_ref "INSN"))
		     (eq (symbol_ref "INSN_CODE (PREV_INSN (insn))")
			 (symbol_ref "code_for_indirect_jump_scratch")))
		(if_then_else (eq_attr "braf_branch_p" "yes")
			      (const_int 6)
			      (const_int 10))
		(eq_attr "braf_branch_p" "yes")
		(const_int 10)
;; ??? using pc is not computed transitively.
		(ne (match_dup 0) (match_dup 0))
		(const_int 12)
		] (const_int 14))
	 ] (const_int 2)))

;; (define_function_unit {name} {num-units} {n-users} {test}
;;                       {ready-delay} {issue-delay} [{conflict-list}])

;; Load and store instructions save a cycle if they are aligned on a
;; four byte boundary.  Using a function unit for stores encourages
;; gcc to separate load and store instructions by one instruction,
;; which makes it more likely that the linker will be able to word
;; align them when relaxing.

;; Loads have a latency of two.
;; However, call insns can have a delay slot, so that we want one more
;; insn to be scheduled between the load of the function address and the call.
;; This is equivalent to a latency of three.
;; We cannot use a conflict list for this, because we need to distinguish
;; between the actual call address and the function arguments.
;; ADJUST_COST can only properly handle reductions of the cost, so we
;; use a latency of three here.
;; We only do this for SImode loads of general registers, to make the work
;; for ADJUST_COST easier.
(define_function_unit "memory" 1 0
  (eq_attr "type" "load_si,pcload_si")
  3 2)
(define_function_unit "memory" 1 0
  (eq_attr "type" "load,pcload,pload,store,pstore")
  2 2)

(define_function_unit "int"    1 0
  (eq_attr "type" "arith3,arith3b") 3 3)

(define_function_unit "int"    1 0
  (eq_attr "type" "dyn_shift") 2 2)

(define_function_unit "int"    1 0
  (eq_attr "type" "arith,arith3b,dyn_shift") 2 2)

;; ??? These are approximations.
(define_function_unit "mpy"    1 0 (eq_attr "type" "smpy") 2 2)
(define_function_unit "mpy"    1 0 (eq_attr "type" "dmpy") 3 3)

(define_function_unit "fp"     1 0 (eq_attr "type" "fp,fmove") 2 1)
(define_function_unit "fp"     1 0 (eq_attr "type" "fdiv") 13 12)


; Definitions for filling branch delay slots.

(define_attr "needs_delay_slot" "yes,no" (const_string "no"))

(define_attr "hit_stack" "yes,no" (const_string "no"))

(define_attr "interrupt_function" "no,yes"
  (const (symbol_ref "pragma_interrupt")))

(define_attr "in_delay_slot" "yes,no"
  (cond [(eq_attr "type" "cbranch") (const_string "no")
	 (eq_attr "type" "pcload,pcload_si") (const_string "no")
	 (eq_attr "needs_delay_slot" "yes") (const_string "no")
	 (eq_attr "length" "2") (const_string "yes")
	 ] (const_string "no")))

(define_delay
  (eq_attr "needs_delay_slot" "yes")
  [(eq_attr "in_delay_slot" "yes") (nil) (nil)])

;; On the SH and SH2, the rte instruction reads the return pc from the stack,
;; and thus we can't put a pop instruction in its delay slot.
;; ??? On the SH3, the rte instruction does not use the stack, so a pop
;; instruction can go in the delay slot.

;; Since a normal return (rts) implicitly uses the PR register,
;; we can't allow PR register loads in an rts delay slot.

(define_delay
  (eq_attr "type" "return")
  [(and (eq_attr "in_delay_slot" "yes")
	(ior (and (eq_attr "interrupt_function" "no")
		  (eq_attr "type" "!pload"))
	     (and (eq_attr "interrupt_function" "yes")
		  (eq_attr "hit_stack" "no")))) (nil) (nil)])

;; Since a call implicitly uses the PR register, we can't allow
;; a PR register store in a jsr delay slot.

(define_delay
  (ior (eq_attr "type" "call") (eq_attr "type" "sfunc"))
  [(and (eq_attr "in_delay_slot" "yes")
	(eq_attr "type" "!pstore")) (nil) (nil)])

;; Say that we have annulled true branches, since this gives smaller and
;; faster code when branches are predicted as not taken.

(define_delay
  (and (eq_attr "type" "cbranch")
       (ne (symbol_ref "TARGET_SH2") (const_int 0)))
  [(eq_attr "in_delay_slot" "yes") (eq_attr "in_delay_slot" "yes") (nil)])

;; -------------------------------------------------------------------------
;; SImode signed integer comparisons
;; -------------------------------------------------------------------------

(define_insn ""
  [(set (reg:SI 18)
	(eq:SI (and:SI (match_operand:SI 0 "arith_reg_operand" "z,r")
		       (match_operand:SI 1 "arith_operand" "L,r"))
	       (const_int 0)))]
  ""
  "tst	%1,%0")

;; ??? Perhaps should only accept reg/constant if the register is reg 0.
;; That would still allow reload to create cmpi instructions, but would
;; perhaps allow forcing the constant into a register when that is better.
;; Probably should use r0 for mem/imm compares, but force constant into a
;; register for pseudo/imm compares.

(define_insn "cmpeqsi_t"
  [(set (reg:SI 18) (eq:SI (match_operand:SI 0 "arith_reg_operand" "r,z,r")
			   (match_operand:SI 1 "arith_operand" "N,rI,r")))]
  ""
  "@
	tst	%0,%0
	cmp/eq	%1,%0
	cmp/eq	%1,%0")

(define_insn "cmpgtsi_t"
  [(set (reg:SI 18) (gt:SI (match_operand:SI 0 "arith_reg_operand" "r,r")
			   (match_operand:SI 1 "arith_reg_or_0_operand" "r,N")))]
  ""
  "@
	cmp/gt	%1,%0
	cmp/pl	%0")

(define_insn "cmpgesi_t"
  [(set (reg:SI 18) (ge:SI (match_operand:SI 0 "arith_reg_operand" "r,r")
			   (match_operand:SI 1 "arith_reg_or_0_operand" "r,N")))]
  ""
  "@
	cmp/ge	%1,%0
	cmp/pz	%0")

;; -------------------------------------------------------------------------
;; SImode unsigned integer comparisons
;; -------------------------------------------------------------------------

(define_insn "cmpgeusi_t"
  [(set (reg:SI 18) (geu:SI (match_operand:SI 0 "arith_reg_operand" "r")
			    (match_operand:SI 1 "arith_reg_operand" "r")))]
  ""
  "cmp/hs	%1,%0")

(define_insn "cmpgtusi_t"
  [(set (reg:SI 18) (gtu:SI (match_operand:SI 0 "arith_reg_operand" "r")
			    (match_operand:SI 1 "arith_reg_operand" "r")))]
  ""
  "cmp/hi	%1,%0")

;; We save the compare operands in the cmpxx patterns and use them when
;; we generate the branch.

(define_expand "cmpsi"
  [(set (reg:SI 18) (compare (match_operand:SI 0 "arith_operand" "")
			     (match_operand:SI 1 "arith_operand" "")))]
  ""
  "
{
  sh_compare_op0 = operands[0];
  sh_compare_op1 = operands[1];
  DONE;
}")

;; -------------------------------------------------------------------------
;; DImode signed integer comparisons
;; -------------------------------------------------------------------------

;; ??? Could get better scheduling by splitting the initial test from the
;; rest of the insn after reload.  However, the gain would hardly justify
;; the sh.md size increase necessary to do that.

(define_insn ""
  [(set (reg:SI 18)
	(eq:SI (and:DI (match_operand:DI 0 "arith_reg_operand" "r")
		       (match_operand:DI 1 "arith_operand" "r"))
	       (const_int 0)))]
  ""
  "* return output_branchy_insn (EQ, \"tst\\t%S1,%S0\;bf\\t%l9\;tst\\t%R1,%R0\",
				 insn, operands);"
  [(set_attr "length" "6")
   (set_attr "type" "arith3b")])

(define_insn "cmpeqdi_t"
  [(set (reg:SI 18) (eq:SI (match_operand:DI 0 "arith_reg_operand" "r,r")
			   (match_operand:DI 1 "arith_reg_or_0_operand" "N,r")))]
  ""
  "*
  return output_branchy_insn
   (EQ,
    (which_alternative
     ? \"cmp/eq\\t%S1,%S0\;bf\\t%l9\;cmp/eq\\t%R1,%R0\"
     : \"tst\\t%S0,%S0\;bf\\t%l9\;tst\\t%R0,%R0\"),
    insn, operands);"
  [(set_attr "length" "6")
   (set_attr "type" "arith3b")])

(define_insn "cmpgtdi_t"
  [(set (reg:SI 18) (gt:SI (match_operand:DI 0 "arith_reg_operand" "r,r")
			   (match_operand:DI 1 "arith_reg_or_0_operand" "r,N")))]
  "TARGET_SH2"
  "@
	cmp/eq\\t%S1,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/gt\\t%S1,%S0\;cmp/hi\\t%R1,%R0\\n%,Ldi%=:
	tst\\t%S0,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/pl\\t%S0\;cmp/hi\\t%S0,%R0\\n%,Ldi%=:"
  [(set_attr "length" "8")
   (set_attr "type" "arith3")])

(define_insn "cmpgedi_t"
  [(set (reg:SI 18) (ge:SI (match_operand:DI 0 "arith_reg_operand" "r,r")
			   (match_operand:DI 1 "arith_reg_or_0_operand" "r,N")))]
  "TARGET_SH2"
  "@
	cmp/eq\\t%S1,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/ge\\t%S1,%S0\;cmp/hs\\t%R1,%R0\\n%,Ldi%=:
	cmp/pz\\t%S0"
  [(set_attr "length" "8,2")
   (set_attr "type" "arith3,arith")])

;; -------------------------------------------------------------------------
;; DImode unsigned integer comparisons
;; -------------------------------------------------------------------------

(define_insn "cmpgeudi_t"
  [(set (reg:SI 18) (geu:SI (match_operand:DI 0 "arith_reg_operand" "r")
			    (match_operand:DI 1 "arith_reg_operand" "r")))]
  "TARGET_SH2"
  "cmp/eq\\t%S1,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/hs\\t%S1,%S0\;cmp/hs\\t%R1,%R0\\n%,Ldi%=:"
  [(set_attr "length" "8")
   (set_attr "type" "arith3")])

(define_insn "cmpgtudi_t"
  [(set (reg:SI 18) (gtu:SI (match_operand:DI 0 "arith_reg_operand" "r")
			    (match_operand:DI 1 "arith_reg_operand" "r")))]
  "TARGET_SH2"
  "cmp/eq\\t%S1,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/hi\\t%S1,%S0\;cmp/hi\\t%R1,%R0\\n%,Ldi%=:"
  [(set_attr "length" "8")
   (set_attr "type" "arith3")])

;; We save the compare operands in the cmpxx patterns and use them when
;; we generate the branch.

(define_expand "cmpdi"
  [(set (reg:SI 18) (compare (match_operand:DI 0 "arith_operand" "")
			     (match_operand:DI 1 "arith_operand" "")))]
  "TARGET_SH2"
  "
{
  sh_compare_op0 = operands[0];
  sh_compare_op1 = operands[1];
  DONE;
}")

;; -------------------------------------------------------------------------
;; Addition instructions
;; -------------------------------------------------------------------------

;; ??? This should be a define expand.

(define_insn "adddi3"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(plus:DI (match_operand:DI 1 "arith_reg_operand" "%0")
		 (match_operand:DI 2 "arith_reg_operand" "r")))
   (clobber (reg:SI 18))]
  ""
  "#"
  [(set_attr "length" "6")])

(define_split
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(plus:DI (match_operand:DI 1 "arith_reg_operand" "%0")
		 (match_operand:DI 2 "arith_reg_operand" "r")))
   (clobber (reg:SI 18))]
  "reload_completed"
  [(const_int 0)]
  "
{
  rtx high0, high2, low0 = gen_lowpart (SImode, operands[0]);
  high0 = gen_rtx (REG, SImode,
		   true_regnum (operands[0]) + (TARGET_LITTLE_ENDIAN ? 1 : 0));
  high2 = gen_rtx (REG, SImode,
		   true_regnum (operands[2]) + (TARGET_LITTLE_ENDIAN ? 1 : 0));
  emit_insn (gen_clrt ());
  emit_insn (gen_addc (low0, low0, gen_lowpart (SImode, operands[2])));
  emit_insn (gen_addc1 (high0, high0, high2));
  DONE;
}")

(define_insn "addc"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(plus:SI (plus:SI (match_operand:SI 1 "arith_reg_operand" "0")
			  (match_operand:SI 2 "arith_reg_operand" "r"))
		 (reg:SI 18)))
   (set (reg:SI 18)
	(ltu:SI (plus:SI (match_dup 1) (match_dup 2)) (match_dup 1)))]
  ""
  "addc	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "addc1"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(plus:SI (plus:SI (match_operand:SI 1 "arith_reg_operand" "0")
			  (match_operand:SI 2 "arith_reg_operand" "r"))
		 (reg:SI 18)))
   (clobber (reg:SI 18))]
  ""
  "addc	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "addsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(plus:SI (match_operand:SI 1 "arith_operand" "%0")
		 (match_operand:SI 2 "arith_operand" "rI")))]
  ""
  "add	%2,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Subtraction instructions
;; -------------------------------------------------------------------------

;; ??? This should be a define expand.

(define_insn "subdi3"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(minus:DI (match_operand:DI 1 "arith_reg_operand" "0")
		 (match_operand:DI 2 "arith_reg_operand" "r")))
   (clobber (reg:SI 18))]
  ""
  "#"
  [(set_attr "length" "6")])

(define_split
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(minus:DI (match_operand:DI 1 "arith_reg_operand" "0")
		  (match_operand:DI 2 "arith_reg_operand" "r")))
   (clobber (reg:SI 18))]
  "reload_completed"
  [(const_int 0)]
  "
{
  rtx high0, high2, low0 = gen_lowpart (SImode, operands[0]);
  high0 = gen_rtx (REG, SImode,
		   true_regnum (operands[0]) + (TARGET_LITTLE_ENDIAN ? 1 : 0));
  high2 = gen_rtx (REG, SImode,
		   true_regnum (operands[2]) + (TARGET_LITTLE_ENDIAN ? 1 : 0));
  emit_insn (gen_clrt ());
  emit_insn (gen_subc (low0, low0, gen_lowpart (SImode, operands[2])));
  emit_insn (gen_subc1 (high0, high0, high2));
  DONE;
}")

(define_insn "subc"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(minus:SI (minus:SI (match_operand:SI 1 "arith_reg_operand" "0")
			    (match_operand:SI 2 "arith_reg_operand" "r"))
		  (reg:SI 18)))
   (set (reg:SI 18)
	(gtu:SI (minus:SI (match_dup 1) (match_dup 2)) (match_dup 1)))]
  ""
  "subc	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "subc1"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(minus:SI (minus:SI (match_operand:SI 1 "arith_reg_operand" "0")
			    (match_operand:SI 2 "arith_reg_operand" "r"))
		  (reg:SI 18)))
   (clobber (reg:SI 18))]
  ""
  "subc	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "*subsi3_internal"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(minus:SI (match_operand:SI 1 "arith_reg_operand" "0")
		  (match_operand:SI 2 "arith_reg_operand" "r")))]
  ""
  "sub	%2,%0"
  [(set_attr "type" "arith")])

;; Convert `constant - reg' to `neg rX; add rX, #const' since this
;; will sometimes save one instruction.  Otherwise we might get
;; `mov #const, rY; sub rY,rX; mov rX, rY' if the source and dest regs
;; are the same.

(define_expand "subsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(minus:SI (match_operand:SI 1 "arith_operand" "")
		  (match_operand:SI 2 "arith_reg_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[1]) == CONST_INT)
    {
      emit_insn (gen_negsi2 (operands[0], operands[2]));
      emit_insn (gen_addsi3 (operands[0], operands[0], operands[1]));
      DONE;
    }
}")

;; -------------------------------------------------------------------------
;; Division instructions
;; -------------------------------------------------------------------------

;; We take advantage of the library routines which don't clobber as many
;; registers as a normal function call would.

;; The INSN_REFERENCES_ARE_DELAYED in sh.h is problematic because it
;; also has an effect on the register that holds the address of the sfunc.
;; To make this work, we have an extra dummy insns that shows the use
;; of this register for reorg.

(define_insn "use_sfunc_addr"
  [(set (reg:SI 17) (unspec [(match_operand:SI 0 "register_operand" "r")] 5))]
  ""
  ""
  [(set_attr "length" "0")])

;; We must use a pseudo-reg forced to reg 0 in the SET_DEST rather than
;; hard register 0.  If we used hard register 0, then the next instruction
;; would be a move from hard register 0 to a pseudo-reg.  If the pseudo-reg
;; gets allocated to a stack slot that needs its address reloaded, then
;; there is nothing to prevent reload from using r0 to reload the address.
;; This reload would clobber the value in r0 we are trying to store.
;; If we let reload allocate r0, then this problem can never happen.

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=z")
	(udiv:SI (reg:SI 4) (reg:SI 5)))
   (clobber (reg:SI 18))
   (clobber (reg:SI 17))
   (clobber (reg:SI 4))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  ""
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "udivsi3"
  [(set (reg:SI 4) (match_operand:SI 1 "general_operand" ""))
   (set (reg:SI 5) (match_operand:SI 2 "general_operand" ""))
   (set (match_dup 3) (symbol_ref:SI "__udivsi3"))
   (parallel [(set (match_operand:SI 0 "register_operand" "")
		   (udiv:SI (reg:SI 4)
			    (reg:SI 5)))
	      (clobber (reg:SI 18))
	      (clobber (reg:SI 17))
	      (clobber (reg:SI 4))
	      (use (match_dup 3))])]
  ""
  "operands[3] = gen_reg_rtx(SImode);")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=z")
	(div:SI (reg:SI 4) (reg:SI 5)))
   (clobber (reg:SI 18))
   (clobber (reg:SI 17))
   (clobber (reg:SI 1))
   (clobber (reg:SI 2))
   (clobber (reg:SI 3))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  ""
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "divsi3"
  [(set (reg:SI 4) (match_operand:SI 1 "general_operand" ""))
   (set (reg:SI 5) (match_operand:SI 2 "general_operand" ""))
   (set (match_dup 3) (symbol_ref:SI "__sdivsi3"))
   (parallel [(set (match_operand:SI 0 "register_operand" "")
		   (div:SI (reg:SI 4)
			   (reg:SI 5)))
	      (clobber (reg:SI 18))
	      (clobber (reg:SI 17))
	      (clobber (reg:SI 1))
	      (clobber (reg:SI 2))
	      (clobber (reg:SI 3))
	      (use (match_dup 3))])]
  ""
  "operands[3] = gen_reg_rtx(SImode);")

;; -------------------------------------------------------------------------
;; Multiplication instructions
;; -------------------------------------------------------------------------

(define_insn ""
  [(set (reg:SI 21)
	(mult:SI (zero_extend:SI (match_operand:HI 0 "arith_reg_operand" "r"))
		 (zero_extend:SI (match_operand:HI 1 "arith_reg_operand" "r"))))]
  ""
  "mulu	%1,%0"
  [(set_attr "type" "smpy")])

(define_insn ""
  [(set (reg:SI 21)
	(mult:SI (sign_extend:SI
		  (match_operand:HI 0 "arith_reg_operand" "r"))
		 (sign_extend:SI
		  (match_operand:HI 1 "arith_reg_operand" "r"))))]
  ""
  "muls	%1,%0"
  [(set_attr "type" "smpy")])

(define_expand "mulhisi3"
  [(set (reg:SI 21)
	(mult:SI (sign_extend:SI
		  (match_operand:HI 1 "arith_reg_operand" ""))
		 (sign_extend:SI
		  (match_operand:HI 2 "arith_reg_operand" ""))))
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI 21))]
  ""
  "")

(define_expand "umulhisi3"
  [(set (reg:SI 21)
	(mult:SI (zero_extend:SI
		  (match_operand:HI 1 "arith_reg_operand" ""))
		 (zero_extend:SI
		  (match_operand:HI 2 "arith_reg_operand" ""))))
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI 21))]
  ""
  "")

;; mulsi3 on the SH2 can be done in one instruction, on the SH1 we generate
;; a call to a routine which clobbers known registers.

(define_insn ""
  [(set (match_operand:SI 1 "register_operand" "=z")
	(mult:SI (reg:SI 4) (reg:SI 5)))
   (clobber (reg:SI 21))
   (clobber (reg:SI 18))
   (clobber (reg:SI 17))
   (clobber (reg:SI 3))
   (clobber (reg:SI 2))
   (clobber (reg:SI 1))
   (use (match_operand:SI 0 "arith_reg_operand" "r"))]
  ""
  "jsr	@%0%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "mulsi3_call"
  [(set (reg:SI 4) (match_operand:SI 1 "general_operand" ""))
   (set (reg:SI 5) (match_operand:SI 2 "general_operand" ""))
   (set (match_dup 3) (symbol_ref:SI "__mulsi3"))
   (parallel[(set (match_operand:SI 0 "register_operand" "")
		  (mult:SI (reg:SI 4)
			   (reg:SI 5)))
	     (clobber (reg:SI 21))
	     (clobber (reg:SI 18))
	     (clobber (reg:SI 17))
	     (clobber (reg:SI 3))
	     (clobber (reg:SI 2))
	     (clobber (reg:SI 1))
	     (use (match_dup 3))])]
  ""
  "operands[3] = gen_reg_rtx(SImode);")

(define_insn "mul_l"
  [(set (reg:SI 21)
	(mult:SI (match_operand:SI 0 "arith_reg_operand" "r")
		 (match_operand:SI 1 "arith_reg_operand" "r")))]
  "TARGET_SH2"
  "mul.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_expand "mulsi3"
  [(set (reg:SI 21)
	(mult:SI  (match_operand:SI 1 "arith_reg_operand" "")
		  (match_operand:SI 2 "arith_reg_operand" "")))
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI 21))]
  ""
  "
{
  if (!TARGET_SH2)
    {
      FAIL;
      /* ??? Does this give worse or better code?  */
      emit_insn (gen_mulsi3_call (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "mulsidi3_i"
  [(set (reg:DI 20)
	(mult:DI (sign_extend:DI (match_operand:SI 0 "arith_reg_operand" "r"))
		 (sign_extend:DI (match_operand:SI 1 "arith_reg_operand" "r"))))]
  "TARGET_SH2"
  "dmuls.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_expand "mulsidi3"
  [(set (reg:DI 20)
	(mult:DI (sign_extend:DI (match_operand:SI 1 "arith_reg_operand" ""))
		 (sign_extend:DI (match_operand:SI 2 "arith_reg_operand" ""))))
   (set (match_operand:DI 0 "arith_reg_operand" "")
	(reg:DI 20))]
  "TARGET_SH2"
  "
{
  /* We must swap the two words when copying them from MACH/MACL to the
     output register.  */
  if (TARGET_LITTLE_ENDIAN)
    {
      rtx low_dst = operand_subword (operands[0], 0, 1, DImode);
      rtx high_dst = operand_subword (operands[0], 1, 1, DImode);

      emit_insn (gen_mulsidi3_i (operands[1], operands[2]));

      emit_insn (gen_rtx (CLOBBER, VOIDmode, operands[0]));
      emit_move_insn (low_dst, gen_rtx (REG, SImode, 21));
      emit_move_insn (high_dst, gen_rtx (REG, SImode, 20));
      DONE;
    }
}")

(define_insn "umulsidi3_i"
  [(set (reg:DI 20)
	(mult:DI (zero_extend:DI (match_operand:SI 0 "arith_reg_operand" "r"))
		 (zero_extend:DI (match_operand:SI 1 "arith_reg_operand" "r"))))]
  "TARGET_SH2"
  "dmulu.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_expand "umulsidi3"
  [(set (reg:DI 20)
	(mult:DI (zero_extend:DI (match_operand:SI 1 "arith_reg_operand" ""))
		 (zero_extend:DI (match_operand:SI 2 "arith_reg_operand" ""))))
   (set (match_operand:DI 0 "arith_reg_operand" "")
	(reg:DI 20))]
  "TARGET_SH2"
  "
{
  /* We must swap the two words when copying them from MACH/MACL to the
     output register.  */
  if (TARGET_LITTLE_ENDIAN)
    {
      rtx low_dst = operand_subword (operands[0], 0, 1, DImode);
      rtx high_dst = operand_subword (operands[0], 1, 1, DImode);

      emit_insn (gen_umulsidi3_i (operands[1], operands[2]));

      emit_insn (gen_rtx (CLOBBER, VOIDmode, operands[0]));
      emit_move_insn (low_dst, gen_rtx (REG, SImode, 21));
      emit_move_insn (high_dst, gen_rtx (REG, SImode, 20));
      DONE;
    }
}")

(define_insn ""
  [(set (reg:SI 20)
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI (match_operand:SI 0 "arith_reg_operand" "r"))
			       (sign_extend:DI (match_operand:SI 1 "arith_reg_operand" "r")))
		      (const_int 32))))
   (clobber (reg:SI 21))]
  "TARGET_SH2"
  "dmuls.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_expand "smulsi3_highpart"
  [(parallel [(set (reg:SI 20)
		   (truncate:SI
		    (lshiftrt:DI (mult:DI (sign_extend:DI (match_operand:SI 1 "arith_reg_operand" ""))
					  (sign_extend:DI (match_operand:SI 2 "arith_reg_operand" "")))
				 (const_int 32))))
	      (clobber (reg:SI 21))])
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI 20))]
  "TARGET_SH2"
  "")

(define_insn ""
  [(set (reg:SI 20)
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI (match_operand:SI 0 "arith_reg_operand" "r"))
			       (zero_extend:DI (match_operand:SI 1 "arith_reg_operand" "r")))
		      (const_int 32))))
   (clobber (reg:SI 21))]
  "TARGET_SH2"
  "dmulu.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_expand "umulsi3_highpart"
  [(parallel [(set (reg:SI 20)
		   (truncate:SI
		    (lshiftrt:DI (mult:DI (zero_extend:DI (match_operand:SI 1 "arith_reg_operand" ""))
					  (zero_extend:DI (match_operand:SI 2 "arith_reg_operand" "")))
				 (const_int 32))))
	      (clobber (reg:SI 21))])
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI 20))]
  "TARGET_SH2"
  "")

;; -------------------------------------------------------------------------
;; Logical operations
;; -------------------------------------------------------------------------

(define_insn ""
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,z")
	(and:SI (match_operand:SI 1 "arith_reg_operand" "%0,0")
		(match_operand:SI 2 "logical_operand" "r,L")))]
  ""
  "and	%2,%0"
  [(set_attr "type" "arith")])

;; If the constant is 255, then emit a extu.b instruction instead of an
;; and, since that will give better code.

(define_expand "andsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(and:SI (match_operand:SI 1 "arith_reg_operand" "")
		(match_operand:SI 2 "logical_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 255)
    {
      emit_insn (gen_zero_extendqisi2 (operands[0],
				       gen_lowpart (QImode, operands[1])));
      DONE;
    }
}")

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,z")
	(ior:SI (match_operand:SI 1 "arith_reg_operand" "%0,0")
		(match_operand:SI 2 "logical_operand" "r,L")))]
  ""
  "or	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "=z,r")
	(xor:SI (match_operand:SI 1 "arith_reg_operand" "%0,0")
		(match_operand:SI 2 "logical_operand" "L,r")))]
  ""
  "xor	%2,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Shifts and rotates
;; -------------------------------------------------------------------------

(define_insn "rotlsi3_1"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "arith_reg_operand" "0")
		   (const_int 1)))
   (set (reg:SI 18)
	(lshiftrt:SI (match_dup 1) (const_int 31)))]
  ""
  "rotl	%0"
  [(set_attr "type" "arith")])

(define_insn "rotlsi3_31"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "arith_reg_operand" "0")
		   (const_int 31)))
   (clobber (reg:SI 18))]
  ""
  "rotr	%0"
  [(set_attr "type" "arith")])

(define_insn "rotlsi3_16"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "arith_reg_operand" "r")
		   (const_int 16)))]
  ""
  "swap.w	%1,%0"
  [(set_attr "type" "arith")])

(define_expand "rotlsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(rotate:SI (match_operand:SI 1 "arith_reg_operand" "")
		   (match_operand:SI 2 "immediate_operand" "")))]
  ""
  "
{
  static char rot_tab[] = {
    000, 000, 000, 000, 000, 000, 010, 001,
    001, 001, 011, 013, 003, 003, 003, 003,
    003, 003, 003, 003, 003, 013, 012, 002,
    002, 002, 010, 000, 000, 000, 000, 000,
  };

  int count, choice;

  if (GET_CODE (operands[2]) != CONST_INT)
    FAIL;
  count = INTVAL (operands[2]);
  choice = rot_tab[count];
  if (choice & 010 && SH_DYNAMIC_SHIFT_COST <= 1)
    FAIL;
  choice &= 7;
  switch (choice)
    {
    case 0:
      emit_move_insn (operands[0], operands[1]);
      count -= (count & 16) * 2;
      break;
    case 3:
     emit_insn (gen_rotlsi3_16 (operands[0], operands[1]));
     count -= 16;
     break;
    case 1:
    case 2:
      {
	rtx parts[2];
	parts[0] = gen_reg_rtx (SImode);
	parts[1] = gen_reg_rtx (SImode);
	emit_insn (gen_rotlsi3_16 (parts[2-choice], operands[1]));
	parts[choice-1] = operands[1];
	emit_insn (gen_ashlsi3 (parts[0], parts[0], GEN_INT (8)));
	emit_insn (gen_lshrsi3 (parts[1], parts[1], GEN_INT (8)));
	emit_insn (gen_iorsi3 (operands[0], parts[0], parts[1]));
	count = (count & ~16) - 8;
      }
    }

  for (; count > 0; count--)
    emit_insn (gen_rotlsi3_1 (operands[0], operands[0]));
  for (; count < 0; count++)
    emit_insn (gen_rotlsi3_31 (operands[0], operands[0]));

  DONE;
}")

(define_insn "*rotlhi3_8"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r")
	(rotate:HI (match_operand:HI 1 "arith_reg_operand" "r")
		   (const_int 8)))]
  ""
  "swap.b	%1,%0"
  [(set_attr "type" "arith")])

(define_expand "rotlhi3"
  [(set (match_operand:HI 0 "arith_reg_operand" "")
	(rotate:HI (match_operand:HI 1 "arith_reg_operand" "")
		   (match_operand:HI 2 "immediate_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) != CONST_INT || INTVAL (operands[2]) != 8)
    FAIL;
}")

;;
;; shift left

(define_insn "ashlsi3_d"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashift:SI (match_operand:SI 1 "arith_reg_operand" "0")
		   (match_operand:SI 2 "arith_reg_operand" "r")))]
  "TARGET_SH3"
  "shld	%2,%0"
  [(set_attr "type" "dyn_shift")])

(define_insn "ashlsi3_k"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,r")
	(ashift:SI (match_operand:SI 1 "arith_reg_operand" "0,0")
		   (match_operand:SI 2 "const_int_operand" "M,K")))]
  "CONST_OK_FOR_K (INTVAL (operands[2]))"
  "@
	add	%0,%0
	shll%O2	%0"
  [(set_attr "type" "arith")])

(define_insn "ashlhi3_k"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r,r")
	(ashift:HI (match_operand:HI 1 "arith_reg_operand" "0,0")
		   (match_operand:HI 2 "const_int_operand" "M,K")))]
  "CONST_OK_FOR_K (INTVAL (operands[2]))"
  "@
	add	%0,%0
	shll%O2	%0"
  [(set_attr "type" "arith")])

(define_insn "ashlsi3_n"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashift:SI (match_operand:SI 1 "arith_reg_operand" "0")
		   (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (reg:SI 18))]
  "! sh_dynamicalize_shift_p (operands[2])"
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shift_insns_rtx (insn)") (const_int 1))
	       (const_string "2")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 3))
	       (const_string "6")]
	      (const_string "8")))
   (set_attr "type" "arith")])

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(ashift:SI (match_operand:SI 1 "arith_reg_operand" "")
		   (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (reg:SI 18))]
  ""
  [(use (reg:SI 0))]
  "
{
  gen_shifty_op (ASHIFT, operands);
  DONE;
}")

(define_expand "ashlsi3"
  [(parallel [(set (match_operand:SI 0 "arith_reg_operand" "")
		   (ashift:SI (match_operand:SI 1 "arith_reg_operand" "")
			      (match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:SI 18))])]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && sh_dynamicalize_shift_p (operands[2]))
    operands[2] = force_reg (SImode, operands[2]);
  if (TARGET_SH3 && arith_reg_operand (operands[2], GET_MODE (operands[2])))
    {
      emit_insn (gen_ashlsi3_d (operands[0], operands[1], operands[2]));
      DONE;
    }
  if (! immediate_operand (operands[2], GET_MODE (operands[2])))
    FAIL;
}")

(define_insn "ashlhi3"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r")
	(ashift:HI (match_operand:HI 1 "arith_reg_operand" "0")
		   (match_operand:HI 2 "const_int_operand" "n")))
   (clobber (reg:SI 18))]
  ""
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shift_insns_rtx (insn)") (const_int 1))
	       (const_string "2")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 2))
	       (const_string "4")]
	      (const_string "6")))
   (set_attr "type" "arith")])

(define_split
  [(set (match_operand:HI 0 "arith_reg_operand" "")
	(ashift:HI (match_operand:HI 1 "arith_reg_operand" "")
		   (match_operand:HI 2 "const_int_operand" "n")))
   (clobber (reg:SI 18))]
  ""
  [(use (reg:SI 0))]
  "
{
  gen_shifty_hi_op (ASHIFT, operands);
  DONE;
}")

;
; arithmetic shift right
;

(define_insn "ashrsi3_k"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (match_operand:SI 2 "const_int_operand" "M")))
   (clobber (reg:SI 18))]
  "INTVAL (operands[2]) == 1"
  "shar	%0"
  [(set_attr "type" "arith")])

;; We can't do HImode right shifts correctly unless we start out with an
;; explicit zero / sign extension; doing that would result in worse overall
;; code, so just let the machine independent code widen the mode.
;; That's why we don't have ashrhi3_k / lshrhi3_k / lshrhi3_m / lshrhi3 .


;; ??? This should be a define expand.

(define_insn "ashrsi2_16"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
        (ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "r")
                     (const_int 16)))]
  ""
  "#"
  [(set_attr "length" "4")])

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
        (ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "r")
		     (const_int 16)))]
  ""
  [(set (match_dup 0) (rotate:SI (match_dup 1) (const_int 16)))
   (set (match_dup 0) (sign_extend:SI (match_dup 2)))]
  "operands[2] = gen_lowpart (HImode, operands[0]);")

;; ??? This should be a define expand.

(define_insn "ashrsi2_31"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (const_int 31)))
   (clobber (reg:SI 18))]
  ""
  "#"
  [(set_attr "length" "4")])

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (const_int 31)))
   (clobber (reg:SI 18))]
  ""
  [(const_int 0)]
  "
{
  emit_insn (gen_ashlsi_c (operands[0], operands[1]));
  emit_insn (gen_subc1 (operands[0], operands[0], operands[0]));
  DONE;
}")

(define_insn "ashlsi_c"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashift:SI (match_operand:SI 1 "arith_reg_operand" "0") (const_int 1)))
   (set (reg:SI 18) (lt:SI (match_dup 1)
			   (const_int 0)))]
  ""
  "shll	%0"
  [(set_attr "type" "arith")])

(define_insn "ashrsi3_d"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (neg:SI (match_operand:SI 2 "arith_reg_operand" "r"))))]
  "TARGET_SH3"
  "shad	%2,%0"
  [(set_attr "type" "dyn_shift")])

(define_insn "ashrsi3_n"
  [(set (reg:SI 4)
	(ashiftrt:SI (reg:SI 4)
		     (match_operand:SI 0 "const_int_operand" "i")))
   (clobber (reg:SI 18))
   (clobber (reg:SI 17))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  ""
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "ashrsi3"
  [(parallel [(set (match_operand:SI 0 "arith_reg_operand" "")
		   (ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "")
				(match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:SI 18))])]
  ""
  "if (expand_ashiftrt (operands)) DONE; else FAIL;")

;; logical shift right

(define_insn "lshrsi3_d"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (neg:SI (match_operand:SI 2 "arith_reg_operand" "r"))))]
  "TARGET_SH3"
  "shld	%2,%0"
  [(set_attr "type" "dyn_shift")])

;;  Only the single bit shift clobbers the T bit.

(define_insn "lshrsi3_m"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (match_operand:SI 2 "const_int_operand" "M")))
   (clobber (reg:SI 18))]
  "CONST_OK_FOR_M (INTVAL (operands[2]))"
  "shlr	%0"
  [(set_attr "type" "arith")])

(define_insn "lshrsi3_k"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (match_operand:SI 2 "const_int_operand" "K")))]
  "CONST_OK_FOR_K (INTVAL (operands[2]))
   && ! CONST_OK_FOR_M (INTVAL (operands[2]))"
  "shlr%O2	%0"
  [(set_attr "type" "arith")])

(define_insn "lshrsi3_n"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (reg:SI 18))]
  "! sh_dynamicalize_shift_p (operands[2])"
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shift_insns_rtx (insn)") (const_int 1))
	       (const_string "2")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 3))
	       (const_string "6")]
	      (const_string "8")))
   (set_attr "type" "arith")])

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "")
		     (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (reg:SI 18))]
  ""
  [(use (reg:SI 0))]
  "
{
  gen_shifty_op (LSHIFTRT, operands);
  DONE;
}")

(define_expand "lshrsi3"
  [(parallel [(set (match_operand:SI 0 "arith_reg_operand" "")
		   (lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "")
				(match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:SI 18))])]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && sh_dynamicalize_shift_p (operands[2]))
    operands[2] = force_reg (SImode, operands[2]);
  if (TARGET_SH3 && arith_reg_operand (operands[2], GET_MODE (operands[2])))
    {
      rtx count = copy_to_mode_reg (SImode, operands[2]);
      emit_insn (gen_negsi2 (count, count));
      emit_insn (gen_lshrsi3_d (operands[0], operands[1], count));
      DONE;
    }
  if (! immediate_operand (operands[2], GET_MODE (operands[2])))
    FAIL;
}")

;; ??? This should be a define expand.

(define_insn "ashldi3_k"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(ashift:DI (match_operand:DI 1 "arith_reg_operand" "0")
		   (const_int 1)))
   (clobber (reg:SI 18))]
  ""
  "shll	%R0\;rotcl	%S0"
  [(set_attr "length" "4")
   (set_attr "type" "arith")])

(define_expand "ashldi3"
  [(parallel [(set (match_operand:DI 0 "arith_reg_operand" "")
		   (ashift:DI (match_operand:DI 1 "arith_reg_operand" "")
			      (match_operand:DI 2 "immediate_operand" "")))
	      (clobber (reg:SI 18))])]
  ""
  "{ if (GET_CODE (operands[2]) != CONST_INT
	 || INTVAL (operands[2]) != 1) FAIL;} ")

;; ??? This should be a define expand.

(define_insn "lshrdi3_k"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(lshiftrt:DI (match_operand:DI 1 "arith_reg_operand" "0")
		     (const_int 1)))
   (clobber (reg:SI 18))]
  ""
  "shlr	%S0\;rotcr	%R0"
  [(set_attr "length" "4")
   (set_attr "type" "arith")])

(define_expand "lshrdi3"
  [(parallel [(set (match_operand:DI 0 "arith_reg_operand" "")
		   (lshiftrt:DI (match_operand:DI 1 "arith_reg_operand" "")
			       (match_operand:DI 2 "immediate_operand" "")))
	     (clobber (reg:SI 18))])]
  ""
  "{ if (GET_CODE (operands[2]) != CONST_INT
	 || INTVAL (operands[2]) != 1) FAIL;} ")

;; ??? This should be a define expand.

(define_insn "ashrdi3_k"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(ashiftrt:DI (match_operand:DI 1 "arith_reg_operand" "0")
		     (const_int 1)))
   (clobber (reg:SI 18))]
  ""
  "shar	%S0\;rotcr	%R0"
  [(set_attr "length" "4")
   (set_attr "type" "arith")])

(define_expand "ashrdi3"
  [(parallel [(set (match_operand:DI 0 "arith_reg_operand" "")
		   (ashiftrt:DI (match_operand:DI 1 "arith_reg_operand" "")
				(match_operand:DI 2 "immediate_operand" "")))
	      (clobber (reg:SI 18))])]
  ""
  "{ if (GET_CODE (operands[2]) != CONST_INT
	 || INTVAL (operands[2]) != 1) FAIL; } ")

;; combined left/right shift

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(and:SI (ashift:SI (match_operand:SI 1 "register_operand" "")
			   (match_operand:SI 2 "const_int_operand" "n"))
		(match_operand:SI 3 "const_int_operand" "n")))]
  "(unsigned)INTVAL (operands[2]) < 32"
  [(use (reg:SI 0))]
  "if (gen_shl_and (operands[0], operands[2], operands[3], operands[1])) FAIL;
   DONE;")

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(and:SI (ashift:SI (match_operand:SI 1 "register_operand" "")
			   (match_operand:SI 2 "const_int_operand" "n"))
		(match_operand:SI 3 "const_int_operand" "n")))
   (clobber (reg:SI 18))]
  "(unsigned)INTVAL (operands[2]) < 32"
  [(use (reg:SI 0))]
  "if (gen_shl_and (operands[0], operands[2], operands[3], operands[1])) FAIL;
   DONE;")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(and:SI (ashift:SI (match_operand:SI 1 "register_operand" "0")
			   (match_operand:SI 2 "const_int_operand" "n"))
		(match_operand:SI 3 "const_int_operand" "n")))
   (clobber (reg:SI 18))]
  "shl_and_kind (operands[2], operands[3], 0) == 1"
 "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_and_length (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 4))
	       (const_string "8")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 5))
	       (const_string "10")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 6))
	       (const_string "12")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 7))
	       (const_string "14")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 8))
	       (const_string "16")]
	      (const_string "18")))
   (set_attr "type" "arith")])

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=z")
	(and:SI (ashift:SI (match_operand:SI 1 "register_operand" "0")
			   (match_operand:SI 2 "const_int_operand" "n"))
		(match_operand:SI 3 "const_int_operand" "n")))
   (clobber (reg:SI 18))]
  "shl_and_kind (operands[2], operands[3], 0) == 2"
 "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_and_length (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 4))
	       (const_string "8")]
	      (const_string "10")))
   (set_attr "type" "arith")])

;; shift left / and combination with a scratch register: The combine pass
;; does not accept the individual instructions, even though they are
;; cheap.  But it needs a precise description so that it is usable after
;; reload.
(define_insn "and_shl_scratch"
  [(set (match_operand:SI 0 "register_operand" "=r,&r")
	(lshiftrt:SI (ashift:SI (and:SI (lshiftrt:SI (match_operand:SI 1 "register_operand" "r,0")
						     (match_operand:SI 2 "const_int_operand" "N,n"))
					(match_operand:SI 3 "" "0,r"))
				(match_operand:SI 4 "const_int_operand" "n,n"))
		     (match_operand:SI 5 "const_int_operand" "n,n")))
   (clobber (reg:SI 18))]
  ""
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_and_scr_length (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shl_and_scr_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_and_scr_length (insn)") (const_int 4))
	       (const_string "8")
	       (eq (symbol_ref "shl_and_scr_length (insn)") (const_int 5))
	       (const_string "10")]
	      (const_string "12")))
   (set_attr "type" "arith")])

(define_split
  [(set (match_operand:SI 0 "register_operand" "=r,&r")
	(lshiftrt:SI (ashift:SI (and:SI (lshiftrt:SI (match_operand:SI 1 "register_operand" "r,0")
						     (match_operand:SI 2 "const_int_operand" "N,n"))
					(match_operand:SI 3 "register_operand" "0,r"))
				(match_operand:SI 4 "const_int_operand" "n,n"))
		     (match_operand:SI 5 "const_int_operand" "n,n")))
   (clobber (reg:SI 18))]
  ""
  [(use (reg:SI 0))]
  "
{
  rtx and_source = operands[rtx_equal_p (operands[0], operands[1]) ? 3 : 1];

  if (INTVAL (operands[2]))
    {
      gen_shifty_op (LSHIFTRT, operands);
    }
  emit_insn (gen_andsi3 (operands[0], operands[0], and_source));
  operands[2] = operands[4];
  gen_shifty_op (ASHIFT, operands);
  if (INTVAL (operands[5]))
    {
      operands[2] = operands[5];
      gen_shifty_op (LSHIFTRT, operands);
    }
  DONE;
}")

;; signed left/right shift combination.
(define_split
  [(set (match_operand:SI 0 "register_operand" "=r")
        (sign_extract:SI (ashift:SI (match_operand:SI 1 "register_operand" "r")
				    (match_operand:SI 2 "const_int_operand" "n"))
			 (match_operand:SI 3 "const_int_operand" "n")
			 (const_int 0)))
   (clobber (reg:SI 18))]
  ""
  [(use (reg:SI 0))]
  "if (gen_shl_sext (operands[0], operands[2], operands[3], operands[1])) FAIL;
   DONE;")

(define_insn "shl_sext_ext"
  [(set (match_operand:SI 0 "register_operand" "=r")
        (sign_extract:SI (ashift:SI (match_operand:SI 1 "register_operand" "0")
				    (match_operand:SI 2 "const_int_operand" "n"))
			 (match_operand:SI 3 "const_int_operand" "n")
			 (const_int 0)))
   (clobber (reg:SI 18))]
  "(unsigned)shl_sext_kind (operands[2], operands[3], 0) - 1 < 5"
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_sext_length (insn)") (const_int 1))
	       (const_string "2")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 4))
	       (const_string "8")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 5))
	       (const_string "10")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 6))
	       (const_string "12")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 7))
	       (const_string "14")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 8))
	       (const_string "16")]
	      (const_string "18")))
    (set_attr "type" "arith")])

(define_insn "shl_sext_sub"
  [(set (match_operand:SI 0 "register_operand" "=z")
        (sign_extract:SI (ashift:SI (match_operand:SI 1 "register_operand" "0")
				    (match_operand:SI 2 "const_int_operand" "n"))
			 (match_operand:SI 3 "const_int_operand" "n")
			 (const_int 0)))
   (clobber (reg:SI 18))]
  "(shl_sext_kind (operands[2], operands[3], 0) & ~1) == 6"
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_sext_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 4))
	       (const_string "8")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 5))
	       (const_string "10")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 6))
	       (const_string "12")]
	      (const_string "14")))
    (set_attr "type" "arith")])

;; These patterns are found in expansions of DImode shifts by 16, and
;; allow the xtrct instruction to be generated from C source.

(define_insn "xtrct_left"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
        (ior:SI (ashift:SI (match_operand:SI 1 "arith_reg_operand" "r")
			   (const_int 16))
 	        (lshiftrt:SI (match_operand:SI 2 "arith_reg_operand" "0")
			     (const_int 16))))]
  ""
  "xtrct	%1,%0"
  [(set_attr "type" "arith")])

(define_insn "xtrct_right"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
        (ior:SI (lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
			     (const_int 16))
 	        (ashift:SI (match_operand:SI 2 "arith_reg_operand" "r")
			   (const_int 16))))]
  ""
  "xtrct	%2,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Unary arithmetic
;; -------------------------------------------------------------------------

(define_insn "negc"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(neg:SI (plus:SI (reg:SI 18)
			 (match_operand:SI 1 "arith_reg_operand" "r"))))
   (set (reg:SI 18)
	(ne:SI (ior:SI (reg:SI 18) (match_dup 1))
	       (const_int 0)))]
  ""
  "negc	%1,%0"
  [(set_attr "type" "arith")])

(define_expand "negdi2"
  [(set (match_operand:DI 0 "arith_reg_operand" "")
	(neg:DI (match_operand:DI 1 "arith_reg_operand" "")))
   (clobber (reg:SI 18))]
  ""
  "
{
  int low_word = (TARGET_LITTLE_ENDIAN ? 0 : 1);
  int high_word = (TARGET_LITTLE_ENDIAN ? 1 : 0);

  rtx low_src = operand_subword (operands[1], low_word, 0, DImode);
  rtx high_src = operand_subword (operands[1], high_word, 0, DImode);

  rtx low_dst = operand_subword (operands[0], low_word, 1, DImode);
  rtx high_dst = operand_subword (operands[0], high_word, 1, DImode);

  emit_insn (gen_clrt ());
  emit_insn (gen_negc (low_dst, low_src));
  emit_insn (gen_negc (high_dst, high_src));
  DONE;
}")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(neg:SI (match_operand:SI 1 "arith_reg_operand" "r")))]
  ""
  "neg	%1,%0"
  [(set_attr "type" "arith")])

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(not:SI (match_operand:SI 1 "arith_reg_operand" "r")))]
  ""
  "not	%1,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Zero extension instructions
;; -------------------------------------------------------------------------

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(zero_extend:SI (match_operand:HI 1 "arith_reg_operand" "r")))]
  ""
  "extu.w	%1,%0"
  [(set_attr "type" "arith")])

(define_insn "zero_extendqisi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(zero_extend:SI (match_operand:QI 1 "arith_reg_operand" "r")))]
  ""
  "extu.b	%1,%0"
  [(set_attr "type" "arith")])

(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r")
	(zero_extend:HI (match_operand:QI 1 "arith_reg_operand" "r")))]
  ""
  "extu.b	%1,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Sign extension instructions
;; -------------------------------------------------------------------------

;; ??? This should be a define expand.
;; ??? Or perhaps it should be dropped?

/* There is no point in defining extendsidi2; convert_move generates good
   code for that.  */

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,r")
	(sign_extend:SI (match_operand:HI 1 "general_movsrc_operand" "r,m")))]
  ""
  "@
	exts.w	%1,%0
   	mov.w	%1,%0"
  [(set_attr "type" "arith,load")])

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,r")
	(sign_extend:SI (match_operand:QI 1 "general_movsrc_operand" "r,m")))]
  ""
  "@
	exts.b	%1,%0
	mov.b	%1,%0"
  [(set_attr "type" "arith,load")])

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r,r")
	(sign_extend:HI (match_operand:QI 1 "general_movsrc_operand" "r,m")))]
  ""
  "@
	exts.b	%1,%0
	mov.b	%1,%0"
  [(set_attr "type" "arith,load")])

;; -------------------------------------------------------------------------
;; Move instructions
;; -------------------------------------------------------------------------

;; define push and pop so it is easy for sh.c

(define_insn "push"
  [(set (mem:SI (pre_dec:SI (reg:SI 15)))
	(match_operand:SI 0 "register_operand" "r,l,x"))]
  ""
  "@
	mov.l	%0,@-r15
	sts.l	%0,@-r15
	sts.l	%0,@-r15"
  [(set_attr "type" "store,pstore,store")
   (set_attr "hit_stack" "yes")])

(define_insn "pop"
  [(set (match_operand:SI 0 "register_operand" "=r,l,x")
	(mem:SI (post_inc:SI (reg:SI 15))))]
  ""
  "@
	mov.l	@r15+,%0
	lds.l	@r15+,%0
	lds.l	@r15+,%0"
  [(set_attr "type" "load,pload,load")
   (set_attr "hit_stack" "yes")])

(define_insn "push_e"
  [(set (mem:SF (pre_dec:SI (reg:SI 15)))
	(match_operand:SF 0 "register_operand" "r,f,y"))]
  "TARGET_SH3E"
  "@
	mov.l	%0,@-r15
	fmov.s	%0,@-r15
	sts.l	%0,@-r15"
  [(set_attr "type" "store")
   (set_attr "hit_stack" "yes")])

(define_insn "pop_e"
  [(set (match_operand:SF 0 "register_operand" "=r,f,y")
	(mem:SF (post_inc:SI (reg:SI 15))))]
  "TARGET_SH3E"
  "@
	mov.l	@r15+,%0
	fmov.s	@r15+,%0
	lds.l	@r15+,%0"
  [(set_attr "type" "load")
   (set_attr "hit_stack" "yes")])

;; These two patterns can happen as the result of optimization, when
;; comparisons get simplified to a move of zero or 1 into the T reg.
;; They don't disappear completely, because the T reg is a fixed hard reg.

(define_insn "clrt"
  [(set (reg:SI 18) (const_int 0))]
  ""
  "clrt")

(define_insn "sett"
  [(set (reg:SI 18) (const_int 1))]
  ""
  "sett")

;; t/r is first, so that it will be preferred over r/r when reloading a move
;; of a pseudo-reg into the T reg
(define_insn "movsi_i"
  [(set (match_operand:SI 0 "general_movdst_operand" "=t,r,r,r,r,r,m,<,<,xl,x,l,r")
	(match_operand:SI 1 "general_movsrc_operand" "r,Q,rI,m,xl,t,r,x,l,r,>,>,i"))]
  "
   ! TARGET_SH3E
   && (register_operand (operands[0], SImode)
       || register_operand (operands[1], SImode))"
  "@
	cmp/pl	%1
	mov.l	%1,%0
	mov	%1,%0
	mov.l	%1,%0
	sts	%1,%0
	movt	%0
	mov.l	%1,%0
	sts.l	%1,%0
	sts.l	%1,%0
	lds	%1,%0
	lds.l	%1,%0
	lds.l	%1,%0
	fake	%1,%0"
  [(set_attr "type" "*,pcload_si,move,load_si,move,move,store,store,pstore,move,load,pload,pcload_si")
   (set_attr "length" "*,*,*,*,*,*,*,*,*,*,*,*,*")])

;; t/r must come after r/r, lest reload will try to reload stuff like
;; (subreg:SI (reg:SF 38 fr14) 0) into T (compiling stdlib/strtod.c -m3e -O2)
;; ??? This allows moves from macl to fpul to be recognized, but these moves
;; will require a reload.
(define_insn "movsi_ie"
  [(set (match_operand:SI 0 "general_movdst_operand" "=r,r,t,r,r,r,m,<,<,xl,x,l,r,y,r,y")
	(match_operand:SI 1 "general_movsrc_operand" "Q,rI,r,m,xl,t,r,x,l,r,>,>,i,r,y,y"))]
  "TARGET_SH3E
   && (register_operand (operands[0], SImode)
       || register_operand (operands[1], SImode))"
  "@
	mov.l	%1,%0
	mov	%1,%0
	cmp/pl	%1
	mov.l	%1,%0
	sts	%1,%0
	movt	%0
	mov.l	%1,%0
	sts.l	%1,%0
	sts.l	%1,%0
	lds	%1,%0
	lds.l	%1,%0
	lds.l	%1,%0
	fake	%1,%0
	lds	%1,%0
	sts	%1,%0
	! move optimized away"
  [(set_attr "type" "pcload_si,move,*,load_si,move,move,store,store,pstore,move,load,pload,pcload_si,gp_fpul,gp_fpul,nil")
   (set_attr "length" "*,*,*,*,*,*,*,*,*,*,*,*,*,*,*,0")])

(define_insn "movsi_i_lowpart"
  [(set (strict_low_part (match_operand:SI 0 "general_movdst_operand" "=r,r,r,r,r,m,r"))
	(match_operand:SI 1 "general_movsrc_operand" "Q,rI,m,xl,t,r,i"))]
   "register_operand (operands[0], SImode)
    || register_operand (operands[1], SImode)"
  "@
	mov.l	%1,%0
	mov	%1,%0
	mov.l	%1,%0
	sts	%1,%0
	movt	%0
	mov.l	%1,%0
	fake	%1,%0"
  [(set_attr "type" "pcload,move,load,move,move,store,pcload")])
(define_expand "movsi"
  [(set (match_operand:SI 0 "general_movdst_operand" "")
	(match_operand:SI 1 "general_movsrc_operand" ""))]
  ""
  "{ if (prepare_move_operands (operands, SImode)) DONE; }")

(define_insn "movqi_i"
  [(set (match_operand:QI 0 "general_movdst_operand" "=r,r,m,r,r,l")
	(match_operand:QI 1 "general_movsrc_operand"  "ri,m,r,t,l,r"))]
  "arith_reg_operand (operands[0], QImode)
   || arith_reg_operand (operands[1], QImode)"
  "@
	mov	%1,%0
	mov.b	%1,%0
	mov.b	%1,%0
	movt	%0
	sts	%1,%0
	lds	%1,%0"
 [(set_attr "type" "move,load,store,move,move,move")])

(define_expand "movqi"
  [(set (match_operand:QI 0 "general_operand" "")
	(match_operand:QI 1 "general_operand"  ""))]
  ""
  "{ if (prepare_move_operands (operands, QImode)) DONE; }")

(define_insn "movhi_i"
  [(set (match_operand:HI 0 "general_movdst_operand" "=r,r,r,r,m,r,l,r")
	(match_operand:HI 1 "general_movsrc_operand" "Q,rI,m,t,r,l,r,i"))]
  "arith_reg_operand (operands[0], HImode)
   || arith_reg_operand (operands[1], HImode)"
  "@
	mov.w	%1,%0
	mov	%1,%0
	mov.w	%1,%0
	movt	%0
	mov.w	%1,%0
	sts	%1,%0
	lds	%1,%0
	fake	%1,%0"
  [(set_attr "type" "pcload,move,load,move,store,move,move,pcload")])

(define_expand "movhi"
  [(set (match_operand:HI 0 "general_movdst_operand" "")
	(match_operand:HI 1 "general_movsrc_operand"  ""))]
  ""
  "{ if (prepare_move_operands (operands, HImode)) DONE; }")

;; ??? This should be a define expand.

;; x/r can be created by inlining/cse, e.g. for execute/961213-1.c
;; compiled with -m2 -ml -O3 -funroll-loops
(define_insn ""
  [(set (match_operand:DI 0 "general_movdst_operand" "=r,r,r,m,r,r,r,*!x")
	(match_operand:DI 1 "general_movsrc_operand" "Q,r,m,r,I,i,x,r"))]
  "arith_reg_operand (operands[0], DImode)
   || arith_reg_operand (operands[1], DImode)"
  "* return output_movedouble (insn, operands, DImode);"
  [(set_attr "length" "4")
   (set_attr "type" "pcload,move,load,store,move,pcload,move,move")])

;; If the output is a register and the input is memory or a register, we have
;; to be careful and see which word needs to be loaded first.  

(define_split
  [(set (match_operand:DI 0 "general_movdst_operand" "")
	(match_operand:DI 1 "general_movsrc_operand" ""))]
  "reload_completed"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 5))]
  "
{
  int regno;

  if ((GET_CODE (operands[0]) == MEM
       && GET_CODE (XEXP (operands[0], 0)) == PRE_DEC)
      || (GET_CODE (operands[1]) == MEM
	  && GET_CODE (XEXP (operands[1], 0)) == POST_INC))
    FAIL;

  if (GET_CODE (operands[0]) == REG)
    regno = REGNO (operands[0]);
  else if (GET_CODE (operands[0]) == SUBREG)
    regno = REGNO (SUBREG_REG (operands[0])) + SUBREG_WORD (operands[0]);
  else if (GET_CODE (operands[0]) == MEM)
    regno = -1;

  if (regno == -1
      || ! refers_to_regno_p (regno, regno + 1, operands[1], 0))
    {
      operands[2] = operand_subword (operands[0], 0, 0, DImode);
      operands[3] = operand_subword (operands[1], 0, 0, DImode);
      operands[4] = operand_subword (operands[0], 1, 0, DImode);
      operands[5] = operand_subword (operands[1], 1, 0, DImode);
    }
  else
    {
      operands[2] = operand_subword (operands[0], 1, 0, DImode);
      operands[3] = operand_subword (operands[1], 1, 0, DImode);
      operands[4] = operand_subword (operands[0], 0, 0, DImode);
      operands[5] = operand_subword (operands[1], 0, 0, DImode);
    }

  if (operands[2] == 0 || operands[3] == 0
      || operands[4] == 0 || operands[5] == 0)
    FAIL;
}")

(define_expand "movdi"
  [(set (match_operand:DI 0 "general_movdst_operand" "")
	(match_operand:DI 1 "general_movsrc_operand" ""))]
  ""
  "{ if ( prepare_move_operands (operands, DImode)) DONE; }")

;; ??? This should be a define expand.

(define_insn "movdf_k"
  [(set (match_operand:DF 0 "general_movdst_operand" "=r,r,r,m")
	(match_operand:DF 1 "general_movsrc_operand" "r,FQ,m,r"))]
  "arith_reg_operand (operands[0], DFmode)
   || arith_reg_operand (operands[1], DFmode)"
  "* return output_movedouble (insn, operands, DFmode);"
  [(set_attr "length" "4")
   (set_attr "type" "move,pcload,load,store")])

;; If the output is a register and the input is memory or a register, we have
;; to be careful and see which word needs to be loaded first.  

(define_split
  [(set (match_operand:DF 0 "general_movdst_operand" "")
	(match_operand:DF 1 "general_movsrc_operand" ""))]
  "reload_completed"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 5))]
  "
{
  int regno;

  if ((GET_CODE (operands[0]) == MEM
       && GET_CODE (XEXP (operands[0], 0)) == PRE_DEC)
      || (GET_CODE (operands[1]) == MEM
	  && GET_CODE (XEXP (operands[1], 0)) == POST_INC))
    FAIL;

  if (GET_CODE (operands[0]) == REG)
    regno = REGNO (operands[0]);
  else if (GET_CODE (operands[0]) == SUBREG)
    regno = REGNO (SUBREG_REG (operands[0])) + SUBREG_WORD (operands[0]);
  else if (GET_CODE (operands[0]) == MEM)
    regno = -1;

  if (regno == -1
      || ! refers_to_regno_p (regno, regno + 1, operands[1], 0))
    {
      operands[2] = operand_subword (operands[0], 0, 0, DFmode);
      operands[3] = operand_subword (operands[1], 0, 0, DFmode);
      operands[4] = operand_subword (operands[0], 1, 0, DFmode);
      operands[5] = operand_subword (operands[1], 1, 0, DFmode);
    }
  else
    {
      operands[2] = operand_subword (operands[0], 1, 0, DFmode);
      operands[3] = operand_subword (operands[1], 1, 0, DFmode);
      operands[4] = operand_subword (operands[0], 0, 0, DFmode);
      operands[5] = operand_subword (operands[1], 0, 0, DFmode);
    }

  if (operands[2] == 0 || operands[3] == 0
      || operands[4] == 0 || operands[5] == 0)
    FAIL;
}")

;; If a base address generated by LEGITIMIZE_ADDRESS for SImode is
;; used only once, let combine add in the index again.

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(match_operand:SI 1 "" ""))
   (clobber (match_operand 2 "register_operand" ""))]
  "! reload_in_progress && ! reload_completed"
  [(use (reg:SI 0))]
  "
{
  rtx addr, reg, const_int;

  if (GET_CODE (operands[1]) != MEM)
    FAIL;
  addr = XEXP (operands[1], 0);
  if (GET_CODE (addr) != PLUS)
    FAIL;
  reg = XEXP (addr, 0);
  const_int = XEXP (addr, 1);
  if (GET_CODE (reg) != REG || GET_CODE (const_int) != CONST_INT)
    FAIL;
  emit_move_insn (operands[2], const_int);
  emit_move_insn (operands[0],
		  change_address (operands[1], VOIDmode,
				  gen_rtx (PLUS, SImode, reg, operands[2])));
  DONE;
}")

(define_split
  [(set (match_operand:SI 1 "" "")
	(match_operand:SI 0 "register_operand" ""))
   (clobber (match_operand 2 "register_operand" ""))]
  "! reload_in_progress && ! reload_completed"
  [(use (reg:SI 0))]
  "
{
  rtx addr, reg, const_int;

  if (GET_CODE (operands[1]) != MEM)
    FAIL;
  addr = XEXP (operands[1], 0);
  if (GET_CODE (addr) != PLUS)
    FAIL;
  reg = XEXP (addr, 0);
  const_int = XEXP (addr, 1);
  if (GET_CODE (reg) != REG || GET_CODE (const_int) != CONST_INT)
    FAIL;
  emit_move_insn (operands[2], const_int);
  emit_move_insn (change_address (operands[1], VOIDmode,
				  gen_rtx (PLUS, SImode, reg, operands[2])),
		  operands[0]);
  DONE;
}")

(define_expand "movdf"
  [(set (match_operand:DF 0 "general_movdst_operand" "")
	(match_operand:DF 1 "general_movsrc_operand" ""))]
  ""
  "
{
  if (prepare_move_operands (operands, DFmode)) DONE;
}")


(define_insn "movsf_i"
  [(set (match_operand:SF 0 "general_movdst_operand" "=r,r,r,r,m,l,r")
	(match_operand:SF 1 "general_movsrc_operand"  "r,I,FQ,m,r,r,l"))]
  "
   ! TARGET_SH3E
   && (arith_reg_operand (operands[0], SFmode)
       || arith_reg_operand (operands[1], SFmode))"
  "@
	mov	%1,%0
	mov	%1,%0
	mov.l	%1,%0
	mov.l	%1,%0
	mov.l	%1,%0
	lds	%1,%0
	sts	%1,%0"
  [(set_attr "type" "move,move,pcload,load,store,move,move")])

;; We may not split the ry/yr/XX alternatives to movsi_ie, since
;; update_flow_info would not know where to put REG_EQUAL notes
;; when the destination changes mode.
(define_insn "movsf_ie"
  [(set (match_operand:SF 0 "general_movdst_operand"
	 "=f,r,f,f,fy,f,m,r,r,m,f,y,y,rf,r,y,y")
	(match_operand:SF 1 "general_movsrc_operand"
	  "f,r,G,H,FQ,m,f,FQ,m,r,y,f,>,fr,y,r,y"))
   (clobber (match_scratch:SI 2 "=X,X,X,X,&z,X,X,X,X,X,X,X,X,y,X,X,X"))]

  "TARGET_SH3E
   && (arith_reg_operand (operands[0], SFmode)
       || arith_reg_operand (operands[1], SFmode))"
  "@
	fmov	%1,%0
	mov	%1,%0
	fldi0	%0
	fldi1	%0
	#
	fmov.s	%1,%0
	fmov.s	%1,%0
	mov.l	%1,%0
	mov.l	%1,%0
	mov.l	%1,%0
	fsts	fpul,%0
	flds	%1,fpul
	lds.l	%1,%0
	#
	sts	%1,%0
	lds	%1,%0
	! move optimized away"
  [(set_attr "type" "fmove,move,fmove,fmove,pcload,load,store,pcload,load,store,fmove,fmove,load,*,gp_fpul,gp_fpul,nil")
   (set_attr "length" "*,*,*,*,4,*,*,*,*,*,2,2,2,*,2,2,0")])

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(match_operand:SF 1 "register_operand" ""))
   (clobber (reg:SI 22))]
  ""
  [(parallel [(set (reg:SF 22) (match_dup 1))
	      (clobber (scratch:SI))])
   (parallel [(set (match_dup 0) (reg:SF 22))
	      (clobber (scratch:SI))])]
  "")

(define_expand "movsf"
  [(set (match_operand:SF 0 "general_movdst_operand" "")
        (match_operand:SF 1 "general_movsrc_operand" ""))]
  ""
  "
{
  if (prepare_move_operands (operands, SFmode))
    DONE;
  if (TARGET_SH3E)
    {
      emit_insn (gen_movsf_ie (operands[0], operands[1]));
      DONE;
    }
}")

(define_expand "reload_insf"
  [(parallel [(set (match_operand:SF 0 "register_operand" "=f")
		   (match_operand:SF 1 "immediate_operand" "FQ"))
	      (clobber (match_operand:SI 2 "register_operand" "=&z"))])]
  ""
  "")

;; ------------------------------------------------------------------------
;; Define the real conditional branch instructions.
;; ------------------------------------------------------------------------

(define_insn "branch_true"
  [(set (pc) (if_then_else (ne (reg:SI 18) (const_int 0))
			   (label_ref (match_operand 0 "" ""))
			   (pc)))]
  ""
  "* return output_branch (1, insn, operands);"
  [(set_attr "type" "cbranch")])

(define_insn "branch_false"
  [(set (pc) (if_then_else (eq (reg:SI 18) (const_int 0))
			   (label_ref (match_operand 0 "" ""))
			   (pc)))]
  ""
  "* return output_branch (0, insn, operands);"
  [(set_attr "type" "cbranch")])

;; Patterns to prevent reorg from re-combining a condbranch with a branch
;; which destination is too far away.
;; The const_int_operand is distinct for each branch target; it avoids
;; unwanted matches with redundant_insn.
(define_insn "block_branch_redirect"
  [(set (pc) (unspec [(match_operand 0 "const_int_operand" "")] 4))]
  ""
  ""
  [(set_attr "length" "0")])

;; This one has the additional purpose to record a possible scratch register
;; for the following branch.
(define_insn "indirect_jump_scratch"
  [(set (match_operand 0 "register_operand" "r")
	(unspec [(match_operand 1 "const_int_operand" "")] 4))]
  ""
  ""
  [(set_attr "length" "0")])

;; Conditional branch insns

(define_expand "beq"
  [(set (pc)
	(if_then_else (ne (reg:SI 18) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, EQ);")

(define_expand "bne"
  [(set (pc)
	(if_then_else (eq (reg:SI 18) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, EQ);")

(define_expand "bgt"
  [(set (pc)
	(if_then_else (ne (reg:SI 18) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, GT);")

(define_expand "blt"
  [(set (pc)
	(if_then_else (eq (reg:SI 18) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  if (GET_MODE (sh_compare_op0) == SFmode)
    {
      rtx tmp = sh_compare_op0;
      sh_compare_op0 = sh_compare_op1;
      sh_compare_op1 = tmp;
      emit_insn (gen_bgt (operands[0]));
      DONE;
    }
  from_compare (operands, GE);
}")

(define_expand "ble"
  [(set (pc)
	(if_then_else (eq (reg:SI 18) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  if (TARGET_SH3E
      && TARGET_IEEE
      && GET_MODE_CLASS (GET_MODE (sh_compare_op0)) == MODE_FLOAT)
    {
      rtx tmp = sh_compare_op0;
      sh_compare_op0 = sh_compare_op1;
      sh_compare_op1 = tmp;
      emit_insn (gen_bge (operands[0]));
      DONE;
    }
  from_compare (operands, GT);
}")

(define_expand "bge"
  [(set (pc)
	(if_then_else (ne (reg:SI 18) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  if (TARGET_SH3E
      && ! TARGET_IEEE
      && GET_MODE_CLASS (GET_MODE (sh_compare_op0)) == MODE_FLOAT)
    {
      rtx tmp = sh_compare_op0;
      sh_compare_op0 = sh_compare_op1;
      sh_compare_op1 = tmp;
      emit_insn (gen_ble (operands[0]));
      DONE;
    }
  from_compare (operands, GE);
}")

(define_expand "bgtu"
  [(set (pc)
	(if_then_else (ne (reg:SI 18) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, GTU); ")

(define_expand "bltu"
  [(set (pc)
		  (if_then_else (eq (reg:SI 18) (const_int 0))
				(label_ref (match_operand 0 "" ""))
				(pc)))]
  ""
  "from_compare (operands, GEU);")

(define_expand "bgeu"
  [(set (pc)
	(if_then_else (ne (reg:SI 18) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, GEU);")

(define_expand "bleu"
  [(set (pc)
	(if_then_else (eq (reg:SI 18) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, GTU);")

;; ------------------------------------------------------------------------
;; Jump and linkage insns
;; ------------------------------------------------------------------------

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "*
{
  /* The length is 16 if the delay slot is unfilled.  */
  if (get_attr_length(insn) > 4)
    return output_far_jump(insn, operands[0]);
  else
    return   \"bra	%l0%#\";
}"
  [(set_attr "type" "jump")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "calli"
  [(call (mem:SI (match_operand:SI 0 "arith_reg_operand" "r"))
	 (match_operand 1 "" ""))
   (clobber (reg:SI 17))]
  ""
  "jsr	@%0%#"
  [(set_attr "type" "call")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "call_valuei"
  [(set (match_operand 0 "" "=rf")
	(call (mem:SI (match_operand:SI 1 "arith_reg_operand" "r"))
	      (match_operand 2 "" "")))
   (clobber (reg:SI 17))]
  ""
  "jsr	@%1%#"
  [(set_attr "type" "call")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "call"
  [(parallel [(call (mem:SI (match_operand 0 "arith_reg_operand" ""))
			    (match_operand 1 "" ""))
	      (clobber (reg:SI 17))])]
  ""
  "operands[0] = force_reg (SImode, XEXP (operands[0], 0));")

(define_expand "call_value"
  [(parallel [(set (match_operand 0 "arith_reg_operand" "")
		   (call (mem:SI (match_operand 1 "arith_reg_operand" ""))
				 (match_operand 2 "" "")))
	      (clobber (reg:SI 17))])]
  ""
  "operands[1] = force_reg (SImode, XEXP (operands[1], 0));")

(define_insn "indirect_jump"
  [(set (pc)
	(match_operand:SI 0 "arith_reg_operand" "r"))]
  ""
  "jmp	@%0%#"
  [(set_attr "needs_delay_slot" "yes")
   (set_attr "type" "jump_ind")])

;; The use of operand 1 / 2 helps us distinguish case table jumps
;; which can be present in structured code from indirect jumps which can not
;; be present in structured code.  This allows -fprofile-arcs to work.

;; For SH1 processors.
(define_insn "casesi_jump_1"
  [(set (pc)
	(match_operand:SI 0 "register_operand" "r"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "jmp  @%0%#"
  [(set_attr "needs_delay_slot" "yes")
   (set_attr "type" "jump_ind")])

;; For all later processors.
(define_insn "casesi_jump_2"
  [(set (pc) (plus:SI (match_operand:SI 0 "register_operand" "r")
		      (match_operand 1 "braf_label_ref_operand" "")))
   (use (label_ref (match_operand 2 "" "")))]
  ""
  "braf	%0%#"
  [(set_attr "needs_delay_slot" "yes")
   (set_attr "type" "jump_ind")])

(define_insn "dummy_jump"
  [(set (pc) (const_int 0))]
  ""
  ""
  [(set_attr "length" "0")])

;; Call subroutine returning any type.
;; ??? This probably doesn't work.

(define_expand "untyped_call"
  [(parallel [(call (match_operand 0 "" "")
		    (const_int 0))
	      (match_operand 1 "" "")
	      (match_operand 2 "" "")])]
  "TARGET_SH3E"
  "
{
  int i;

  emit_call_insn (gen_call (operands[0], const0_rtx, const0_rtx, const0_rtx));

  for (i = 0; i < XVECLEN (operands[2], 0); i++)
    {
      rtx set = XVECEXP (operands[2], 0, i);
      emit_move_insn (SET_DEST (set), SET_SRC (set));
    }

  /* The optimizer does not know that the call sets the function value
     registers we stored in the result block.  We avoid problems by
     claiming that all hard registers are used and clobbered at this
     point.  */
  emit_insn (gen_blockage ());

  DONE;
}")

;; ------------------------------------------------------------------------
;; Misc insns
;; ------------------------------------------------------------------------

(define_insn "dect"
  [(set (reg:SI 18)
	(eq:SI (match_operand:SI 0 "arith_reg_operand" "+r") (const_int 1)))
   (set (match_dup 0) (plus:SI (match_dup 0) (const_int -1)))]
  "TARGET_SH2"
  "dt	%0"
  [(set_attr "type" "arith")])

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")

;; Load address of a label. This is only generated by the casesi expand,
;; and by machine_dependent_reorg (fixing up fp moves).
;; This must use unspec, because this only works for labels that are
;; within range,

(define_insn "mova"
  [(set (reg:SI 0)
	(unspec [(label_ref (match_operand 0 "" ""))] 1))]
  ""
  "mova	%O0,r0"
  [(set_attr "in_delay_slot" "no")
   (set_attr "type" "arith")])

;; case instruction for switch statements.

;; Operand 0 is index
;; operand 1 is the minimum bound
;; operand 2 is the maximum bound - minimum bound + 1
;; operand 3 is CODE_LABEL for the table;
;; operand 4 is the CODE_LABEL to go to if index out of range.

(define_expand "casesi"
  [(match_operand:SI 0 "arith_reg_operand" "")
   (match_operand:SI 1 "arith_reg_operand" "")
   (match_operand:SI 2 "arith_reg_operand" "")
   (match_operand 3 "" "") (match_operand 4 "" "")]
  ""
  "
{
  rtx reg = gen_reg_rtx (SImode);
  rtx reg2 = gen_reg_rtx (SImode);
  operands[1] = copy_to_mode_reg (SImode, operands[1]);
  operands[2] = copy_to_mode_reg (SImode, operands[2]);
  /* If optimizing, casesi_worker depends on the mode of the instruction
     before label it 'uses' - operands[3].  */
  emit_insn (gen_casesi_0 (operands[0], operands[1], operands[2], operands[4],
			   reg));
  emit_insn (gen_casesi_worker_0 (reg2, reg, operands[3]));
  if (TARGET_SH2)
    {
      rtx lab = gen_label_rtx ();
      emit_jump_insn (gen_casesi_jump_2 (reg2,
					 gen_rtx (LABEL_REF, VOIDmode, lab),
					 operands[3]));
      emit_label (lab);
      /* Put a fake jump after the label, lest some optimization might
	 delete the barrier and LAB.  */
      emit_jump_insn (gen_dummy_jump ());
    }
  else
    {
      emit_jump_insn (gen_casesi_jump_1 (reg2, operands[3]));
    }
  /* For SH2 and newer, the ADDR_DIFF_VEC is not actually relative to
     operands[3], but to lab.  We will fix this up in
     machine_dependent_reorg.  */
  emit_barrier ();
  DONE;
}")

(define_expand "casesi_0"
  [(set (match_operand:SI 4 "" "") (match_operand:SI 0 "arith_reg_operand" ""))
   (set (match_dup 4) (minus:SI (match_dup 4)
				(match_operand:SI 1 "arith_operand" "")))
   (set (reg:SI 18)
	(gtu:SI (match_dup 4)
		(match_operand:SI 2 "arith_reg_operand" "")))
   (set (pc)
	(if_then_else (ne (reg:SI 18)
			  (const_int 0))
		      (label_ref (match_operand 3 "" ""))
		      (pc)))]
  ""
  "")

;; ??? reload might clobber r0 if we use it explicitly in the RTL before
;; reload; using a R0_REGS pseudo reg is likely to give poor code.
;; So we keep the use of r0 hidden in a R0_REGS clobber until after reload.

(define_insn "casesi_worker_0"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(unspec [(match_operand 1 "register_operand" "0,r")
		 (label_ref (match_operand 2 "" ""))] 2))
   (clobber (match_scratch:SI 3 "=X,1"))
   (clobber (match_scratch:SI 4 "=&z,z"))]
  ""
  "#")

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(unspec [(match_operand 1 "register_operand" "")
		 (label_ref (match_operand 2 "" ""))] 2))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "! TARGET_SH2 && reload_completed"
  [(set (reg:SI 0) (unspec [(label_ref (match_dup 2))] 1))
   (parallel [(set (match_dup 0)
	      (unspec [(reg:SI 0) (match_dup 1) (label_ref (match_dup 2))] 2))
	      (clobber (match_dup 3))])
   (set (match_dup 0) (plus:SI (match_dup 0) (reg:SI 0)))]
  "LABEL_NUSES (operands[2])++;")

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(unspec [(match_operand 1 "register_operand" "")
		 (label_ref (match_operand 2 "" ""))] 2))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_SH2 && reload_completed"
  [(set (reg:SI 0) (unspec [(label_ref (match_dup 2))] 1))
   (parallel [(set (match_dup 0)
	      (unspec [(reg:SI 0) (match_dup 1) (label_ref (match_dup 2))] 2))
	      (clobber (match_dup 3))])]
  "LABEL_NUSES (operands[2])++;")

(define_insn "*casesi_worker"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(unspec [(reg:SI 0) (match_operand 1 "register_operand" "0,r")
		 (label_ref (match_operand 2 "" ""))] 2))
   (clobber (match_scratch:SI 3 "=X,1"))]
  ""
  "*
{
  rtx diff_vec = PATTERN (next_real_insn (operands[2]));

  if (GET_CODE (diff_vec) != ADDR_DIFF_VEC)
    abort ();

  switch (GET_MODE (diff_vec))
    {
    case SImode:
      return \"shll2	%1\;mov.l	@(r0,%1),%0\";
    case HImode:
      return \"add	%1,%1\;mov.w	@(r0,%1),%0\";
    case QImode:
      if (ADDR_DIFF_VEC_FLAGS (diff_vec).offset_unsigned)
	return \"mov.b	@(r0,%1),%0\;extu.b	%0,%0\";
      return \"mov.b	@(r0,%1),%0\";
    default:
      abort ();
    }
}"
  [(set_attr "length" "4")])

(define_insn "return"
  [(return)]
  "reload_completed"
  "%@	%#"
  [(set_attr "type" "return")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "prologue"
  [(const_int 0)]
  ""
  "sh_expand_prologue (); DONE;")

(define_expand "epilogue"
  [(return)]
  ""
  "sh_expand_epilogue ();")

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] 0)]
  ""
  ""
  [(set_attr "length" "0")])

;; ------------------------------------------------------------------------
;; Scc instructions
;; ------------------------------------------------------------------------

(define_insn "movt"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(eq:SI (reg:SI 18) (const_int 1)))]
  ""
  "movt	%0"
  [(set_attr "type" "arith")])

(define_expand "seq"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (EQ);")

(define_expand "slt"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (LT);")

(define_expand "sle"
  [(match_operand:SI 0 "arith_reg_operand" "")]
  ""
  "
{
  rtx tmp = sh_compare_op0;
  sh_compare_op0 = sh_compare_op1;
  sh_compare_op1 = tmp;
  emit_insn (gen_sge (operands[0]));
  DONE;
}")

(define_expand "sgt"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (GT);")

(define_expand "sge"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "
{
  if (GET_MODE (sh_compare_op0) == SFmode)
    {
      if (TARGET_IEEE)
	{
	  rtx t_reg = gen_rtx (REG, SImode, T_REG);
	  rtx lab = gen_label_rtx ();
	  emit_insn (gen_rtx (SET, VOIDmode, t_reg,
			      gen_rtx (EQ, SImode, sh_compare_op0,
				       sh_compare_op1)));
	  emit_jump_insn (gen_branch_true (lab));
	  emit_insn (gen_rtx (SET, VOIDmode, t_reg,
			      gen_rtx (GT, SImode, sh_compare_op0,
				       sh_compare_op1)));
	  emit_label (lab);
	  emit_insn (gen_movt (operands[0]));
	}
      else
	emit_insn (gen_movnegt (operands[0], prepare_scc_operands (LT)));
      DONE;
    }
  operands[1] = prepare_scc_operands (GE);
}")

(define_expand "sgtu"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (GTU);")

(define_expand "sltu"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (LTU);")

(define_expand "sleu"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (LEU);")

(define_expand "sgeu"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (GEU);")

;; sne moves the complement of the T reg to DEST like this:
;;      cmp/eq ...
;;      mov    #-1,temp
;;      negc   temp,dest
;;   This is better than xoring compare result with 1 because it does
;;   not require r0 and further, the -1 may be CSE-ed or lifted out of a
;;   loop.

(define_expand "sne"
  [(set (match_dup 2) (const_int -1))
   (parallel [(set (match_operand:SI 0 "arith_reg_operand" "")
		   (neg:SI (plus:SI (match_dup 1)
				    (match_dup 2))))
	      (set (reg:SI 18)
		   (ne:SI (ior:SI (match_dup 1) (match_dup 2))
			  (const_int 0)))])]  
  ""
  "
{
   operands[1] = prepare_scc_operands (EQ);
   operands[2] = gen_reg_rtx (SImode);
}")

;; Use the same trick for FP sle / sge
(define_expand "movnegt"
  [(set (match_dup 2) (const_int -1))
   (parallel [(set (match_operand 0 "" "")
		   (neg:SI (plus:SI (match_dup 1)
				    (match_dup 2))))
	      (set (reg:SI 18)
		   (ne:SI (ior:SI (match_operand 1 "" "") (match_dup 2))
			  (const_int 0)))])]  
  ""
  "operands[2] = gen_reg_rtx (SImode);")

;; Recognize mov #-1/negc/neg sequence, and change it to movt/add #-1.
;; This prevents a regression that occurred when we switched from xor to
;; mov/neg for sne.

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(plus:SI (reg:SI 18)
		 (const_int -1)))]
  ""
  [(set (match_dup 0) (eq:SI (reg:SI 18) (const_int 1)))
   (set (match_dup 0) (plus:SI (match_dup 0) (const_int -1)))]
  "")

;; -------------------------------------------------------------------------
;; Instructions to cope with inline literal tables
;; -------------------------------------------------------------------------

; 2 byte integer in line

(define_insn "consttable_2"
 [(unspec_volatile [(match_operand:SI 0 "general_operand" "=g")] 2)]
 ""
 "*
{
  assemble_integer (operands[0], 2, 1);
  return \"\";
}"
 [(set_attr "length" "2")
 (set_attr "in_delay_slot" "no")])

; 4 byte integer in line

(define_insn "consttable_4"
 [(unspec_volatile [(match_operand:SI 0 "general_operand" "=g")] 4)]
 ""
 "*
{
  assemble_integer (operands[0], 4, 1);
  return \"\";
}"
 [(set_attr "length" "4")
  (set_attr "in_delay_slot" "no")])

; 8 byte integer in line

(define_insn "consttable_8"
 [(unspec_volatile [(match_operand:SI 0 "general_operand" "=g")] 6)]
 ""
 "*
{
  assemble_integer (operands[0], 8, 1);
  return \"\";
}"
 [(set_attr "length" "8")
  (set_attr "in_delay_slot" "no")])

; 4 byte floating point

(define_insn "consttable_sf"
 [(unspec_volatile [(match_operand:SF 0 "general_operand" "=g")] 4)]
 ""
 "*
{
  union real_extract u;
  bcopy ((char *) &CONST_DOUBLE_LOW (operands[0]), (char *) &u, sizeof u);
  assemble_real (u.d, SFmode);
  return \"\";
}"
 [(set_attr "length" "4")
  (set_attr "in_delay_slot" "no")])

; 8 byte floating point

(define_insn "consttable_df"
 [(unspec_volatile [(match_operand:DF 0 "general_operand" "=g")] 6)]
 ""
 "*
{
  union real_extract u;
  bcopy ((char *) &CONST_DOUBLE_LOW (operands[0]), (char *) &u, sizeof u);
  assemble_real (u.d, DFmode);
  return \"\";
}"
 [(set_attr "length" "8")
  (set_attr "in_delay_slot" "no")])

;; Alignment is needed for some constant tables; it may also be added for
;; Instructions at the start of loops, or after unconditional branches.
;; ??? We would get more accurate lengths if we did instruction
;; alignment based on the value of INSN_CURRENT_ADDRESS; the approach used
;; here is too conservative.

; align to a two byte boundary

(define_expand "align_2"
 [(unspec_volatile [(const_int 1)] 1)]
 ""
 "")

; align to a four byte boundary
;; align_4 and align_log are instructions for the starts of loops, or
;; after unconditional branches, which may take up extra room.

(define_expand "align_4"
 [(unspec_volatile [(const_int 2)] 1)]
 ""
 "")

; align to a cache line boundary

(define_insn "align_log"
 [(unspec_volatile [(match_operand 0 "const_int_operand" "")] 1)]
 ""
 ""
 [(set_attr "length" "0")
  (set_attr "in_delay_slot" "no")])

; emitted at the end of the literal table, used to emit the
; 32bit branch labels if needed.

(define_insn "consttable_end"
  [(unspec_volatile [(const_int 0)] 11)]
  ""
  "* return output_jump_label_table ();"
  [(set_attr "in_delay_slot" "no")])

;; -------------------------------------------------------------------------
;; Misc
;; -------------------------------------------------------------------------

;; String/block move insn.

(define_expand "movstrsi"
  [(parallel [(set (mem:BLK (match_operand:BLK 0 "" ""))
		   (mem:BLK (match_operand:BLK 1 "" "")))
	      (use (match_operand:SI 2 "nonmemory_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (clobber (reg:SI 17))
	      (clobber (reg:SI 4))
	      (clobber (reg:SI 5))
	      (clobber (reg:SI 0))])]
  ""
  "
{
  if(expand_block_move (operands))
     DONE;
  else FAIL;
}")

(define_insn "block_move_real"
  [(parallel [(set (mem:BLK (reg:SI 4))
		   (mem:BLK (reg:SI 5)))
	      (use (match_operand:SI 0 "arith_reg_operand" "r"))
	      (clobber (reg:SI 17))
	      (clobber (reg:SI 0))])]
  ""
  "jsr	@%0%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "block_lump_real"
  [(parallel [(set (mem:BLK (reg:SI 4))
		   (mem:BLK (reg:SI 5)))
	      (use (match_operand:SI 0 "arith_reg_operand" "r"))
	      (use (reg:SI 6))
	      (clobber (reg:SI 17))
	      (clobber (reg:SI 4))
	      (clobber (reg:SI 5))
	      (clobber (reg:SI 6))
	      (clobber (reg:SI 0))])]
  ""
  "jsr	@%0%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

;; -------------------------------------------------------------------------
;; Floating point instructions.
;; -------------------------------------------------------------------------

;; ??? All patterns should have a type attribute.

(define_insn "addsf3"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "arith_reg_operand" "%0")
		 (match_operand:SF 2 "arith_reg_operand" "f")))]
  "TARGET_SH3E"
  "fadd	%2,%0"
  [(set_attr "type" "fp")])

(define_insn "subsf3"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "arith_reg_operand" "0")
		 (match_operand:SF 2 "arith_reg_operand" "f")))]
  "TARGET_SH3E"
  "fsub	%2,%0"
  [(set_attr "type" "fp")])

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "arith_reg_operand" "%0")
		 (match_operand:SF 2 "arith_reg_operand" "f")))]
  "TARGET_SH3E"
  "fmul	%2,%0"
  [(set_attr "type" "fp")])

(define_insn "*macsf3"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(plus:SF (mult:SF (match_operand:SF 1 "arith_reg_operand" "%w")
			  (match_operand:SF 2 "arith_reg_operand" "f"))
		 (match_operand:SF 3 "arith_reg_operand" "0")))]
  "TARGET_SH3E"
  "fmac	fr0,%2,%0"
  [(set_attr "type" "fp")])

(define_insn "divsf3"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(div:SF (match_operand:SF 1 "arith_reg_operand" "0")
		 (match_operand:SF 2 "arith_reg_operand" "f")))]
  "TARGET_SH3E"
  "fdiv	%2,%0"
  [(set_attr "type" "fdiv")])

(define_expand "floatsisf2"
  [(set (reg:SI 22)
	(match_operand:SI 1 "arith_reg_operand" ""))
   (set (match_operand:SF 0 "arith_reg_operand" "")
        (float:SF (reg:SI 22)))]
  "TARGET_SH3E"
  "")

(define_insn "*floatsisf2_ie"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(float:SF (reg:SI 22)))]
  "TARGET_SH3E"
  "float	fpul,%0"
  [(set_attr "type" "fp")])

(define_expand "fix_truncsfsi2"
  [(set (reg:SI 22)
	(fix:SI (match_operand:SF 1 "arith_reg_operand" "f")))
   (set (match_operand:SI 0 "arith_reg_operand" "=r")
	(reg:SI 22))]
  "TARGET_SH3E"
  "")

(define_insn "*fixsfsi"
  [(set (reg:SI 22)
	(fix:SI (match_operand:SF 0 "arith_reg_operand" "f")))]
  "TARGET_SH3E"
  "ftrc	%0,fpul"
  [(set_attr "type" "fp")])

(define_insn "cmpgtsf_t"
  [(set (reg:SI 18) (gt:SI (match_operand:SF 0 "arith_reg_operand" "f")
			   (match_operand:SF 1 "arith_reg_operand" "f")))]
  "TARGET_SH3E"
  "fcmp/gt	%1,%0"
  [(set_attr "type" "fp")])

(define_insn "cmpeqsf_t"
  [(set (reg:SI 18) (eq:SI (match_operand:SF 0 "arith_reg_operand" "f")
			   (match_operand:SF 1 "arith_reg_operand" "f")))]
  "TARGET_SH3E"
  "fcmp/eq	%1,%0"
  [(set_attr "type" "fp")])

(define_insn "ieee_ccmpeqsf_t"
  [(set (reg:SI 18) (ior:SI (reg:SI 18)
			    (eq:SI (match_operand:SF 0 "arith_reg_operand" "f")
				   (match_operand:SF 1 "arith_reg_operand" "f"))))]
  "TARGET_SH3E && TARGET_IEEE"
  "* return output_ieee_ccmpeq (insn, operands);"
  [(set_attr "length" "4")])


(define_expand "cmpsf"
  [(set (reg:SI 18) (compare (match_operand:SF 0 "arith_operand" "")
			     (match_operand:SF 1 "arith_operand" "")))]
  "TARGET_SH3E"
  "
{
  sh_compare_op0 = operands[0];
  sh_compare_op1 = operands[1];
  DONE;
}")

(define_insn "negsf2"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(neg:SF (match_operand:SF 1 "arith_reg_operand" "0")))]
  "TARGET_SH3E"
  "fneg	%0"
  [(set_attr "type" "fp")])

(define_insn "sqrtsf2"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(sqrt:DF (match_operand:SF 1 "arith_reg_operand" "0")))]
  "TARGET_SH3E"
  "fsqrt	%0"
  [(set_attr "type" "fdiv")])

(define_insn "abssf2"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(abs:SF (match_operand:SF 1 "arith_reg_operand" "0")))]
  "TARGET_SH3E"
  "fabs	%0"
  [(set_attr "type" "fp")])

;; Bit field extract patterns.  These give better code for packed bitfields,
;; because they allow auto-increment addresses to be generated.

(define_expand "insv"
  [(set (zero_extract:SI (match_operand:QI 0 "memory_operand" "")
			 (match_operand:SI 1 "immediate_operand" "")
			 (match_operand:SI 2 "immediate_operand" ""))
	(match_operand:SI 3 "general_operand" ""))]
  "! TARGET_LITTLE_ENDIAN"
  "
{
  rtx addr_target, orig_address, shift_reg;
  HOST_WIDE_INT size;

  /* ??? expmed doesn't care for non-register predicates.  */
  if (! memory_operand (operands[0], VOIDmode)
      || ! immediate_operand (operands[1], VOIDmode)
      || ! immediate_operand (operands[2], VOIDmode)
      || ! general_operand (operands[3], VOIDmode))
    FAIL;
  /* If this isn't a 16 / 24 / 32 bit field, or if
     it doesn't start on a byte boundary, then fail.  */
  size = INTVAL (operands[1]);
  if (size < 16 || size > 32 || size % 8 != 0
      || (INTVAL (operands[2]) % 8) != 0)
    FAIL;

  size /= 8;
  orig_address = XEXP (operands[0], 0);
  addr_target = gen_reg_rtx (SImode);
  shift_reg = gen_reg_rtx (SImode);
  emit_insn (gen_movsi (shift_reg, operands[3]));
  emit_insn (gen_addsi3 (addr_target, orig_address, GEN_INT (size - 1)));

  operands[0] = change_address (operands[0], QImode, addr_target);
  emit_insn (gen_movqi (operands[0], gen_rtx (SUBREG, QImode, shift_reg, 0)));

  while (size -= 1)
    {
      emit_insn (gen_lshrsi3_k (shift_reg, shift_reg, GEN_INT (8)));
      emit_insn (gen_addsi3 (addr_target, addr_target, GEN_INT (-1)));
      emit_insn (gen_movqi (operands[0],
			    gen_rtx (SUBREG, QImode, shift_reg, 0)));
    }

  DONE;
}")

;; -------------------------------------------------------------------------
;; Peepholes
;; -------------------------------------------------------------------------

;; This matches cases where a stack pointer increment at the start of the
;; epilogue combines with a stack slot read loading the return value.

(define_peephole
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(mem:SI (match_operand:SI 1 "arith_reg_operand" "")))
   (set (match_dup 1) (plus:SI (match_dup 1) (const_int 4)))]
  "REGNO (operands[1]) != REGNO (operands[0])"
  "mov.l	@%1+,%0")

;; See the comment on the dt combiner pattern above.

(define_peephole
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(plus:SI (match_dup 0)
		 (const_int -1)))
   (set (reg:SI 18)
	(eq:SI (match_dup 0)
	       (const_int 0)))]
  "TARGET_SH2"
  "dt	%0")

;; These convert sequences such as `mov #k,r0; add r15,r0; mov.l @r0,rn'
;; to `mov #k,r0; mov.l @(r0,r15),rn'.  These sequences are generated by
;; reload when the constant is too large for a reg+offset address.

;; ??? We would get much better code if this was done in reload.  This would
;; require modifying find_reloads_address to recognize that if the constant
;; is out-of-range for an immediate add, then we get better code by reloading
;; the constant into a register than by reloading the sum into a register,
;; since the former is one instruction shorter if the address does not need
;; to be offsettable.  Unfortunately this does not work, because there is
;; only one register, r0, that can be used as an index register.  This register
;; is also the function return value register.  So, if we try to force reload
;; to use double-reg addresses, then we end up with some instructions that
;; need to use r0 twice.  The only way to fix this is to change the calling
;; convention so that r0 is not used to return values.

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:SI (match_dup 0))
	(match_operand:SI 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.l	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:SI 2 "general_movdst_operand" "")
	(mem:SI (match_dup 0)))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.l	@(%0,%1),%2")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:HI (match_dup 0))
	(match_operand:HI 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.w	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:HI 2 "general_movdst_operand" "")
	(mem:HI (match_dup 0)))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.w	@(%0,%1),%2")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:QI (match_dup 0))
	(match_operand:QI 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.b	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:QI 2 "general_movdst_operand" "")
	(mem:QI (match_dup 0)))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.b	@(%0,%1),%2")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:SF (match_dup 0))
	(match_operand:SF 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0
   && ((GET_CODE (operands[2]) == REG && REGNO (operands[2]) < 16)
       || (GET_CODE (operands[2]) == SUBREG
	   && REGNO (SUBREG_REG (operands[2])) < 16))
   && reg_unused_after (operands[0], insn)"
  "mov.l	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:SF 2 "general_movdst_operand" "")

	(mem:SF (match_dup 0)))]
  "REGNO (operands[0]) == 0
   && ((GET_CODE (operands[2]) == REG && REGNO (operands[2]) < 16)
       || (GET_CODE (operands[2]) == SUBREG
	   && REGNO (SUBREG_REG (operands[2])) < 16))
   && reg_unused_after (operands[0], insn)"
  "mov.l	@(%0,%1),%2")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:SF (match_dup 0))
	(match_operand:SF 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0
   && ((GET_CODE (operands[2]) == REG && REGNO (operands[2]) >= FIRST_FP_REG)
       || (GET_CODE (operands[2]) == SUBREG
	   && REGNO (SUBREG_REG (operands[2])) >= FIRST_FP_REG))
   && reg_unused_after (operands[0], insn)"
  "fmov{.s|}	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:SF 2 "general_movdst_operand" "")

	(mem:SF (match_dup 0)))]
  "REGNO (operands[0]) == 0
   && ((GET_CODE (operands[2]) == REG && REGNO (operands[2]) >= FIRST_FP_REG)
       || (GET_CODE (operands[2]) == SUBREG
	   && REGNO (SUBREG_REG (operands[2])) >= FIRST_FP_REG))
   && reg_unused_after (operands[0], insn)"
  "fmov{.s|}	@(%0,%1),%2")

;; Switch to a new stack with its address in sp_switch (a SYMBOL_REF).  */
(define_insn "sp_switch_1"
  [(const_int 1)]
  ""
  "*
{
  rtx xoperands[1];

  xoperands[0] = sp_switch;
  output_asm_insn (\"mov.l r0,@-r15\;mov.l %0,r0\", xoperands);
  output_asm_insn (\"mov.l @r0,r0\;mov.l r15,@-r0\", xoperands);
  return \"mov r0,r15\";
}"
  [(set_attr "length" "10")])

;; Switch back to the original stack for interrupt functions with the
;; sp_switch attribute.  */
(define_insn "sp_switch_2"
  [(const_int 2)]
  ""
  "mov.l @r15+,r15\;mov.l @r15+,r0"
  [(set_attr "length" "4")])
