#ifdef TEST_LIBIO
#include <iostdio.h>
#else
#ifdef __cplusplus
#include <strstream.h>
#else
#include <stdio.h>
#endif
#endif /* !TEST_LIBIO */
#include <string.h>

/* Tests taken from Cygnus C library. */
typedef struct {
  int line;
  long value;
  char *result;
  char *format_string;
} sprint_int_type;

sprint_int_type sprint_ints[] = 
{
__LINE__, 0x000838d2L,	"838d2", "%.4x",
__LINE__, 0x0063be46L,	"63BE46", "%-6X",
__LINE__, -0x1b236c0L,	"-28456640", "%#0.d",
__LINE__, -0x0000003L,	"-3", "% 0d",
__LINE__, 0x0000ed51L,	"ed51", "%2.x",
__LINE__, -0x00001f2L,	"-498", "%1ld",
__LINE__, 0x0ea3e927L,	"EA3E927", "%+X",
__LINE__, 0xffbef8daL,	"FFBEF8DA", "%5X",
__LINE__, 0x62ff9f56L,	"62ff9f56", "%0x",
__LINE__, 0x00000ad2L,	"AD2", "%.0X",
__LINE__, 0x00000000L,	"      ", "% 6.ld",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%1.4X",
__LINE__, 0x0000208cL,	" 208C", "%5X",
__LINE__, 0x0000003cL,	"3c", "%x",
__LINE__, 0xffff6177L,	"0xffff6177", "%+#x",
__LINE__, 0xffffdc8dL,	"ffffdc8d", "%+x",
__LINE__, 0x00000000L,	"0", "%X",
__LINE__, 0x00002434L,	"9268", "%0d",
__LINE__, 0xd2c72cdbL,	"d2c72cdb", "%-x",
__LINE__, 0xfe38012bL,	"0xfe38012b", "%+#7x",
__LINE__, 0x00000001L,	"0001", "%#.4d",
__LINE__, -0x008525aL,	"-0545370", "%06.7ld",
__LINE__, 0xffffffacL,	"ffffffac", "%3.7x",
__LINE__, 0x007424d2L,	"+7611602", "%+ld",
__LINE__, 0x00001a85L,	"1A85", "%.4X",
__LINE__, -0x0000019L,	"-25", "%3.d",
__LINE__, 0xfffffffeL,	"fffffffe", "%-x",
__LINE__, -0x34473b2L,	"-54817714", "% d",
__LINE__, 0x000000eaL,	"234", "%1.ld",
__LINE__, -0x0000004L,	"-4     ", "%-7.ld",
__LINE__, 0x00006c94L,	"27796", "%0d",
__LINE__, 0x00000001L,	"1", "%ld",
__LINE__, 0x00000619L,	"619", "%1x",
__LINE__, 0x0000209cL,	"8348", "%ld",
__LINE__, -0x327f8ffL,	"-52951295", "%-0ld",
__LINE__, 0xffffff0bL,	"FFFFFF0B", "%2.X",
__LINE__, 0xf199d6aeL,	"F199D6AE", "%X",
__LINE__, 0x3ca5602eL,	"1017471022", "%-1.ld",
__LINE__, -0xfb2080bL,	"-263325707", "%3.5d",
__LINE__, 0x00001cb8L,	"7352", "%d",
__LINE__, 0x00000000L,	"0000000", "%3.7d",
__LINE__, 0xffffff40L,	"FFFFFF40", "%+X",
__LINE__, 0x14664450L,	"0x14664450", "%#x",
__LINE__, 0x0000002eL,	"2e", "%1x",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, 0xffff606aL,	"0XFFFF606A", "%#X",
__LINE__, 0xffffff33L,	"0XFFFFFF33", "%#X",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, -0x0000012L,	"-00018", "%-2.5d",
__LINE__, 0x0001fbe6L,	"130022", "%1.d",
__LINE__, 0xfff59dd9L,	"fff59dd9", "%+x",
__LINE__, 0x00000002L,	"2", "%0.0d",
__LINE__, 0x00000fe1L,	"fe1    ", "%-7.x",
__LINE__, 0x001f8f6aL,	"1F8F6A", "%1.X",
__LINE__, 0x0000001bL,	"000001B", "%04.7X",
__LINE__, 0x126a2609L,	" 308946441", "% 4d",
__LINE__, 0xffffffe3L,	"0XFFFFFFE3", "%+#.1X",
__LINE__, 0x1858f1c9L,	"1858f1c9", "%.3x",
__LINE__, 0x003fc672L,	"3fc672", "%1x",
__LINE__, 0x00c0bddcL,	"12631516", "%#d",
__LINE__, 0x000006d6L,	"1750", "%#d",
__LINE__, 0x000006a0L,	"6A0", "%X",
__LINE__, 0x000007beL,	"7BE", "%X",
__LINE__, -0x1c7cd1aL,	"-29871386", "%ld",
__LINE__, 0x000000ccL,	"204", "%ld",
__LINE__, 0x000002dbL,	"731  ", "%-#5d",
__LINE__, 0xffff67adL,	"FFFF67AD", "% X",
__LINE__, 0x00000008L,	"8", "%d",
__LINE__, 0xffe07007L,	"FFE07007", "%5X",
__LINE__, -0x0000001L,	"     -1", "% 7d",
__LINE__, 0xfffffffeL,	"fffffffe", "%x",
__LINE__, 0x00027b68L,	"+162664", "%+ld",
__LINE__, 0x0a7c1997L,	"+175905175", "%+2ld",
__LINE__, 0xfe300896L,	"fe300896", "%.4x",
__LINE__, 0x00000537L,	"537", "%-0.x",
__LINE__, 0x3e981779L,	"3e981779", "%.6x",
__LINE__, 0xfffff05eL,	"FFFFF05E", "%1.0X",
__LINE__, -0x07bc0cfL,	"-8110287", "%-7d",
__LINE__, -0x01371bcL,	"-1274300", "%.7ld",
__LINE__, -0x0000013L,	"-19", "%.2ld",
__LINE__, 0x000000d1L,	"0xd1", "%#x",
__LINE__, -0x0000003L,	"-3", "%-ld",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%4.1X",
__LINE__, 0x00000000L,	"0", "%ld",
__LINE__, 0x0001c8afL,	"116911", "%d",
__LINE__, 0x000048c3L,	"48C3", "%X",
__LINE__, 0x00000079L,	"0x0000079", "%-#0.7x",
__LINE__, 0x0000615aL,	" 24922", "% d",
__LINE__, 0xfffffff5L,	"fffffff5", "%x",
__LINE__, 0x00000308L,	"0000308", "%+07.7x",
__LINE__, 0xfcadc983L,	"fcadc983", "%x",
__LINE__, 0x00000097L,	"151", "%#d",
__LINE__, 0x000001c5L,	"453", "%0.2ld",
__LINE__, 0x00000000L,	"00", "%-1.2x",
__LINE__, 0x00000001L,	"+1", "%+02.d",
__LINE__, 0x01eb4354L,	"1EB4354", "% X",
__LINE__, 0xffffa7d1L,	"ffffa7d1", "%5.x",
__LINE__, 0x0003170eL,	"0x3170e", "%#x",
__LINE__, 0x000001ceL,	"1CE", "% .2X",
__LINE__, 0x3a2991fbL,	"975802875", "%d",
__LINE__, -0xcdad8e2L,	"-215668962", "%-d",
__LINE__, 0xfe0261c3L,	"fe0261c3", "%x",
__LINE__, -0x0006ea7L,	"-28327", "% ld",
__LINE__, 0x032854a3L,	"0X32854A3", "% #6X",
__LINE__, 0x0000004bL,	"4b", "%x",
__LINE__, 0xffff6ca3L,	"FFFF6CA3", "%4.X",
__LINE__, 0x00000000L,	"0", "%X",
__LINE__, 0x00611f04L,	"611F04", "%.1X",
__LINE__, 0x00000000L,	"     0", "%#6d",
__LINE__, 0x0002c711L,	"2c711", "%-02.x",
__LINE__, -0x07a2fe4L,	"-8007652", "%d",
__LINE__, -0x0000547L,	"-1351", "%ld",
__LINE__, 0x00013954L,	"0x13954", "%#x",
__LINE__, -0x00523b7L,	"-336823", "%ld",
__LINE__, -0x00f6c6eL,	"-1010798", "%6.ld",
__LINE__, 0xffea6427L,	"FFEA6427", "%3X",
__LINE__, -0x0000005L,	"-5", "%d",
__LINE__, -0x04fe618L,	"-5236248", "% .7d",
__LINE__, 0xffa80a28L,	"ffa80a28", "%-0x",
__LINE__, 0x00000047L,	"71", "%ld",
__LINE__, 0x001dc6bbL,	"1951419", "%#4ld",
__LINE__, 0x00000868L,	"  2152", "%#6d",
__LINE__, 0x000002fbL,	"2fb", "%x",
__LINE__, 0x00607fa0L,	"6324128", "%4d",
__LINE__, 0xfffed161L,	"fffed161", "%x",
__LINE__, 0x0001c6e4L,	" 116452", "% 2.5d",
__LINE__, 0x0003dda8L,	"3DDA8", "%4X",
__LINE__, 0xfffffff8L,	"fffffff8", "%x",
__LINE__, 0xfacf664aL,	"facf664a", "%x",
__LINE__, 0x000000c1L,	"C1", "% 1X",
__LINE__, 0x0000839cL,	"  839C", "%6X",
__LINE__, 0xfffff69aL,	"FFFFF69A", "%X",
__LINE__, 0x000e5c2eL,	"+941102", "%+d",
__LINE__, -0x0000004L,	"-4", "%#d",
__LINE__, 0x00000000L,	"00000", "%#.5ld",
__LINE__, 0xfffffffeL,	"fffffffe", "%3.1x",
__LINE__, 0x0010ed68L,	"1109352", "%-ld",
__LINE__, 0xffffffe9L,	"ffffffe9", "%.6x",
__LINE__, 0x00000007L,	"   7", "% 4.ld",
__LINE__, 0x0000cabaL,	"51898", "%ld",
__LINE__, -0x0000119L,	"-281", "% d",
__LINE__, 0x0c3012a9L,	"204477097", "%03.6ld",
__LINE__, -0x001c98fL,	"-117135", "%ld",
__LINE__, 0x000017b1L,	"+6065", "%+d",
__LINE__, 0x00000001L,	"1", "%ld",
__LINE__, -0x0000019L,	"-25", "% .2d",
__LINE__, 0x0009ae28L,	"9AE28", "%X",
__LINE__, 0xe861c4feL,	"e861c4fe", "%7.x",
__LINE__, 0xffac88d3L,	"FFAC88D3", "%X",
__LINE__, -0x00005dfL,	"-01503", "%-5.5ld",
__LINE__, 0x0000013eL,	"318", "%-0d",
__LINE__, 0x04b6f58fL,	"4b6f58f", "%x",
__LINE__, 0xfffe3978L,	"fffe3978", "%+0.6x",
__LINE__, 0x57ee5244L,	"57ee5244", "%+7.4x",
__LINE__, 0xfffb5610L,	"fffb5610", "% 6x",
__LINE__, 0x00000006L,	"      6", "%#7d",
__LINE__, 0x0000000cL,	"0x0000c", "%#.5x",
__LINE__, -0xec59362L,	"-247829346", "%1.7d",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, -0x0007e4bL,	"-32331", "% d",
__LINE__, 0x0ececa6fL,	"248433263", "%0d",
__LINE__, 0x00000578L,	"   578", "%+6.x",
__LINE__, -0x0000003L,	"-3", "%ld",
__LINE__, 0x000002bbL,	"2bb", "% 0x",
__LINE__, -0x0000006L,	"-6", "%-ld",
__LINE__, 0x000002f9L,	"761", "%d",
__LINE__, 0xffffd736L,	"ffffd736", "%3.4x",
__LINE__, 0x0010ba79L,	"1096313", "%7.4d",
__LINE__, -0x0001244L,	"-4676", "%#.1d",
__LINE__, 0x00000dbeL,	"DBE", "%1X",
__LINE__, -0x0000015L,	"-21", "%-0.d",
__LINE__, 0xffffffffL,	"0xffffffff", "%#x",
__LINE__, -0x6cdf4a3L,	"-114160803", "%ld",
__LINE__, 0x00008ac9L,	"8AC9", "%1X",
__LINE__, 0x00000000L,	"00", "%.2X",
__LINE__, -0x2263dbaL,	"-36060602", "%5.5d",
__LINE__, 0x00007da9L,	"32169", "%0d",
__LINE__, 0xfffffff7L,	"FFFFFFF7", "% 4.X",
__LINE__, 0xfbf36ccaL,	"FBF36CCA", "%.1X",
__LINE__, 0x00000040L,	"64", "%.0ld",
__LINE__, 0x0000001cL,	" 28", "% d",
__LINE__, 0xfffffadbL,	"0xfffffadb", "%#.5x",
__LINE__, 0x0eb95847L,	"247027783", "%d",
__LINE__, 0xfffd7030L,	"FFFD7030", "%+02X",
__LINE__, 0x00000005L,	"00005", "%.5x",
__LINE__, 0xfffffffdL,	"FFFFFFFD", "%X",
__LINE__, 0x98975b15L,	"98975B15", "%02X",
__LINE__, -0x0000034L,	"   -52", "%6ld",
__LINE__, 0xffd7d0ccL,	"ffd7d0cc", "% 5.6x",
__LINE__, 0xffffffa6L,	"FFFFFFA6", "%X",
__LINE__, 0xfff27132L,	"fff27132", "%x",
__LINE__, -0x065b74dL,	"-6666061", "%+6ld",
__LINE__, 0xf6ac99d6L,	"0XF6AC99D6", "%#X",
__LINE__, 0xfffff4bdL,	"FFFFF4BD", "%X",
__LINE__, 0xfffffb62L,	"FFFFFB62", "%6X",
__LINE__, 0xf8434543L,	"f8434543", "%-0x",
__LINE__, 0x0002b374L,	"0x2b374", "%-#6x",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0xffb5751dL,	"ffb5751d", "%-3.x",
__LINE__, 0x34ea7347L,	"887780167", "%d",
__LINE__, -0x008f457L,	"-586839", "%0ld",
__LINE__, 0x00000001L,	"   1", "%#4d",
__LINE__, 0xc32d7ad4L,	"c32d7ad4", "%0x",
__LINE__, 0xfffffb80L,	"FFFFFB80", "%-.2X",
__LINE__, 0x00000756L,	"756   ", "%-6x",
__LINE__, 0xfffb020fL,	"FFFB020F", "%+.2X",
__LINE__, -0xe68619fL,	"-241721759", "%#1.6ld",
__LINE__, 0x180166cdL,	"402745037", "%3.7ld",
__LINE__, -0x0000001L,	"-1", "%+00d",
__LINE__, 0xfdbc3611L,	"fdbc3611", "%x",
__LINE__, -0x000005bL,	"-91", "%d",
__LINE__, 0xffffe77fL,	"ffffe77f", "%x",
__LINE__, -0x0000019L,	"-25", "%ld",
__LINE__, 0x00000016L,	"22", "%#d",
__LINE__, -0x0000025L,	"-37", "%ld",
__LINE__, 0xffffe43fL,	"ffffe43f", "%x",
__LINE__, 0x000050a5L,	"00050a5", "%.7x",
__LINE__, 0x0000000cL,	"   12", "% 5.ld",
__LINE__, -0x001faffL,	"-129791", "%4d",
__LINE__, 0x239d7cf2L,	"597523698", "%0.7ld",
__LINE__, 0x04092183L,	"4092183", "% 7X",
__LINE__, -0x0043498L,	"-275608", "%-ld",
__LINE__, -0x0018dbeL,	"-101822", "%d",
__LINE__, 0xff3e09c3L,	"FF3E09C3", "%X",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, -0x15d57558L,	"-366310744", "%+0.7ld",
__LINE__, 0x0004fb06L,	"326406", "%0.0d",
__LINE__, 0x00000119L,	"0X119", "%#X",
__LINE__, -0x14c53e19L,	"-348470809", "%d",
__LINE__, 0x00000019L,	"0000019", "% .7X",
__LINE__, -0x0000654L,	"-1620", "%0.4ld",
__LINE__, -0xde5899bL,	"-233146779", "%#.1d",
__LINE__, 0x0013c1f0L,	"1294832", "%4.ld",
__LINE__, 0x0a9fe761L,	"A9FE761", "%X",
__LINE__, -0x00000e5L,	"-229", "%1ld",
__LINE__, 0x00000161L,	"000353", "%.6ld",
__LINE__, 0x6b04e4bdL,	"0x6b04e4bd", "%#7.0x",
__LINE__, -0x0000ef0L,	"-3824 ", "%-6.ld",
__LINE__, -0x026306eL,	"-2502766", "%ld",
__LINE__, 0x00000000L,	"0", "%-X",
__LINE__, 0xfffffe1fL,	"fffffe1f", "%-x",
__LINE__, 0x0003aecfL,	" 241359", "% 2.1ld",
__LINE__, -0x0000014L,	"-20", "%d",
__LINE__, 0x00000002L,	"0002", "%-.4ld",
__LINE__, 0xfffff662L,	"0XFFFFF662", "% #.6X",
__LINE__, 0x00000006L,	"6", "%0x",
__LINE__, 0x0001f4c4L,	" 128196", "% 0d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%5X",
__LINE__, 0x05605e38L,	"90201656", "%ld",
__LINE__, 0xffffffdeL,	"0XFFFFFFDE", "% #X",
__LINE__, 0x000001e0L,	"    1e0", "%7.x",
__LINE__, 0x00000007L,	"7", "%X",
__LINE__, 0x00000001L,	"+1", "%+d",
__LINE__, 0xffffffe0L,	"FFFFFFE0", "% X",
__LINE__, 0xffd7f77aL,	"FFD7F77A", "%+00.1X",
__LINE__, 0xfffffffeL,	"0xfffffffe", "%-#x",
__LINE__, 0x01b0a63bL,	"1b0a63b", "%x",
__LINE__, -0x06554b7L,	"-6640823", "%d",
__LINE__, 0xfffffff8L,	"fffffff8", "%x",
__LINE__, 0x00000b2dL,	"b2d", "%x",
__LINE__, -0x2664ba2L,	"-40258466", "%-d",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%X",
__LINE__, -0x0000552L,	" -1362", "%6.2ld",
__LINE__, 0x00000009L,	" 00009", "%6.5x",
__LINE__, 0x00035c72L,	"220274", "%05.ld",
__LINE__, -0x014d09dL,	"-1364125", "%d",
__LINE__, -0x0000002L,	"  -2", "% 4d",
__LINE__, 0x00000001L,	"1", "%+X",
__LINE__, 0x00000028L,	"28", "%X",
__LINE__, 0xf25c9eb2L,	"F25C9EB2", "%7.X",
__LINE__, -0x7ae4b62L,	"-128863074", "%d",
__LINE__, 0x00630d87L,	"630D87", "%2X",
__LINE__, 0x000000f8L,	"F8", "%-X",
__LINE__, 0xfffffff9L,	"FFFFFFF9", "%X",
__LINE__, -0x0000007L,	"-7", "%0d",
__LINE__, -0x2518fcdL,	"-38899661", "% 3ld",
__LINE__, 0xfffff4b4L,	"FFFFF4B4", "%-5X",
__LINE__, 0x01cc36c8L,	"30160584", "%ld",
__LINE__, 0xffffffffL,	"ffffffff", "%-x",
__LINE__, 0x0000000bL,	"    11", "%6.ld",
__LINE__, 0x00010d55L,	" 68949", "% d",
__LINE__, -0x0c01306L,	"-12587782", "% 6.1ld",
__LINE__, 0x001719d7L,	"1513943", "%.1ld",
__LINE__, -0x0000002L,	" -2", "%+3.ld",
__LINE__, 0x0000018eL,	"398", "%d",
__LINE__, 0x000000a6L,	"0xa6", "%-#3x",
__LINE__, 0x00006f66L,	" 28518", "% #d",
__LINE__, 0x0000032aL,	"32A", "%X",
__LINE__, -0x0000145L,	"-325", "%0d",
__LINE__, 0xffffffffL,	"ffffffff", "%2.x",
__LINE__, 0x00287171L,	"2650481", "%ld",
__LINE__, 0x0000004bL,	"+75", "%+02.ld",
__LINE__, 0xfffffff8L,	"fffffff8", "%-0x",
__LINE__, 0x00000064L,	"64", "% X",
__LINE__, 0xfffffca2L,	"fffffca2", "%0x",
__LINE__, 0x000010b6L,	"10b6", "% .0x",
__LINE__, -0x003806fL,	"-229487", "%7d",
__LINE__, -0x00000b7L,	"-183", "%3ld",
__LINE__, 0xffffe5baL,	"FFFFE5BA", "%0X",
__LINE__, 0x001f0da8L,	"1f0da8", "%+x",
__LINE__, 0x000ce185L,	"844165", "%0ld",
__LINE__, 0x00000c96L,	"3222", "%0d",
__LINE__, -0x0013099L,	"-77977", "%1.ld",
__LINE__, -0x5f3c47aL,	"-99861626", "%.6ld",
__LINE__, 0x00000cbfL,	"  CBF", "%+5.X",
__LINE__, -0x0000001L,	"-1", "%+ld",
__LINE__, 0x0d793bc3L,	"d793bc3", "%6.x",
__LINE__, 0xfffffffdL,	"0xfffffffd", "%+#x",
__LINE__, -0x0000070L,	"  -112", "%6.d",
__LINE__, 0xfffffb3fL,	"FFFFFB3F", "%.7X",
__LINE__, 0x037dfc78L,	"0X37DFC78", "%#X",
__LINE__, 0x00009ba5L,	"39845", "%3ld",
__LINE__, 0x0000004aL,	"4a", "%0x",
__LINE__, 0xffffff81L,	"ffffff81", "%5.5x",
__LINE__, -0x86ef222L,	"-141488674", "%ld",
__LINE__, -0xac5531eL,	"-180704030", "% 4ld",
__LINE__, 0x00002493L,	"2493", "%+X",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%1.3X",
__LINE__, 0x0005c875L,	"378997", "%.0ld",
__LINE__, 0x0301d345L,	"50451269", "%d",
__LINE__, 0xfff6b589L,	"fff6b589", "%2.4x",
__LINE__, -0x00001dbL,	"-475   ", "%-7.0d",
__LINE__, 0x0000d1e7L,	"0x000d1e7", "%#2.7x",
__LINE__, 0xf4c4d2bbL,	"f4c4d2bb", "%.6x",
__LINE__, 0x00c89f54L,	"13147988", "%ld",
__LINE__, -0x6599253cL,	"-1704535356", "%+ld",
__LINE__, 0xab7d61eaL,	"ab7d61ea", "% x",
__LINE__, 0x00000006L,	"6", "%1ld",
__LINE__, 0xffff5ab7L,	"ffff5ab7", "%0x",
__LINE__, -0x1cfeca5bL,	"-486459995", "%#ld",
__LINE__, 0x000000f3L,	"    f3", "% 6.x",
__LINE__, -0x0000021L,	"-33", "%d",
__LINE__, 0xfe7246acL,	"fe7246ac", "%-5.x",
__LINE__, 0x00000017L,	"00017", "%-.5X",
__LINE__, -0x0cc250aL,	"-13378826", "%0.0d",
__LINE__, -0x00010aeL,	"-04270", "%#.5ld",
__LINE__, -0x7952c8bL,	"-127216779", "% ld",
__LINE__, 0x0002a53eL,	"173374", "%4.0d",
__LINE__, 0x03801bbfL,	"3801BBF", "%0X",
__LINE__, 0x0368645fL,	"+57173087", "%+#0.6ld",
__LINE__, 0x0000002fL,	"47", "%d",
__LINE__, 0x00000003L,	"3", "%x",
__LINE__, 0x000005f7L,	"5F7", "%0X",
__LINE__, -0x06e5e76L,	"-7233142", "% 0.1ld",
__LINE__, 0x053da936L,	"53da936", "%1.4x",
__LINE__, -0x0df0c2fL,	"-14617647", "%.5ld",
__LINE__, 0xfffffffdL,	"FFFFFFFD", "%-0X",
__LINE__, 0x000104bfL,	"104BF", "%X",
__LINE__, 0x000353fcL,	"353FC", "%X",
__LINE__, 0x182a18dcL,	"+405412060", "%+ld",
__LINE__, 0x0000000eL,	" 14", "% 2d",
__LINE__, -0x0000091L,	"-145", "%+ld",
__LINE__, 0x0029a9d6L,	"2730454", "%d",
__LINE__, 0x00009d57L,	"009d57", "% .6x",
__LINE__, 0x4c4d4f79L,	"1280135033", "%5.ld",
__LINE__, -0x000075bL,	"-1883", "% 03d",
__LINE__, -0x001b718L,	"-112408", "%+d",
__LINE__, 0xfffaaf57L,	"FFFAAF57", "%+1X",
__LINE__, 0x00f44e52L,	"F44E52", "% 4X",
__LINE__, 0x00000002L,	"0X2", "%#X",
__LINE__, 0x000a85e9L,	"A85E9", "%+0X",
__LINE__, 0xffff70bbL,	"ffff70bb", "%6x",
__LINE__, 0x00004e15L,	"4e15", "%x",
__LINE__, 0x000eeb60L,	" 977760", "% ld",
__LINE__, 0xfffffff1L,	"fffffff1", "%0x",
__LINE__, -0x294d7e2L,	"-43309026", "% 02.d",
__LINE__, 0x0001aaebL,	"0109291", "%02.7ld",
__LINE__, 0x000a01fcL,	"0xa01fc", "%-#.5x",
__LINE__, 0x002c3c30L,	"+2898992", "%+#d",
__LINE__, 0x015667aeL,	"+22439854", "%+5ld",
__LINE__, -0x05af42bL,	"-5960747", "%+d",
__LINE__, 0x0000be36L,	"be36", "%+2x",
__LINE__, 0x005e3f67L,	"5e3f67", "% x",
__LINE__, -0x0000020L,	"-32", "% ld",
__LINE__, -0x0003617L,	"-13847", "% d",
__LINE__, 0x00000014L,	"14  ", "%-4.X",
__LINE__, 0x00000001L,	"001", "%0.3d",
__LINE__, 0xfffffea9L,	"fffffea9", "%3.x",
__LINE__, 0xe447099eL,	"E447099E", "%0X",
__LINE__, 0x00049c71L,	"302193", "%d",
__LINE__, 0x76356ed3L,	"0x76356ed3", "%#4.1x",
__LINE__, 0x00000005L,	"  0X5", "%#5X",
__LINE__, 0x00004da2L,	"0x004da2", "%#1.6x",
__LINE__, 0xffdfb36cL,	"FFDFB36C", "%4X",
__LINE__, 0xffffe3c5L,	"FFFFE3C5", "%+4.X",
__LINE__, 0x00000006L,	"6", "%0x",
__LINE__, -0x914ff17L,	"-152370967", "% .5ld",
__LINE__, -0x0000002L,	"-2", "%0ld",
__LINE__, 0xffffff36L,	"FFFFFF36", "% 2X",
__LINE__, -0x0bb1598L,	"-12260760", "%-ld",
__LINE__, 0x00006db5L,	"28085", "%0.5ld",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, -0x0000001L,	"-1", "%0ld",
__LINE__, 0x0fa37e79L,	"FA37E79", "%1.X",
__LINE__, -0x00000acL,	"-172", "%.2d",
__LINE__, 0xffffffd8L,	"ffffffd8", "%.7x",
__LINE__, -0x000a513L,	"-42259", "%ld",
__LINE__, 0x00001294L,	"4756", "%2ld",
__LINE__, -0x56bae0b4L,	"-1455087796", "%.1ld",
__LINE__, 0x3b26d5faL,	"3b26d5fa", "%x",
__LINE__, 0xff657013L,	"ff657013", "%x",
__LINE__, -0x00005f5L,	"-1525", "%0.0ld",
__LINE__, -0x0000001L,	"     -1", "% 7d",
__LINE__, -0x02396b2L,	"-2332338", "%d",
__LINE__, -0x0000003L,	"-000003", "%+7.6d",
__LINE__, 0xfd3ec7c1L,	"fd3ec7c1", "% 3.4x",
__LINE__, -0x076e338L,	"-7791416", "%0.d",
__LINE__, -0x000015eL,	"-350", "%3ld",
__LINE__, 0x0a0f0b71L,	"a0f0b71", "%x",
__LINE__, 0xfffe00baL,	"FFFE00BA", "%X",
__LINE__, 0x00036bd8L,	" 36bd8", "% 06.x",
__LINE__, 0xfffff2dfL,	"0XFFFFF2DF", "%#2.6X",
__LINE__, 0x004687fbL,	"4622331", "%ld",
__LINE__, -0x0000331L,	"  -817", "%+6.d",
__LINE__, 0xfcd5b090L,	"fcd5b090", "%+0x",
__LINE__, 0x0334f94cL,	"334F94C", "%.6X",
__LINE__, 0x00000bceL,	"3022", "%.3ld",
__LINE__, 0xf28d9dddL,	"f28d9ddd", "%x",
__LINE__, 0x00003a79L,	" 14969", "% ld",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%.7X",
__LINE__, 0x0043d7feL,	"43D7FE", "%X",
__LINE__, -0x0000b82L,	"-2946", "%-ld",
__LINE__, -0x00e29d8L,	"-928216", "%d",
__LINE__, 0xffffffecL,	"ffffffec", "%-x",
__LINE__, 0x0aeaf557L,	"0xaeaf557", "%-#x",
__LINE__, 0x00c07fe6L,	"C07FE6", "%X",
__LINE__, 0x307414d8L,	"307414d8", "% 0x",
__LINE__, -0x045ef67L,	"-4583271", "%d",
__LINE__, 0x0000024aL,	" 0000586", "% .7d",
__LINE__, 0xfffffc42L,	"fffffc42", "%x",
__LINE__, 0xfc38c249L,	"fc38c249", "%5.x",
__LINE__, -0x000d096L,	"-53398", "%-d",
__LINE__, -0x213a345L,	"-34841413", "%ld",
__LINE__, -0x0000130L,	"-304", "%ld",
__LINE__, -0x000efd1L,	"-61393", "%ld",
__LINE__, 0xfffff867L,	"FFFFF867", "%2X",
__LINE__, 0x00113ed0L,	"0x113ed0", "%-#7x",
__LINE__, 0x00000677L,	" 1655", "% 3.ld",
__LINE__, 0x0000002fL,	"2f", "%x",
__LINE__, 0xfffffd38L,	"fffffd38", "%-4x",
__LINE__, -0x000b3ccL,	"-46028", "%1.2d",
__LINE__, 0x45da719bL,	"45DA719B", "%+0X",
__LINE__, -0x000a454L,	" -42068", "%7.3ld",
__LINE__, 0x01cc7c30L,	" 30178352", "% d",
__LINE__, -0x05ae80eL,	"-5957646", "%#.4ld",
__LINE__, 0x000000b9L,	"185", "%d",
__LINE__, 0x003fcaf4L,	"4180724", "%1.ld",
__LINE__, 0x02da1b74L,	"2DA1B74", "%X",
__LINE__, 0xffffffd9L,	"FFFFFFD9", "%X",
__LINE__, 0x00064359L,	"64359 ", "%-6X",
__LINE__, 0x000000f0L,	"240", "%ld",
__LINE__, -0x01715e5L,	"-1512933", "%ld",
__LINE__, 0xc8f6e118L,	"0XC8F6E118", "%#X",
__LINE__, 0xfffffd8fL,	"FFFFFD8F", "%X",
__LINE__, 0x0000176dL,	"5997  ", "%-6d",
__LINE__, 0x00003cabL,	"0x3cab", "%#0.3x",
__LINE__, 0x00000001L,	" 1", "% d",
__LINE__, 0xfffff610L,	"0XFFFFF610", "%#X",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%5.7X",
__LINE__, 0x00000001L,	"1", "%0x",
__LINE__, 0x00000001L,	"00001", "%.5ld",
__LINE__, -0x0000d51L,	"-3409", "%d",
__LINE__, -0x08639eeL,	"-8796654", "%ld",
__LINE__, 0x00003121L,	"12577", "%#1.2ld",
__LINE__, 0x0000004eL,	"78", "%d",
__LINE__, 0xfffff64fL,	"fffff64f", "%-x",
__LINE__, 0x0000002aL,	"2a", "%0x",
__LINE__, 0x00000020L,	"20", "%x",
__LINE__, -0x00000b8L,	"-184", "%#ld",
__LINE__, 0x0000000aL,	"10", "%-#d",
__LINE__, 0x00000364L,	"868", "%.1ld",
__LINE__, 0x00d1f9b6L,	"D1F9B6", "%0.X",
__LINE__, 0x008cfda1L,	"8CFDA1", "% 6.X",
__LINE__, 0xffd58cceL,	"FFD58CCE", "%X",
__LINE__, 0x00000008L,	"0000008", "%6.7ld",
__LINE__, 0x00000318L,	" 318", "%4X",
__LINE__, 0x000172d8L,	"94936", "%2ld",
__LINE__, -0x056ccbfL,	"-5688511", "%ld",
__LINE__, 0x000000c7L,	"+000199", "%+0.6d",
__LINE__, 0x00000002L,	"0X2", "%-#X",
__LINE__, 0xfffff634L,	"FFFFF634", "%.1X",
__LINE__, -0x00001f3L,	"-499", "%-ld",
__LINE__, -0x000081bL,	"-2075", "%-d",
__LINE__, 0x000000b5L,	"181", "%0d",
__LINE__, 0xfe961ee8L,	"fe961ee8", "%0x",
__LINE__, 0x000028a2L,	"10402", "%d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%.4X",
__LINE__, -0x000058aL,	"-1418", "%.3ld",
__LINE__, 0x00001cebL,	"1CEB", "%X",
__LINE__, 0x00000021L,	"21", "% X",
__LINE__, 0x00000002L,	"2", "%0d",
__LINE__, -0x2f9bbf5L,	"-49921013", "%.4ld",
__LINE__, 0x00000e91L,	"03729", "%#.5ld",
__LINE__, 0xf1116740L,	"f1116740", "%2x",
__LINE__, 0x00014f72L,	"14F72", "%X",
__LINE__, 0xfffffcedL,	"FFFFFCED", "%X",
__LINE__, 0xffffffffL,	"ffffffff", "%.5x",
__LINE__, 0x0017cf0cL,	" 1560332", "% 0ld",
__LINE__, 0x0000000aL,	"A", "% X",
__LINE__, 0xff3a39d4L,	"ff3a39d4", "%x",
__LINE__, 0xfffef05fL,	"FFFEF05F", "%X",
__LINE__, 0xfedfe708L,	"fedfe708", "%03.0x",
__LINE__, 0x000345a0L,	"345A0", "% X",
__LINE__, -0x1ed5b6f7L,	"-517322487", "%d",
__LINE__, 0xd2d56c22L,	"D2D56C22", "%0.X",
__LINE__, 0x00002cbfL,	"2CBF", "%.2X",
__LINE__, 0x00000db4L,	"db4", "%3x",
__LINE__, -0x000b154L,	"-45396", "%d",
__LINE__, 0x002bf4c7L,	"2BF4C7", "%X",
__LINE__, 0x6954abf4L,	"+1767156724", "%+d",
__LINE__, 0xfffffffbL,	"fffffffb", "%x",
__LINE__, -0x29e0050eL,	"-702547214", "%-0ld",
__LINE__, -0x0014989L,	"-84361", "%-#0.3ld",
__LINE__, 0x001a557cL,	"+1725820", "%+6.5d",
__LINE__, -0x56689a81L,	"-1449695873", "%.2d",
__LINE__, 0x00000016L,	"   16", "%05.X",
__LINE__, 0x0001da1eL,	" 121374", "% d",
__LINE__, -0x04deac7L,	"-5106375", "%03.4d",
__LINE__, 0x000012b1L,	"4785", "%d",
__LINE__, 0x0009a116L,	"9a116", "%-x",
__LINE__, -0x0000003L,	"-000003", "%4.6ld",
__LINE__, 0x00000000L,	"", "%.0x",
__LINE__, 0x0000000aL,	"  A", "% 3X",
__LINE__, 0xfffffff0L,	"0xfffffff0", "%-#0.1x",
__LINE__, 0x00000086L,	"86", "%0X",
__LINE__, 0x0000001fL,	"31", "%-d",
__LINE__, 0x0386f706L,	"59176710", "%3.6ld",
__LINE__, 0xffe437aeL,	"0XFFE437AE", "%#X",
__LINE__, 0x0e5405c6L,	"e5405c6", "%-x",
__LINE__, 0xfffdee46L,	"FFFDEE46", "%+X",
__LINE__, 0xff861e9dL,	"FF861E9D", "%5.X",
__LINE__, 0xfffff570L,	"FFFFF570", "%-X",
__LINE__, 0x045c90bdL,	"45c90bd", "%0x",
__LINE__, 0x000000aaL,	"AA", "%+X",
__LINE__, -0x747262eL,	"-122103342", "%0ld",
__LINE__, 0xffffad89L,	"FFFFAD89", "%X",
__LINE__, 0x00000018L,	"18", "%0.2X",
__LINE__, 0x00057a2dL,	" 358957", "% #7.d",
__LINE__, 0x73a0e21dL,	"1939923485", "%ld",
__LINE__, -0x00021e1L,	"-8673", "%0d",
__LINE__, 0x000000e9L,	"   233", "% 06.3ld",
__LINE__, 0xffffcc0dL,	"ffffcc0d", "%x",
__LINE__, 0x00000052L,	"52", "%x",
__LINE__, 0x01c155afL,	"1C155AF", "%.5X",
__LINE__, 0xffffffffL,	"ffffffff", "%0.x",
__LINE__, -0x00400a4L,	"-262308", "%-d",
__LINE__, -0x0000001L,	"-0000001", "%#.7ld",
__LINE__, 0x01fb9c99L,	"1fb9c99", "% 03.5x",
__LINE__, 0xffffffffL,	"ffffffff", "%6.x",
__LINE__, 0xff5e5eeaL,	"FF5E5EEA", "%X",
__LINE__, 0x0000000fL,	"F", "%+0X",
__LINE__, 0xfffffe3aL,	"fffffe3a", "% x",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%-X",
__LINE__, -0x0000007L,	"-7", "%0ld",
__LINE__, -0x002f635L,	"-194101", "%d",
__LINE__, -0x0000005L,	"-5", "%ld",
__LINE__, -0x0000059L,	"-89", "%0ld",
__LINE__, -0x1ccda96L,	"-30202518", "%d",
__LINE__, -0x0000002L,	"-2", "%-d",
__LINE__, 0xffffffdaL,	"0XFFFFFFDA", "%#X",
__LINE__, 0x00036cc5L,	"224453", "%#d",
__LINE__, 0x00000010L,	"+16", "%+ld",
__LINE__, 0x0b6039c7L,	"190855623", "%d",
__LINE__, -0x0000002L,	"-002", "%#.3d",
__LINE__, 0xfff3e746L,	"FFF3E746", "%-4X",
__LINE__, 0x0361b3deL,	"361B3DE", "% 04X",
__LINE__, 0xffffe6a2L,	"ffffe6a2", "%-x",
__LINE__, 0x00032790L,	"0x0032790", "%#7.7x",
__LINE__, 0xffe33b4eL,	"ffe33b4e", "%-0x",
__LINE__, -0x0094663L,	"-607843", "%.3ld",
__LINE__, -0x00a3efaL,	"-671482", "%4d",
__LINE__, 0x000000e6L,	"   00E6", "%7.4X",
__LINE__, 0x000125cbL,	"125CB", "%+X",
__LINE__, 0x0000b97eL,	"b97e", "%x",
__LINE__, -0x0000039L,	"-57", "%+ld",
__LINE__, 0xffffe39aL,	"ffffe39a", "%5.4x",
__LINE__, 0xffffffffL,	"ffffffff", "%6.1x",
__LINE__, -0xdee910cL,	"-233738508", "%-#2d",
__LINE__, -0x14044930L,	"-335825200", "%6.ld",
__LINE__, 0x00a81259L,	"a81259", "%x",
__LINE__, 0x020e74c6L,	"20E74C6", "%X",
__LINE__, -0x00000fbL,	"-251", "%01.d",
__LINE__, 0x034ceb45L,	"34CEB45", "%5.X",
__LINE__, 0xfeacb66aL,	"feacb66a", "% x",
__LINE__, 0x00003eb6L,	"3EB6", "% X",
__LINE__, 0x000009efL,	"9ef", "% x",
__LINE__, 0xf9d9dd07L,	"F9D9DD07", "%0X",
#ifndef __PCCNECV70__

__LINE__, 0x000154d7L,	"087255", "%.6ld",
__LINE__, -0x000036eL,	"-878", "%-ld",
__LINE__, -0x0007dccL,	"-32204", "% d",
__LINE__, 0x000019dcL,	"6620", "%d",
__LINE__, 0xffffff6eL,	"FFFFFF6E", "%2X",
__LINE__, 0x00000016L,	"0x16", "%-#x",
__LINE__, 0xffdb3e96L,	"ffdb3e96", "%+.5x",
__LINE__, 0xffffffefL,	"FFFFFFEF", "% 04.X",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%5X",
__LINE__, 0x000c08cdL,	"C08CD", "%-X",
__LINE__, 0x18de71eeL,	"18de71ee", "%x",
__LINE__, 0xffffffffL,	"ffffffff", "% x",
__LINE__, -0x00025bdL,	"-009661", "%#.6d",
__LINE__, 0x2f05de14L,	" 788913684", "% 6.4ld",
__LINE__, 0x0c99cf86L,	"211406726", "%.5d",
__LINE__, 0x09e6a21dL,	" 166109725", "% 0d",
__LINE__, -0x013da65L,	"-1301093", "%+ld",
__LINE__, 0x000003d0L,	" 976", "% 4.2d",
__LINE__, -0xef9e3ccL,	"-251257804", "%-7.0d",
__LINE__, 0x0000000cL,	"+12", "%+00ld",
__LINE__, 0xffffffe2L,	"ffffffe2", "%x",
__LINE__, 0x000000feL,	"fe", "%-x",
__LINE__, 0xfffffc5fL,	"fffffc5f", "%x",
__LINE__, -0x0005c55L,	"-23637", "%d",
__LINE__, -0x0111ff2L,	"-1122290", "% 7.d",
__LINE__, -0x1a1746e5L,	"-437733093", "%.4ld",
__LINE__, 0x00001007L,	"004103", "%00.6d",
__LINE__, 0xffffffe1L,	"ffffffe1", "%x",
__LINE__, 0x0000d80fL,	"55311", "%d",
__LINE__, 0x00000004L,	"4", "%+X",
__LINE__, 0xfffffffdL,	"fffffffd", "%6x",
__LINE__, -0x2afbcc3cL,	"-721144892", "%4.6ld",
__LINE__, 0x00377f96L,	"377F96", "%6.X",
__LINE__, 0xffffffc8L,	"FFFFFFC8", "%0X",
__LINE__, 0x007ed9d1L,	"8313297", "%-3d",
__LINE__, 0x00000000L,	"0", "%-X",
__LINE__, 0x001e122dL,	"1970733", "%01.d",
__LINE__, -0x000029bL,	"-667", "%ld",
__LINE__, -0x002f563L,	"-193891", "% 2.5d",
__LINE__, 0xfffffffeL,	"fffffffe", "%+3.7x",
__LINE__, 0xfff7658cL,	"fff7658c", "%x",
__LINE__, -0x0006d08L,	"-0027912", "%7.7ld",
__LINE__, 0x00000080L,	"80", "%X",
__LINE__, 0x0000078fL,	"  1935", "% 6ld",
__LINE__, 0xfffffffbL,	"FFFFFFFB", "% X",
__LINE__, 0x000000aeL,	"     AE", "%7.X",
__LINE__, -0x000d6aaL,	"-54954", "%-ld",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%6.X",
__LINE__, 0x000003bfL,	"+959", "%+d",
__LINE__, -0x7242d04bL,	"-1916981323", "% ld",
__LINE__, 0xf0e6546fL,	"F0E6546F", "% .7X",
__LINE__, 0x047e196aL,	"75372906", "%ld",
__LINE__, 0x0240174eL,	"240174E", "%+0X",
__LINE__, -0x0000006L,	"-006", "%.3ld",
__LINE__, 0x00068aacL,	"428716", "%#ld",
__LINE__, 0xffffffa1L,	"ffffffa1", "%0x",
__LINE__, 0x000adab3L,	"adab3", "%x",
__LINE__, -0x00000aeL,	"-0000174", "%7.7ld",
__LINE__, 0x0f0a8f4bL,	"f0a8f4b", "% x",
__LINE__, 0xfee229bcL,	"fee229bc", "%x",
__LINE__, -0x275b8455L,	"-660309077", "%.2ld",
__LINE__, -0xca4b2a5L,	"-212120229", "%d",
__LINE__, 0x000000b5L,	" 181", "%04.d",
__LINE__, 0xfff213f2L,	"FFF213F2", "%X",
__LINE__, 0x00000003L,	"3", "%-X",
__LINE__, 0x0ebb978bL,	"247175051", "%.6ld",
__LINE__, 0xffffffcaL,	"FFFFFFCA", "%X",
__LINE__, -0x0000003L,	"-03", "%+0.2d",
__LINE__, -0x178ff86L,	"-24706950", "%+d",
__LINE__, 0x0000003cL,	"     60", "%7.ld",
__LINE__, -0x001012dL,	"-65837", "%.5d",
__LINE__, 0x03673fd2L,	"3673fd2", "%.5x",
__LINE__, -0x001fe74L,	"-130676", "%#0.6ld",
__LINE__, 0x004f6226L,	"4f6226", "%-0x",
__LINE__, 0xfffffa0fL,	"fffffa0f", "%7x",
__LINE__, 0xfffffff8L,	"fffffff8", "%-.6x",
__LINE__, -0x0000001L,	"-1", "%#d",
__LINE__, 0xffffe43dL,	"ffffe43d", "%7x",
__LINE__, 0x00009d47L,	"0040263", "%7.7ld",
__LINE__, 0xff0fc79fL,	"FF0FC79F", "%-4.X",
__LINE__, 0x2d610907L,	"2d610907", "%x",
__LINE__, -0x00002deL,	"-734", "%04d",
__LINE__, 0x0000036bL,	"    36B", "%7.1X",
__LINE__, 0x00000002L,	"2", "%.0x",
__LINE__, -0x1f577b3eL,	"-525826878", "%d",
__LINE__, 0x0000002dL,	"45", "%#ld",
__LINE__, 0xfffffffbL,	"fffffffb", "%x",
__LINE__, -0x0000004L,	"-4", "%-.0d",
__LINE__, 0x00016ba4L,	"16ba4", "%x",
__LINE__, -0x1ad853d5L,	"-450384853", "% 0ld",
__LINE__, 0x00366899L,	"366899", "%2.x",
__LINE__, 0x1659158bL,	"1659158B", "%X",
__LINE__, 0x000076c7L,	"76c7", "%x",
__LINE__, 0x00000674L,	"674", "%0x",
__LINE__, 0x016c9d8aL,	"+23895434", "%+ld",
__LINE__, 0xfffffc43L,	"FFFFFC43", "%0X",
__LINE__, 0xfff249d2L,	"fff249d2", "%-2.x",
__LINE__, 0xffffffddL,	"ffffffdd", "%5x",
__LINE__, 0xffffa7efL,	"FFFFA7EF", "%0.3X",
__LINE__, 0x030d4d06L,	"30d4d06", "%x",
__LINE__, -0x0e4694bL,	"-14969163", "%d",
__LINE__, 0x00000078L,	"120", "%.3ld",
__LINE__, -0x16c1273eL,	"-381757246", "%0d",
__LINE__, 0xffffd183L,	"FFFFD183", "% 0X",
__LINE__, -0x2dfdaddL,	"-48224989", "%ld",
__LINE__, -0x5767fe5cL,	"-1466433116", "%ld",
__LINE__, 0x01bea036L,	"29270070", "%#4.3d",
__LINE__, 0x00000027L,	"27", "%-x",
__LINE__, 0x0004d183L,	"4D183", "%X",
__LINE__, 0xffdaf9c8L,	"FFDAF9C8", "%.7X",
__LINE__, 0xfffffd95L,	"fffffd95", "%x",
__LINE__, -0x0059acbL,	"-367307", "%00.d",
__LINE__, 0x017d8db4L,	"17d8db4", "% 05.x",
__LINE__, 0x0001f084L,	"001F084", "%5.7X",
__LINE__, 0x00000006L,	" 6", "% ld",
__LINE__, 0x011b0802L,	"18548738", "%.3ld",
__LINE__, 0x00000006L,	"  6", "%#3.d",
__LINE__, 0xffffffffL,	"ffffffff", "%6x",
__LINE__, 0x00000001L,	"1", "% x",
__LINE__, 0x00000750L,	" 01872", "% .5d",
__LINE__, 0xfffffff9L,	"fffffff9", "%x",
__LINE__, -0x00f842cL,	"-1016876", "%+d",
__LINE__, -0x001dcf0L,	"-122096", "%-0d",
__LINE__, 0x000000c9L,	"0XC9", "% #3X",
__LINE__, 0x1e368e86L,	"1e368e86", "%7x",
__LINE__, -0x0001157L,	"-4439", "% 03.4d",
__LINE__, 0xfff91e87L,	"FFF91E87", "%3.5X",
__LINE__, 0x00000006L,	"6", "%x",
__LINE__, 0x00000bcaL,	"3018", "%ld",
__LINE__, 0x00495ff6L,	"495ff6", "%01.0x",
__LINE__, -0x0267f7aL,	"-2523002", "% #5d",
__LINE__, 0x00000060L,	"96", "%-d",
__LINE__, 0x000850c6L,	"544966", "%#.1d",
__LINE__, 0x00231457L,	"231457", "%-6.4X",
__LINE__, 0x0000000bL,	"11", "%-d",
__LINE__, 0x000003bdL,	"957", "%#d",
__LINE__, 0xfd51d970L,	"FD51D970", "%+.7X",
__LINE__, 0x000007bfL,	"1983", "%-ld",
__LINE__, 0x000034b2L,	"34B2", "%0.X",
__LINE__, 0x0000c18dL,	"C18D", "%0.X",
__LINE__, 0xffffbb83L,	"ffffbb83", "% 3x",
__LINE__, 0x000001d0L,	"0x1d0", "%#x",
__LINE__, -0x003c784L,	"-247684", "%#ld",
__LINE__, 0x0210cffaL,	"210CFFA", "%X",
__LINE__, -0x33093a1L,	"-53515169", "% 0d",
__LINE__, 0x00000001L,	" 1", "% #ld",
__LINE__, 0xffffaa53L,	"ffffaa53", "%-4.5x",
__LINE__, 0x2935c056L,	"691388502", "%1.d",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, 0x000013d1L,	"0X013D1", "%+#2.5X",
__LINE__, -0x000035cL,	"-860", "%-.2d",
__LINE__, 0x00000000L,	"    ", "%-4.X",
__LINE__, -0x0000147L,	"-327", "%d",
__LINE__, 0x0a317eb0L,	"171015856", "%.7d",
__LINE__, 0x00000003L,	"3", "%ld",
__LINE__, 0x000001d6L,	"1d6", "%-x",
__LINE__, 0x18185214L,	"404247060", "%-.2ld",
__LINE__, 0x00574140L,	"0574140", "%.7X",
__LINE__, 0x00002ea5L,	"02ea5", "%.5x",
__LINE__, 0x00000005L,	"5", "% x",
__LINE__, 0xffc47ed6L,	"ffc47ed6", "%-x",
__LINE__, 0x0001f5daL,	"0X1F5DA", "%#X",
__LINE__, 0xfffffcc9L,	"fffffcc9", "% x",
__LINE__, 0x02586c98L,	"2586C98", "%X",
__LINE__, -0x0000036L,	"-54", "% ld",
__LINE__, 0x00064b57L,	"412503", "%1.5d",
__LINE__, -0x0000007L,	"-7", "%#0.0ld",
__LINE__, 0x00023a03L,	"145923", "%ld",
__LINE__, -0x0000065L,	"-101", "%+#d",
__LINE__, 0x00000208L,	"208", "%X",
__LINE__, 0x00e97728L,	"15300392", "%-ld",
__LINE__, 0x0000030aL,	"+778", "%+d",
__LINE__, 0xf4d7deeeL,	"F4D7DEEE", "%+X",
__LINE__, -0x000009aL,	"-154", "%+.3ld",
__LINE__, 0x000002c0L,	"+704", "%+ld",
__LINE__, 0x0067ec23L,	"67ec23", "%x",
__LINE__, 0x005ca7fcL,	"+6072316", "%+d",
__LINE__, 0xfffff5f1L,	"fffff5f1", "%x",
__LINE__, 0x00000601L,	"  0X601", "%#7.2X",
__LINE__, -0x0000057L,	"-87", "% ld",
__LINE__, -0x0000078L,	"   -120", "%7.d",
__LINE__, -0x000001fL,	"-31   ", "%-6d",
__LINE__, 0x0160c000L,	"23117824", "%ld",
__LINE__, -0x0000007L,	"-7", "%0ld",
__LINE__, 0xfffffffeL,	"fffffffe", "%+x",
__LINE__, 0x5b6ef898L,	"5b6ef898", "%+0x",
__LINE__, 0x0009bfb6L,	"638902", "%d",
__LINE__, -0x0000145L,	"  -325", "%#6.0d",
__LINE__, -0x508c048L,	"-84459592", "%-5.ld",
__LINE__, 0x00000002L,	" 0x2", "% #4x",
__LINE__, 0x0001486eL,	"84078", "%#d",
__LINE__, 0x006ac76aL,	"6997866", "%.6d",
__LINE__, 0xffffff98L,	"FFFFFF98", "%X",
__LINE__, 0xfffffe08L,	"fffffe08", "%6.x",
__LINE__, -0x24ef47eL,	"-38728830", "%1.6ld",
__LINE__, 0x39d1b2dbL,	"39D1B2DB", "% X",
__LINE__, 0xfffc9ce2L,	"0xfffc9ce2", "%#x",
__LINE__, 0x59485e14L,	"1497914900", "%#4ld",
__LINE__, 0x000022ebL,	"22EB", "%3.X",
__LINE__, 0xfa410352L,	"FA410352", "%-X",
__LINE__, -0x4a342f0L,	"-77808368", "% ld",
__LINE__, 0xef5825a4L,	"EF5825A4", "%.6X",
__LINE__, 0x01b0185aL,	"0x1b0185a", "% #x",
__LINE__, -0x0004290L,	"-17040", "%.3d",
__LINE__, -0x10f88659L,	"-284722777", "%+6.2ld",
__LINE__, 0x00003216L,	"12822", "%-d",
__LINE__, 0x4a31a219L,	"1244766745", "%d",
__LINE__, 0xffffffb5L,	"FFFFFFB5", "%-X",
__LINE__, 0x0000d586L,	"D586", "%-2.X",
__LINE__, 0x00008496L,	"33942", "%1.d",
__LINE__, -0x0000011L,	"-17", "%1ld",
__LINE__, 0x0000003cL,	"3C", "%2.X",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%.3X",
__LINE__, 0x0000152aL,	"152A", "%X",
__LINE__, 0xfffe876eL,	"FFFE876E", "%X",
__LINE__, -0x0003874L,	"-14452", "%-ld",
__LINE__, -0x004918aL,	"-299402", "%#.6d",
__LINE__, -0x000000cL,	"-12", "%-d",
__LINE__, 0xffffd812L,	"FFFFD812", "%+X",
__LINE__, -0x000000cL,	"-12", "%0d",
__LINE__, -0x0000229L,	"-553", "%0d",
__LINE__, 0x00002ab8L,	"2AB8", "%4.X",
__LINE__, 0x0000004bL,	"+75", "%+ld",
__LINE__, 0x001c3178L,	" 1847672", "% ld",
__LINE__, -0x0000006L,	"-6", "%.0ld",
__LINE__, 0x0003be65L,	"245349", "%ld",
__LINE__, -0x0000001L,	"-1", "%#1ld",
__LINE__, 0x0000007fL,	"+127", "%+ld",
__LINE__, 0x0000020eL,	"526  ", "%-5ld",
__LINE__, 0x00000002L,	"2", "%d",
__LINE__, 0x03bd0873L,	"0X3BD0873", "%#X",
__LINE__, 0x00093a52L,	"604754", "%-2d",
__LINE__, -0x00823fcL,	"-0533500", "%+.7ld",
__LINE__, 0x00000000L,	"    ", "%4.X",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, 0xfff09edeL,	"fff09ede", "%-x",
__LINE__, 0x01e28c24L,	"31624228", "%ld",
__LINE__, 0x00001dccL,	"1DCC", "%X",
__LINE__, -0x0f0ea0dL,	"-15788557", "%-00.ld",
__LINE__, 0xffff73a1L,	"FFFF73A1", "%X",
__LINE__, -0x0004040L,	"-16448", "%+#d",
__LINE__, 0x0073b158L,	"0x73b158", "%#7x",
__LINE__, 0xfffff8ffL,	"FFFFF8FF", "% 5X",
__LINE__, -0x0000004L,	"-4", "%0d",
__LINE__, 0xffff56a3L,	"ffff56a3", "%1.6x",
__LINE__, -0x0000041L,	"-65", "%0d",
__LINE__, 0x00000009L,	"+0000009", "%+2.7d",
__LINE__, 0xffffe13dL,	"0XFFFFE13D", "%+#2.X",
__LINE__, -0x00002ceL,	"-00718", "%.5ld",
__LINE__, 0xffc53e28L,	"ffc53e28", "%03.4x",
__LINE__, 0x00000005L,	"0X5", "%#X",
__LINE__, 0x00000004L,	"4", "%x",
__LINE__, 0xe21b35ebL,	"e21b35eb", "%-x",
__LINE__, -0x0000098L,	"-152", "%-ld",
__LINE__, 0xffffff81L,	"FFFFFF81", "%2X",
__LINE__, 0x00000003L,	"00003", "%.5ld",
__LINE__, 0xfffffffcL,	"fffffffc", "%+x",
__LINE__, 0x000491f5L,	"299509", "%1.ld",
__LINE__, 0xf06bfd7dL,	"F06BFD7D", "%X",
__LINE__, -0x0000006L,	"-6", "%0d",
__LINE__, -0x0a4af7dL,	"-10792829", "%-0d",
__LINE__, -0x11a74efL,	"-18511087", "%ld",
__LINE__, 0x2dc95e17L,	"768171543", "%-1.d",
__LINE__, -0x0000001L,	"-1", "%#ld",
__LINE__, 0x00000033L,	"51", "%-#d",
__LINE__, 0x002d0219L,	"2949657", "%ld",
__LINE__, 0xfffffffdL,	"FFFFFFFD", "%2.4X",
__LINE__, 0x00000f20L,	"+3872", "%+ld",
__LINE__, -0x0000047L,	"-071", "%4.3ld",
__LINE__, 0x00000010L,	"    16", "%6d",
__LINE__, 0x00000000L,	"0", "%0d",
__LINE__, 0xffffff57L,	"FFFFFF57", "%X",
__LINE__, -0x0000700L,	"-1792", "%-#d",
__LINE__, -0x0000064L,	"-100", "%-ld",
__LINE__, 0xff26d49aL,	"FF26D49A", "%-0X",
__LINE__, -0x0000006L,	"-6", "%.1ld",
__LINE__, 0x1391edc5L,	"1391edc5", "%.1x",
__LINE__, 0x0000014aL,	"330", "%-#ld",
__LINE__, 0x07ecd1e1L,	"7ecd1e1", "%6x",
__LINE__, -0xa2b8898L,	"-170625176", "%3.d",
__LINE__, 0x00035287L,	"0x35287", "%#.0x",
__LINE__, 0x00000000L,	"00000", "%0.5X",
__LINE__, -0x0000153L,	"-339", "%d",
__LINE__, 0x0000ad6eL,	" 44398", "% 0.d",
__LINE__, 0x00000001L,	"1", "%-X",
__LINE__, -0x000000dL,	"-13   ", "%-6.2d",
__LINE__, -0x01bff8aL,	"-1834890", "%d",
__LINE__, 0x000a0fa8L,	"+659368", "%+ld",
__LINE__, 0xac044dc0L,	"ac044dc0", "%.0x",
__LINE__, 0x0003a729L,	"239401", "%ld",
__LINE__, -0x00004f0L,	"-1264", "%+ld",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0x00000012L,	"12", "% x",
__LINE__, 0xffff770bL,	"ffff770b", "%7.1x",
__LINE__, 0xd7458572L,	"d7458572", "%x",
__LINE__, 0x01f1b4f9L,	"1f1b4f9", "% 0x",
__LINE__, 0xfffb2198L,	"0XFFFB2198", "% #1.X",
__LINE__, 0x00ef6189L,	" 15688073", "% ld",
__LINE__, -0x3f0ae63L,	"-66104931", "% #d",
__LINE__, -0x0006075L,	"-24693", "%ld",
__LINE__, 0x000000a1L,	"161", "%d",
__LINE__, 0xfffffffcL,	"fffffffc", "%3.2x",
__LINE__, 0xff6b4125L,	"FF6B4125", "%+5.X",
__LINE__, 0x00000001L,	"     1", "%6.d",
__LINE__, -0x0000001L,	"-1", "%+0d",
__LINE__, -0x000096cL,	"-2412", "%0.4d",
__LINE__, 0x00039c6fL,	"236655", "%.0d",
__LINE__, 0x3625286cL,	"908404844", "%.1d",
__LINE__, 0xfffffffaL,	"fffffffa", "%x",
__LINE__, 0x00000000L,	"0", "%X",
__LINE__, 0x00c34353L,	"12796755", "%#.4d",
__LINE__, 0x000002dfL,	"735", "%ld",
__LINE__, 0xffff38faL,	"FFFF38FA", "%5.1X",
__LINE__, -0x000002aL,	"-42", "%0.d",
__LINE__, 0x0000077eL,	"1918", "%ld",
__LINE__, 0x000001f7L,	"503", "%ld",
__LINE__, 0x00000004L,	"4", "%ld",
__LINE__, 0x0021fb02L,	"2226946", "%d",
__LINE__, 0x007c858dL,	"8160653", "%-0d",
__LINE__, -0x0000109L,	"-265", "%.0d",
__LINE__, 0xfffffffaL,	"fffffffa", "% x",
__LINE__, 0x0097932dL,	"97932d", "%+x",
__LINE__, 0xfffbbd03L,	"fffbbd03", "%-.5x",
__LINE__, -0x0000005L,	"-5", "%0d",
__LINE__, 0x03ee3a95L,	"65944213", "%ld",
__LINE__, -0x0000002L,	" -00002", "%7.5d",
__LINE__, 0xea1a4e54L,	"EA1A4E54", "%X",
__LINE__, -0x000a9d6L,	"-43478", "%+d",
__LINE__, -0x0fd8d65L,	"-16616805", "%5ld",
__LINE__, 0x00000001L,	"1", "%-d",
__LINE__, 0x00000072L,	"72", "%2.X",
__LINE__, 0xffffff94L,	"FFFFFF94", "%X",
__LINE__, 0x00000d2aL,	"D2A", "%+X",
__LINE__, 0xffff614fL,	"ffff614f", "%x",
__LINE__, -0x0000018L,	"-24", "%ld",
__LINE__, 0x0000003bL,	"059", "%2.3d",
__LINE__, 0x0000001aL,	"1A", "%0X",
__LINE__, -0x0000109L,	"-265", "%02ld",
__LINE__, 0x00000f9dL,	"3997", "%#1d",
__LINE__, 0x0000001bL,	"1b", "%x",
__LINE__, 0xffffff07L,	"ffffff07", "%x",
__LINE__, 0xfff1a425L,	"0xfff1a425", "%#x",
__LINE__, 0x00000005L,	"5", "%-1d",
__LINE__, -0x53a6efdL,	"-87715581", "%ld",
__LINE__, 0x042f37dbL,	"42F37DB", "%6.X",
__LINE__, 0x00053bd5L,	"+342997", "%+5ld",
__LINE__, 0xffffffffL,	"ffffffff", "% x",
__LINE__, 0xffffffefL,	"FFFFFFEF", "%6.X",
__LINE__, -0x10ec29aL,	"-17744538", "%+2.d",
__LINE__, 0x01dcc901L,	"1dcc901", "%x",
__LINE__, 0x0007dc68L,	"515176", "%-3.d",
__LINE__, -0x0000062L,	"-0098", "%#2.4d",
__LINE__, 0x00000000L,	"   ", "%3.0X",
__LINE__, -0x00000deL,	"-222", "%ld",
__LINE__, 0x000c1fb8L,	"C1FB8", "%0X",
__LINE__, 0x0005bf58L,	"5BF58", "%X",
__LINE__, -0x000dd1bL,	"-56603", "%-03.1d",
__LINE__, 0x00000b14L,	"B14", "%+3.X",
__LINE__, 0x00000799L,	"799", "%-x",
__LINE__, 0xfffffffaL,	"fffffffa", "%x",
__LINE__, 0x00000003L,	"0x00003", "% #7.5x",
__LINE__, -0x002b9f1L,	"-178673", "%+d",
__LINE__, -0x001b817L,	"-112663", "%0d",
__LINE__, 0xf6f98533L,	"f6f98533", "%.1x",
__LINE__, 0x00338ffcL,	"3379196", "%d",
__LINE__, 0x0409e9b5L,	"0X409E9B5", "%#X",
__LINE__, 0x00b8e98eL,	" 12118414", "% 0d",
__LINE__, -0x002a8f6L,	"-174326", "%ld",
__LINE__, 0x13bb9722L,	"331061026", "%0d",
__LINE__, 0x00063c71L,	"63c71", "%x",
__LINE__, 0xfffffe37L,	"FFFFFE37", "%.1X",
__LINE__, 0xffff7b3eL,	"ffff7b3e", "%+.1x",
__LINE__, 0x005eeab1L,	"5eeab1", "%+x",
__LINE__, 0xffc69e99L,	"ffc69e99", "%x",
__LINE__, -0x000005cL,	"  -92", "%5ld",
__LINE__, 0x07d8fa8aL,	"7d8fa8a", "%x",
__LINE__, 0x00030e0aL,	"200202", "%-4.1d",
__LINE__, 0x00001dc1L,	"1DC1", "%.0X",
__LINE__, 0x00000008L,	"8", "%0ld",
__LINE__, -0x01b5397L,	"-1790871", "%3.d",
__LINE__, 0x27fbb4b5L,	"27fbb4b5", "%x",
__LINE__, -0xe3fdcfcL,	"-239066364", "%4ld",
__LINE__, 0x0008bcb1L,	"8bcb1", "%0x",
__LINE__, 0xffff039eL,	"ffff039e", "%.6x",
__LINE__, 0x000d0bd4L,	"d0bd4", "%-x",
__LINE__, 0x00000000L,	"+0", "%+d",
__LINE__, -0x2a49ea4L,	"-44342948", "%1d",
__LINE__, -0x0000055L,	"-85", "%0d",
__LINE__, -0x0000a05L,	"-2565", "%3.3ld",
__LINE__, -0x000000bL,	"-11 ", "%-4d",
__LINE__, 0xfff30444L,	"FFF30444", "%7.X",
__LINE__, 0x0000003fL,	"63", "%-0d",
__LINE__, 0x00046779L,	"46779", "%X",
__LINE__, 0x000028d7L,	" 0X28D7", "%#7.X",
__LINE__, 0x00000019L,	"   19", "%5x",
__LINE__, 0x0032291dL,	"3287325", "%2.ld",
__LINE__, 0x00057afaL,	"57AFA", "%X",
__LINE__, 0xfffe8c64L,	"fffe8c64", "%3.4x",
__LINE__, -0x624110d6L,	"-1648431318", "%+6d",
__LINE__, 0x0000001aL,	"   26", "% 5.d",
__LINE__, 0xfffffffdL,	"FFFFFFFD", "%6.X",
__LINE__, 0x00199490L,	"1676432", "%-1d",
__LINE__, -0xfff8265L,	"-268403301", "%-0ld",
__LINE__, 0x0000000eL,	"e", "%-x",
__LINE__, 0x00c38aecL,	"c38aec", "%x",
__LINE__, -0x00658f4L,	"-415988", "%#ld",
__LINE__, 0x0066ac4eL,	"6728782", "%0d",
__LINE__, 0xc4a808d5L,	"c4a808d5", "%x",
__LINE__, 0x00000000L,	"     0", "%6.1x",
__LINE__, 0x00066d24L,	"66d24", "%x",
__LINE__, 0x00002117L,	"2117", "%X",
__LINE__, 0xfe06fdf4L,	"FE06FDF4", "%0X",
__LINE__, 0xfffffff9L,	"fffffff9", "%x",
__LINE__, 0x1c6bb795L,	"+476821397", "%+d",
__LINE__, 0xfffffba4L,	"FFFFFBA4", "%X",
__LINE__, 0xfffd7d44L,	"fffd7d44", "%0x",
__LINE__, 0x0019dd17L,	"1694999", "%d",
__LINE__, 0x6475851eL,	"0x6475851e", "% #7.x",
__LINE__, -0x00330d5L,	"-209109", "%0ld",
__LINE__, 0x009f53f7L,	"09F53F7", "%+6.7X",
__LINE__, -0x00172f9L,	" -94969", "%7.5ld",
__LINE__, 0xffffffdcL,	"FFFFFFDC", "%X",
__LINE__, -0x013bdecL,	"-1293804", "%+#2ld",
__LINE__, 0xfff845c0L,	"fff845c0", "%+7.x",
__LINE__, -0x0fbe712L,	"-16508690", "%.7d",
__LINE__, 0xffffe13fL,	"ffffe13f", "%x",
__LINE__, 0xbbc19951L,	"BBC19951", "%-4X",
__LINE__, -0x28d6d1bL,	"-42822939", "%#d",
__LINE__, -0x93cda6bL,	"-154983019", "%-d",
__LINE__, 0xffc93342L,	"FFC93342", "%7.X",
__LINE__, 0x072ac8b3L,	" 120244403", "% ld",
__LINE__, 0xfff8d17bL,	"FFF8D17B", "% X",
__LINE__, 0x00000da5L,	"DA5", "%0.X",
__LINE__, 0x055ad3acL,	"0x55ad3ac", "%#1x",
__LINE__, 0x00000e5aL,	" 3674", "% .4ld",
__LINE__, 0xffffff79L,	"FFFFFF79", "%+X",
__LINE__, 0xffffe167L,	"ffffe167", "%+5x",
__LINE__, 0x0000fa50L,	"0064080", "%.7ld",
__LINE__, 0x00000001L,	"1", "%-d",
__LINE__, 0xfffffffeL,	"fffffffe", "%x",
__LINE__, 0x000009acL,	" 2476", "% #2.ld",
__LINE__, 0x00000e78L,	"0003704", "%.7ld",
__LINE__, -0x000dfc3L,	"-57283", "%6.d",
__LINE__, 0x00000ee0L,	"EE0", "%0X",
__LINE__, -0x293703b3L,	"-691471283", "%ld",
__LINE__, 0x000073e8L,	"  73e8", "%6x",
__LINE__, 0xffffdffdL,	"ffffdffd", "%5.5x",
__LINE__, 0x00000004L,	"4", "%+00.x",
__LINE__, 0x00000008L,	"0X8", "%#X",
__LINE__, 0x0003044cL,	"3044c", "%0x",
__LINE__, 0xffc2095eL,	"FFC2095E", "%0X",
__LINE__, 0x00000aacL,	"0002732", "%-.7ld",
__LINE__, 0xffffff79L,	"FFFFFF79", "%+1.X",
__LINE__, 0x53a0f94aL,	" 1403058506", "% 2.4ld",
__LINE__, 0x000e928dL,	"e928d", "%x",
__LINE__, 0x0024127aL,	"2364026", "%5.d",
__LINE__, 0x000f7c1cL,	" 1014812", "% 2.d",
__LINE__, -0x000003dL,	"-61 ", "%-#4ld",
__LINE__, -0x0000122L,	"-290", "%+ld",
__LINE__, 0x00000006L,	"+6", "%+0d",
__LINE__, 0x00000129L,	" 000129", "%7.6X",
__LINE__, 0x15d873e5L,	" 366506981", "% 5.7d",
__LINE__, 0x00000001L,	"1", "%d",
__LINE__, 0x038d6110L,	"+59597072", "%+d",
__LINE__, 0x0f46ccc3L,	"256298179", "%-1.4d",
__LINE__, 0xfe434d21L,	"fe434d21", "%x",
__LINE__, -0x179797d7L,	"-395810775", "%d",
__LINE__, 0xe35807bfL,	"e35807bf", "%x",
__LINE__, 0x00000003L,	"     +3", "%+7d",
__LINE__, 0x017e699eL,	"25061790", "%#ld",
__LINE__, -0x0000029L,	"-41", "%d",
__LINE__, 0xffffff11L,	"ffffff11", "%1.x",
__LINE__, -0x0001bf6L,	"-7158", "%+0ld",
__LINE__, 0xffffff4bL,	"FFFFFF4B", "%4X",
__LINE__, -0x0000040L,	"-64", "%ld",
__LINE__, 0x000034d6L,	"+13526", "%+ld",
__LINE__, 0xffffffa7L,	"ffffffa7", "%x",
__LINE__, 0xfffffe8eL,	"fffffe8e", "%+.3x",
__LINE__, 0x00000000L,	"0", "%0.1d",
__LINE__, -0x007cdf1L,	"-511473", "%ld",
__LINE__, 0xfffffeefL,	"FFFFFEEF", "%-X",
__LINE__, 0x00002d91L,	"2d91", "%x",
__LINE__, -0x000025bL,	"-603", "%#ld",
__LINE__, -0x000001bL,	"-27", "%-ld",
__LINE__, 0x042b6752L,	"42B6752", "%+X",
__LINE__, -0x75afb0a6L,	"-1974448294", "% ld",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, 0x00000542L,	"  1346", "%6d",
__LINE__, -0x0000010L,	"-16", "%+0d",
__LINE__, 0xfffed8f7L,	"FFFED8F7", "%5.X",
__LINE__, 0x0541852eL,	"541852e", "% 2.x",
__LINE__, 0xff22aec3L,	"ff22aec3", "% .1x",
__LINE__, 0x5e34b745L,	"1580513093", "%ld",
__LINE__, 0xfffffff3L,	"fffffff3", "%x",
__LINE__, 0x0eda7b86L,	"+249199494", "%+.3d",
__LINE__, 0xffffe40fL,	"ffffe40f", "%+x",
__LINE__, -0x0003484L,	"-13444", "%-1.5ld",
__LINE__, 0x0000334bL,	" 13131", "%6.ld",
__LINE__, -0x0000149L,	"-329", "%ld",
__LINE__, 0x00000001L,	"  001", "% 5.3x",
__LINE__, 0xffeaa035L,	"ffeaa035", "%+3.5x",
__LINE__, 0x00211dffL,	"2170367", "%ld",
__LINE__, 0x007e91f4L,	"7e91f4", "%x",
__LINE__, 0xfffffffcL,	"0xfffffffc", "%+#5x",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%6.X",
__LINE__, 0x0156a9b5L,	"156a9b5", "%x",
__LINE__, 0xfffffe58L,	"fffffe58", "%+x",
__LINE__, 0xffff8c66L,	"FFFF8C66", "%.0X",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, 0x00000005L,	"      5", "%7.d",
__LINE__, -0x0000002L,	"-2", "%ld",
__LINE__, 0x000076b9L,	" 30393", "% ld",
__LINE__, 0x00003824L,	"3824", "%4X",
__LINE__, 0x00000cdfL,	"    CDF", "% 7X",
__LINE__, 0x017c9e8fL,	"17C9E8F", "%-X",
__LINE__, -0x20f582dL,	"-34560045", "%-.5d",
__LINE__, 0x0000732eL,	"  29486", "% 7.ld",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%+0X",
__LINE__, 0xf379a4a2L,	"F379A4A2", "% .7X",
__LINE__, -0x0000028L,	"-40", "%-d",
__LINE__, 0xe73cf79eL,	"e73cf79e", "%x",
__LINE__, 0x00000002L,	"      2", "%7ld",
__LINE__, -0x00029b1L,	"-10673", "%-#1.ld",
__LINE__, -0x0002a58L,	"-10840", "%3.d",
__LINE__, 0x00000002L,	"2", "%-X",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%X",
__LINE__, -0x000003aL,	"  -58", "%5ld",
__LINE__, 0x0245ef3bL,	"245ef3b", "%.3x",
__LINE__, 0x00026ccaL,	"158922", "%-06.3ld",
__LINE__, 0x01016fd3L,	"16871379", "%-d",
__LINE__, 0x000016fcL,	"5884", "%0ld",
__LINE__, -0x00007fbL,	"  -2043", "%7.3d",
__LINE__, 0xfff73d3cL,	"fff73d3c", "%0x",
__LINE__, -0x0000110L,	"-272", "% 04.3d",
__LINE__, 0x0000000eL,	" 014", "% 04ld",
__LINE__, -0x0000039L,	"-57", "%.0ld",
__LINE__, 0x00000c95L,	"c95", "%0x",
__LINE__, 0xffff3b2eL,	"ffff3b2e", "%x",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%X",
__LINE__, 0x00000015L,	"21", "%.1d",
__LINE__, 0x0000000cL,	"+12", "%+ld",
__LINE__, 0x00000000L,	"0", "%+X",
__LINE__, 0xfffc9a14L,	"fffc9a14", "%-.5x",
__LINE__, 0x0000003cL,	"60", "%.2ld",
__LINE__, -0x0000023L,	"   -35", "%6.d",
__LINE__, 0x00000740L,	"1856", "%ld",
__LINE__, 0x00000160L,	"160", "% 3.X",
__LINE__, 0x00000006L,	"    6", "%5.X",
__LINE__, -0x0000677L,	"-1655", "%.3ld",
__LINE__, 0x12709c7eL,	"12709C7E", "%.7X",
__LINE__, 0x0000090fL,	"+2319", "%+#d",
__LINE__, 0xffffffe0L,	"0xffffffe0", "%#4.1x",
__LINE__, 0x00132ce0L,	"1256672", "%ld",
__LINE__, 0x00000059L,	"59", "%+X",
__LINE__, -0x0000017L,	"-23", "%0d",
__LINE__, -0x01fade6L,	"-2076134", "%-4.3ld",
__LINE__, 0x000df3faL,	"914426", "%.5ld",
__LINE__, 0xfffffd0fL,	"fffffd0f", "%7x",
__LINE__, -0x000c212L,	"-49682", "%0.1ld",
__LINE__, 0xffff8bcbL,	"FFFF8BCB", "%.3X",
__LINE__, 0x0000000aL,	"a", "% x",
__LINE__, 0x00000021L,	"21", "%x",
__LINE__, -0x0000040L,	"-64", "% 1ld",
__LINE__, 0x00000009L,	"     9", "%6.ld",
__LINE__, -0x0000d67L,	"-3431", "% 5.3d",
__LINE__, 0x03a85f1bL,	"61366043", "%ld",
__LINE__, 0x00000035L,	"000053", "%0.6d",
__LINE__, 0xfffda5cbL,	"fffda5cb", "%+x",
__LINE__, 0xffffff78L,	"FFFFFF78", "%-7.0X",
__LINE__, 0xfffffd6dL,	"fffffd6d", "%7.x",
__LINE__, 0xfffffc08L,	"fffffc08", "%7.3x",
__LINE__, 0x00003335L,	" 13109", "% #d",
__LINE__, -0x0000002L,	"   -2", "%5.d",
__LINE__, -0x13767a48L,	"-326531656", "%+ld",
__LINE__, 0x00000be5L,	"3045", "%4.0ld",
__LINE__, 0xfffdb28cL,	"FFFDB28C", "%X",
__LINE__, 0x00127118L,	"1208600", "%ld",
__LINE__, 0x00000086L,	" 134", "% ld",
__LINE__, 0x0002214cL,	"2214c", "%+x",
__LINE__, 0x0000a0c2L,	" a0c2", "%5.0x",
__LINE__, -0x000007cL,	"-124", "%ld",
__LINE__, 0x0000012aL,	"00298", "%3.5d",
__LINE__, 0xfd4f1257L,	"FD4F1257", "%+2.X",
__LINE__, 0xffffd8aaL,	"ffffd8aa", "%5x",
__LINE__, -0x00000a7L,	"-167", "%+ld",
__LINE__, -0x0009c69L,	"-40041", "%0.0ld",
__LINE__, 0x02230418L,	"35849240", "%-0.6ld",
__LINE__, 0x00000000L,	"     0", "%6x",
__LINE__, 0xfffff184L,	"fffff184", "%02.5x",
__LINE__, -0x0ae967bL,	"-11441787", "%d",
__LINE__, 0x0015de3aL,	"1433146", "%-5.3d",
__LINE__, -0x0071e93L,	"-466579", "%1.ld",
__LINE__, 0xfffff8bdL,	"fffff8bd", "%+x",
__LINE__, -0x00000e4L,	"-228", "%+ld",
__LINE__, 0x000001d8L,	" 472", "% .3ld",
__LINE__, 0x00315faaL,	"315faa", "%-0x",
__LINE__, 0x00000e59L,	"e59", "%0x",
__LINE__, -0x0000005L,	"-5", "%ld",
__LINE__, 0x000018ecL,	"6380", "%ld",
__LINE__, 0xfffffff9L,	"fffffff9", "%5.2x",
__LINE__, -0xe7cfd39L,	"-243072313", "%-d",
__LINE__, 0x0002c30bL,	"2C30B", "%1.2X",
__LINE__, 0x0000007aL,	"7A", "%X",
__LINE__, 0xf604ecb2L,	"F604ECB2", "%2X",
__LINE__, -0x05f602cL,	"-6250540", "%d",
__LINE__, 0xffff9c86L,	"ffff9c86", "%2.x",
__LINE__, -0x00d7f55L,	"-884565", "%#d",
__LINE__, 0xd2a37824L,	"D2A37824", "%4X",
__LINE__, 0x00000000L,	"", "%-.0x",
__LINE__, 0x000d4b51L,	"0d4b51", "%3.6x",
__LINE__, 0x000ecd97L,	"ecd97", "% x",
__LINE__, -0x0000018L,	"-024", "%+04ld",
__LINE__, -0x009f292L,	"-651922", "%ld",
__LINE__, -0x0002da9L,	"-11689", "%-0ld",
__LINE__, -0x000a218L,	"-41496", "%4.5d",
__LINE__, 0xffff85acL,	"FFFF85AC", "% 04.X",
__LINE__, -0x0d9ffbeL,	"-14286782", "%0d",
__LINE__, 0xfb18cc8eL,	"fb18cc8e", "%x",
__LINE__, 0xffffe5d3L,	"FFFFE5D3", "%-X",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, -0x0000006L,	"-6", "% d",
__LINE__, 0x0002fc62L,	"2fc62", "% 03.x",
__LINE__, 0x00000000L,	"00", "%.2d",
__LINE__, -0x00000fdL,	"  -253", "%6ld",
__LINE__, -0x000000bL,	"-11", "%d",
__LINE__, -0x00042a3L,	"-17059", "% 6d",
__LINE__, 0x00000002L,	"2", "% X",
__LINE__, -0x61ead93eL,	"-1642780990", "%-0d",
__LINE__, 0xf2e61f6dL,	"f2e61f6d", "%-.4x",
__LINE__, 0xffd31b93L,	"ffd31b93", "%x",
__LINE__, -0x0000008L,	"-8", "%ld",
__LINE__, 0xffffffffL,	"ffffffff", "%00x",
__LINE__, 0x000000fbL,	"+000251", "%+2.6d",
__LINE__, 0x00000015L,	"  15", "%4.X",
__LINE__, 0x06ec6d96L,	"6EC6D96", "%+2.X",
__LINE__, 0xffff1df7L,	"0xffff1df7", "% #1x",
__LINE__, -0x000004bL,	"-75", "%-ld",
__LINE__, 0x00000008L,	"8", "%#.0d",
__LINE__, 0x00001355L,	"4949", "%3.4ld",
__LINE__, -0x00000f7L,	"-247", "%d",
__LINE__, 0x0000001fL,	"31", "%.2ld",
__LINE__, 0x0000d556L,	"D556", "%-X",
__LINE__, 0xffffd5a5L,	"ffffd5a5", "% x",
__LINE__, -0x0000e34L,	"-3636", "%#d",
__LINE__, -0x0000007L,	"-7", "%d",
__LINE__, 0x01ba10a4L,	"1ba10a4", "%x",
__LINE__, 0xfffff759L,	"FFFFF759", "% X",
__LINE__, -0x80d0adbL,	"-135072475", "%d",
__LINE__, 0x0002bf61L,	"2bf61", "%x",
__LINE__, 0xffff008bL,	"FFFF008B", "%-7X",
__LINE__, 0x00000e72L,	"E72", "%X",
__LINE__, -0x00000eaL,	"-234", "%0ld",
__LINE__, -0x0007b9dL,	"-0031645", "%0.7ld",
__LINE__, 0x0001baaaL,	"0X1BAAA", "%#4X",
__LINE__, 0x0000a57fL,	"  a57f", "%6.x",
__LINE__, -0x21a73726L,	"-564606758", "%ld",
__LINE__, 0x06f45c9fL,	"0x6f45c9f", "%#.3x",
__LINE__, 0x00018e5dL,	"101981", "%-d",
__LINE__, 0x0001e69aL,	"124570", "%-d",
__LINE__, -0x0000d26L,	"  -3366", "% 07.d",
__LINE__, 0x00000000L,	"+", "%+0.ld",
__LINE__, 0x00003916L,	"14614", "%ld",
__LINE__, 0xfffffd8fL,	"fffffd8f", "%-3.x",
__LINE__, 0x00000011L,	"11", "%x",
__LINE__, 0x000000e7L,	"E7", "%X",
__LINE__, 0xfdf9d89bL,	"FDF9D89B", "%X",
__LINE__, 0x00000a7cL,	"a7c", "%x",
__LINE__, 0x0000003fL,	"00003F", "%.6X",
__LINE__, 0xffffe729L,	"FFFFE729", "%X",
__LINE__, 0xfffffffeL,	"fffffffe", "% .6x",
__LINE__, -0x0000a4bL,	"-2635", "%+d",
__LINE__, 0xffffff50L,	"ffffff50", "%0.7x",
__LINE__, 0xfaf57e8bL,	"faf57e8b", "% 4.x",
__LINE__, -0x0000056L,	"-86", "%ld",
__LINE__, 0x08ed2a4dL,	"8ed2a4d", "%4x",
__LINE__, 0xff8d9081L,	"FF8D9081", "%+0.X",
__LINE__, 0x002730a1L,	"2568353", "%4d",
__LINE__, 0xffff9564L,	"ffff9564", "%x",
__LINE__, -0x0000006L,	"  -6", "%4ld",
__LINE__, -0x19890310L,	"-428409616", "%0ld",
__LINE__, 0xd2ce636cL,	"d2ce636c", "%+x",
__LINE__, -0x00001feL,	"-510", "%d",
__LINE__, 0x00000006L,	"0000006", "%+0.7x",
__LINE__, 0xffffffc2L,	"0XFFFFFFC2", "%-#.5X",
__LINE__, -0x00000fdL,	"-253", "%+d",
__LINE__, 0x000216aaL,	"0x216aa", "%#x",
__LINE__, 0xffe36c66L,	"ffe36c66", "%x",
__LINE__, 0x00000002L,	"2", "%x",
__LINE__, -0x0000025L,	"-37", "% d",
__LINE__, 0x0000007eL,	"126", "%d",
__LINE__, 0x0003c1f9L,	"+246265", "%+ld",
__LINE__, 0x00000001L,	"1", "%ld",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, -0x00539e7L,	"-342503", "%06.ld",
__LINE__, 0x00000d42L,	"  3394", "%#6.ld",
__LINE__, 0xf73b7c4eL,	"F73B7C4E", "%X",
__LINE__, 0x00000022L,	"22", "%.1x",
__LINE__, 0xffffa883L,	"FFFFA883", "%X",
__LINE__, 0x016ec247L,	"16ec247", "%x",
__LINE__, 0x00000019L,	"19", "%+X",
__LINE__, 0x0000665aL,	"665A", "% 2.X",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%-5.X",
__LINE__, 0x008e3fbcL,	"8E3FBC", "%X",
__LINE__, 0xfffffffaL,	"FFFFFFFA", "%X",
__LINE__, 0x1b806597L,	"461399447", "%.2d",
__LINE__, 0x00000366L,	"0000870", "%#1.7ld",
__LINE__, 0x0001d92eL,	"1d92e", "%x",
__LINE__, 0x000104ceL,	"104CE", "%-X",
__LINE__, 0xfffffe4cL,	"fffffe4c", "%x",
__LINE__, 0x000000e9L,	"E9", "%X",
__LINE__, 0x000a855cL,	" 689500", "% d",
__LINE__, 0x00000075L,	"75", "% X",
__LINE__, -0x0000026L,	"-38", "%ld",
__LINE__, 0xfffff169L,	"fffff169", "%-04.2x",
__LINE__, 0xffffff6fL,	"ffffff6f", "%x",
__LINE__, 0x00000003L,	"0x3", "%#x",
__LINE__, 0x00623babL,	"6437803", "%.0d",
__LINE__, -0x2260224cL,	"-576725580", "%ld",
__LINE__, 0xe7e7a998L,	"E7E7A998", "%.1X",
__LINE__, 0x00000005L,	"5", "%X",
__LINE__, 0x0000b560L,	"0xb560", "%#x",
__LINE__, 0xfe11854dL,	"fe11854d", "%-.5x",
__LINE__, 0x00190014L,	"1638420", "%ld",
__LINE__, 0x0001d22aL,	"0X1D22A", "%-#X",
__LINE__, 0x00000c16L,	"c16", "%2x",
__LINE__, 0x00000d1aL,	"3354", "%#d",
__LINE__, 0x000165f6L,	"91638", "%d",
__LINE__, 0xfffff557L,	"0XFFFFF557", "%#X",
__LINE__, 0x00000588L,	"    588", "%07.X",
__LINE__, 0xf4a72708L,	"f4a72708", "%x",
__LINE__, 0xfff1cba9L,	"0xfff1cba9", "% #2.5x",
__LINE__, 0x000333a4L,	"209828", "%d",
__LINE__, 0x0000179bL,	"179B", "% 2.X",
__LINE__, 0x00000460L,	"1120", "%0ld",
__LINE__, 0xffffff89L,	"FFFFFF89", "%X",
__LINE__, -0x0000012L,	"-18", "%ld",
__LINE__, 0x00004fe0L,	"20448", "%0.d",
__LINE__, 0x00532e77L,	"532e77", "%00.x",
__LINE__, 0xf7b92efeL,	"f7b92efe", "%0x",
__LINE__, -0x0000243L,	"-579", "%+1.d",
__LINE__, 0x34894bb7L,	"+881413047", "%+d",
__LINE__, 0xfffaa189L,	"FFFAA189", "% 6X",
__LINE__, -0x0000579L,	"-1401", "%+ld",
__LINE__, 0x005acb12L,	"5acb12", "%5.0x",
__LINE__, 0xffff890aL,	"FFFF890A", "%X",
__LINE__, 0x010dff2fL,	"10DFF2F", "%.7X",
__LINE__, 0x00005a7fL,	"23167", "%#ld",
__LINE__, 0x000005e3L,	"1507", "%#3d",
__LINE__, -0xa815bcbL,	"-176249803", "%d",
__LINE__, 0xffffffffL,	"ffffffff", "%+x",
__LINE__, 0xfffe0ff7L,	"fffe0ff7", "%3x",
__LINE__, 0xffffffffL,	"0XFFFFFFFF", "%#2.1X",
__LINE__, -0x1cc5ea52L,	"-482732626", "%6.d",
__LINE__, 0x000425edL,	"+0271853", "%+.7d",
__LINE__, 0x00000001L,	"1", "%+x",
__LINE__, -0x48f2a72L,	"-76491378", "%7.0d",
__LINE__, 0xfffffff7L,	"FFFFFFF7", "% 0X",
__LINE__, 0xfd8ffc0aL,	"fd8ffc0a", "%.1x",
__LINE__, 0x0001f56dL,	"  1F56D", "%+7.2X",
__LINE__, 0x000000dbL,	"    DB", "%6.X",
__LINE__, 0xffffffc2L,	"ffffffc2", "%x",
__LINE__, 0x00000001L,	"001", "%03ld",
__LINE__, 0xffd89f58L,	"ffd89f58", "% 0.x",
__LINE__, 0xfe1a72fcL,	"fe1a72fc", "%x",
__LINE__, 0xfffff9b6L,	"FFFFF9B6", "%X",
__LINE__, 0x00243633L,	"243633", "%X",
__LINE__, 0x00821bc7L,	"+8526791", "%+#0ld",
__LINE__, 0xfe63f348L,	"0XFE63F348", "%#3X",
__LINE__, 0xff729f19L,	"ff729f19", "%4x",
__LINE__, 0xffff570fL,	"FFFF570F", "%+X",
__LINE__, 0x00a57a42L,	"10844738", "%6.3d",
__LINE__, 0xfe4a3ed0L,	"FE4A3ED0", "%6.X",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, 0x000001bbL,	"01bb", "% .4x",
__LINE__, 0x02b4a1e9L,	"2b4a1e9", "%-7.x",
__LINE__, 0x31750683L,	"31750683", "%x",
__LINE__, 0x00001cd7L,	"7383", "%#ld",
__LINE__, 0x0000079dL,	"1949", "%d",
__LINE__, 0xffb8ff3bL,	"FFB8FF3B", "%X",
__LINE__, 0x00a768b6L,	"0A768B6", "%-6.7X",
__LINE__, 0x1c665b48L,	"0X1C665B48", "% #X",
__LINE__, -0x000037dL,	"-000893", "%3.6d",
__LINE__, 0x29890443L,	"29890443", "%+0x",
__LINE__, 0x000000e5L,	"e5  ", "%-4x",
__LINE__, 0xfff2b5faL,	"FFF2B5FA", "%X",
__LINE__, -0x5d32c2bL,	"-97725483", "%05ld",
__LINE__, -0x00016c5L,	" -05829", "%+#7.5ld",
__LINE__, 0x00000644L,	"644", "%X",
__LINE__, -0x018c027L,	"-1622055", "%+.1d",
__LINE__, 0x0000013cL,	"0x13c", "%#x",
__LINE__, 0x00000009L,	"+9", "%+#ld",
__LINE__, 0x00000000L,	"0", "%ld",
__LINE__, -0x018eb19L,	"-1633049", "%4.3ld",
__LINE__, 0xfffff429L,	"FFFFF429", "% X",
__LINE__, 0x0032de67L,	"32DE67", "%X",
__LINE__, 0x0016bdfaL,	" 1490426", "% .2ld",
__LINE__, 0x00000065L,	"65", "%+.0X",
__LINE__, 0x00000072L,	"  72", "%+4.2X",
__LINE__, 0x00075119L,	"75119", "%2x",
__LINE__, 0x000000b8L,	"b8", "%x",
__LINE__, 0x000000d0L,	"d0", "%x",
__LINE__, 0x000000b9L,	"b9", "%x",
__LINE__, 0x003fda9dL,	" 4184733", "% #3.d",
__LINE__, 0x00029a24L,	"170532", "%4.d",
__LINE__, -0x132a337dL,	"-321532797", "% ld",
__LINE__, 0x0000047aL,	"0X47A", "%-#X",
__LINE__, 0x00000000L,	"0", "%-ld",
__LINE__, -0x0d9750bL,	"-14251275", "% ld",
__LINE__, 0x00029d6cL,	"29d6c", "%x",
__LINE__, 0xfb060cc0L,	"fb060cc0", "%x",
__LINE__, 0xffffd524L,	"0XFFFFD524", "%#X",
__LINE__, 0xffffff30L,	"ffffff30", "%-5x",
__LINE__, 0x00001650L,	"0005712", "%#0.7d",
__LINE__, 0x0000b702L,	"0B702", "%03.5X",
__LINE__, 0x000003c1L,	"3c1", "% .1x",
__LINE__, -0x0290412L,	"-2688018", "%d",
__LINE__, -0x00008bfL,	"-2239", "%#d",
__LINE__, -0x0000001L,	"-1", "%d",
__LINE__, 0x0001d750L,	"1D750", "%-X",
__LINE__, 0x006eee92L,	"6EEE92", "%-X",
__LINE__, 0xff812b02L,	"ff812b02", "%0x",
__LINE__, 0xfffffeacL,	"FFFFFEAC", "%+0X",
__LINE__, 0x000003a5L,	"3a5", "%x",
__LINE__, -0x15270ceeL,	"-354880750", "%2.ld",
__LINE__, 0x06b686d2L,	"6b686d2", "%0x",
__LINE__, 0xffe9cdccL,	"ffe9cdcc", "%x",
__LINE__, 0x0ecb168eL,	"ecb168e", "%x",
__LINE__, 0x00000051L,	"51", "%-X",
__LINE__, -0x0018860L,	"-100448", "%-0d",
__LINE__, 0x8f08b82bL,	"0x8f08b82b", "%-#.5x",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, 0x0000000eL,	"e", "%+01x",
__LINE__, 0x04cf15bcL,	" 80680380", "% #ld",
__LINE__, 0x50006e8aL,	"50006e8a", "%x",
__LINE__, 0x0002f669L,	"194153", "%0d",
__LINE__, 0x000000a6L,	"  166", "% 5.ld",
__LINE__, -0x04036bbL,	"-4208315", "%7.5d",
__LINE__, 0x00070deaL,	"70DEA", "%+X",
__LINE__, 0x00000964L,	"0x964", "%#x",
__LINE__, 0x0000004dL,	"0x4d", "% #3.x",
__LINE__, -0x0000001L,	"-1", "%-0d",
__LINE__, 0x0000043eL,	"1086", "%ld",
__LINE__, -0x0000001L,	"-1", "%-d",
__LINE__, 0x00000000L,	"+0", "%+d",
__LINE__, 0xfffe68d9L,	"FFFE68D9", "%7.X",
__LINE__, -0x0169199L,	"-1479065", "%#.5ld",
__LINE__, -0x000003dL,	"-61", "%ld",
__LINE__, 0x00000001L,	"+1", "%+.1d",
__LINE__, 0x0001a65dL,	"1a65d", "%.5x",
__LINE__, 0x00000141L,	"+000321", "%+#5.6ld",
__LINE__, 0x00000000L,	"   0", "%4x",
__LINE__, 0x00000408L,	"1032", "%-2.3ld",
__LINE__, 0xffffffedL,	"FFFFFFED", "%-X",
__LINE__, 0xfe832351L,	"FE832351", "% .4X",
__LINE__, 0x003a421bL,	"3A421B", "%-X",
__LINE__, -0x53ed7f25L,	"-1408073509", "%ld",
__LINE__, -0x0000003L,	"-0003", "%-5.4ld",
__LINE__, 0x00000ad0L,	"   2768", "%7d",
__LINE__, 0xfffaf30bL,	"FFFAF30B", "%X",
__LINE__, 0x006349d3L,	" 6506963", "% 6.2ld",
__LINE__, 0x07f0146aL,	"7f0146a", "%+3.4x",
__LINE__, -0x0000002L,	" -2", "% 3.ld",
__LINE__, -0x26e94f3L,	"-40801523", "%-#ld",
__LINE__, -0x0000004L,	"   -004", "%7.3d",
__LINE__, 0xfffe8cc9L,	"FFFE8CC9", "%0X",
__LINE__, 0x00000018L,	"   18", "%5.x",
__LINE__, -0x4941de83L,	"-1229053571", "% 0.5ld",
__LINE__, 0x00000000L,	"     0", "%6ld",
__LINE__, 0xfffffffeL,	"0XFFFFFFFE", "%-#X",
__LINE__, -0x0142ae1L,	"-1321697", "%4.ld",
__LINE__, -0x0319e7fL,	"-3251839", "%0ld",
__LINE__, 0x000004ffL,	"    4FF", "%7.2X",
__LINE__, -0x0001c3eL,	"-7230", "%#.2ld",
__LINE__, 0xffffe522L,	"ffffe522", "%x",
__LINE__, 0x0001d1cbL,	"+119243", "%+.3ld",
__LINE__, 0xfad19d52L,	"FAD19D52", "%+X",
__LINE__, 0x00002a7cL,	" 10876", "% 0.ld",
__LINE__, 0x00001449L,	"1449", "%X",
__LINE__, 0x000732b8L,	"471736", "%d",
__LINE__, -0x211a496eL,	"-555370862", "%ld",
__LINE__, -0x0000004L,	"-4", "%1.d",
__LINE__, 0x0295c03dL,	"43368509", "%5.ld",
__LINE__, 0x01fa5722L,	"33183522", "%0ld",
__LINE__, 0xfffbff62L,	"0xfffbff62", "%#x",
__LINE__, 0x000000f5L,	" 245", "% 2.d",
__LINE__, 0x000000a0L,	"160", "%-d",
__LINE__, 0x0000000fL,	"15", "%.2ld",
__LINE__, 0x0bf5f077L,	"+200667255", "%+ld",
__LINE__, -0x14d3e5aL,	"-21839450", "%#2.3d",
__LINE__, -0x21cbe656L,	"-567010902", "%ld",
__LINE__, 0x000002b9L,	"697", "%ld",
__LINE__, 0xfffff9b0L,	"FFFFF9B0", "%X",
__LINE__, 0x007fd9c7L,	"8378823", "%3.4d",
__LINE__, 0x00036d06L,	"36d06", "%x",
__LINE__, 0xffde8052L,	"FFDE8052", "%4.6X",
__LINE__, 0x0000000dL,	"13", "%#d",
__LINE__, 0x68157d93L,	"68157d93", "%x",
__LINE__, 0x00000005L,	"5", "%1x",
__LINE__, 0xfffffff4L,	"FFFFFFF4", "%X",
__LINE__, 0xf5bbf7e9L,	"f5bbf7e9", "%+.1x",
__LINE__, 0x0be98f98L,	"BE98F98", "%X",
__LINE__, 0x00000122L,	"00122", "%.5X",
__LINE__, -0x0000936L,	"-2358", "%+#3.0ld",
__LINE__, 0xfd230f09L,	"FD230F09", "%-7X",
__LINE__, 0x00000089L,	"137", "%ld",
__LINE__, 0x00000078L,	"    120", "%7d",
__LINE__, -0x68ef2b6bL,	"-1760504683", "%-ld",
__LINE__, 0xc24480bbL,	"C24480BB", "%+4X",
__LINE__, 0xfefe36a2L,	"FEFE36A2", "%0X",
__LINE__, -0x35344baL,	"-55788730", "%7.d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%+.6X",
__LINE__, -0x0000f40L,	"-3904", "% ld",
__LINE__, 0xfffffffbL,	"FFFFFFFB", "%X",
__LINE__, 0x58b37c4bL,	"58b37c4b", "%2.2x",
__LINE__, 0x000000e2L,	"226", "%#ld",
__LINE__, 0xfff5ebdeL,	"fff5ebde", "%-7.1x",
__LINE__, 0x0c6ea9beL,	"208579006", "%-ld",
__LINE__, 0xff708c74L,	"FF708C74", "% 4.X",
__LINE__, 0x00000000L,	"  0", "% 3X",
__LINE__, 0x00000004L,	"  4", "%03.d",
__LINE__, 0x0919be7cL,	"+152682108", "%+6.d",
__LINE__, 0x00d4fd1eL,	"13958430", "%0d",
__LINE__, 0xfe77a69eL,	"fe77a69e", "%-7.x",
__LINE__, 0x284ded44L,	"676195652", "%-#2ld",
__LINE__, -0x00006e6L,	"-1766", "% ld",
__LINE__, -0x7dac7eaL,	"-131778538", "%.0ld",
__LINE__, 0x0003c50fL,	"247055", "%#d",
__LINE__, 0xfffffffcL,	"fffffffc", "%-x",
__LINE__, 0xfe0f0d1fL,	"fe0f0d1f", "% 5.1x",
__LINE__, 0x00000009L,	"9", "%0ld",
__LINE__, -0x0175cc1L,	"-1531073", "%-04.d",
__LINE__, 0x000e4da2L,	" 937378", "% 4.ld",
__LINE__, 0x00000762L,	"762", "%-0.X",
__LINE__, 0x005211bfL,	"5211bf", "%-x",
__LINE__, 0xfffffffbL,	"fffffffb", "%+2.6x",
__LINE__, 0x00008862L,	"34914", "%ld",
__LINE__, 0xfffc9754L,	"fffc9754", "%+x",
__LINE__, 0x0000716eL,	"716E", "%X",
__LINE__, 0x000000a8L,	"a8", "%x",
__LINE__, 0xffff84f5L,	"ffff84f5", "%0x",
__LINE__, 0x00005032L,	"5032", "%x",
__LINE__, 0xffe242b4L,	"ffe242b4", "%6x",
__LINE__, 0x002df9bdL,	"3013053", "%ld",
__LINE__, 0xffffe267L,	"FFFFE267", "%.5X",
__LINE__, 0xffffffc7L,	"0xffffffc7", "%#x",
__LINE__, -0x1727c38L,	"-24280120", "%d",
__LINE__, 0x01308072L,	"1308072", "%x",
__LINE__, -0x5883c7cL,	"-92814460", "%+ld",
__LINE__, 0x000030adL,	"30ad", "%x",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%X",
__LINE__, -0x2090a708L,	"-546350856", "% d",
__LINE__, 0x0024e6b4L,	"2418356", "%#ld",
__LINE__, 0x02db71acL,	"2DB71AC", "% 6.3X",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%2.7X",
__LINE__, -0x000074eL,	"  -1870", "%7.ld",
__LINE__, -0x0011d84L,	"-73092", "%d",
__LINE__, 0x00160723L,	"160723", "%1.3x",
__LINE__, 0x00412929L,	"4270377", "%-d",
__LINE__, -0x0008fc6L,	"-36806", "% d",
__LINE__, 0x00000002L,	"2", "%d",
__LINE__, 0x0eb67ffaL,	"eb67ffa", "%.4x",
__LINE__, 0x05b86c3cL,	"95972412", "%4.4d",
__LINE__, 0xffffca9cL,	"FFFFCA9C", "% 4.X",
__LINE__, 0x0007d571L,	"7d571", "%-0x",
__LINE__, -0x000239bL,	"-09115", "%5.5d",
__LINE__, -0x0000155L,	" -341", "%5.3ld",
__LINE__, 0x00000034L,	"34", "%x",
__LINE__, -0x0000051L,	"-81", "%.1ld",
__LINE__, 0x309bbbe0L,	"309bbbe0", "%x",
__LINE__, 0x0075be1eL,	" 7716382", "% #ld",
__LINE__, 0x000002d5L,	"2d5", "%x",
__LINE__, 0x006b466dL,	"6B466D", "%-0X",
__LINE__, 0x01d6c30fL,	"1D6C30F", "%4.X",
__LINE__, 0x00000003L,	"      3", "%07.x",
__LINE__, 0xfffcc102L,	"FFFCC102", "%6.X",
__LINE__, 0xffffffffL,	"0XFFFFFFFF", "%#X",
__LINE__, 0xfffffffeL,	"fffffffe", "%+x",
__LINE__, 0x00000005L,	"5", "%ld",
__LINE__, 0xff060284L,	"ff060284", "%x",
__LINE__, 0x007a3325L,	"7A3325", "%-X",
__LINE__, 0xf5f595bdL,	"F5F595BD", "%0X",
__LINE__, 0xfffa3a10L,	"FFFA3A10", "%0X",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, -0x15078f9L,	"-22051065", "%7d",
__LINE__, -0x0000002L,	"-000002", "%.6d",
__LINE__, 0x00000036L,	"54", "%1.1ld",
__LINE__, -0xbbecf6aL,	"-197054314", "%ld",
__LINE__, 0x0000043dL,	"43D", "%X",
__LINE__, 0xfffffffaL,	"0xfffffffa", "% #6.x",
__LINE__, 0x016759f8L,	"23550456", "%0.ld",
__LINE__, 0x000052d2L,	"+21202", "%+6.2d",
__LINE__, -0x007d232L,	"-512562", "%ld",
__LINE__, 0x00240be0L,	"2362336", "%.1d",
__LINE__, -0x0000001L,	"-1", "%0d",
__LINE__, 0xfffffffaL,	"FFFFFFFA", "%X",
__LINE__, -0x0000e88L,	"-3720", "%ld",
__LINE__, 0xfffffa9bL,	"FFFFFA9B", "%.5X",
__LINE__, 0x09296eebL,	"153710315", "%-1.0d",
__LINE__, 0x001f46fcL,	"0X1F46FC", "%#X",
__LINE__, 0x00000006L,	"6", "%X",
__LINE__, 0xffffff87L,	"0XFFFFFF87", "%+#X",
__LINE__, 0x00000469L,	"0469", "%04X",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, 0x00000000L,	"", "%.0ld",
__LINE__, -0x52bc137L,	"-86753591", "%-#3ld",
__LINE__, -0x2bddb08L,	"-45996808", "%-3.d",
__LINE__, 0x041367f7L,	"41367F7", "%+X",
__LINE__, -0x0018eb5L,	"-102069", "%+ld",
__LINE__, -0x0000537L,	"-1335", "%#ld",
__LINE__, -0x6f159ff4L,	"-1863688180", "%+1.d",
__LINE__, 0x00112ac8L,	"0X112AC8", "%#6.3X",
__LINE__, 0x00000000L,	"   ", "%3.d",
__LINE__, 0x0008afe8L,	"08afe8", "%+3.6x",
__LINE__, 0x00000015L,	"21", "%ld",
__LINE__, -0x02b7130L,	"-2847024", "% #2.4d",
__LINE__, 0xffffffd0L,	"FFFFFFD0", "%X",
__LINE__, -0x6970fa1L,	"-110563233", "%+#.4ld",
__LINE__, 0x06387dccL,	"0X6387DCC", "%-#X",
__LINE__, 0xffffd506L,	"ffffd506", "%+6x",
__LINE__, -0x00fe5cdL,	"-1041869", "%-#7d",
__LINE__, -0x0c35bf6L,	"-12803062", "%-03d",
__LINE__, -0x0020d89L,	"-134537", "%#d",
__LINE__, -0x0c7aed3L,	"-13086419", "%-ld",
__LINE__, -0x000362aL,	"-13866", "%#.4ld",
__LINE__, -0x02d05f0L,	"-2950640", "%#ld",
__LINE__, 0x02de1321L,	"0x2de1321", "%#7.x",
__LINE__, 0xffb56428L,	"0xffb56428", "%#x",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%X",
__LINE__, 0xf072292dL,	"F072292D", "%.5X",
__LINE__, -0x0f4b0f2L,	"-16036082", "%.5ld",
__LINE__, 0x01b81885L,	"28842117", "%5d",
__LINE__, -0x009cfa6L,	"-642982", "%d",
__LINE__, 0xfffffffdL,	"0XFFFFFFFD", "%-#.5X",
__LINE__, 0x0dc97a66L,	"DC97A66", "%2.X",
__LINE__, 0x000000beL,	"190", "%.0d",
__LINE__, 0xffffe1c7L,	"FFFFE1C7", "% X",
__LINE__, 0x01883b9aL,	"1883b9a", "%3x",
__LINE__, 0xffffdde1L,	"ffffdde1", "%+x",
__LINE__, 0x2f1b4e32L,	"+790318642", "%+ld",
__LINE__, 0x000129aaL,	"129aa", "%x",
__LINE__, -0x00092c2L,	"-37570", "%d",
__LINE__, 0x00070fbdL,	"70fbd", "%x",
__LINE__, -0x00000eaL,	"-234", "%+4ld",
__LINE__, 0xfffffffeL,	"fffffffe", "%x",
__LINE__, 0x0091c7f7L,	"91C7F7", "% .3X",
__LINE__, -0x0c14fe2L,	"-12668898", "%d",
__LINE__, -0x0017c15L,	"-97301", "%d",
__LINE__, -0x00005d0L,	"-0001488", "%5.7d",
__LINE__, 0x0114c36eL,	"18137966", "%0d",
__LINE__, 0xffffffffL,	"ffffffff", "%+x",
__LINE__, 0x0ac76e78L,	"180842104", "%d",
__LINE__, 0x001976cdL,	" 1668813", "% 4.ld",
__LINE__, -0x0642319L,	"-6562585", "% d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%X",
__LINE__, -0x035019dL,	"-3473821", "%.7d",
__LINE__, -0x0000061L,	"-97", "%#3.d",
__LINE__, 0x0000001fL,	"    31", "% 6.1ld",
__LINE__, -0x0000024L,	"-36", "%d",
__LINE__, 0x000b3785L,	"735109", "%ld",
__LINE__, 0xfffffda9L,	"fffffda9", "%-x",
__LINE__, 0x00254832L,	"2443314", "%-ld",
__LINE__, 0xfffffd40L,	"FFFFFD40", "%0X",
__LINE__, -0x0006105L,	"-24837", "%+#d",
__LINE__, 0x00000006L,	"+6", "%+d",
__LINE__, 0xffd40fd8L,	"ffd40fd8", "%3.x",
__LINE__, -0x000988eL,	"-39054", "%03d",
__LINE__, 0x0005ad8bL,	"5AD8B", "%0.0X",
__LINE__, 0x00000001L,	"1", "%d",
__LINE__, 0xfe1f59b7L,	"fe1f59b7", "%4.x",
__LINE__, -0x0000022L,	"-34", "%#d",
__LINE__, 0x0018e3e9L,	"18E3E9", "% X",
__LINE__, 0xffffff25L,	"FFFFFF25", "%2.X",
__LINE__, -0x00002c6L,	"-710", "%1.ld",
__LINE__, 0x00009765L,	"38757", "%5ld",
__LINE__, 0xfe197646L,	"FE197646", "%-X",
__LINE__, 0x00000001L,	"    1", "%+5.x",
__LINE__, -0x0000002L,	"-2", "%#ld",
__LINE__, 0x0072f6beL,	"72F6BE", "%1X",
__LINE__, -0x000f06dL,	"-61549", "%-d",
__LINE__, 0x00000001L,	"    1", "%5X",
__LINE__, 0x328cba28L,	" 848083496", "% 2.ld",
__LINE__, 0x0000cddcL,	"cddc", "%.1x",
__LINE__, 0xfffffff9L,	"fffffff9", "%7x",
__LINE__, 0x00baf511L,	"BAF511", "%-5.6X",
__LINE__, 0x00000001L,	"   1", "%4.ld",
__LINE__, 0x0001e4b0L,	"+124080", "%+ld",
__LINE__, -0x07548f3L,	"-7686387", "% 6.d",
__LINE__, -0x01b14eaL,	"-1774826", "% #0d",
__LINE__, -0x000005cL,	"-92 ", "%-04ld",
__LINE__, -0x00000aeL,	"-174", "%+.3ld",
__LINE__, 0x0000008cL,	"0X8C", "%+#X",
__LINE__, 0x14c02360L,	"14C02360", "%.6X",
__LINE__, 0xfffffff6L,	"FFFFFFF6", "%X",
__LINE__, 0x009f4ee5L,	"9f4ee5", "%x",
__LINE__, 0x00000035L,	"35", "%X",
__LINE__, -0x00000ebL,	"-235", "%ld",
__LINE__, 0x1552ced8L,	"1552CED8", "%04X",
__LINE__, 0x0000002aL,	"   2A", "%5X",
__LINE__, 0xffffffffL,	"ffffffff", "% x",
__LINE__, -0xdec0db2L,	"-233573810", "%d",
__LINE__, 0x001e2ef0L,	"1978096", "%2.d",
__LINE__, 0xffffef24L,	"ffffef24", "%.5x",
__LINE__, 0xfffe6a6cL,	"fffe6a6c", "%+x",
__LINE__, -0x0000004L,	"-4", "% ld",
__LINE__, 0xfe3c6743L,	"fe3c6743", "%.1x",
__LINE__, 0x0000033dL,	"829", "%0ld",
__LINE__, -0x00006a0L,	"  -1696", "% 7.ld",
__LINE__, 0xffffffdbL,	"ffffffdb", "%0.0x",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%3.3X",
__LINE__, -0x0000004L,	"-4", "%#ld",
__LINE__, 0x00b32b56L,	"B32B56", "%X",
__LINE__, 0xffffffffL,	"0xffffffff", "%+#x",
__LINE__, 0x01cd1a48L,	"1cd1a48", "%+7x",
__LINE__, 0xffffffdaL,	"ffffffda", "%x",
__LINE__, 0x1886509eL,	"1886509E", "% X",
__LINE__, 0x000000ebL,	"235", "%0d",
__LINE__, 0xfffffff4L,	"fffffff4", "%0x",
__LINE__, 0x00000547L,	"547", "% X",
__LINE__, 0x000017e6L,	"17e6", "%-2.x",
__LINE__, 0x00001dc4L,	"7620", "%d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%3.0X",
__LINE__, 0xffff93faL,	"0XFFFF93FA", "%#X",
__LINE__, 0xfffffe1cL,	"FFFFFE1C", "%-X",
__LINE__, 0x00000000L,	"", "% .0x",
__LINE__, 0x000000a1L,	"A1", "%X",
__LINE__, 0xffffffffL,	"0xffffffff", "%#x",
__LINE__, -0x0001460L,	"-05216", "%+#.5d",
__LINE__, 0x00000001L,	"1     ", "%-6.x",
__LINE__, 0xfffd5324L,	"FFFD5324", "%+2.6X",
__LINE__, 0x00000007L,	"    07", "%06.2d",
__LINE__, 0x00000003L,	"3", "%-X",
__LINE__, 0xfffffdb7L,	"0XFFFFFDB7", "%+#X",
__LINE__, 0xfffff4ccL,	"fffff4cc", "%0x",
__LINE__, 0x00000000L,	"0    ", "%-5X",
__LINE__, 0x00758c96L,	"758C96", "%X",
__LINE__, -0x0000001L,	"-1", "%-ld",
__LINE__, 0x00000001L,	"1", "%ld",
__LINE__, 0x03f03cafL,	"66075823", "%.2ld",
__LINE__, 0x0000a87cL,	"a87c", "%1.x",
__LINE__, 0x00000034L,	"34", "%X",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0x00010167L,	"10167", "%x",
__LINE__, -0x00007ceL,	"-1998 ", "%-6ld",
__LINE__, 0x00000001L,	"1", "%.0d",
__LINE__, 0x00d94ceeL,	"14241006", "%ld",
__LINE__, -0x0000008L,	"-8", "% d",
__LINE__, -0x71520839L,	"-1901201465", "%+0d",
__LINE__, 0x0000035aL,	"35a", "%-x",
__LINE__, 0xfffd2f68L,	"FFFD2F68", "%-X",
__LINE__, 0x0006ea53L,	"453203", "%1d",
__LINE__, 0x000000dfL,	"DF", "% 1X",
__LINE__, 0xfffffffeL,	"fffffffe", "% 7x",
__LINE__, 0x00000156L,	"156", "% X",
__LINE__, 0x00037ac9L,	" 228041", "% ld",
__LINE__, 0xffffffdeL,	"FFFFFFDE", "%0.5X",
__LINE__, 0x00000025L,	"37", "%-0.ld",
__LINE__, -0x4133686L,	"-68368006", "%2ld",
__LINE__, -0x000003bL,	"-59", "%.2ld",
__LINE__, 0xfffff910L,	"fffff910", "% 00.0x",
__LINE__, 0xff9ec802L,	"FF9EC802", "%2.6X",
__LINE__, 0x00000008L,	"0X8", "%#1X",
__LINE__, 0xfffffff7L,	"FFFFFFF7", "%-X",
__LINE__, 0x0029a4daL,	"2729178", "%04.ld",
__LINE__, 0x007d1588L,	"8197512", "%#d",
__LINE__, 0x0007e86dL,	"518253", "%0d",
__LINE__, 0xfffffff9L,	"fffffff9", "%x",
__LINE__, 0x00000002L,	"002", "%.3d",
__LINE__, 0x00006ec1L,	"6EC1", "%2X",
__LINE__, 0x0000300cL,	"12300", "%-d",
__LINE__, -0x0000002L,	"-2", "%+ld",
__LINE__, -0x0000002L,	"-2", "%ld",
__LINE__, -0x00015d5L,	"-005589", "%#.6ld",
__LINE__, 0x00000041L,	"65", "%d",
__LINE__, 0x00000229L,	"0000229", "% 0.7x",
__LINE__, 0xfffffffbL,	"fffffffb", "%03.x",
__LINE__, 0x00093262L,	"0602722", "%.7d",
__LINE__, -0x00037b4L,	"-14260", "%-0ld",
__LINE__, 0xfffffffcL,	"fffffffc", "%-x",
__LINE__, 0xf24cb3e6L,	"f24cb3e6", "%1x",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0xfffffffbL,	"FFFFFFFB", "%0X",
__LINE__, 0x00000031L,	"0000049", "%00.7ld",
__LINE__, 0x00000bb3L,	"BB3", "%.1X",
__LINE__, -0x0000001L,	"-0001", "%+#4.4ld",
__LINE__, -0x0000001L,	"-1", "% d",
__LINE__, 0x00022c0cL,	"22c0c", "%-x",
__LINE__, 0xffffffd4L,	"ffffffd4", "%x",
__LINE__, 0x000729c6L,	"469446", "%3.d",
__LINE__, 0xb180feaeL,	"b180feae", "%3.x",
__LINE__, 0x124fac15L,	"307211285", "%-0ld",
__LINE__, -0x0000004L,	"-4", "%ld",
__LINE__, 0x0000006aL,	"106", "%#d",
__LINE__, 0x0000297fL,	"297F", "%+3X",
__LINE__, 0x0000000eL,	"14", "%0ld",
__LINE__, 0x00000027L,	"27", "%0.1X",
__LINE__, 0xffeb98ebL,	"ffeb98eb", "% 05.2x",
__LINE__, 0xfffff19bL,	"FFFFF19B", "%+X",
__LINE__, 0x00025992L,	"154002", "%6.6d",
__LINE__, 0x00000040L,	"   040", "%6.3X",
__LINE__, 0x00000a9eL,	" 0a9e", "%5.4x",
__LINE__, 0x00c7f2ccL,	"c7f2cc", "%x",
__LINE__, 0x000325e6L,	" 325E6", "%6.X",
__LINE__, -0x69faad3L,	"-111127251", "%d",
__LINE__, -0x059a307L,	"-5874439", "% ld",
__LINE__, 0xfffffff6L,	"0xfffffff6", "%#0.0x",
__LINE__, 0x0030fdf3L,	"30fdf3", "%x",
__LINE__, 0x00007343L,	"+29507", "%+#2d",
__LINE__, 0x0003cf4bL,	"0X3CF4B", "% #.2X",
__LINE__, 0x00000433L,	"+1075", "%+0ld",
__LINE__, 0xfffffffdL,	"fffffffd", "%+.3x",
__LINE__, 0x0ae30c4eL,	"ae30c4e", "%+00x",
__LINE__, 0x0002540fL,	"02540f", "%-.6x",
__LINE__, -0x0000001L,	"  -01", "% #5.2ld",
__LINE__, 0xffffffe7L,	"0xffffffe7", "% #5.x",
__LINE__, 0x0000005bL,	"91", "%d",
__LINE__, 0x00001f9bL,	"8091", "%.4ld",
__LINE__, 0xfffff315L,	"fffff315", "%4.x",
__LINE__, -0x130eec41L,	"-319745089", "% ld",
__LINE__, 0xfff8fe13L,	"FFF8FE13", "%X",
__LINE__, -0x0000004L,	"-00004", "%5.5d",
__LINE__, 0x00000669L,	"669", "%0X",
__LINE__, -0x0000004L,	"-4", "%d",
__LINE__, 0xf5e81496L,	"F5E81496", "% 6X",
__LINE__, -0x0000001L,	"-1", "% 0d",
__LINE__, 0xfffffff7L,	"fffffff7", "%x",
__LINE__, 0x000001deL,	"478", "%d",
__LINE__, 0x0000623eL,	"25150", "%5.0d",
__LINE__, 0xffffffa8L,	"FFFFFFA8", "%+X",
__LINE__, -0x0000117L,	"-279", "% ld",
__LINE__, -0x0000517L,	"-1303", "%d",
__LINE__, 0xfffff9d5L,	"fffff9d5", "% x",
__LINE__, 0x000001ccL,	"1CC", "%-X",
__LINE__, 0x0000019aL,	"0000410", "%.7d",
__LINE__, 0x00000003L,	"3     ", "%-06X",
__LINE__, 0x00000009L,	"0x9", "%#0x",
__LINE__, 0xfd544610L,	"0XFD544610", "% #X",
__LINE__, 0xfffffffcL,	"fffffffc", "%+x",
__LINE__, 0x00009437L,	"37943", "%ld",
__LINE__, -0x00b5ea6L,	"-745126", "%d",
__LINE__, 0xffffffd8L,	"ffffffd8", "%6x",
__LINE__, 0x00002a2dL,	"10797", "%.3ld",
__LINE__, 0x00275238L,	"2576952", "%0ld",
__LINE__, 0xfff90a34L,	"FFF90A34", "%-7X",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "% .7X",
__LINE__, -0xb3b673eL,	"-188442430", "% ld",
__LINE__, 0xfffff67aL,	"0xfffff67a", "%#0.x",
__LINE__, 0x0000dff6L,	"   dff6", "%+7.x",
__LINE__, 0xffee46e3L,	"ffee46e3", "%x",
__LINE__, 0x00001a66L,	" 0006758", "% 7.7d",
__LINE__, 0x0002b475L,	"2B475", "%.4X",
__LINE__, 0x0002090dL,	"002090d", "%.7x",
__LINE__, -0x0057838L,	"-358456", "%#ld",
__LINE__, 0x00000004L,	"0x4", "%#x",
__LINE__, 0x0574cb62L,	"91540322", "%#7d",
__LINE__, -0x0054388L,	"-344968", "% #d",
__LINE__, 0x000421c2L,	"421C2", "% X",
__LINE__, 0x00000003L,	"3", "%0d",
__LINE__, 0xffffe2e2L,	"ffffe2e2", "% 5.x",
__LINE__, 0x00000021L,	"+33", "%+d",
__LINE__, -0x0020033L,	"-131123", "%ld",
__LINE__, -0x0000001L,	"  -1", "%4.ld",
__LINE__, 0x000000fdL,	"000fd", "%3.5x",
__LINE__, 0x023e4337L,	"37634871", "%1d",
__LINE__, 0x6e823d96L,	"6E823D96", "% X",
__LINE__, 0xfff0e133L,	"fff0e133", "%x",
__LINE__, -0x000deccL,	"-57036", "%3d",
__LINE__, 0x004397b8L,	"4429752", "%0d",
__LINE__, -0x0000023L,	"   -35", "%6d",
__LINE__, 0xffe701caL,	"FFE701CA", "%3X",
__LINE__, 0x000c0319L,	"+787225", "%+.6d",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0xfffffe1dL,	"FFFFFE1D", "%X",
__LINE__, 0xfffffb33L,	"fffffb33", "%x",
__LINE__, 0x02b5e30aL,	"45474570", "%d",
__LINE__, 0x000074ebL,	"29931", "%03.ld",
__LINE__, -0x4e42e310L,	"-1313006352", "%-0.d",
__LINE__, -0x000007bL,	"-123", "%d",
__LINE__, 0x00000160L,	" 352", "% d",
__LINE__, -0x16af31ecL,	"-380580332", "%#ld",
__LINE__, -0x000006eL,	"-000110", "%07ld",
__LINE__, 0x232699a0L,	"232699a0", "%7.x",
__LINE__, 0x00f9b8e5L,	"+16365797", "%+0d",
__LINE__, 0x0000000cL,	"C", "%X",
__LINE__, 0xfffffd4fL,	"FFFFFD4F", "%X",
__LINE__, 0xffffe7bbL,	"FFFFE7BB", "%.7X",
__LINE__, -0x0000163L,	"-355", "%d",
__LINE__, 0x00070315L,	" 459541", "% #2.d",
__LINE__, -0x7d5c12aL,	"-131449130", "% 6.ld",
__LINE__, 0xffffffb2L,	"FFFFFFB2", "%X",
__LINE__, -0x0004aadL,	"-19117", "%+6.4ld",
__LINE__, 0x00115586L,	"1136006", "%0d",
__LINE__, -0x0000021L,	"-33", "%d",
__LINE__, 0x093ce01eL,	"93ce01e", "% 5x",
__LINE__, 0x00672135L,	"672135", "% x",
__LINE__, 0x05f4abd5L,	"0x5f4abd5", "%+#6.x",
__LINE__, -0x0448b03L,	"-4492035", "%-0.2ld",
__LINE__, 0x00000000L,	"0", "%#x",
__LINE__, 0x1987217eL,	"428286334", "%d",
__LINE__, 0x000010f6L,	"10f6", "%-x",
__LINE__, 0x0000177aL,	"177a", "%1x",
__LINE__, 0xfffffefdL,	"FFFFFEFD", "%7X",
__LINE__, -0x095cbf8L,	"-9817080", "%-5ld",
__LINE__, 0x0000008aL,	"138", "%2.0ld",
__LINE__, 0xfffe80adL,	"fffe80ad", "%0x",
__LINE__, -0x1a4c8f7L,	"-27576567", "%d",
__LINE__, 0x00000000L,	"0", "%-x",
__LINE__, 0x0000a82bL,	"43051", "%-ld",
__LINE__, 0x000000ebL,	"235", "%2.3ld",
__LINE__, -0x0002747L,	"-10055", "%d",
__LINE__, 0x00000319L,	"0X319", "%#X",
__LINE__, 0xfffffcfeL,	"FFFFFCFE", "% X",
__LINE__, 0x00050f0eL,	"50f0e", "%-1x",
__LINE__, -0x398e09eL,	"-60350622", "%0.7ld",
__LINE__, 0x00000000L,	"  ", "%2.ld",
__LINE__, 0x00000049L,	"00049", "% .5X",
__LINE__, -0x00000ddL,	" -221", "%+#5ld",
__LINE__, 0xf6db2facL,	"f6db2fac", "%-07x",
__LINE__, 0x0000004fL,	"4F", "% .0X",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0xfd07f692L,	"fd07f692", "%x",
__LINE__, 0xdb98bde0L,	"db98bde0", "%x",
__LINE__, 0x00000271L,	"0271", "% 3.4x",
__LINE__, -0x000115aL,	"-4442", "%#1.ld",
__LINE__, 0x0002f5f2L,	"194034", "%ld",
__LINE__, -0x0000152L,	"   -338", "%+7ld",
__LINE__, 0x00059336L,	"365366", "%d",
__LINE__, 0xfffffff6L,	"fffffff6", "%-7x",
__LINE__, 0xfb916c51L,	"fb916c51", "%-x",
__LINE__, 0xffff413dL,	"FFFF413D", "%-X",
__LINE__, 0xf2576910L,	"F2576910", "%-4.X",
__LINE__, 0xfffc7730L,	"fffc7730", "%5.x",
__LINE__, 0x000002e6L,	"+742", "%+1d",
__LINE__, -0x00001bfL,	"-447", "%3d",
__LINE__, 0x000002e1L,	"2E1", "%-X",
__LINE__, 0x00000096L,	"150", "%#0ld",
__LINE__, 0x000002bdL,	"701", "%d",
__LINE__, -0x0053386L,	"-340870", "%#d",
__LINE__, 0xfffdb076L,	"FFFDB076", "%X",
__LINE__, 0x00004dc5L,	" +19909", "%+07.ld",
__LINE__, 0x00000f7aL,	" F7A", "%4X",
__LINE__, 0x02405000L,	" 37769216", "% ld",
__LINE__, 0xfffce68dL,	"fffce68d", "%0x",
__LINE__, -0x35b3af2L,	"-56310514", "%-ld",
__LINE__, -0x0238631L,	"-2328113", "%.4d",
__LINE__, -0x000001eL,	"-030", "%.3ld",
__LINE__, 0xffffffddL,	"FFFFFFDD", "%.4X",
__LINE__, 0x0013f6acL,	"13f6ac", "%02.x",
__LINE__, 0xfffffffaL,	"fffffffa", "%+07.x",
__LINE__, -0x000192bL,	" -6443", "%6.d",
__LINE__, 0x0000058bL,	"+1419", "%+d",
__LINE__, 0x00001391L,	"5009", "%ld",
__LINE__, -0x0041a57L,	"-268887", "%1ld",
__LINE__, 0xfffff266L,	"0xfffff266", "%+#6.6x",
__LINE__, 0x0000018bL,	"   395", "%6.ld",
__LINE__, 0x009ae24dL,	"+10150477", "%+ld",
__LINE__, 0x0000007eL,	"7E", "%X",
__LINE__, 0xfffffd53L,	"FFFFFD53", "% 0X",
__LINE__, 0x000002faL,	"2FA", "%-1.3X",
__LINE__, 0x000000a4L,	"164", "%0d",
__LINE__, 0x00001833L,	"6195", "%ld",
__LINE__, -0x0000001L,	"-1", "%d",
__LINE__, 0xf2fcbd9bL,	"F2FCBD9B", "%+0.2X",
__LINE__, 0x00004a8aL,	"4A8A", "%X",
__LINE__, -0x10695cdaL,	"-275340506", "%d",
__LINE__, 0x00000037L,	"37", "%X",
__LINE__, 0x00082d5cL,	"82D5C", "%+0.5X",
__LINE__, 0xfffffe01L,	"fffffe01", "% 5.3x",
__LINE__, 0x000005eaL,	"05EA", "% 1.4X",
__LINE__, 0x0e0b8826L,	"e0b8826", "%2x",
__LINE__, -0x0000161L,	"-353", "%+d",
__LINE__, 0x19e3014aL,	"19E3014A", "%+5X",
__LINE__, 0x00000140L,	"140", "%x",
__LINE__, 0xffff84b9L,	"FFFF84B9", "%X",
__LINE__, -0x0005776L,	"-22390", "%+5ld",
__LINE__, 0x0162ad61L,	"162AD61", "% X",
__LINE__, 0x00002395L,	"2395", "%X",
__LINE__, 0x003702ecL,	"3605228", "%5.2d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%7X",
__LINE__, 0x00001778L,	"0x1778", "%#5.x",
__LINE__, 0xc52bef7fL,	"C52BEF7F", "%X",
__LINE__, 0xfffffec4L,	"FFFFFEC4", "%X",
__LINE__, 0x00000006L,	"6", "%X",
__LINE__, 0x00000000L,	"000", "%03.3x",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0xffff6c46L,	"FFFF6C46", "% 2.2X",
__LINE__, -0x1506098L,	"-22044824", "%01.d",
__LINE__, 0x03415cafL,	"3415caf", "%x",
__LINE__, -0x00007b4L,	"-1972", "%#4.4d",
__LINE__, -0x00158c9L,	"-88265", "%03.4d",
__LINE__, 0x6947c336L,	"1766310710", "%.6d",
__LINE__, 0x0000017cL,	"17C", "% 0X",
__LINE__, -0x00001b7L,	"-439", "% 0ld",
__LINE__, 0x06a7575aL,	"6A7575A", "%-.0X",
__LINE__, 0x000b3459L,	"734297", "%ld",
__LINE__, -0x395d8ddL,	"-60152029", "%ld",
__LINE__, 0x00036bb3L,	"224179", "%-6.d",
__LINE__, 0xffff14ffL,	"FFFF14FF", "%X",
__LINE__, -0x15910e4fL,	"-361827919", "%-0d",
__LINE__, -0x0000004L,	"-4", "%#d",
__LINE__, 0xf7f7adacL,	"F7F7ADAC", "% 3.X",
__LINE__, 0xffffff74L,	"FFFFFF74", "%0X",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, -0x000007bL,	"-123   ", "%-7.d",
__LINE__, -0x000002cL,	"-44", "%d",
__LINE__, -0x000002bL,	"  -43", "%5d",
__LINE__, 0x0000ae5fL,	"44639", "%d",
__LINE__, 0x003cbc63L,	"3CBC63", "%X",
__LINE__, 0xfffffffcL,	"0XFFFFFFFC", "%#5.7X",
__LINE__, 0x0003e044L,	"3E044", "%X",
__LINE__, -0x0000c46L,	"-3142", "%.1d",
__LINE__, 0xff18f4bbL,	"FF18F4BB", "%0X",
__LINE__, 0xfffffffdL,	"FFFFFFFD", "%.1X",
__LINE__, -0x01c0f27L,	"-1838887", "%0d",
__LINE__, -0x1242901fL,	"-306352159", "%.4ld",
__LINE__, 0x1775c10aL,	"393593098", "%6.ld",
__LINE__, 0x00000001L,	"  1", "%03.d",
__LINE__, 0xfff1fd30L,	"0xfff1fd30", "%#x",
__LINE__, 0x00000191L,	"191", "%0.X",
__LINE__, 0x2e597178L,	"777613688", "%2.ld",
__LINE__, -0x4ef0cf3L,	"-82775283", "%+.6ld",
__LINE__, -0x0000085L,	"  -133", "%6.d",
__LINE__, 0x0000014dL,	"333  ", "%-5ld",
__LINE__, -0xc03bd74L,	"-201571700", "%07.6ld",
__LINE__, -0x000000aL,	"-10", "%d",
__LINE__, 0x01f5e86eL,	"32893038", "%#2.ld",
__LINE__, 0x00000033L,	"0X33", "% #X",
__LINE__, 0x0087c797L,	" 8898455", "% 7.d",
__LINE__, -0x0001205L,	"-4613", "%5d",
__LINE__, 0x00000192L,	"    192", "%7.X",
__LINE__, 0x000e6c00L,	"945152", "%6.1ld",
__LINE__, 0x00018629L,	" 99881", "% d",
__LINE__, -0x04739c6L,	"-4667846", "%-01.3ld",
__LINE__, 0x00001f42L,	"8002", "%d",
__LINE__, 0x00000cafL,	"3247", "%d",
__LINE__, -0x4992e24L,	"-77147684", "%#.6d",
__LINE__, 0x0000001dL,	"1d", "%-0x",
__LINE__, 0x14d79f03L,	"349675267", "%0ld",
__LINE__, 0x00000dd4L,	" 03540", "%#6.5ld",
__LINE__, 0x0005f30eL,	"0X5F30E", "%#X",
__LINE__, 0x00000157L,	"157", "%X",
__LINE__, -0x9281698L,	"-153622168", "%d",
__LINE__, -0x000004aL,	"-74", "%d",
__LINE__, -0x0010c9eL,	"-68766", "%-0d",
__LINE__, 0x00000059L,	"00089", "%.5ld",
__LINE__, -0x06959e3L,	"-6904291", "% 4.d",
__LINE__, 0xfbea12b1L,	"0XFBEA12B1", "%+#X",
__LINE__, 0xffffdfb1L,	"FFFFDFB1", "%2.6X",
__LINE__, 0x0434faacL,	"434faac", "%.5x",
__LINE__, 0xffffffffL,	"ffffffff", "% x",
__LINE__, 0x00000b32L,	"B32", "%0X",
__LINE__, 0x00000047L,	"71", "%.1d",
__LINE__, 0x00070befL,	" 0461807", "% .7d",
__LINE__, 0x00000038L,	"38", "% 0x",
__LINE__, 0x00000000L,	"     0", "%6X",
__LINE__, 0xfff9c011L,	"FFF9C011", "%2X",
__LINE__, 0xfffffffeL,	"fffffffe", "%7x",
__LINE__, 0xfffffff9L,	"FFFFFFF9", "%X",
__LINE__, -0x016a095L,	"-1482901", "%4.0ld",
__LINE__, -0x000001cL,	"-28", "% ld",
__LINE__, 0xfffd6133L,	"0xfffd6133", "%#x",
__LINE__, 0x000004a4L,	"0x4a4", "%#x",
__LINE__, 0x000003c2L,	"0962", "%.4d",
__LINE__, -0x000323bL,	"-12859", "%+#d",
__LINE__, 0x0f620237L,	"F620237", "%X",
__LINE__, 0x00007863L,	"007863", "%.6X",
__LINE__, 0x0000002cL,	" 44", "% #ld",
__LINE__, 0xfffffff0L,	"fffffff0", "%03.6x",
__LINE__, 0xffff6346L,	"FFFF6346", "%1.X",
__LINE__, 0x00063188L,	"63188", "% x",
__LINE__, 0xfffff91cL,	"fffff91c", "%-.3x",
__LINE__, 0x004cd0b4L,	"4CD0B4", "%-2.X",
__LINE__, 0x06b4d739L,	"112514873", "%0.1d",
__LINE__, -0x0009bebL,	"-39915", "%.2d",
__LINE__, 0x0000831bL,	"33563", "%d",
__LINE__, 0x00000001L,	"1", "%X",
__LINE__, -0x942d76bL,	"-155375467", "% #0ld",
__LINE__, 0xffff2a95L,	"FFFF2A95", "%2X",
__LINE__, 0x00548d5eL,	"5541214", "%.3ld",
__LINE__, 0x0b5e1a01L,	"B5E1A01", "% .7X",
__LINE__, 0xfffffc22L,	"fffffc22", "%6x",
__LINE__, -0x0000dd7L,	"-3543", "%-.3ld",
__LINE__, 0xfffff834L,	"FFFFF834", "%X",
__LINE__, 0x0365f762L,	"57014114", "%ld",
__LINE__, -0x0000003L,	"-3", "%d",
__LINE__, 0x3bd998a3L,	"1004116131", "%d",
__LINE__, 0xfffff6c9L,	"FFFFF6C9", "%+X",
__LINE__, 0xffffded9L,	"FFFFDED9", "%-.1X",
__LINE__, -0x00fbb5aL,	"-1031002", "% 1.0d",
__LINE__, 0xffffffb7L,	"ffffffb7", "%6.x",
__LINE__, 0xff1b8ac3L,	"FF1B8AC3", "%-X",
__LINE__, 0xfffffff2L,	"FFFFFFF2", "%00.X",
__LINE__, -0x000013dL,	" -317", "%05.d",
__LINE__, 0x0000f5e2L,	"+62946", "%+0.2ld",
__LINE__, 0x16ac6358L,	"16ac6358", "%x",
__LINE__, 0xffff8728L,	"FFFF8728", "%+X",
__LINE__, -0x0014a6dL,	"-084589", "%0.6ld",
__LINE__, 0xfc904514L,	"FC904514", "%+0X",
__LINE__, 0x00000004L,	"4", "%ld",
__LINE__, 0xffffffe0L,	"ffffffe0", "%+x",
__LINE__, -0x0a0ffddL,	"-10551261", "%+02d",
__LINE__, -0x0000bbcL,	"-3004", "%+d",
__LINE__, 0x00000006L,	"     +6", "%+7ld",
__LINE__, 0x17afa6e5L,	"397387493", "%ld",
__LINE__, 0xfffff6bfL,	"fffff6bf", "%+04.4x",
__LINE__, 0x000001dcL,	"01dc", "% 02.4x",
__LINE__, 0x0000000eL,	" 14", "% d",
__LINE__, 0xfffffff9L,	"0XFFFFFFF9", "%#4.X",
__LINE__, 0x0000005dL,	"93", "%0d",
__LINE__, -0x004fa05L,	"-0326149", "%.7d",
__LINE__, -0x0000018L,	"-24", "%ld",
__LINE__, 0xfffff7ebL,	"FFFFF7EB", "%X",
__LINE__, 0x0072b044L,	" 7516228", "% .7ld",
__LINE__, 0xffffffedL,	"0xffffffed", "%#x",
__LINE__, 0x0010364dL,	"10364D", "%X",
__LINE__, 0xfff90469L,	"0XFFF90469", "%#X",
__LINE__, 0x000001b4L,	" 436", "% 0d",
__LINE__, 0x00000000L,	"0", "% X",
__LINE__, 0xfffffff3L,	"fffffff3", "%x",
__LINE__, 0x19335d40L,	"19335d40", "%6x",
__LINE__, 0x00039c24L,	"236580", "%ld",
__LINE__, 0x000021f7L,	"8695", "%0.4ld",
__LINE__, -0x057b406L,	"-5747718", "%d",
__LINE__, -0x017b371L,	"-1553265", "%#ld",
__LINE__, 0x0003e405L,	"254981", "%2.d",
__LINE__, 0x00000001L,	"1", "%-.1x",
__LINE__, 0x000000aeL,	"AE", "%.1X",
__LINE__, 0xffd85825L,	"ffd85825", "%-7.x",
__LINE__, 0xfffad763L,	"fffad763", "%x",
__LINE__, 0x002431d4L,	"2372052", "%6.ld",
__LINE__, 0x00000003L,	"000003", "%-05.6d",
__LINE__, 0xffffffebL,	"0xffffffeb", "%#x",
__LINE__, 0xff8cf3b0L,	"ff8cf3b0", "%x",
__LINE__, 0xfe88d2ffL,	"0xfe88d2ff", "%+#.2x",
__LINE__, 0xffffff6bL,	"ffffff6b", "%6.3x",
__LINE__, 0xfffffffeL,	"fffffffe", "%-x",
__LINE__, 0xe998945aL,	"e998945a", "%2.x",
__LINE__, 0x03b9c50fL,	"3B9C50F", "%+X",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%3.7X",
__LINE__, 0x000024efL,	"24ef", "%+x",
__LINE__, 0xfffffc04L,	"FFFFFC04", "%X",
__LINE__, 0x0d4bef7cL,	" 223080316", "% .1ld",
__LINE__, -0xc33f3bcL,	"-204731324", "%.5ld",
__LINE__, 0xffffffffL,	"0XFFFFFFFF", "%#2X",
__LINE__, 0x0000e493L,	"e493", "%x",
__LINE__, 0x000001b4L,	"1b4", "%x",
__LINE__, 0xffffffd6L,	"0xffffffd6", "% #1x",
__LINE__, 0x00000001L,	"1", "%d",
__LINE__, -0x0000f28L,	"-3880", "%ld",
__LINE__, 0x00000277L,	"631", "%-1ld",
__LINE__, 0x00000001L,	" 1", "%2x",
__LINE__, -0x0ff4d2cL,	"-16731436", "%#ld",
__LINE__, 0x0bb80344L,	"196608836", "%00ld",
__LINE__, 0xffffffdcL,	"FFFFFFDC", "%X",
__LINE__, 0x00000484L,	"1156", "%ld",
__LINE__, 0x00000341L,	"341", "%-.2x",
__LINE__, 0x0000ee62L,	"ee62", "%x",
__LINE__, 0xfffffe20L,	"fffffe20", "%+x",
__LINE__, -0x00076ebL,	"-30443", "%.2d",
__LINE__, 0x2c4a7407L,	"2c4a7407", "% x",
__LINE__, 0x00000000L,	"   ", "%3.X",
__LINE__, 0xffffff60L,	"ffffff60", "% 4.x",
__LINE__, 0x000e4cf2L,	"+937202", "%+.5ld",
__LINE__, 0x00000008L,	" 00008", "%06.5X",
__LINE__, 0x0002f612L,	"194066", "%d",
__LINE__, 0xfffffc96L,	"fffffc96", "%-3.3x",
__LINE__, -0x0000001L,	"-1", "% ld",
__LINE__, 0x00000000L,	"      ", "% 6.0X",
__LINE__, 0xfffffff5L,	"fffffff5", "%3.x",
__LINE__, 0x0bfd63a1L,	"201155489", "%d",
__LINE__, -0x1547c214L,	"-357024276", "%ld",
__LINE__, 0x00000004L,	"4", "%#0.d",
__LINE__, -0x000f2f3L,	"-62195", "%.2d",
__LINE__, 0xfff843ddL,	"FFF843DD", "%X",
__LINE__, 0x00966e36L,	"9858614", "%.0ld",
__LINE__, 0x0000782eL,	"0X782E", "% #X",
__LINE__, 0x00bd36c0L,	"12400320", "%ld",
__LINE__, 0x00000000L,	"00", "% .2X",
__LINE__, 0x00000000L,	"0", "%1X",
__LINE__, 0x0003f416L,	"3f416 ", "%-6.x",
__LINE__, -0x00b74bdL,	"-750781", "% ld",
__LINE__, 0x0000138aL,	"138a", "% x",
__LINE__, 0x024df7f0L,	"24DF7F0", "% 0.6X",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%X",
__LINE__, -0x0003284L,	"-12932 ", "%-07.ld",
__LINE__, 0x000094d3L,	"94d3", "%x",
__LINE__, 0x000000bfL,	"bf", "%.2x",
__LINE__, 0x00000000L,	"00000", "%-1.5X",
__LINE__, -0x04899b8L,	"-4757944", "%d",
__LINE__, 0x2b51bf20L,	"+726777632", "%+d",
__LINE__, -0x000000dL,	"-13", "%.2d",
__LINE__, 0x04f78fbdL,	"4F78FBD", "% 7.X",
__LINE__, 0x00011684L,	"71300", "%5.d",
__LINE__, 0x0000539dL,	"21405", "%0d",
__LINE__, 0x00000008L,	"000008", "%-3.6X",
__LINE__, 0xfc7a2cdcL,	"fc7a2cdc", "%2.3x",
__LINE__, 0xffc21da1L,	"ffc21da1", "%x",
__LINE__, 0x00000273L,	"273", "%x",
__LINE__, 0x00000000L,	"0", "%#X",
__LINE__, -0x31cd6b9L,	"-52221625", "% d",
__LINE__, 0xfffffff8L,	"FFFFFFF8", "%.0X",
__LINE__, 0x00000002L,	"2", "%#ld",
__LINE__, 0x00e8922cL,	"15241772", "%d",
__LINE__, 0xfeb19ea7L,	"FEB19EA7", "%0.1X",
__LINE__, 0x00003931L,	"014641", "%06ld",
__LINE__, 0x00000015L,	"0X00015", "%#.5X",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%1.X",
__LINE__, 0xfff17103L,	"0XFFF17103", "% #X",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%+X",
__LINE__, 0x00000002L,	"00002", "%.5x",
__LINE__, 0x00001617L,	"   5655", "% 7.d",
__LINE__, -0x0000010L,	"-000016", "%00.6d",
__LINE__, 0x000000b0L,	"B0", "% X",
__LINE__, 0xfc9362b2L,	"FC9362B2", "%-X",
__LINE__, 0xfc3d8276L,	"fc3d8276", "% 1x",
__LINE__, 0x00001405L,	"5125", "%#d",
__LINE__, 0x02250183L,	" 35979651", "% ld",
__LINE__, 0xffc9b007L,	"ffc9b007", "% 4.x",
__LINE__, 0x00000311L,	"785", "%0d",
__LINE__, 0x0004d273L,	" 316019", "% d",
__LINE__, 0x00000001L,	"1", "%1.x",
__LINE__, 0xffff240fL,	"FFFF240F", "%4.X",
__LINE__, 0x0049cfdaL,	"+4837338", "%+ld",
__LINE__, 0x012f6dd5L,	"12F6DD5", "% 6.2X",
__LINE__, 0x00000002L,	"0x2", "%#2.0x",
__LINE__, 0xfffd834aL,	"FFFD834A", "%.6X",
__LINE__, 0xfe2a40f8L,	"0XFE2A40F8", "%#X",
__LINE__, 0xffffffebL,	"ffffffeb", "%x",
__LINE__, -0x00ac5cbL,	"-705995", "%d",
__LINE__, -0x3021108cL,	"-807473292", "% .4d",
__LINE__, -0x0000035L,	"-53", "%-ld",
__LINE__, -0x1a36475L,	"-27485301", "% d",
__LINE__, -0x0000011L,	"-17", "%d",
__LINE__, 0x000001a3L,	"000419", "%.6ld",
__LINE__, 0x0030a0a8L,	"3186856", "%.5ld",
__LINE__, 0x00000019L,	"25", "%d",
__LINE__, 0xf32deac1L,	"F32DEAC1", "%06.2X",
__LINE__, -0x0000004L,	" -00004", "%7.5ld",
__LINE__, 0x00000000L,	"0", "%ld",
__LINE__, 0x0006bf19L,	"442137", "%#0.d",
__LINE__, 0x566f6c44L,	"1450142788", "%1.6d",
__LINE__, 0xfffffc10L,	"fffffc10", "%.2x",
__LINE__, -0x000e04dL,	"-57421", "%+0d",
__LINE__, 0x00000000L,	"0000000", "%+.7X",
__LINE__, 0x00b5c74dL,	" 11913037", "% ld",
__LINE__, -0x028dfe2L,	"-2678754", "%05.1d",
__LINE__, 0xfffffee0L,	"fffffee0", "%0x",
__LINE__, -0x030c077L,	"-3194999", "%-.6d",
__LINE__, 0x00055ca1L,	"055ca1", "%-.6x",
__LINE__, 0x00000000L,	"       ", "%7.X",
__LINE__, 0xfffffe3bL,	"FFFFFE3B", "%X",
__LINE__, 0xffffffffL,	"FFFFFFFF", "% 3X",
__LINE__, 0x00000857L,	"2135", "%-#1.d",
__LINE__, -0x00546a2L,	"-345762", "%0.5d",
__LINE__, 0x0000000bL,	"0xb   ", "%-#6x",
__LINE__, 0x00000d2bL,	"d2b ", "%-4.0x",
__LINE__, 0x0ae02b9eL,	"AE02B9E", "%X",
__LINE__, 0xfffffa7bL,	"fffffa7b", "%-2.x",
__LINE__, 0x00000001L,	"1", "%X",
__LINE__, 0x000006adL,	"01709", "%05.5ld",
__LINE__, -0x0000102L,	"-258", "%-0.ld",
__LINE__, 0x00000000L,	"0", "%.1X",
__LINE__, -0x01daa95L,	"-1944213", "%-1ld",
__LINE__, 0x02b99040L,	"2B99040", "%2.X",
__LINE__, 0x1b3d5621L,	"1B3D5621", "%X",
__LINE__, 0x0312d16bL,	"51564907", "%-1.7ld",
__LINE__, 0x000aa76cL,	" 698220", "% 2d",
__LINE__, 0x00000000L,	"0", "%ld",
__LINE__, 0xfff8a4ecL,	"FFF8A4EC", "%-X",
__LINE__, 0xffffe06dL,	"ffffe06d", "%x",
__LINE__, 0x00000003L,	"3", "% x",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0xd3e244ddL,	"D3E244DD", "%+5X",
__LINE__, 0x000028b3L,	" 28b3", "% 5.x",
__LINE__, 0x0001acebL,	"109803", "%6d",
__LINE__, 0xfffbc5caL,	"0xfffbc5ca", "%-#5x",
__LINE__, 0x00000097L,	"    151", "% 7ld",
__LINE__, 0x00001fccL,	"+8140", "%+d",
__LINE__, 0xffffffffL,	"ffffffff", "%0x",
__LINE__, -0x00052a9L,	"-21161", "%ld",
__LINE__, 0xfffffc76L,	"FFFFFC76", "%.1X",
__LINE__, -0x2acb012L,	"-44871698", "%0.1ld",
__LINE__, 0xffffff81L,	"ffffff81", "%x",
__LINE__, -0x0018394L,	"-99220", "%-ld",
__LINE__, 0x0000001bL,	"1B", "%X",
__LINE__, 0x00000033L,	"51", "%1d",
__LINE__, 0xffec37e5L,	"FFEC37E5", "%-1X",
__LINE__, -0x000000aL,	"  -10", "%#5.d",
__LINE__, -0x0000412L,	"-1042", "%ld",
__LINE__, 0x000cd0b1L,	"cd0b1  ", "%-7.5x",
__LINE__, 0x0b445370L,	"B445370", "%+2.0X",
__LINE__, 0xfffffff3L,	"0XFFFFFFF3", "%-#X",
__LINE__, 0xffff9f33L,	"FFFF9F33", "%5.X",
__LINE__, 0x00010a1eL,	"10A1E", "%-2X",
__LINE__, -0xede156fL,	"-249435503", "% 7.1ld",
__LINE__, 0xfc6d63aaL,	"fc6d63aa", "% .6x",
__LINE__, 0x0000311cL,	" 12572", "% ld",
__LINE__, 0x00001f8aL,	"8074", "%00.d",
__LINE__, 0x00000199L,	"199", "%-X",
__LINE__, 0xfffffc60L,	"FFFFFC60", "%+3X",
__LINE__, -0x000022cL,	"-556", "%+0ld",
__LINE__, 0x021d8407L,	"35488775", "%-#.7ld",
__LINE__, 0x0000020fL,	"527", "%d",
__LINE__, -0x000064bL,	"-1611", "%#ld",
__LINE__, -0x0c15aefL,	"-12671727", "%d",
__LINE__, -0x1f1a6881L,	"-521824385", "%ld",
__LINE__, 0xffffc115L,	"ffffc115", "% x",
__LINE__, 0x00000017L,	" 23", "% #ld",
__LINE__, 0x00000dc1L,	"DC1 ", "%-4X",
__LINE__, 0x000002caL,	"2CA", "%X",
__LINE__, 0x000f052cL,	" 984364", "%7.d",
__LINE__, 0x0000005aL,	"0090", "%0.4d",
__LINE__, -0x001e463L,	"-124003", "% 4.ld",
__LINE__, 0x00000001L,	"0000001", "%+.7X",
__LINE__, 0x00000bfbL,	"0000bfb", "%5.7x",
__LINE__, 0x0002484bL,	"149579", "%#1d",
__LINE__, 0x0043ba18L,	"4438552", "%-ld",
__LINE__, 0x000078f8L,	"0X78F8", "%#X",
__LINE__, 0x00000001L,	"   1", "%4d",
__LINE__, 0x0cedaeedL,	"CEDAEED", "%X",
__LINE__, 0x00000003L,	"+3", "%+ld",
__LINE__, 0xfffffffbL,	"FFFFFFFB", "%7.4X",
__LINE__, 0x00000169L,	"361", "%ld",
__LINE__, 0x00003c7aL,	"+15482", "%+ld",
__LINE__, -0x0159d93L,	"-1416595", "% 0.0d",
__LINE__, 0x0000775cL,	"+30556", "%+3.d",
__LINE__, 0x10284768L,	"+271075176", "%+0.0ld",
__LINE__, -0xf8b610eL,	"-260792590", "%0d",
__LINE__, 0xfdd8d369L,	"fdd8d369", "%-.3x",
__LINE__, 0x000c9495L,	"+824469", "%+ld",
__LINE__, -0x000003fL,	"   -063", "%7.3d",
__LINE__, -0x000073bL,	"-1851", "%+03.ld",
__LINE__, 0xfffe4e23L,	"0xfffe4e23", "%#.5x",
__LINE__, 0x0081788cL,	"81788c", "%5x",
__LINE__, -0x015f888L,	"-1439880", "%+1d",
__LINE__, -0x31d64b4L,	"-52257972", "%0.2d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%6.5X",
__LINE__, -0x0000072L,	"-114", "%+.1d",
__LINE__, -0x00000e1L,	"-225", "%ld",
__LINE__, 0x000006a8L,	"0x6a8", "%+#x",
__LINE__, 0xfffe673aL,	"fffe673a", "%01.x",
__LINE__, 0xfff2ee0dL,	"FFF2EE0D", "%-X",
__LINE__, 0x0290320aL,	"43004426", "%0ld",
__LINE__, -0xeb7a832L,	"-246917170", "% ld",
__LINE__, 0x02ae9265L,	"2ae9265", "%1.x",
__LINE__, 0xffffffd2L,	"ffffffd2", "%+2.x",
__LINE__, 0x00e6e858L,	"0xe6e858", "%#0.x",
__LINE__, 0x00000c4aL,	"+3146", "%+3.1d",
__LINE__, -0x6943c1aL,	"-110378010", "% 0ld",
__LINE__, 0x0167b119L,	"167b119", "%0x",
__LINE__, 0xfffffffeL,	"fffffffe", "%+x",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%X",
__LINE__, 0x000b861eL,	"755230", "%ld",
__LINE__, 0x0000015bL,	"347", "%-#ld",
__LINE__, 0xfffffffaL,	"0XFFFFFFFA", "%#X",
__LINE__, 0x000de9e5L,	"911845", "%d",
__LINE__, 0x00000001L,	"01", "%.2d",
__LINE__, 0x000007a5L,	"1957", "%0d",
__LINE__, 0x0000000fL,	"f", "%x",
__LINE__, 0x00c38cbfL,	" 12815551", "% .2d",
__LINE__, -0x7bd1b6eL,	"-129833838", "% d",
__LINE__, -0x000013cL,	"-316", "%0d",
__LINE__, 0x00001aadL,	"1AAD", "%-0X",
__LINE__, 0x0034f903L,	"3471619", "%00d",
__LINE__, 0xff925717L,	"ff925717", "%4x",
__LINE__, 0x00000002L,	"02", "%.2d",
__LINE__, 0x00000f34L,	"F34", "%+X",
__LINE__, 0xffffeefeL,	"FFFFEEFE", "%X",
__LINE__, 0xfffeecb4L,	"FFFEECB4", "% 2.X",
__LINE__, 0x00034421L,	"214049", "%0ld",
__LINE__, 0x00000000L,	"     0", "%+6X",
__LINE__, -0x0000062L,	"-98", "%-#2d",
__LINE__, -0x0000557L,	"-1367", "%-4.4d",
__LINE__, 0xffffe17cL,	"FFFFE17C", "%X",
__LINE__, 0x00000097L,	"00097", "%.5X",
__LINE__, 0xfffcb278L,	"FFFCB278", "%0.7X",
__LINE__, -0x0000001L,	"-0001  ", "%-7.4d",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, 0x000002c4L,	"708", "%d",
__LINE__, 0x04946f45L,	"4946F45", "%-2.X",
__LINE__, 0x000000ffL,	"00ff", "% 2.4x",
__LINE__, 0x00073307L,	"471815", "%3ld",
__LINE__, 0x0085b7b6L,	"+8763318", "%+ld",
__LINE__, -0x0000002L,	"-2", "%1ld",
__LINE__, -0x0000001L,	"-1", "%-2d",
__LINE__, -0x00000b5L,	"   -181", "%7ld",
__LINE__, -0x0412486L,	"-4269190", "%+2.1ld",
__LINE__, 0xffffffffL,	"ffffffff", "%0x",
__LINE__, 0x0000006dL,	"6d", "%x",
__LINE__, 0x000000daL,	"218", "%-.3ld",
__LINE__, 0xfffffcfeL,	"fffffcfe", "%x",
__LINE__, 0x652e60c7L,	"652E60C7", "%7.7X",
__LINE__, 0x00000035L,	" 53", "% #2d",
__LINE__, 0x000000fcL,	"FC", "%-X",
__LINE__, 0x00000019L,	" 25", "% ld",
__LINE__, 0xfffffcf4L,	"fffffcf4", "%6x",
__LINE__, 0xffffff41L,	"ffffff41", "%x",
__LINE__, 0x00000034L,	" 52", "%3.ld",
__LINE__, 0xffffffb2L,	"ffffffb2", "%-x",
__LINE__, -0x6dc43e7cL,	"-1841577596", "% .2ld",
__LINE__, 0x00000004L,	"4", "%d",
__LINE__, -0x000023bL,	"-571", "%ld",
__LINE__, -0x000004dL,	"-77", "%ld",
__LINE__, 0x0000e3baL,	"58298", "%.0ld",
__LINE__, 0xfffffff2L,	"fffffff2", "%0.0x",
__LINE__, -0x0000020L,	"-32", "%ld",
__LINE__, 0xffffb33eL,	"0XFFFFB33E", "%-#X",
__LINE__, 0x00000000L,	"    ", "% 4.x",
__LINE__, 0xffd96f92L,	"FFD96F92", "%X",
__LINE__, 0x0000002eL,	" 46", "% 0ld",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, -0x5008ba3L,	"-83921827", "%+d",
__LINE__, 0xfdc1df3dL,	"FDC1DF3D", "%0X",
__LINE__, 0xfc7410e5L,	"fc7410e5", "%7x",
__LINE__, 0xfffffffaL,	"FFFFFFFA", "% 6.X",
__LINE__, 0x00000000L,	"0", "%X",
__LINE__, -0x040fd4eL,	"-4259150", "% 05.d",
__LINE__, 0x0000003bL,	" 59", "%3.2d",
__LINE__, 0xff776dd8L,	"ff776dd8", "%x",
__LINE__, 0x0000055bL,	"+1371", "%+#2d",
__LINE__, 0x00004841L,	"4841", "%.1x",
__LINE__, 0x0229d710L,	"36296464", "%-.2ld",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0xfffe8376L,	"fffe8376", "%0x",
__LINE__, 0x000a7b83L,	"a7b83", "%x",
__LINE__, 0x0000000dL,	"    013", "%#7.3d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%5.0X",
__LINE__, 0x00000704L,	"  0x704", "%#7.0x",
__LINE__, 0xfff970b9L,	"FFF970B9", "%.1X",
__LINE__, -0x000b60aL,	"-46602", "%+d",
__LINE__, 0x00000000L,	" 00000", "%6.5x",
__LINE__, 0x00000003L,	"3", "%X",
__LINE__, 0x0000c14bL,	"c14b", "%0x",
__LINE__, 0x066d7860L,	"107837536", "%-d",
__LINE__, 0x00000013L,	"  13", "%4.x",
__LINE__, 0xfff96f18L,	"FFF96F18", "%4X",
__LINE__, 0xffffff30L,	"FFFFFF30", "%X",
__LINE__, 0xffffffffL,	"FFFFFFFF", "% .7X",
__LINE__, -0x72a9e985L,	"-1923737989", "%2.d",
__LINE__, 0x00000002L,	"0x2", "%#x",
__LINE__, 0x0000050eL,	"50e", "%2.3x",
__LINE__, 0x0000605cL,	"24668", "%4.1d",
__LINE__, 0xffffff3eL,	"ffffff3e", "%x",
__LINE__, -0x0000010L,	"-16", "%-2d",
__LINE__, 0x000061aaL,	"61AA", "%X",
__LINE__, 0x000c2ec3L,	"C2EC3", "%0X",
__LINE__, -0x0000001L,	"-1", "%-0d",
__LINE__, 0x00130e17L,	"+1248791", "%+.6ld",
__LINE__, 0x000000efL,	"EF", "%-X",
__LINE__, -0x0000001L,	"   -1", "%+5ld",
__LINE__, 0x0000989dL,	"39069", "%d",
__LINE__, 0x00000000L,	"0", "%-x",
__LINE__, 0x00000417L,	"417", "%X",
__LINE__, 0x00005e86L,	"5E86", "%+X",
__LINE__, -0x0007c08L,	"-31752", "%ld",
__LINE__, 0x00da8e0fL,	"DA8E0F", "%2.2X",
__LINE__, -0x3ee095ecL,	"-1054905836", "% 0d",
__LINE__, 0xfffdb5a3L,	"fffdb5a3", "%x",
__LINE__, 0xffffff83L,	"FFFFFF83", "%X",
__LINE__, 0xfff8efd7L,	"0xfff8efd7", "%#x",
__LINE__, 0x00000020L,	" 32", "% d",
__LINE__, 0xfff7c002L,	"fff7c002", "%.7x",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, 0x00000000L,	"  000", "%05.3X",
__LINE__, 0xfff190eeL,	"FFF190EE", "%X",
__LINE__, 0x00000a6cL,	"  2668", "%#6.ld",
__LINE__, 0x00037024L,	"37024", "%x",
__LINE__, 0xfffec37fL,	"FFFEC37F", "%X",
__LINE__, 0x007ee9bbL,	"8317371", "%#0.ld",
__LINE__, 0x00000122L,	"290", "%ld",
__LINE__, -0x0013b5fL,	"-80735", "%ld",
__LINE__, 0xfffffff6L,	"FFFFFFF6", "%X",
__LINE__, -0x0000c16L,	"-0003094", "%-00.7d",
__LINE__, -0x00010edL,	"-4333", "%ld",
__LINE__, 0x00000007L,	" 0X007", "%#6.3X",
__LINE__, 0x0053781eL,	" 5470238", "% 2d",
__LINE__, 0xffff03e9L,	"0XFFFF03E9", "%+#7.3X",
__LINE__, 0xfffffdc2L,	"0xfffffdc2", "% #4.x",
__LINE__, -0x00018e1L,	"-6369", "%d",
__LINE__, 0xf3a4abc6L,	"F3A4ABC6", "%-.2X",
__LINE__, 0xfff64a27L,	"FFF64A27", "%7.7X",
__LINE__, 0x00195ae5L,	"195AE5", "%+03.X",
__LINE__, 0xfff8849aL,	"fff8849a", "%.1x",
__LINE__, -0x001b045L,	"-110661", "%+ld",
__LINE__, 0x01e8a106L,	"32022790", "%7.ld",
__LINE__, 0x0008ee94L,	"8EE94", "%X",
__LINE__, 0xfffcdabcL,	"FFFCDABC", "%X",
__LINE__, 0xfda75cd2L,	"fda75cd2", "%x",
__LINE__, 0x00fd505aL,	"fd505a", "%x",
__LINE__, 0x00003748L,	"3748", "%+x",
__LINE__, 0xffffffe5L,	"ffffffe5", "% 3.6x",
__LINE__, -0x1d1c4045L,	"-488390725", "%d",
__LINE__, 0xfffffff9L,	"0xfffffff9", "%#x",
__LINE__, -0x0000001L,	"-1", "%-#ld",
__LINE__, 0x00000191L,	"191", "%X",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%-X",
__LINE__, -0x0000006L,	"-6", "%ld",
__LINE__, 0x00000033L,	"  33", "% 4x",
__LINE__, -0x0159a14L,	"-1415700", "% ld",
__LINE__, 0x000001c3L,	"00001c3", "%07x",
__LINE__, 0xffffe9e2L,	"ffffe9e2", "%-x",
__LINE__, 0x5b19abd9L,	"0x5b19abd9", "%-#x",
__LINE__, 0xffff1baeL,	"0xffff1bae", "%#x",
__LINE__, 0x00000001L,	"+1", "%+d",
__LINE__, 0x006a23c7L,	"6A23C7", "%2.X",
__LINE__, 0x000008a4L,	" 8a4", "% 4.1x",
__LINE__, 0xfffffcd9L,	"fffffcd9", "%.1x",
__LINE__, 0x0000121bL,	"121B", "%X",
__LINE__, 0x001231aaL,	"1192362", "%7.d",
__LINE__, -0x008026dL,	"-524909", "%4.2d",
__LINE__, 0x192ea594L,	"422487444", "%ld",
__LINE__, 0x0001a800L,	"108544", "%0d",
__LINE__, 0x000062f1L,	"62f1", "%.4x",
__LINE__, 0xff8b39b0L,	"ff8b39b0", "% x",
__LINE__, 0x00000001L,	"0x1", "%+#x",
__LINE__, 0x0000144aL,	"5194", "%ld",
__LINE__, 0x00002599L,	"9625", "%d",
__LINE__, 0xffa0a2efL,	"ffa0a2ef", "%0x",
__LINE__, 0xff6712e1L,	"FF6712E1", "%0X",
__LINE__, 0x0007ebb3L,	"519091", "%1ld",
__LINE__, 0x0000000fL,	"15  ", "%-4.ld",
__LINE__, -0x0000096L,	"-150", "%2.ld",
__LINE__, 0x0000004fL,	"4F", "%.2X",
__LINE__, 0xfffffc29L,	"fffffc29", "%-4.x",
__LINE__, 0x00000019L,	"19", "%x",
__LINE__, 0x00000c4eL,	"c4e", "%x",
__LINE__, 0x0000006bL,	" 0006B", "%6.5X",
__LINE__, 0x00c8d2c6L,	"c8d2c6", "%.0x",
__LINE__, -0x256fb8deL,	"-628078814", "%ld",
__LINE__, 0x4f51fcf4L,	"4F51FCF4", "%+X",
__LINE__, 0x000f000eL,	"983054", "%1.ld",
__LINE__, 0xfffff03fL,	"fffff03f", "%x",
__LINE__, 0x0000001dL,	"   1D", "%05.X",
__LINE__, 0x0072ea14L,	"72ea14", "%x",
__LINE__, -0xc6098b9L,	"-207657145", "%-7d",
__LINE__, 0x00000a76L,	"2678", "%3ld",
__LINE__, 0xfff84db3L,	"FFF84DB3", "%X",
__LINE__, 0x0fb52870L,	"fb52870", "%+x",
__LINE__, 0x08bc170aL,	"0x8bc170a", "%#x",
__LINE__, 0xfffeeb00L,	"fffeeb00", "%0.5x",
__LINE__, 0x000ece95L,	"970389", "%d",
__LINE__, 0x00000000L,	"0", "%0X",
__LINE__, 0x07f98e8aL,	"7f98e8a", "% x",
__LINE__, 0x000499ebL,	" 499eb", "% 6.x",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%-X",
__LINE__, 0x0aa45e86L,	"178544262", "%#.2d",
__LINE__, 0xff73387dL,	"FF73387D", "%03.X",
__LINE__, 0xfffffb51L,	"FFFFFB51", "%.3X",
__LINE__, 0xffffffdcL,	"ffffffdc", "%6.x",
__LINE__, 0xffffffedL,	"FFFFFFED", "%-X",
__LINE__, 0x0001c4c2L,	"1c4c2", "%0.3x",
__LINE__, -0x0000001L,	"-0000001", "%-#.7d",
__LINE__, 0x00000007L,	"7", "%0.x",
__LINE__, 0x00000001L,	"1", "%ld",
__LINE__, 0xffffd000L,	"ffffd000", "%4.3x",
__LINE__, 0x00000030L,	"48", "%2.d",
__LINE__, -0x6c121ceL,	"-113320398", "%.5ld",
__LINE__, 0x000001edL,	"1ED", "% 3.X",
__LINE__, 0xfffff0f3L,	"FFFFF0F3", "%+.6X",
__LINE__, 0xffffffecL,	"ffffffec", "%x",
__LINE__, 0x002d5ab8L,	"0x2d5ab8", "%-#x",
__LINE__, 0x0026acffL,	"2534655", "%0ld",
__LINE__, 0x01d90cd7L,	"+31001815", "%+.2ld",
__LINE__, -0x1f7abc0L,	"-33008576", "%7.6d",
__LINE__, 0xfc5babccL,	"fc5babcc", "%x",
__LINE__, -0x9b74892L,	"-163006610", "% .6d",
__LINE__, 0x03931d84L,	"59972996", "%0.d",
__LINE__, 0x07d261ceL,	"131228110", "%#ld",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0x00000002L,	"2", "%+X",
__LINE__, -0x0000604L,	"-1540", "%+d",
__LINE__, 0x00000000L,	"       ", "%7.x",
__LINE__, 0x00000001L,	"1", "%.0X",
__LINE__, -0x0005a8eL,	"-23182", "% d",
__LINE__, 0x03fb2730L,	"3fb2730", "%7.x",
__LINE__, 0xffffff03L,	"ffffff03", "%x",
__LINE__, 0x00000000L,	"   ", "%-#3.d",
__LINE__, 0x04025a4bL,	"0X4025A4B", "%+#X",
__LINE__, -0x0000001L,	"  -1", "%4.d",
__LINE__, 0xfffe00a3L,	"FFFE00A3", "%+X",
__LINE__, -0x1b26e3c8L,	"-455533512", "% ld",
__LINE__, 0x000017e5L,	"6117", "%d",
__LINE__, -0x0e4f3b6L,	"-15004598", "%0ld",
__LINE__, 0x00000034L,	"52", "%ld",
__LINE__, 0x0000024cL,	" 24C", "%4X",
__LINE__, 0xfffedf65L,	"FFFEDF65", "%-0X",
__LINE__, -0x000ff1fL,	"-65311", "%+#d",
__LINE__, 0x00000007L,	"      7", "%7.x",
__LINE__, 0x018656aeL,	"18656ae", "%3.7x",
__LINE__, -0x0000004L,	"-4", "%d",
__LINE__, 0x7081292dL,	"1887512877", "%d",
__LINE__, 0x87d3e48cL,	"87d3e48c", "%-x",
__LINE__, 0xf99c516eL,	"0xf99c516e", "% #7.4x",
__LINE__, 0xfffffffaL,	"FFFFFFFA", "%-1X",
__LINE__, -0x000001dL,	"-29", "%#ld",
__LINE__, -0x0000001L,	"-1", "%+ld",
__LINE__, 0x28ab3350L,	" 682308432", "% 1d",
__LINE__, -0x0000006L,	"-6", "%ld",
__LINE__, 0xfffffffbL,	"FFFFFFFB", "%.5X",
__LINE__, -0x0000007L,	"-7", "%#d",
__LINE__, -0x0000328L,	"  -808", "%6.ld",
__LINE__, -0x29386f00L,	"-691564288", "%.3d",
__LINE__, -0x059f38aL,	"-5895050", "%.4ld",
__LINE__, 0xfffff888L,	"FFFFF888", "%3X",
__LINE__, 0xffffffdfL,	"ffffffdf", "%0.0x",
__LINE__, -0xb4fc354L,	"-189776724", "%2d",
__LINE__, 0x00058c07L,	"363527", "%1.d",
__LINE__, 0x0a256162L,	"a256162", "%x",
__LINE__, -0x05c87b0L,	"-6064048", "%0ld",
__LINE__, 0xfffffda1L,	"fffffda1", "%x",
__LINE__, 0x000034b7L,	"13495", "%d",
__LINE__, -0x6d1a8918L,	"-1830455576", "%.1d",
__LINE__, 0x00022290L,	"139920", "%05ld",
__LINE__, 0x00000000L,	"0", "%-x",
__LINE__, -0x1f8eafceL,	"-529444814", "%4.d",
__LINE__, -0x7bf32808L,	"-2079533064", "% ld",
__LINE__, 0x0000023cL,	"23c", "% x",
__LINE__, 0x00000039L,	"39", "%X",
__LINE__, -0x000556dL,	"-21869", "%ld",
__LINE__, -0x00000caL,	"-202", "%ld",
__LINE__, 0x00002e28L,	"11816", "%-d",
__LINE__, 0x00000011L,	"17", "%-ld",
__LINE__, 0xfffffffbL,	"FFFFFFFB", "%-X",
__LINE__, 0xfffdd67fL,	"0XFFFDD67F", "%#X",
__LINE__, -0x000003dL,	"-61", "%d",
__LINE__, 0x0000bfceL,	"0XBFCE", "%-#5.2X",
__LINE__, 0xfffffffcL,	"fffffffc", "%x",
__LINE__, -0x00aea17L,	"-715287", "%.5d",
__LINE__, -0x02fce89L,	"-3133065", "%0d",
__LINE__, 0x007f6ed1L,	"7F6ED1", "%6X",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%X",
__LINE__, -0x0002761L,	"-10081", "%#6.2d",
__LINE__, 0x003be8d8L,	"3BE8D8", "%-X",
__LINE__, 0x00000901L,	"  2305", "%6.d",
__LINE__, 0x00049916L,	"0301334", "%3.7ld",
__LINE__, 0x0678ffeaL,	"0X678FFEA", "%#4X",
__LINE__, 0xffffffffL,	"ffffffff", "%+.0x",
__LINE__, -0x31d2ec61L,	"-835906657", "%.0d",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%0X",
__LINE__, -0x0015588L,	"-87432", "%d",
__LINE__, 0xffffff3eL,	"ffffff3e", "%.4x",
__LINE__, 0x0000000aL,	"10", "%d",
__LINE__, -0x0000003L,	"-3", "%2.1ld",
__LINE__, -0x000d29aL,	"-53914", "%ld",
__LINE__, -0x04ccbe0L,	"-5032928", "%2.2ld",
__LINE__, 0x0357c2a5L,	"357c2a5", "% 7.x",
__LINE__, 0x00000009L,	" 9", "% 1.ld",
__LINE__, -0x005908dL,	"-364685", "%0d",
__LINE__, -0x0000de6L,	"-3558", "%0ld",
__LINE__, 0x2d395e6bL,	"+758734443", "%+6d",
__LINE__, 0x001aba58L,	"1ABA58", "% X",
__LINE__, 0x0ceba5abL,	"0XCEBA5AB", "%#.1X",
__LINE__, -0x01a8575L,	"-1738101", "% 2ld",
__LINE__, 0x0000000dL,	"13", "%#ld",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, 0x4b856407L,	"4b856407", "%5x",
__LINE__, 0x006f333cL,	"6F333C", "%-X",
__LINE__, 0x000000d0L,	"d0", "%x",
__LINE__, 0x2ecf0d4eL,	"2ecf0d4e", "%0x",
__LINE__, -0x0000188L,	"-0000392", "%#1.7ld",
__LINE__, -0x0000037L,	"-55", "%d",
__LINE__, 0xfffffff1L,	"FFFFFFF1", "% .1X",
__LINE__, 0x00000001L,	"0x1", "%#3x",
__LINE__, 0x000005edL,	"5ED", "%3X",
__LINE__, 0x031183a3L,	"31183A3", "%X",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, -0x0018695L,	"-99989", "%-0.5ld",
__LINE__, -0x0000001L,	"-01", "%0.2ld",
__LINE__, 0x00007822L,	"7822", "%+x",
__LINE__, 0x00000000L,	"0", "% x",
__LINE__, 0xfda2461aL,	"FDA2461A", "%X",
__LINE__, 0x065c50efL,	"106713327", "%2.ld",
__LINE__, 0x00000a81L,	"a81", "% 0x",
__LINE__, -0x000022eL,	"-558", "%.0ld",
__LINE__, 0x00013d2fL,	"81199", "%.2ld",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%+X",
__LINE__, 0x000015f9L,	"5625", "%04.ld",
__LINE__, 0x0ab575a2L,	"179664290", "%0d",
__LINE__, 0x0024d07fL,	"0X24D07F", "%#X",
__LINE__, 0x07ee35e1L,	"7EE35E1", "%+X",
__LINE__, -0x00c114cL,	"-790860", "%#ld",
__LINE__, 0x00003be3L,	"  15331", "%07.d",
__LINE__, 0xfff87570L,	"FFF87570", "%4.0X",
__LINE__, -0x14eab419L,	"-350925849", "%-ld",
__LINE__, -0x000001bL,	"-27", "%ld",
__LINE__, 0x167ce2eaL,	"0x167ce2ea", "%#0.x",
__LINE__, -0x00009bcL,	"-002492", "% 3.6d",
__LINE__, 0xfffffdb9L,	"0XFFFFFDB9", "%#7.X",
__LINE__, 0x008b2b9dL,	"8B2B9D", "% X",
__LINE__, 0x000cfec3L,	"CFEC3", "% 05X",
__LINE__, 0x05970be6L,	"5970be6", "%x",
__LINE__, 0x00002780L,	"010112", "%2.6d",
__LINE__, 0x00000005L,	"+5", "%+d",
__LINE__, 0xfffffffbL,	"0xfffffffb", "%#3.x",
__LINE__, 0x00000001L,	"1    ", "%-#5.ld",
__LINE__, -0x0000017L,	"-23", "%ld",
__LINE__, -0x023b943L,	"-2341187", "%d",
__LINE__, 0x0000000dL,	"13", "%ld",
__LINE__, 0x00025a03L,	"25a03", "% .5x",
__LINE__, 0x3e1ebe24L,	"3e1ebe24", "% x",
__LINE__, 0x0000013aL,	"0x13a", "%#5.0x",
__LINE__, 0xfff6f5b3L,	"FFF6F5B3", "%4.X",
__LINE__, -0x0000a8aL,	"-2698", "%.3d",
__LINE__, 0x0009dd5fL,	"9dd5f", "%x",
__LINE__, 0x000003c7L,	" 3C7", "%04.2X",
__LINE__, 0x1bcfa2f2L,	"1bcfa2f2", "%+1.x",
__LINE__, 0x0001b4f4L,	"1b4f4", "%+1.x",
__LINE__, 0x1bc19a90L,	"465672848", "%#d",
__LINE__, 0xffffffffL,	"ffffffff", "%+06x",
__LINE__, -0x0000a88L,	"-2696", "%3.d",
__LINE__, 0x00084a19L,	"84A19", "%-X",
__LINE__, 0xffe1fc8fL,	"FFE1FC8F", "%0.1X",
__LINE__, -0x0000a3aL,	"-2618", "%5d",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, -0x5c6183dL,	"-96868413", "%+ld",
__LINE__, -0x0000001L,	"-1", "%-d",
__LINE__, 0x0000faa8L,	"64168", "%05.d",
__LINE__, 0x003913efL,	"3740655", "%ld",
__LINE__, 0x0dde330aL,	"232665866", "%#ld",
__LINE__, 0xfcfb1a7bL,	"FCFB1A7B", "%+X",
__LINE__, 0x07b1a81fL,	" 129083423", "% 0d",
__LINE__, 0x00000001L,	"1", "%d",
__LINE__, 0x00000070L,	"  112", "%5ld",
__LINE__, 0xffff74d9L,	"ffff74d9", "%x",
__LINE__, -0x001ab93L,	"-109459", "%03.d",
__LINE__, 0x0eb6b497L,	"EB6B497", "%+X",
__LINE__, 0x07adbac2L,	"128826050", "%#0.4d",
__LINE__, 0xff747068L,	"FF747068", "%6.X",
__LINE__, -0x190ce98fL,	"-420276623", "%06.6ld",
__LINE__, -0x0000007L,	"-7", "%.0d",
__LINE__, 0x0001240fL,	"1240f", "% 3x",
__LINE__, 0x267ae4a0L,	"645588128", "%-#ld",
__LINE__, -0x0000001L,	"-1", "% ld",
__LINE__, -0x0000066L,	"-00102", "%.5ld",
__LINE__, 0x868fa035L,	"868fa035", "%x",
__LINE__, 0x00000000L,	"    ", "%-4.ld",
__LINE__, 0xfffffe72L,	"FFFFFE72", "%4.4X",
__LINE__, 0x00a6b4f4L,	"10925300", "%#ld",
__LINE__, -0x0000002L,	"-2", "%00.1d",
__LINE__, -0x00000a3L,	"-163", "%ld",
__LINE__, 0xfffffffeL,	"fffffffe", "% 3.x",
__LINE__, 0xffe25941L,	"ffe25941", "% x",
__LINE__, 0x0000a20fL,	"41487", "%ld",
__LINE__, -0x000009bL,	"-155", "%#.3ld",
__LINE__, 0x000c5dc1L,	"810433", "%4.ld",
__LINE__, 0x00003ec4L,	"16068", "%ld",
__LINE__, 0x000002f3L,	"0755", "%04ld",
__LINE__, 0xffffff28L,	"FFFFFF28", "%.5X",
__LINE__, -0x08450ffL,	"-8671487", "%-3.0ld",
__LINE__, 0x00000092L,	"92", "%x",
__LINE__, -0x0000317L,	"-791", "%d",
__LINE__, 0x0000000dL,	"d", "%x",
__LINE__, 0x00000036L,	"36", "%x",
__LINE__, -0x112693fL,	"-17983807", "%ld",
__LINE__, 0x00004226L,	"16934", "%0.d",
__LINE__, 0x000001baL,	" 442", "% ld",
__LINE__, 0xfffffffcL,	"0XFFFFFFFC", "%#4X",
__LINE__, 0xffdb3d23L,	"0xffdb3d23", "% #x",
__LINE__, 0x039eb84dL,	"39EB84D", "%+.6X",
__LINE__, 0xffffc7daL,	"ffffc7da", "%0x",
__LINE__, 0xfffffdb6L,	"FFFFFDB6", "%6X",
__LINE__, 0x001b75b0L,	"1799600", "%ld",
__LINE__, 0xfffffca2L,	"FFFFFCA2", "%-X",
__LINE__, 0xffffffbaL,	"ffffffba", "%7.4x",
__LINE__, -0x000124eL,	"-4686", "%3.ld",
__LINE__, -0x000bec0L,	"-48832", "% 0d",
__LINE__, 0xfffffca0L,	"fffffca0", "%2.x",
__LINE__, 0x00b2a462L,	"11707490", "%ld",
__LINE__, 0x0745a647L,	"745a647", "%+4.x",
__LINE__, 0xfffffbacL,	"0XFFFFFBAC", "%#3.X",
__LINE__, -0x0000002L,	"-2", "%-0.1d",
__LINE__, 0x0006cfdbL,	"446427", "%#5.d",
__LINE__, -0x0000001L,	"-1", "%d",
__LINE__, 0x043b134eL,	"43B134E", "%X",
__LINE__, -0x0000015L,	"-21", "%ld",
__LINE__, -0x0000114L,	"-276", "%0d",
__LINE__, -0x0004d4aL,	"-19786", "%-d",
__LINE__, -0x000001cL,	"-28", "%ld",
__LINE__, -0x0cb89fcL,	"-13339132", "%ld",
__LINE__, 0xffffffcfL,	"ffffffcf", "%x",
__LINE__, 0xf6d2387aL,	"f6d2387a", "%-x",
__LINE__, -0x00000cdL,	"-205", "%#ld",
__LINE__, 0x00000000L,	"0", "%#x",
__LINE__, 0xfffffc81L,	"fffffc81", "%x",
__LINE__, 0x00000000L,	" 0", "% ld",
__LINE__, 0x00024fb5L,	"24fb5", "%x",
__LINE__, 0x000012faL,	"12FA", "%X",
__LINE__, 0x0318ce7cL,	"51957372", "%0d",
__LINE__, 0x02280a99L,	"2280a99", "%-x",
__LINE__, 0xffffff5cL,	"FFFFFF5C", "%2.X",
__LINE__, -0x000002eL,	"    -46", "%7ld",
__LINE__, -0x04a73e8L,	"-4879336", "%4ld",
__LINE__, 0x000007f3L,	"7f3", "% 1.3x",
__LINE__, 0x00000114L,	"0x114", "%#x",
__LINE__, 0x0000030cL,	"30c", "%-x",
__LINE__, 0x001dd0ddL,	"0x1dd0dd", "%+#5.5x",
__LINE__, 0xfff23de3L,	"fff23de3", "%-x",
__LINE__, -0x0178f9cL,	"-1544092", "%d",
__LINE__, 0x02ded8daL,	"2DED8DA", "%X",
__LINE__, -0x0991672L,	"-10032754", "%3.d",
__LINE__, 0x6943c150L,	"6943c150", "%x",
__LINE__, 0xffffc25dL,	"FFFFC25D", "%4X",
__LINE__, 0x00000c9cL,	" 0003228", "% .7d",
__LINE__, 0xffffffdfL,	"FFFFFFDF", "% 6.X",
__LINE__, 0x0001a145L,	" 1a145", "%6.0x",
__LINE__, 0xffdc832fL,	"0xffdc832f", "%#.1x",
__LINE__, 0x00699f7bL,	"699f7b", "%x",
__LINE__, 0xf9575268L,	"F9575268", "%+0X",
__LINE__, 0x04eb4783L,	"82528131", "%-ld",
__LINE__, -0x0000023L,	"-35", "%0ld",
__LINE__, -0x012b08aL,	"-1224842", "%0d",
__LINE__, 0xffffb587L,	"FFFFB587", "%X",
__LINE__, 0xffffffe9L,	"ffffffe9", "%x",
__LINE__, 0x006b5596L,	" 7034262", "% 0d",
__LINE__, 0x004d0d2aL,	"+5049642", "%+ld",
__LINE__, -0x002a099L,	"-172185", "%d",
__LINE__, 0x00000224L,	"548", "%ld",
__LINE__, 0x03e0cca8L,	"65064104", "%d",
__LINE__, -0x7bb389dL,	"-129710237", "%.3ld",
__LINE__, 0xffc630f5L,	"ffc630f5", "%-07.0x",
__LINE__, 0xfffffff8L,	"FFFFFFF8", "%X",
__LINE__, 0x0030225bL,	"3154523", "%#d",
__LINE__, 0xff7f4e28L,	"ff7f4e28", "%+4.x",
__LINE__, 0x14ee154dL,	"+351147341", "%+ld",
__LINE__, 0x00000003L,	"03", "%.2d",
__LINE__, 0xfe0359d6L,	"fe0359d6", "%x",
__LINE__, 0x002b71c3L,	"2847171", "%d",
__LINE__, 0x055c4d4aL,	"55C4D4A", "%-X",
__LINE__, 0xfffb17d2L,	"fffb17d2", "% .0x",
__LINE__, 0x00000002L,	"2", "%x",
__LINE__, 0x000018e1L,	"18E1", "%1.1X",
__LINE__, 0x00000331L,	"817", "%0d",
__LINE__, -0x0000982L,	"-2434 ", "%-06.ld",
__LINE__, -0x0000168L,	"-0000360", "%.7ld",
__LINE__, 0xffffffe9L,	"FFFFFFE9", "%-0.4X",
__LINE__, 0xe42084efL,	"E42084EF", "%X",
__LINE__, 0x000000aaL,	"aa", "%x",
__LINE__, -0xe8b98b5L,	"-244029621", "%+d",
__LINE__, -0x00000d9L,	"-217", "%+2.d",
__LINE__, 0x0000027bL,	"27B", "%+.0X",
__LINE__, 0x002e52dbL,	"3035867", "%-ld",
__LINE__, -0x00e2ba8L,	"-928680", "%0.2ld",
__LINE__, 0x003b74d8L,	"3B74D8", "%X",
__LINE__, -0x000006fL,	"-111", "%+ld",
__LINE__, 0xf8507e22L,	"0XF8507E22", "%-#X",
__LINE__, 0x0629f4c0L,	"103412928", "%-ld",
__LINE__, -0x000002dL,	"-45", "%0d",
__LINE__, -0x0001db0L,	"-7600", "%d",
__LINE__, -0x00001bbL,	" -443", "%5.ld",
__LINE__, 0xffffd2b9L,	"ffffd2b9", "%+x",
__LINE__, 0xffffe685L,	"0XFFFFE685", "%#0.7X",
__LINE__, 0x0000a4ceL,	"A4CE", "% X",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%X",
__LINE__, 0x0000000cL,	"C", "% X",
__LINE__, 0xfff59369L,	"FFF59369", "%7X",
__LINE__, 0x00000156L,	"  156", "%5.X",
__LINE__, 0x02833aa9L,	"+42154665", "%+2d",
__LINE__, 0x0004a8f3L,	"+305395", "%+d",
__LINE__, 0x01a09267L,	"1A09267", "%0.3X",
__LINE__, 0x000004f1L,	"4f1", "%x",
__LINE__, 0x00000005L,	"5", "%x",
__LINE__, 0x00000119L,	" 0281", "% #2.4ld",
__LINE__, -0x0001a2aL,	"-6698", "%ld",
__LINE__, 0xa3633a57L,	"A3633A57", "%7X",
__LINE__, -0x10bd2970L,	"-280832368", "%-d",
__LINE__, 0xffff9c38L,	"ffff9c38", "%x",
__LINE__, 0xffdbe81eL,	"ffdbe81e", "%+6.7x",
__LINE__, 0xffffffe7L,	"FFFFFFE7", "%-3.0X",
__LINE__, 0x0002f6d6L,	"2f6d6", "%5.x",
__LINE__, 0xffffffffL,	"ffffffff", "% x",
__LINE__, 0xffc2c07aL,	"ffc2c07a", "%0.x",
__LINE__, 0xfcc0e13aL,	"FCC0E13A", "%X",
__LINE__, 0x0000000dL,	"d", "% x",
__LINE__, 0x0016cac8L,	"16CAC8", "%-0.3X",
__LINE__, 0x00945dc1L,	"9723329", "%2d",
__LINE__, 0xf19a1cd1L,	"F19A1CD1", "%-X",
__LINE__, 0x00000003L,	"+3", "%+ld",
__LINE__, 0x00000773L,	"1907", "%ld",
__LINE__, 0x000263e6L,	"263e6", "%-x",
__LINE__, -0x0238b55L,	"-2329429", "%d",
__LINE__, 0x00006c56L,	"6C56", "%X",
__LINE__, 0x0000f34bL,	"62283", "%#.0ld",
__LINE__, -0x1620e21L,	"-23203361", "%0ld",
__LINE__, 0xf9257d6aL,	"f9257d6a", "%2x",
__LINE__, -0x00ed463L,	"-971875", "%03.d",
__LINE__, 0x02bb94c6L,	"45847750", "%d",
__LINE__, 0xffffd20cL,	"0XFFFFD20C", "%#X",
__LINE__, 0x000087d8L,	"34776", "%.0d",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%+7.X",
__LINE__, -0x0009cd5L,	"-40149", "%-ld",
__LINE__, 0xfffff85eL,	"FFFFF85E", "% 0.7X",
__LINE__, -0x0000006L,	"    -6", "%+#6.ld",
__LINE__, 0x007ff453L,	"0x7ff453", "%-#1.x",
__LINE__, 0xffffffe6L,	"FFFFFFE6", "%2X",
__LINE__, 0x0000001fL,	"0X1F", "%#4X",
__LINE__, -0x001c157L,	"-115031", "%.3ld",
__LINE__, 0x00096e06L,	"617990", "%3.1ld",
__LINE__, 0x0f77271dL,	"259467037", "%d",
__LINE__, -0x0001403L,	"-5123", "%d",
__LINE__, 0xffffff8aL,	"ffffff8a", "%x",
__LINE__, -0x000010fL,	"-271", "%1.ld",
__LINE__, 0xe573cc4aL,	"E573CC4A", "%0X",
__LINE__, -0x0000d88L,	"-3464", "%-d",
__LINE__, 0x0000000eL,	"14", "%#ld",
__LINE__, -0x000345bL,	"-13403", "%#d",
__LINE__, 0x00000602L,	"602", "%+x",
__LINE__, 0x00000011L,	"17", "%#d",
__LINE__, -0x0000002L,	"-2", "%+d",
__LINE__, 0x030fe6e6L,	"51373798", "%d",
__LINE__, 0x00000007L,	"007", "%.3X",
__LINE__, 0x0001abe0L,	"0X1ABE0", "%+#.4X",
__LINE__, 0xfffffdb7L,	"fffffdb7", "%-6x",
__LINE__, 0xffffff8dL,	"FFFFFF8D", "% 02.2X",
__LINE__, 0xfff12126L,	"FFF12126", "%X",
__LINE__, 0x0208e32dL,	"34136877", "%.2d",
__LINE__, 0x11c04b55L,	"297814869", "%ld",
__LINE__, 0xff1e5ca3L,	"0xff1e5ca3", "%#x",
__LINE__, 0xf9643f09L,	"f9643f09", "%x",
__LINE__, -0x003c6daL,	"-247514", "%4d",
__LINE__, 0xff69d0e7L,	"FF69D0E7", "%-X",
__LINE__, 0x00006ae9L,	"0x6ae9", "%#x",
__LINE__, -0x005aefeL,	"-372478", "%d",
__LINE__, 0x0000000dL,	"00013", "%3.5ld",
__LINE__, 0x00cc185cL,	"CC185C", "%X",
__LINE__, 0x3dd14d9fL,	"3DD14D9F", "%1.4X",
__LINE__, -0x4cc2ad3L,	"-80489171", "%1.d",
__LINE__, 0xfffff79eL,	"fffff79e", "%x",
__LINE__, 0xfffeeb03L,	"fffeeb03", "%-1x",
__LINE__, -0x0b1b15cL,	"-11645276", "%0ld",
__LINE__, -0x06b558dL,	"-7034253", "%ld",
__LINE__, 0xfffffe61L,	"fffffe61", "%x",
__LINE__, -0x0000002L,	"-2", "%d",
__LINE__, -0x0000162L,	"-000354", "%-5.6d",
__LINE__, 0x01a23780L,	"27408256", "%d",
__LINE__, 0xffff3a9bL,	"ffff3a9b", "% x",
__LINE__, 0xfffffdc7L,	"0xfffffdc7", "%#4.5x",
__LINE__, 0x00000000L,	"00", "%.2X",
__LINE__, -0x0000006L,	"-6", "%0ld",
__LINE__, -0x16072c6L,	"-23098054", "%#5ld",
__LINE__, -0x07152b8L,	"-7426744", "%01ld",
__LINE__, 0x0000d6c6L,	"0x0d6c6", "%#1.5x",
__LINE__, 0x00000f7cL,	"000f7c", "%+04.6x",
__LINE__, 0x00000bd0L,	"3024", "%4ld",
__LINE__, 0x0000295eL,	"0x295e", "%#x",
__LINE__, 0x00002e38L,	"11832", "%.5d",
__LINE__, -0xa2f5de4L,	"-170876388", "%#d",
__LINE__, -0x001aa36L,	"-109110", "%-#d",
__LINE__, 0x03012091L,	"3012091", "%+2.5X",
__LINE__, -0x00009edL,	"-002541", "%-0.6ld",
__LINE__, 0x0000001dL,	"1d", "%x",
__LINE__, 0xffffe315L,	"FFFFE315", "%+4X",
__LINE__, 0x0000716bL,	"716B", "%X",
__LINE__, 0xfffb8315L,	"0xfffb8315", "%+#x",
__LINE__, 0x00000132L,	"132    ", "%-7.3x",
__LINE__, 0x00000000L,	"+0000000", "%+1.7d",
__LINE__, 0xe16d27abL,	"E16D27AB", "%X",
__LINE__, 0xffffffe5L,	"ffffffe5", "%+x",
__LINE__, -0x000ab9dL,	"-43933", "%ld",
__LINE__, 0xffd042d6L,	"ffd042d6", "%2x",
__LINE__, 0xffffff9bL,	"ffffff9b", "%x",
__LINE__, 0x000000fbL,	"0xfb", "% #1.x",
__LINE__, 0x0000000fL,	" 15", "%#3ld",
__LINE__, 0xfffba2d8L,	"0XFFFBA2D8", "%-#0.X",
__LINE__, 0xfffffff8L,	"0XFFFFFFF8", "% #X",
__LINE__, 0x00000000L,	"    ", "%4.ld",
__LINE__, 0x00000002L,	"2", "%+x",
__LINE__, 0xfffff314L,	"FFFFF314", "%-X",
__LINE__, 0x00000000L,	" 0", "% ld",
__LINE__, -0x0000007L,	"-07", "%3.2ld",
__LINE__, 0xffffdd80L,	"FFFFDD80", "%.6X",
__LINE__, -0x000001bL,	"-27", "%-ld",
__LINE__, -0x0000258L,	"-600", "%-0d",
__LINE__, 0x00016377L,	"16377", "%3X",
__LINE__, 0x00000001L,	"1", "%X",
__LINE__, -0xac5d314L,	"-180736788", "%d",
__LINE__, -0x000036eL,	"-878", "% ld",
__LINE__, 0xfe346af4L,	"fe346af4", "%.5x",
__LINE__, 0xffffffe1L,	"ffffffe1", "%-7.6x",
__LINE__, -0x0a1df07L,	"-10608391", "%#.5d",
__LINE__, 0x000000c9L,	" 0XC9", "%+#5.X",
__LINE__, 0xfffffffeL,	"fffffffe", "%x",
__LINE__, 0xfffffff8L,	"fffffff8", "%+x",
__LINE__, -0x4517255L,	"-72446549", "%.6ld",
__LINE__, 0xfffa3670L,	"FFFA3670", "%-6X",
__LINE__, 0xffffffe0L,	"ffffffe0", "%2.x",
__LINE__, 0xffffffffL,	"ffffffff", "%0x",
__LINE__, 0x0000230dL,	"8973", "%#.1d",
__LINE__, 0x00000238L,	"238", "%0X",
__LINE__, 0xfffce5abL,	"FFFCE5AB", "%-X",
__LINE__, 0x0000002cL,	"2C", "%X",
__LINE__, 0x00000001L,	"   1", "%4.ld",
__LINE__, 0xffffff8dL,	"FFFFFF8D", "%-X",
__LINE__, 0x00069c69L,	"433257", "%06d",
__LINE__, 0xfffffb8dL,	"0xfffffb8d", "%#x",
__LINE__, 0x000d6a2dL,	"879149", "%5.5d",
__LINE__, -0x0001fcbL,	"  -8139", "%7.ld",
__LINE__, 0xfff86937L,	"fff86937", "%-0x",
__LINE__, 0x00059cf9L,	"367865", "%#.0ld",
__LINE__, 0x02c5d87aL,	"46520442", "%3.ld",
__LINE__, 0x00000571L,	"1393", "%ld",
__LINE__, 0x0003c73fL,	"+247615", "%+4ld",
__LINE__, 0x0000004fL,	"4f", "% 0x",
__LINE__, 0x00000000L,	"0", "%-ld",
__LINE__, -0x0e5850fL,	"-15041807", "% ld",
__LINE__, -0x0000002L,	"  -0002", "%7.4d",
__LINE__, 0xfffffd1bL,	"fffffd1b", "%05x",
__LINE__, 0x0000041cL,	" 1052", "% #0.ld",
__LINE__, -0x0000030L,	"-48", "%d",
__LINE__, -0x0013593L,	"-79251", "% #d",
__LINE__, 0x00000001L,	"1", "%+X",
__LINE__, 0x0000056bL,	" 56b", "%4.x",
__LINE__, -0x0000004L,	"-4 ", "%-3d",
__LINE__, -0x0000003L,	"-3", "% ld",
__LINE__, 0xffff7c14L,	"0XFFFF7C14", "%#X",
__LINE__, 0x02f63dd8L,	"49692120", "%.7ld",
__LINE__, -0x03c51c9L,	"-3953097", "%+d",
__LINE__, 0x00ded685L,	"14603909", "%5.ld",
__LINE__, 0xffffffbaL,	"ffffffba", "%x",
__LINE__, 0x000370e8L,	"225512", "%#ld",
__LINE__, 0x00000003L,	"3", "%X",
__LINE__, -0x0024a64L,	"-150116", "%7.d",
__LINE__, 0xff486ca1L,	"ff486ca1", "%x",
__LINE__, 0x000001cfL,	"1CF", "% X",
__LINE__, -0x0002d7eL,	"-11646", "%-0d",
__LINE__, 0x0a594c65L,	"a594c65", "%.4x",
__LINE__, -0x0000002L,	"-0002", "%-5.4ld",
__LINE__, 0x00000000L,	"", "%00.ld",
__LINE__, 0x00058bc4L,	"58BC4", "%3X",
__LINE__, 0x0002cf8eL,	" 184206", "% 0ld",
__LINE__, 0x000009c7L,	"+2503", "%+4.ld",
__LINE__, 0xed0c984dL,	"ED0C984D", "%X",
__LINE__, -0x0000058L,	"-088", "%#.3ld",
__LINE__, 0x0076083dL,	"0X76083D", "%#6X",
__LINE__, -0x0000001L,	"-1", "%#d",
__LINE__, -0x6bf1777L,	"-113186679", "%#ld",
__LINE__, -0x000011fL,	"-287", "%ld",
__LINE__, 0x001b0e7dL,	"1B0E7D", "%-4X",
__LINE__, 0x000007acL,	" 1964", "%5.ld",
__LINE__, 0x00000005L,	"5", "%0.d",
__LINE__, -0x00003baL,	"-954", "%4.0ld",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%X",
__LINE__, 0x00000019L,	"19", "%x",
__LINE__, 0xffffffe0L,	"ffffffe0", "%-.6x",
__LINE__, 0x0000012aL,	" 298", "% d",
__LINE__, 0x00002c74L,	"2c74", "% 4.3x",
__LINE__, 0x000002d5L,	"725", "%d",
__LINE__, 0x0001c9a9L,	"1c9a9", "%-02x",
__LINE__, 0xffc928c8L,	"ffc928c8", "%x",
__LINE__, -0x03ae51fL,	"-3859743", "% #ld",
__LINE__, 0x0000526dL,	"526d", "%x",
__LINE__, -0x00028f0L,	"-10480", "%5ld",
__LINE__, -0x49b4262L,	"-77283938", "%+02.0d",
__LINE__, 0x028d37f0L,	"0x28d37f0", "%+#x",
__LINE__, 0xd66e0af9L,	"D66E0AF9", "%03.X",
__LINE__, -0x00c7707L,	"-816903", "%0d",
__LINE__, -0x00000d0L,	"-208", "%-.1ld",
__LINE__, 0x0000c328L,	"49960", "%d",
__LINE__, 0x34cb86f1L,	"34CB86F1", "%X",
__LINE__, 0x000000f6L,	"F6", "%+X",
__LINE__, 0x0a3407ecL,	"0xa3407ec", "%-#x",
__LINE__, 0x00007ebcL,	"32444", "%#3.d",
__LINE__, 0xfffd3d65L,	"fffd3d65", "%x",
__LINE__, 0x0007bc82L,	"0507010", "%0.7d",
__LINE__, 0x0005bb93L,	"375699", "%ld",
__LINE__, 0x0ec11cc8L,	"0XEC11CC8", "%+#6.2X",
__LINE__, 0xfffff9c6L,	"fffff9c6", "%.5x",
__LINE__, 0xff05ab70L,	"0XFF05AB70", "%-#.3X",
__LINE__, 0x2328b716L,	"589870870", "%d",
__LINE__, 0x00001a79L,	"6777", "%.1d",
__LINE__, 0xfffee573L,	"fffee573", "%0.1x",
__LINE__, -0x0000929L,	"  -2345", "%7.d",
__LINE__, 0xffffff9aL,	"FFFFFF9A", "%2.X",
__LINE__, 0xfffffe60L,	"fffffe60", "%.5x",
__LINE__, 0xfffffcd2L,	"fffffcd2", "%.7x",
__LINE__, 0x00000001L,	"   001", "%6.3X",
__LINE__, 0x00011e9cL,	"+73372", "%+0ld",
__LINE__, 0x0000002aL,	"2a", "% x",
__LINE__, 0xffffffffL,	"ffffffff", "%.7x",
__LINE__, -0x0008ee8L,	"-36584", "%ld",
__LINE__, 0x0000001cL,	"28", "%-d",
__LINE__, 0x000abedaL,	"704218", "%d",
__LINE__, 0x001347f7L,	"1347f7", "%3.0x",
__LINE__, 0x0000023eL,	"574", "%3.3ld",
__LINE__, 0x00000000L,	"0", "%-ld",
__LINE__, -0x0016de0L,	"-93664", "%0ld",
__LINE__, 0xffffff45L,	"FFFFFF45", "% X",
__LINE__, 0x02dfb08cL,	"48214156", "%#ld",
__LINE__, 0x003d73a2L,	"3d73a2", "%6.x",
__LINE__, 0x00147da7L,	"1342887", "%#d",
__LINE__, -0x5ff0f1eL,	"-100601630", "%-01ld",
__LINE__, -0x000000bL,	"-11", "%ld",
__LINE__, 0x00000168L,	"   168", "%+6.x",
__LINE__, 0xffffc28eL,	"ffffc28e", "%0x",
__LINE__, -0x00003a2L,	"-930", "%ld",
__LINE__, 0x0002e56fL,	" 189807", "% 1.ld",
__LINE__, 0x51abf44fL,	"0x51abf44f", "%#.7x",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, 0x9581268fL,	"9581268F", "%+X",
__LINE__, 0xffffff3bL,	"FFFFFF3B", "%X",
__LINE__, 0x000083d4L,	" 33748", "% #d",
__LINE__, 0x00000001L,	"1", "%x",
__LINE__, -0x000e51fL,	"-58655", "%.0ld",
__LINE__, 0x0003eacbL,	"256715", "%6ld",
__LINE__, 0x02be09dbL,	" 46008795", "% 0.ld",
__LINE__, 0xfffffffbL,	"FFFFFFFB", "% X",
__LINE__, 0x000084f5L,	" 34037", "%6ld",
__LINE__, -0x1127f99L,	"-17989529", "%#d",
__LINE__, 0x5f6512deL,	"5f6512de", "%.7x",
__LINE__, 0x00000001L,	"1", "%x",
__LINE__, 0xfff74ab5L,	"fff74ab5", "%x",
__LINE__, 0x0eebeb94L,	"250342292", "%4.ld",
__LINE__, 0x0001b846L,	"0x1b846", "%#1x",
__LINE__, 0x001e8c32L,	"1E8C32", "%2X",
__LINE__, -0x0dae932L,	"-14346546", "%5.1d",
__LINE__, 0x00000001L,	"1", "%ld",
__LINE__, -0x0000042L,	"-66", "%ld",
__LINE__, 0xffffff51L,	"FFFFFF51", "%0.1X",
__LINE__, 0x00000043L,	"43", "%x",
__LINE__, 0x04c21f39L,	" 79830841", "% 0ld",
__LINE__, 0x0000061eL,	"1566", "%03.3d",
__LINE__, -0x0000003L,	"-3", "%+d",
__LINE__, 0x015b32dbL,	" 22754011", "% .4d",
__LINE__, 0xfffff181L,	"FFFFF181", "%-X",
__LINE__, 0x000017ecL,	"0X17EC", "%#X",
__LINE__, 0x000d703eL,	"880702", "%#ld",
__LINE__, -0x6d7533a0L,	"-1836397472", "%ld",
__LINE__, 0x0000008aL,	" 138", "% d",
__LINE__, -0x7368794bL,	"-1936226635", "%+#d",
__LINE__, 0x0000000dL,	"0XD", "%#X",
__LINE__, 0x0000030dL,	"30D", "% X",
__LINE__, 0xfffff9feL,	"FFFFF9FE", "%5X",
__LINE__, 0x00001bb2L,	"7090", "%d",
__LINE__, 0x041d2a0cL,	"41D2A0C", "%0X",
__LINE__, 0x00012aeeL,	" 76526", "% d",
__LINE__, 0x0000055fL,	"55f", "%.1x",
__LINE__, 0xffffffffL,	"0XFFFFFFFF", "%#1X",
__LINE__, 0x07b0a971L,	"+129018225", "%+.2ld",
__LINE__, 0xfffffff8L,	"FFFFFFF8", "%4X",
__LINE__, 0x00000001L,	"1", "%d",
__LINE__, 0x00000038L,	"+56", "%+2ld",
__LINE__, 0xfffffc2fL,	"fffffc2f", "%+7.x",
__LINE__, 0x00004477L,	"0x4477", "% #x",
__LINE__, 0x0000000dL,	"0XD", "%+#3X",
__LINE__, 0xf5bf37b1L,	"F5BF37B1", "%1.X",
__LINE__, 0x1a96f431L,	"446100529", "%d",
__LINE__, 0x0037edf3L,	"+3665395", "%+#4.5ld",
__LINE__, 0x0007f2aaL,	"520874", "%0ld",
__LINE__, -0x00051a3L,	"-20899", "%+#1.ld",
__LINE__, 0x0000037fL,	"37F", "%0X",
__LINE__, 0xffffffb4L,	"ffffffb4", "%x",
__LINE__, -0xd984c00L,	"-228084736", "%+06ld",
__LINE__, 0xffffe1beL,	"FFFFE1BE", "%X",
__LINE__, 0xfff20d48L,	"FFF20D48", "%+6.0X",
__LINE__, 0x000028b7L,	"0x028b7", "%-#7.5x",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, 0x03f37945L,	"66287941", "%d",
__LINE__, 0xffffffedL,	"0XFFFFFFED", "%+#6.4X",
__LINE__, 0x0000f046L,	"f046", "%x",
__LINE__, 0xe9772b51L,	"E9772B51", "%-1.X",
__LINE__, 0xfffffffeL,	"fffffffe", "% x",
__LINE__, 0xfffffffaL,	"0xfffffffa", "%#x",
__LINE__, 0x00000015L,	"15", "%-X",
__LINE__, 0x0000003cL,	"60", "%#ld",
__LINE__, 0x3103952dL,	"822318381", "%0.ld",
__LINE__, 0x17ba68bbL,	"398092475", "%2d",
__LINE__, 0x000006c4L,	"+1732", "%+.2d",
__LINE__, 0x00000043L,	"67", "%#d",
__LINE__, 0x0043fb55L,	"4455253", "%.1ld",
__LINE__, 0x00004b76L,	"4b76", "% 0x",
__LINE__, 0xfff4c56bL,	"FFF4C56B", "%7X",
__LINE__, 0x00766055L,	"766055", "%+5x",
__LINE__, -0x000009fL,	"-159", "%+d",
__LINE__, 0xffff063fL,	"ffff063f", "%-2x",
__LINE__, 0x00808fc8L,	"808fc8", "%x",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, 0x000000f1L,	"00000f1", "%+02.7x",
__LINE__, 0x00000002L,	"2", "%X",
__LINE__, 0x00000000L,	"000", "%03d",
__LINE__, 0xe63f73b2L,	"E63F73B2", "% 1X",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%5.1X",
__LINE__, 0x0d3fa38bL,	"222274443", "%1d",
__LINE__, 0x00000000L,	"0", "% X",
__LINE__, 0x00000001L,	"   1", "%04.ld",
__LINE__, 0x00000046L,	"46", "%0X",
__LINE__, 0x0000761fL,	" 30239", "% ld",
__LINE__, -0x0002517L,	"-9495", "%+d",
__LINE__, 0x00000156L,	"156", "% 0x",
__LINE__, 0x1c55eba2L,	"1c55eba2", "%.6x",
__LINE__, 0x005af80dL,	"5af80d", "%.6x",
__LINE__, 0x0000002eL,	"46", "%d",
__LINE__, -0x0007c0fL,	"-31759", "%ld",
__LINE__, 0xffffe924L,	"FFFFE924", "%7X",
__LINE__, 0x00000174L,	"372", "%ld",
__LINE__, 0xffffffc9L,	"0xffffffc9", "%-#x",
__LINE__, 0x00000020L,	"+000032", "%+07d",
__LINE__, 0xffffe5d9L,	"FFFFE5D9", "%4.5X",
__LINE__, 0xffffffa3L,	"FFFFFFA3", "%+.3X",
__LINE__, 0x00000a03L,	"+2563", "%+2d",
__LINE__, 0x001b58caL,	"+1792202", "%+4d",
__LINE__, 0xffffffc9L,	"0xffffffc9", "%+#5x",
__LINE__, -0x0000003L,	"-3", "% d",
__LINE__, 0xfffffffcL,	"fffffffc", "%+0x",
__LINE__, -0x0000002L,	"-02", "%.2d",
__LINE__, 0x000243fbL,	"148475", "%-ld",
__LINE__, 0x00000001L,	"1", "%0d",
__LINE__, -0x0000672L,	"-1650", "%ld",
__LINE__, -0x0005413L,	"-0021523", "% 7.7d",
__LINE__, 0x00000017L,	"0X17", "%#X",
__LINE__, 0x00000e48L,	"3656", "%0d",
__LINE__, 0xffe79b38L,	"ffe79b38", "%-x",
__LINE__, 0xffffff15L,	"FFFFFF15", "%+6.1X",
__LINE__, 0xfff0272cL,	"fff0272c", "%-.5x",
__LINE__, -0x00b706fL,	"-749679", "%1.ld",
__LINE__, 0x0176aeecL,	"176AEEC", "%.1X",
__LINE__, -0x00005a1L,	"-1441", "% 0ld",
__LINE__, -0x0000002L,	"-00002", "%.5d",
__LINE__, -0xd2e6f5dL,	"-221146973", "%1ld",
__LINE__, -0x0000001L,	" -001", "%5.3ld",
__LINE__, 0x00000001L,	"    1", "%05.ld",
__LINE__, 0x0000749eL,	"+29854", "%+#d",
__LINE__, 0x00000005L,	"5", "%d",
__LINE__, 0xfa7128b0L,	"fa7128b0", "%1.x",
__LINE__, 0xffffbbb4L,	"0XFFFFBBB4", "%#.1X",
__LINE__, 0x0006862fL,	"427567", "%d",
__LINE__, 0x00000002L,	"2", "%X",
__LINE__, 0x000005d4L,	"5d4", "% x",
__LINE__, 0x001387e1L,	"1279969", "%-05.0ld",
__LINE__, -0x0035a56L,	"-219734", "%ld",
__LINE__, -0x4064ecc6L,	"-1080356038", "%ld",
__LINE__, 0x0000360dL,	"13837", "%0ld",
__LINE__, -0xea1a85bL,	"-245475419", "%-.2ld",
__LINE__, 0xffffff2dL,	"FFFFFF2D", "%X",
__LINE__, 0x00000004L,	"   0004", "%7.4x",
__LINE__, 0x00f72ffdL,	"F72FFD", "%-X",
__LINE__, 0x00000fa2L,	"fa2  ", "%-5x",
__LINE__, 0x05ae1f9aL,	"95297434", "%#ld",
__LINE__, 0x0000bf2eL,	"48942", "%3.d",
__LINE__, 0x00000000L,	" ", "%1.X",
__LINE__, 0x01bcb097L,	"29143191", "%ld",
__LINE__, 0x0000009cL,	"156 ", "%-4.0d",
__LINE__, 0xfffffffeL,	"fffffffe", "% x",
__LINE__, 0x00000001L,	"1     ", "%-6.d",
__LINE__, 0xffffffefL,	"ffffffef", "%7.x",
__LINE__, 0xfffffec1L,	"fffffec1", "%.5x",
__LINE__, -0x000000fL,	"-15", "%-1d",
__LINE__, -0x0008426L,	"-33830", "%0ld",
__LINE__, 0x005be0aeL,	"5BE0AE", "% X",
__LINE__, 0x00000009L,	"      9", "%+7X",
__LINE__, -0x0007e18L,	"-32280", "%+0.d",
__LINE__, 0x01697ba1L,	" 23690145", "% 5.ld",
__LINE__, -0x0012042L,	"-073794", "%7.6d",
__LINE__, 0x04e9bd0dL,	"4e9bd0d", "%-2x",
__LINE__, 0xffffffd9L,	"FFFFFFD9", "%.2X",
__LINE__, -0x01b9632L,	"-1807922", "%.6ld",
__LINE__, 0x000000cdL,	"205", "%1.ld",
__LINE__, 0x00000000L,	" ", "% .0d",
__LINE__, 0xff17bbb1L,	"ff17bbb1", "%x",
__LINE__, -0x00146d7L,	"-83671", "%+1.ld",
__LINE__, 0xfffff144L,	"fffff144", "%x",
__LINE__, 0x000f8dbeL,	"F8DBE", "%3.X",
__LINE__, -0x000381cL,	"-14364", "%d",
__LINE__, 0x0000001eL,	"  30", "%4.1d",
__LINE__, 0x00000016L,	"22", "%-0d",
__LINE__, 0x00000002L,	"+02", "%+1.2ld",
__LINE__, 0x0000e803L,	"59395", "%d",
__LINE__, 0xb4c2448dL,	"b4c2448d", "%-7x",
__LINE__, 0x000e697dL,	"944509", "%ld",
__LINE__, 0xfffe6e32L,	"0XFFFE6E32", "%#X",
__LINE__, 0x00000190L,	"  190", "%+5.X",
__LINE__, -0x03a2219L,	"-3809817", "%#6.ld",
__LINE__, -0x000003cL,	"-60 ", "%-#4.ld",
__LINE__, 0x00000000L,	"   ", "% 03.ld",
__LINE__, -0x074f922L,	"-7665954", "%ld",
__LINE__, -0x00000f0L,	"-240", "%-ld",
__LINE__, 0xfffe42d2L,	"0XFFFE42D2", "%#X",
__LINE__, 0x000000ddL,	"DD", "%X",
__LINE__, 0x00359abeL,	"359ABE", "%.1X",
__LINE__, 0xffec7bdfL,	"FFEC7BDF", "%0.1X",
__LINE__, 0x0ecddcbaL,	"248372410", "%-#3.d",
__LINE__, 0x00ad0dbcL,	"11341244", "%ld",
__LINE__, -0x0000001L,	"-1", "%-d",
__LINE__, 0x00050841L,	"50841", "% .5x",
__LINE__, 0x01d359e7L,	"1d359e7", "%1.x",
__LINE__, 0xff9efaa3L,	"FF9EFAA3", "%X",
__LINE__, 0x0007ea10L,	"+518672", "%+ld",
__LINE__, -0x000671cL,	"-26396", "%1d",
__LINE__, 0xffffff91L,	"0xffffff91", "%#4.4x",
__LINE__, 0x00000000L,	"+", "%+0.0ld",
__LINE__, -0x002c53eL,	"-181566", "%3.d",
__LINE__, 0xffffff56L,	"ffffff56", "%x",
__LINE__, 0xfffff589L,	"FFFFF589", "%+X",
__LINE__, 0x00024d13L,	"24D13", "%-5.2X",
__LINE__, 0x00000000L,	"     0", "%6.1d",
__LINE__, 0x00a64f33L,	"A64F33", "%4.4X",
__LINE__, 0xffebb57aL,	"FFEBB57A", "%5.4X",
__LINE__, 0xfff3b4a0L,	"fff3b4a0", "%2.x",
__LINE__, 0xffffffd9L,	"FFFFFFD9", "%.2X",
__LINE__, 0x00d37b84L,	"13859716", "%d",
__LINE__, 0x00001e85L,	"0001E85", "%0.7X",
__LINE__, -0x756148fL,	"-123081871", "% 7.d",
__LINE__, -0x0319339L,	"-3248953", "%+#.4d",
__LINE__, -0x00798b8L,	"-497848", "%#5ld",
__LINE__, -0x0000039L,	"-57", "%0d",
__LINE__, -0x000b1d7L,	"-45527", "%+0.ld",
__LINE__, 0xff811fbaL,	"FF811FBA", "%+X",
__LINE__, 0x00000042L,	" 66", "% ld",
__LINE__, 0xfffffe31L,	"0XFFFFFE31", "%#X",
__LINE__, 0x00000073L,	"115", "%ld",
__LINE__, 0x45091a39L,	"0x45091a39", "%+#3.x",
__LINE__, 0x001270f5L,	"1270f5", "%-5.6x",
__LINE__, 0xfffd91fdL,	"fffd91fd", "%x",
__LINE__, -0x0817badL,	"-8485805", "%#ld",
__LINE__, -0x32ad55fL,	"-53138783", "%0d",
__LINE__, 0x00003e57L,	"15959", "%0ld",
__LINE__, -0x0048756L,	"-296790", "%2.6d",
__LINE__, 0xff90f45fL,	"FF90F45F", "% X",
__LINE__, 0x0000e454L,	"0e454", "% .5x",
__LINE__, 0xfffffffcL,	"fffffffc", "%x",
__LINE__, 0xfffffff7L,	"FFFFFFF7", "%-2X",
__LINE__, 0xffdabf0eL,	"FFDABF0E", "%+X",
__LINE__, 0xffffffffL,	"0XFFFFFFFF", "%#1X",
__LINE__, 0x01516650L,	"1516650", "% x",
__LINE__, 0xffffff51L,	"FFFFFF51", "%X",
__LINE__, 0x000000eaL,	"234", "%00.d",
__LINE__, 0x06db60caL,	"115040458", "%5.d",
__LINE__, 0x00000f01L,	" 3841", "% d",
__LINE__, 0x00000009L,	"9", "%x",
__LINE__, 0x299b3ba0L,	"299b3ba0", "%6.7x",
__LINE__, 0x0067f298L,	"67f298", "%-2.6x",
__LINE__, 0xfffffff5L,	"FFFFFFF5", "% 2X",
__LINE__, 0x00102ff9L,	"102FF9", "%-.0X",
__LINE__, 0xffc22393L,	"0xffc22393", "% #6x",
__LINE__, 0x00007db5L,	"32181", "%-2ld",
__LINE__, 0x0000b0a3L,	"0xb0a3", "%#0x",
__LINE__, 0x001ceebbL,	"1CEEBB", "%-3.4X",
__LINE__, 0x00025101L,	"0x25101", "%#x",
__LINE__, -0x0000001L,	"-1", "%0ld",
__LINE__, 0xffffd846L,	"FFFFD846", "%+2.3X",
__LINE__, 0x00001d79L,	" 7545", "% 0.1ld",
__LINE__, -0x0000002L,	"   -2", "%5d",
__LINE__, 0xf93b9fdcL,	"f93b9fdc", "%5x",
__LINE__, 0xffff0021L,	"FFFF0021", "%6X",
__LINE__, 0x00007cf9L,	"7cf9", "%3.1x",
__LINE__, -0x0000002L,	"-2", "%d",
__LINE__, 0x00001d84L,	"1d84", "%0x",
__LINE__, -0x033201eL,	"-3350558", "%-2.0d",
__LINE__, 0xfff8a6fbL,	"FFF8A6FB", "%+.7X",
__LINE__, 0x00006fffL,	" 28671", "% ld",
__LINE__, -0x02a274aL,	"-2762570", "%d",
__LINE__, -0x0006628L,	"-26152", "%00ld",
__LINE__, 0x00000011L,	"11", "%-x",
__LINE__, -0x0000ed9L,	"-3801", "%0.ld",
__LINE__, 0xfc5b725dL,	"FC5B725D", "%X",
__LINE__, 0x3530bd4eL,	"892386638", "%7.d",
__LINE__, 0x03bb4ff7L,	"62607351", "%#4.7ld",
__LINE__, 0x00009f86L,	"9f86", "%x",
__LINE__, 0x0000e727L,	"59175", "%1d",
__LINE__, 0xfffffdf2L,	"0XFFFFFDF2", "%#X",
__LINE__, 0x00e60dbfL,	"0XE60DBF", "% #1.X",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%+X",
__LINE__, 0x0a16f44eL,	"0XA16F44E", "%#.0X",
__LINE__, 0x0001f97cL,	"1f97c", "% x",
__LINE__, 0x0000000dL,	"13", "%#0ld",
__LINE__, 0x0000002aL,	"42", "%0ld",
__LINE__, 0x00000007L,	"   +7", "%+5ld",
__LINE__, 0xffffff7fL,	"FFFFFF7F", "%-X",
__LINE__, 0x000006a6L,	"1702", "%ld",
__LINE__, 0xfaff2fb1L,	"faff2fb1", "% x",
__LINE__, 0xffff94abL,	"ffff94ab", "%x",
__LINE__, 0x011d611bL,	"0X11D611B", "%#2.3X",
__LINE__, 0x00000000L,	" +000", "%+#5.3ld",
__LINE__, -0x87fcc37L,	"-142593079", "%+d",
__LINE__, -0x0417424L,	"-4289572", "%+d",
__LINE__, 0x03fabc0cL,	"3fabc0c", "%x",
__LINE__, 0xfffff880L,	"fffff880", "%-x",
__LINE__, 0x000002d7L,	"2d7", "%-02.x",
__LINE__, 0x00003e82L,	"16002", "%#d",
__LINE__, -0x0003713L,	"-14099", "% 5d",
__LINE__, -0x0000027L,	"-39", "%ld",
__LINE__, 0x00013098L,	"0077976", "%01.7d",
__LINE__, -0x000000cL,	"-12", "%ld",
__LINE__, -0x00000c0L,	"-192", "% ld",
__LINE__, 0xffbe9285L,	"FFBE9285", "%3.X",
__LINE__, 0x00000046L,	"46", "%x",
__LINE__, 0x00000000L,	"    ", "%+4.x",
__LINE__, 0x00011e72L,	"73330", "%2.3d",
__LINE__, -0x5276dd7L,	"-86470103", "%d",
__LINE__, 0x00000013L,	"19", "%-02.ld",
__LINE__, 0x384118a7L,	"0X384118A7", "%-#X",
__LINE__, 0x00000000L,	"0", "% #X",
__LINE__, 0x00000009L,	"9", "%#ld",
__LINE__, 0x00021145L,	"135493", "%-ld",
__LINE__, 0xff188a0cL,	"FF188A0C", "%1.X",
__LINE__, 0xffffffd5L,	"ffffffd5", "%0x",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "% 0X",
__LINE__, 0xffff74a3L,	"ffff74a3", "%x",
__LINE__, 0x01d5a2f8L,	"1d5a2f8", "%-0.x",
__LINE__, 0xfffffef6L,	"fffffef6", "%+06.x",
__LINE__, 0x00000001L,	"1", "%ld",
__LINE__, 0x00000000L,	"+0", "%+ld",
__LINE__, 0xfffffffcL,	"fffffffc", "%4.x",
__LINE__, -0x0000344L,	"-0836", "% .4d",
__LINE__, 0xfffffffdL,	"FFFFFFFD", "%0X",
__LINE__, 0x000a3121L,	"667937", "%#4.4ld",
__LINE__, 0x0001e211L,	"0X1E211", "%#X",
__LINE__, 0x00000c8bL,	"00C8B", "%05X",
__LINE__, 0xfffffffeL,	"fffffffe", "%+0x",
__LINE__, 0x001a53ceL,	"1725390", "%d",
__LINE__, 0x0000057fL,	"57f    ", "%-7.x",
__LINE__, -0x0073e4dL,	"-474701", "%#ld",
__LINE__, -0x0000002L,	" -2", "% 3.d",
__LINE__, 0x482dc404L,	"482DC404", "%X",
__LINE__, 0x0000011cL,	"11c", "%-.1x",
__LINE__, 0x00000c12L,	" 3090", "%5.3ld",
__LINE__, 0xfffe1068L,	"FFFE1068", "%-.4X",
__LINE__, -0x0055e88L,	"-351880", "%ld",
__LINE__, 0x000c9cefL,	"+826607", "%+d",
__LINE__, 0xffffffe3L,	"ffffffe3", "%0x",
__LINE__, -0x0000ee9L,	"-3817", "%#ld",
__LINE__, 0xff1f6daaL,	"FF1F6DAA", "%X",
__LINE__, 0xfffffc4eL,	"FFFFFC4E", "%5.2X",
__LINE__, -0x000040aL,	"-1034", "%d",
__LINE__, -0x0000085L,	"-00133", "% 01.5d",
__LINE__, -0x126c797cL,	"-309098876", "%5.ld",
__LINE__, 0x00000039L,	" 57", "% d",
__LINE__, 0xfffffff6L,	"0xfffffff6", "%#5.x",
__LINE__, 0xfffffff4L,	"fffffff4", "%7.6x",
__LINE__, 0x00000003L,	"3", "%ld",
__LINE__, 0x0000f8aeL,	"f8ae", "%.0x",
__LINE__, 0x003ca1cfL,	"3973583", "%#3.7d",
__LINE__, 0x14687009L,	"0x14687009", "%+#3x",
__LINE__, 0xfffff1f7L,	"0xfffff1f7", "%#4.5x",
__LINE__, 0xfffff17aL,	"fffff17a", "%3.x",
__LINE__, 0x0011ea18L,	"1174040", "%ld",
__LINE__, -0x0000019L,	"-25", "%03.d",
__LINE__, 0x00015d72L,	"0X15D72", "%-#X",
__LINE__, 0xffde4a41L,	"ffde4a41", "%x",
__LINE__, 0x00006f1fL,	"28447", "%d",
__LINE__, 0xffffffbdL,	"0xffffffbd", "%#.1x",
__LINE__, 0x000013b9L,	"13B9", "%0X",
__LINE__, -0x00001b9L,	"-00441", "%1.5d",
__LINE__, 0x00000001L,	"000001", "%-.6d",
__LINE__, 0x7b602d8fL,	"+2069900687", "%+0ld",
__LINE__, 0x0005e323L,	"+385827", "%+ld",
__LINE__, 0x00002fceL,	"2FCE", "%+0X",
__LINE__, 0x0000000eL,	"0014", "%.4d",
__LINE__, 0xffffffd6L,	"0XFFFFFFD6", "%#4.X",
__LINE__, 0x037bf361L,	"58454881", "%5.ld",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%-7.5X",
__LINE__, -0x016d4dcL,	"-1496284", "%6ld",
__LINE__, 0x0005be9aL,	"0x5be9a", "%-#.5x",
__LINE__, 0xffffffffL,	"ffffffff", "%1x",
__LINE__, 0x00000055L,	"     85", "% 7.d",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, -0x0135392L,	"-1266578", "% ld",
__LINE__, 0x00850f26L,	"8720166", "%d",
__LINE__, 0xffffee39L,	"ffffee39", "%0x",
__LINE__, 0x000000ddL,	"221", "%ld",
__LINE__, 0x00000000L,	"      ", "%6.d",
__LINE__, 0x000000d8L,	"d8", "%x",
__LINE__, 0x000007ecL,	"002028", "%4.6ld",
__LINE__, 0x0dab4e67L,	"0XDAB4E67", "%#X",
__LINE__, 0xfffd7c95L,	"FFFD7C95", "% 4X",
__LINE__, 0x0009302dL,	"9302D", "%3.1X",
__LINE__, 0x00000003L,	" 3", "% d",
__LINE__, 0x0000082fL,	"82f", "%-x",
__LINE__, 0x0652517fL,	"652517F", "%-.2X",
__LINE__, -0x1fd8f4e3L,	"-534312163", "%d",
__LINE__, 0x00000176L,	"176", "%-x",
__LINE__, 0x00000001L,	"1", "%ld",
__LINE__, 0x0000001aL,	"1A", "%X",
__LINE__, -0x0005740L,	"-22336", "% 0ld",
__LINE__, 0xffffffffL,	"ffffffff", "%6x",
__LINE__, 0x1b273b80L,	"0x1b273b80", "%#x",
__LINE__, 0x00000065L,	"65", "%X",
__LINE__, 0x6a62138aL,	"1784812426", "%2ld",
__LINE__, 0x000001a2L,	"1A2", "%X",
__LINE__, -0x002aafdL,	"-174845", "%02.ld",
__LINE__, 0x00000014L,	"20", "%d",
__LINE__, -0x00000c7L,	"   -199", "%7.0ld",
__LINE__, 0xff545bfdL,	"ff545bfd", "%-x",
__LINE__, -0x002beb9L,	"-179897", "%02.2ld",
__LINE__, -0x00000dfL,	"-223", "% 02.d",
__LINE__, -0x000d569L,	"-54633", "%1.ld",
__LINE__, 0x0000000eL,	"14", "%d",
__LINE__, -0x0077407L,	"-488455", "% ld",
__LINE__, 0x0001be09L,	"114185", "%ld",
__LINE__, -0x0000514L,	"-01300", "%+05.5d",
__LINE__, 0xf1fb397fL,	"f1fb397f", "%+x",
__LINE__, 0xfdb6707cL,	"FDB6707C", "%X",
__LINE__, 0x03cad111L,	"3cad111", "%5.x",
__LINE__, -0x022e72fL,	"-2287407", "%d",
__LINE__, -0xda35f48L,	"-228810568", "%d",
__LINE__, -0x02d1fd4L,	"-2957268", "%1.3d",
__LINE__, 0x0000005fL,	"+95", "%+2d",
__LINE__, 0xfffbf8a1L,	"FFFBF8A1", "%4.2X",
__LINE__, 0x0000071eL,	"   71e", "%6.x",
__LINE__, 0x000cc8a5L,	"+837797", "%+03ld",
__LINE__, 0x000eebe9L,	" EEBE9", "%6.X",
__LINE__, -0x2896b204L,	"-680964612", "%d",
__LINE__, -0x09553f8L,	"-9786360", "%d",
__LINE__, 0x000015d3L,	"5587", "%0d",
__LINE__, 0x0000056dL,	" 56d", "%+4.x",
__LINE__, -0x00624adL,	"-402605", "% ld",
__LINE__, 0xfea64ba5L,	"0xfea64ba5", "%#1x",
__LINE__, 0x004f35c6L,	"5191110", "%-ld",
__LINE__, -0x1441fe4L,	"-21241828", "%d",
__LINE__, 0xffffff95L,	"FFFFFF95", "%X",
__LINE__, 0xfffecf81L,	"FFFECF81", "%-2.X",
__LINE__, -0x00002bbL,	"-699", "%-d",
__LINE__, -0x0000c29L,	"-3113", "% 02ld",
__LINE__, 0x000026a3L,	" 9891", "% .4d",
__LINE__, 0x00000003L,	"3", "%-x",
__LINE__, 0x000007dbL,	"+02011", "%+.5ld",
__LINE__, 0xfff99558L,	"FFF99558", "%.1X",
__LINE__, 0x0000fce6L,	"64742", "%4.0d",
__LINE__, 0x000b7ea2L,	"753314", "%ld",
__LINE__, 0x13e5df30L,	"0X13E5DF30", "%#2.X",
__LINE__, 0x006761c4L,	"06761C4", "%6.7X",
__LINE__, 0xffffff78L,	"FFFFFF78", "%0.X",
__LINE__, 0xfffff1c0L,	"0xfffff1c0", "% #x",
__LINE__, -0x034af1cL,	"-3452700", "% 06.1d",
__LINE__, 0x000000deL,	"0000222", "%2.7ld",
__LINE__, 0x000003d8L,	"0x3d8", "%#4.x",
__LINE__, -0x001a1d1L,	"-106961", "%3.1d",
__LINE__, -0x0000002L,	"-2", "% d",
__LINE__, 0x00001de6L,	"+7654", "%+0ld",
__LINE__, 0x00000001L,	"001", "%#.3d",
__LINE__, -0x53dacf9fL,	"-1406848927", "%ld",
__LINE__, 0xfffffffcL,	"fffffffc", "%3.3x",
__LINE__, -0x00950e8L,	"-610536", "%3.6ld",
__LINE__, 0xff14ade9L,	"FF14ADE9", "%6X",
__LINE__, 0x012f5284L,	"0X12F5284", "% #5X",
__LINE__, 0x00005a21L,	" 5a21", "%5x",
__LINE__, 0x00000638L,	"1592", "%2.4ld",
__LINE__, -0x063017bL,	"-6488443", "%ld",
__LINE__, 0x00000000L,	"0", "% X",
__LINE__, 0xfffe8ef2L,	"FFFE8EF2", "%+0X",
__LINE__, -0x0001c96L,	"-7318", "%.3d",
__LINE__, 0x0000ca7dL,	"51837", "%ld",
__LINE__, 0x00000001L,	"1", "%+1x",
__LINE__, 0xfffff7bcL,	"FFFFF7BC", "%X",
__LINE__, -0x03d15e2L,	"-4003298", "%ld",
__LINE__, 0xfffffffeL,	"fffffffe", "% x",
__LINE__, 0x00066183L,	"+418179", "%+7.1ld",
__LINE__, 0xffffef2eL,	"ffffef2e", "%-2.x",
__LINE__, 0x00000000L,	" 000", "%04.3x",
__LINE__, -0x000000fL,	"-15", "% d",
__LINE__, -0x00001f5L,	"-501", "%d",
__LINE__, 0x0c67f159L,	"c67f159", "%6.2x",
__LINE__, -0x0000006L,	"-6", "%.1d",
__LINE__, 0x00000005L,	"0X5", "%+#1X",
__LINE__, -0x0000002L,	"    -2", "%6.ld",
__LINE__, 0xeb2183ecL,	"eb2183ec", "% x",
__LINE__, -0x5e12a322L,	"-1578279714", "%d",
__LINE__, 0x00000001L,	"0x1", "%#x",
__LINE__, -0x0001ea4L,	"-7844", "%0d",
__LINE__, -0x19955a3L,	"-26826147", "%d",
__LINE__, 0x000002a6L,	"2A6", "%2.X",
__LINE__, 0x00000002L,	"2", "%X",
__LINE__, 0xfffffeecL,	"fffffeec", "%0.4x",
__LINE__, 0xfffffffcL,	"fffffffc", "%0x",
__LINE__, 0xffdfe740L,	"FFDFE740", "% X",
__LINE__, -0x0b0b3e7L,	"-11580391", "%.1d",
__LINE__, 0x8e01077cL,	"8E01077C", "%5.7X",
__LINE__, 0x3b6b6d55L,	"996896085", "%1.1d",
__LINE__, 0x000016afL,	"5807", "%ld",
__LINE__, -0x0004900L,	"-18688", "%d",
__LINE__, 0xfffd77bcL,	"FFFD77BC", "%X",
__LINE__, 0x004cbd74L,	"5029236", "%0d",
__LINE__, 0x00000003L,	" 00003", "%6.5d",
__LINE__, 0x0004720fL,	"4720f", "% x",
__LINE__, 0x0e44535dL,	"e44535d", "%4x",
__LINE__, 0xfffffff9L,	"FFFFFFF9", "%3.3X",
__LINE__, -0x0000005L,	"-5", "%-d",
__LINE__, 0x000001a6L,	"00001A6", "%1.7X",
__LINE__, 0x0000004aL,	"4A", "%-2.X",
__LINE__, 0xfffff249L,	"FFFFF249", "%X",
__LINE__, 0x00004345L,	"4345", "%x",
__LINE__, 0x0197041dL,	"197041d", "%+0x",
__LINE__, 0x0000019aL,	"   19a", "% 6.x",
__LINE__, 0xfff98376L,	"FFF98376", "%X",
__LINE__, 0xfc536c41L,	"FC536C41", "%X",
__LINE__, -0x0008d91L,	"-36241", "% d",
__LINE__, 0xf058d69dL,	"f058d69d", "%4.x",
__LINE__, -0x00013efL,	"-5103", "%d",
__LINE__, -0x0000003L,	"-3", "%00ld",
__LINE__, -0x09e80f0L,	"-10387696", "%+07ld",
__LINE__, -0x0222c15L,	"-2239509", "%#0.4ld",
__LINE__, 0x00000004L,	"4", "%0ld",
__LINE__, -0x02c6b0dL,	"-2910989", "% 0ld",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%-4X",
__LINE__, 0xffffff3dL,	"FFFFFF3D", "%-.0X",
__LINE__, -0x0000015L,	"-21", "%0d",
__LINE__, 0x131dfc90L,	"+320732304", "%+d",
__LINE__, 0xffffffffL,	"ffffffff", "%+x",
__LINE__, 0x000035c8L,	"13768", "%0ld",
__LINE__, 0x00000033L,	"0x0033", "%#.4x",
__LINE__, 0x0ce7e8c1L,	"0xce7e8c1", "%#.7x",
__LINE__, 0xfc18b5d2L,	"FC18B5D2", "%+.3X",
__LINE__, 0x00000015L,	"21", "%d",
__LINE__, 0x001a5e7cL,	"1a5e7c", "%05x",
__LINE__, -0x000fbf0L,	"-64496", "%ld",
__LINE__, -0x000a4f7L,	"-042231", "%+2.6d",
__LINE__, -0x0000002L,	"-002", "%3.3ld",
__LINE__, 0x00728878L,	"728878", "%0X",
__LINE__, -0x0000002L,	"-2", "%#.1ld",
__LINE__, -0x00002efL,	"-751", "%-0ld",
__LINE__, 0xfffffff7L,	"fffffff7", "%.3x",
__LINE__, 0x00491867L,	"0491867", "%.7X",
__LINE__, 0x00000d4dL,	"3405", "%-ld",
__LINE__, 0x00234e86L,	"234E86", "%0X",
__LINE__, -0x000001bL,	"-27", "%ld",
__LINE__, 0x00275255L,	"2576981", "%.5ld",
__LINE__, 0xfeacc214L,	"0XFEACC214", "%-#3.X",
__LINE__, -0x0001ce5L,	"-7397", "%+#2.2ld",
__LINE__, 0x089ddb6aL,	"144563050", "%d",
__LINE__, 0x003d5a95L,	"3D5A95", "%1X",
__LINE__, 0x002f0b6dL,	"3083117", "%d",
__LINE__, 0x1e79e228L,	"511304232", "%ld",
__LINE__, 0xfffffe6bL,	"FFFFFE6B", "%+0X",
__LINE__, -0x5104ff3L,	"-84955123", "%.4ld",
__LINE__, 0xfffff1deL,	"FFFFF1DE", "%X",
__LINE__, 0x000000cfL,	"+207", "%+.1ld",
__LINE__, -0x16ad0164L,	"-380436836", "%+5.d",
__LINE__, 0x001fefa6L,	"2092966", "%ld",
__LINE__, 0x00000000L,	"00", "%-.2d",
__LINE__, 0x00195f45L,	"195f45", "%+0x",
__LINE__, 0x00000001L,	"  1", "%3.ld",
__LINE__, -0x00001c9L,	"-457", "% ld",
__LINE__, 0x0002479eL,	"149406", "%#ld",
__LINE__, 0x001ab18bL,	"1749387", "%04d",
__LINE__, 0x00000045L,	"69", "%ld",
__LINE__, 0xfbb13f7dL,	"fbb13f7d", "%.2x",
__LINE__, 0x03ddc208L,	"3ddc208", "%x",
__LINE__, 0x00000007L,	"000007", "%#.6d",
__LINE__, 0x00000000L,	"0", "%01X",
__LINE__, -0x0023110L,	"-143632", "%+0.3d",
__LINE__, 0x00000006L,	"06", "%#.2d",
__LINE__, 0xffff9ec9L,	"ffff9ec9", "%7x",
__LINE__, -0x08afb12L,	"-9108242", "% #0.ld",
__LINE__, 0x00000004L,	"4", "%X",
__LINE__, 0x00059684L,	"59684", "%x",
__LINE__, 0xfff8d8f5L,	"FFF8D8F5", "%X",
__LINE__, 0x00b7027dL,	"+11993725", "%+0.7ld",
__LINE__, 0x0000d814L,	"55316", "%0ld",
__LINE__, 0x03c95a08L,	"3c95a08", "%3x",
__LINE__, -0x0b65f9aL,	"-11952026", "%d",
__LINE__, 0xfd956021L,	"fd956021", "%0x",
__LINE__, 0x000000edL,	"ed", "%0x",
__LINE__, -0x006a80cL,	"-436236", "%.6ld",
__LINE__, 0xfedb109dL,	"fedb109d", "%x",
__LINE__, 0x00000001L,	"1", "%X",
__LINE__, 0x00b3eb71L,	" 11791217", "% d",
__LINE__, 0x00000016L,	"16", "%0X",
__LINE__, 0x000001dbL,	" 475", "% ld",
__LINE__, 0x00465eafL,	"4611759", "%0d",
__LINE__, 0x0001b423L,	"1B423", "%0X",
__LINE__, 0x05df95eaL,	"5df95ea", "%+.5x",
__LINE__, 0x0000000eL,	"     14", "%7ld",
__LINE__, 0xffffb89eL,	"ffffb89e", "%+x",
__LINE__, 0x01259918L,	" 19241240", "% d",
__LINE__, -0x0000f8dL,	"-003981", "%+#.6d",
__LINE__, 0x00054ae0L,	"54AE0", "%X",
__LINE__, -0x4589ed4L,	"-72916692", "% ld",
__LINE__, 0x01017516L,	"1017516", "%6X",
__LINE__, 0xfffb9f15L,	"FFFB9F15", "%.2X",
__LINE__, 0x005f8394L,	"5F8394", "%.2X",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, -0x0000001L,	"     -1", "%7.1ld",
__LINE__, 0x004367afL,	"4417455", "%4.ld",
__LINE__, 0xffffff86L,	"ffffff86", "%4.5x",
__LINE__, -0x0000d17L,	"-3351", "%2.0ld",
__LINE__, 0xffffff31L,	"ffffff31", "%.6x",
__LINE__, -0x0000001L,	"-1", "%ld",
__LINE__, -0x3d785fabL,	"-1031298987", "%d",
__LINE__, -0x0000002L,	"-2", "%-0ld",
__LINE__, 0x0000019cL,	"412", "%d",
__LINE__, -0x0006f54L,	"-28500", "%d",
__LINE__, 0xfffe3524L,	"FFFE3524", "% 6.2X",
__LINE__, -0x128d3c00L,	"-311245824", "%2d",
__LINE__, -0x3be71293L,	"-1004999315", "%d",
__LINE__, 0x0000659dL,	"26013", "%d",
__LINE__, 0x2d947538L,	"+764704056", "%+5d",
__LINE__, 0xffa2a420L,	"FFA2A420", "%0X",
__LINE__, 0x00000001L,	"1", "%d",
__LINE__, 0x04477c14L,	"4477c14", "%.6x",
__LINE__, -0x06e145bL,	"-7214171", "%d",
__LINE__, 0x00009c01L,	"39937", "%-.1d",
__LINE__, 0xffde174bL,	"ffde174b", "% 0x",
__LINE__, 0x0001fbaeL,	"1FBAE", "%01.X",
__LINE__, -0x06b8406L,	"-7046150", "%d",
__LINE__, 0x000005b8L,	"005b8", "%05x",
__LINE__, -0x02d780bL,	"-2979851", "%1d",
__LINE__, 0x00209e26L,	"2137638", "%2d",
__LINE__, 0x0000041aL,	"41A", "%0X",
__LINE__, 0x2a77f42cL,	"2A77F42C", "%02X",
__LINE__, 0x13b6ee14L,	"+330755604", "%+0d",
__LINE__, -0x0000002L,	"-2    ", "%-6.d",
__LINE__, -0x0001eeeL,	"-7918", "% #2.ld",
__LINE__, 0xffffffffL,	"FFFFFFFF", "% .5X",
__LINE__, 0x20d11927L,	"20d11927", "% 0.x",
__LINE__, -0x0018690L,	"-99984", "% ld",
__LINE__, 0x000002a0L,	"2A0", "%-0X",
__LINE__, -0x0000511L,	"-1297", "%+d",
__LINE__, 0x0e782f31L,	"242757425", "%-0.ld",
__LINE__, 0x2ce06da0L,	"752905632", "%#0ld",
__LINE__, 0x00000062L,	"62     ", "%-07x",
__LINE__, -0x015d9d8L,	"-1432024", "% 7d",
__LINE__, 0xc9125ea8L,	"c9125ea8", "%x",
__LINE__, 0x00000006L,	"6", "%.0ld",
__LINE__, 0x0000019cL,	"19c", "%x",
__LINE__, 0x00000000L,	"      ", "%6.d",
__LINE__, 0x00043e89L,	"278153", "%0ld",
__LINE__, 0x3e422abdL,	"1044523709", "%ld",
__LINE__, 0x0220a75dL,	"35694429", "%#7.6d",
__LINE__, 0x0000c21cL,	"C21C", "% X",
__LINE__, 0x000074abL,	"29867", "%d",
__LINE__, 0x056b22aaL,	"56B22AA", "%+0.X",
__LINE__, 0xfffffff9L,	"FFFFFFF9", "%X",
__LINE__, 0x00000000L,	"0", "%X",
__LINE__, 0xf094a4f4L,	"f094a4f4", "%+4.x",
__LINE__, -0x1dad0244L,	"-497877572", "%d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%.1X",
__LINE__, 0xfffffe2dL,	"fffffe2d", "%7.x",
__LINE__, 0x0000042bL,	"0x42b", "%#x",
__LINE__, -0x0000001L,	"-1", "% d",
__LINE__, 0x00e77ef5L,	" 15171317", "% 7.ld",
__LINE__, 0x00006210L,	" 25104", "% 06d",
__LINE__, 0x0011187aL,	"1120378", "%-ld",
__LINE__, -0x000000bL,	"-11", "% #ld",
__LINE__, 0x14cfaff0L,	"14cfaff0", "%-2.3x",
__LINE__, 0xffff74eaL,	"FFFF74EA", "%3.X",
__LINE__, 0x000bfb9dL,	"bfb9d", "%x",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%X",
__LINE__, 0x00014500L,	"0X14500", "%#4.X",
__LINE__, -0x0000001L,	"-1", "%#1d",
__LINE__, -0x0000024L,	"-36", "%-0d",
__LINE__, -0x6528828L,	"-106072104", "%d",
__LINE__, 0x00000075L,	" 117", "% #d",
__LINE__, 0xff027d67L,	"ff027d67", "%0x",
__LINE__, 0x0012b8b3L,	"12b8b3", "%0.1x",
__LINE__, 0x1070147bL,	"275780731", "%.6ld",
__LINE__, 0xffffe88eL,	"FFFFE88E", "%1.3X",
__LINE__, 0xfffffc0dL,	"fffffc0d", "%00.6x",
__LINE__, 0xffd889f5L,	"ffd889f5", "%x",
__LINE__, 0x00000470L,	"1136", "%0ld",
__LINE__, 0x000297f8L,	"169976", "%ld",
__LINE__, 0xfffffffeL,	"fffffffe", "%+1x",
__LINE__, 0x0000064aL,	"64a", "%x",
__LINE__, -0x3d71e43bL,	"-1030874171", "%1.d",
__LINE__, -0x0000004L,	"-4 ", "%-3.d",
__LINE__, 0xfffff132L,	"FFFFF132", "%0.0X",
__LINE__, 0x37b6356fL,	"37b6356f", "%-x",
__LINE__, 0xffffff7aL,	"FFFFFF7A", "%.0X",
__LINE__, 0x00023553L,	"23553", "%x",
__LINE__, 0x39a4c29fL,	"39a4c29f", "%+5.x",
__LINE__, 0xffffffccL,	"ffffffcc", "%x",
__LINE__, 0x0003a83bL,	"239675", "%#6ld",
__LINE__, 0x00000002L,	"2", "%0x",
__LINE__, -0x09b4e8cL,	"-10178188", "%+03.ld",
__LINE__, 0x00000002L,	"0000002", "%-#.7ld",
__LINE__, 0x00000b5eL,	"2910", "%-04ld",
__LINE__, -0x0000254L,	"-596", "%+0d",
__LINE__, 0x00000001L,	"1", "%+1.x",
__LINE__, 0xf8290d3eL,	"0XF8290D3E", "% #X",
__LINE__, 0x00000035L,	"035", "%3.3X",
__LINE__, 0x00131d7dL,	"131D7D ", "%-7.6X",
__LINE__, 0xffdbb36aL,	"0xffdbb36a", "%#.6x",
__LINE__, 0xc7275816L,	"c7275816", "%04.x",
__LINE__, 0x00bae994L,	"12249492", "%0ld",
__LINE__, 0x00000002L,	"+2", "%+0.0ld",
__LINE__, 0xffffffffL,	"ffffffff", "%0x",
__LINE__, 0xffffffe0L,	"ffffffe0", "%x",
__LINE__, 0x00000036L,	"36", "%.0X",
__LINE__, 0xfffffffdL,	"FFFFFFFD", "%1X",
__LINE__, 0xffffffc8L,	"ffffffc8", "%+x",
__LINE__, 0xe71c3689L,	"e71c3689", "%x",
__LINE__, 0x00000007L,	"7  ", "%-3.ld",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, 0x00030400L,	"030400", "%-4.6x",
__LINE__, 0xbd8c6fa7L,	"BD8C6FA7", "%-6X",
__LINE__, 0x00000233L,	"0000563", "%.7ld",
__LINE__, 0xfef92e35L,	"fef92e35", "%x",
__LINE__, 0xffff2172L,	"ffff2172", "%3x",
__LINE__, 0x00001233L,	"1233", "% X",
__LINE__, -0x000d2e1L,	"-53985", "%-0d",
__LINE__, -0x3ba8cb5bL,	"-1000917851", "%0d",
__LINE__, -0x4fefb9aL,	"-83819418", "%5.ld",
__LINE__, 0xffffe9ebL,	"FFFFE9EB", "%X",
__LINE__, 0x1e472dc3L,	"507981251", "%ld",
__LINE__, -0x0077046L,	"-487494", "%0d",
__LINE__, 0x0002c4c9L,	"+181449", "%+7.d",
__LINE__, 0xfffffe63L,	"fffffe63", "%x",
__LINE__, 0xfff5a6dbL,	"FFF5A6DB", "%X",
__LINE__, 0x00174442L,	"174442", "%-5.0X",
__LINE__, 0x017891d9L,	"17891D9", "%+5.X",
__LINE__, 0x0261966bL,	"261966B", "%-X",
__LINE__, -0x3e58614dL,	"-1045979469", "%ld",
__LINE__, 0x002c4c41L,	"+2903105", "%+01ld",
__LINE__, 0x0000000cL,	"012", "%#.3d",
__LINE__, 0x0380f73aL,	"58783546", "%ld",
__LINE__, 0x000002c7L,	"0000711", "%2.7ld",
__LINE__, 0x00000002L,	" 002", "% 04ld",
__LINE__, 0x00687ca0L,	"687CA0", "%X",
__LINE__, 0x0000058aL,	"1418", "%0ld",
__LINE__, -0x0000642L,	"-1602", "% ld",
__LINE__, 0x0001f4f1L,	"1F4F1", "%X",
__LINE__, 0x0026d6fcL,	"+2545404", "%+4.ld",
__LINE__, 0x05dd423cL,	"+98386492", "%+#ld",
__LINE__, 0x0000782cL,	"0782C", "%3.5X",
__LINE__, 0xf67d91f8L,	"f67d91f8", "%-x",
__LINE__, 0xffffcf2dL,	"ffffcf2d", "%+0x",
__LINE__, -0x00af8a6L,	"-719014", "%0ld",
__LINE__, -0xe606ef9L,	"-241200889", "%ld",
__LINE__, 0xfe9d87f7L,	"fe9d87f7", "%+x",
__LINE__, 0x00000d44L,	"d44", "% 1.x",
__LINE__, 0x008716f5L,	"8716f5", "%2x",
__LINE__, 0x000027d4L,	"27D4", "% X",
__LINE__, 0xfdfd92eaL,	"FDFD92EA", "%-.4X",
__LINE__, 0xfffe764fL,	"FFFE764F", "%X",
__LINE__, 0xff699032L,	"ff699032", "%3.x",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%-3X",
__LINE__, -0x368ba995L,	"-915122581", "%+#.6ld",
__LINE__, 0xffffffffL,	"ffffffff", "%0x",
__LINE__, 0x0000035eL,	" 862", "% 1d",
__LINE__, 0xfe703e67L,	"fe703e67", "%07.0x",
__LINE__, 0xfffffffeL,	"fffffffe", "%4.x",
__LINE__, 0x000e20cfL,	"e20cf", "%0x",
__LINE__, 0x000063b5L,	"0X63B5", "%-#X",
__LINE__, 0xfffffffaL,	"fffffffa", "%+2.x",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%2.X",
__LINE__, 0xfdfd69daL,	"FDFD69DA", "%.0X",
__LINE__, 0x00002f61L,	"0x2f61", "%#3.x",
__LINE__, 0x00000009L,	"9", "%x",
__LINE__, 0xffffff86L,	"ffffff86", "%6x",
__LINE__, 0xffffffe4L,	"ffffffe4", "%0x",
__LINE__, 0x0062e73bL,	"+6481723", "%+0ld",
__LINE__, -0x2b059130L,	"-721785136", "%+d",
__LINE__, -0x0000073L,	"-115", "%d",
__LINE__, 0xf596efcfL,	"f596efcf", "%x",
__LINE__, 0x0002f1cbL,	"2F1CB", "%0X",
__LINE__, -0x0000635L,	"-01589", "%.5ld",
__LINE__, 0xfffa011aL,	"FFFA011A", "%0X",
__LINE__, 0x00000047L,	"  47", "%4X",
__LINE__, 0xfffffbc0L,	"FFFFFBC0", "%5.2X",
__LINE__, 0x00000015L,	"15", "% X",
__LINE__, 0x002a87a6L,	"2a87a6", "%.1x",
__LINE__, -0x000069cL,	"-1692", "%+ld",
__LINE__, 0xfffffffdL,	"fffffffd", "%+x",
__LINE__, 0xfeda51f5L,	"FEDA51F5", "%0X",
__LINE__, 0x001781a4L,	"1781a4", "%-0x",
__LINE__, 0xe77358d4L,	"e77358d4", "%+0x",
__LINE__, 0x00000084L,	" 84", "%3.x",
__LINE__, 0xffff0cb2L,	"FFFF0CB2", "%+5.X",
__LINE__, 0x0009fa17L,	"653847", "%0.0ld",
__LINE__, -0x0000c92L,	"-3218", "%d",
__LINE__, 0x0004ebbbL,	"4ebbb", "%x",
__LINE__, 0x2e72568cL,	"+779245196", "%+#ld",
__LINE__, 0xffae86a7L,	"ffae86a7", "%.7x",
__LINE__, 0xffdf3f04L,	"ffdf3f04", "%x",
__LINE__, 0x000000c7L,	"199", "%2.d",
__LINE__, -0x0004a55L,	"-19029", "%ld",
__LINE__, 0x00564ef9L,	"5656313", "%.6ld",
__LINE__, 0xffffc205L,	"ffffc205", "%+.0x",
__LINE__, -0x135085d0L,	"-324044240", "%#.5d",
__LINE__, 0xfffffffeL,	"fffffffe", "%-7x",
__LINE__, -0x0000003L,	"-3", "%.1ld",
__LINE__, 0xffda9e0bL,	"ffda9e0b", "%+0x",
__LINE__, 0x00000001L,	"1", "%d",
__LINE__, 0xffffffdaL,	"ffffffda", "%.6x",
__LINE__, 0x5efdb3d1L,	"+1593684945", "%+0d",
__LINE__, -0x00000caL,	"-202", "% 4.d",
__LINE__, -0x0014433L,	"-82995", "%.3d",
__LINE__, -0x0000002L,	"-000002", "% .6ld",
__LINE__, 0x24aac879L,	"615172217", "%.7d",
__LINE__, -0x1db3c1dL,	"-31144989", "%+#4ld",
__LINE__, 0x000945adL,	"0x945ad", "%#1x",
__LINE__, 0x0000000aL,	"10", "%#.1ld",
__LINE__, -0x002a2e5L,	"-172773", "%d",
__LINE__, 0xfffffff3L,	"FFFFFFF3", "%5X",
__LINE__, 0x0000000eL,	"e", "%+x",
__LINE__, 0x335333dcL,	"861090780", "%6.d",
__LINE__, 0xfffa16f4L,	"FFFA16F4", "%6X",
__LINE__, 0xffffc727L,	"ffffc727", "%+2.x",
__LINE__, 0x00000273L,	"273", "%x",
__LINE__, -0x000000fL,	"-15", "%-0d",
__LINE__, 0x00065fbdL,	"417725", "%5.1d",
__LINE__, 0x00000ed5L,	"3797", "%d",
__LINE__, 0x30a40024L,	"30A40024", "%3.7X",
__LINE__, 0x00000054L,	"84", "%ld",
__LINE__, 0x00000515L,	"01301", "%.5ld",
__LINE__, 0x00000897L,	"+02199", "%+.5d",
__LINE__, -0x0001bccL,	"-7116", "% ld",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%7X",
__LINE__, 0x00000013L,	"0X13", "%#X",
__LINE__, 0xffffffffL,	"0xffffffff", "% #x",
__LINE__, 0x00000006L,	"6", "%ld",
__LINE__, -0x00000c3L,	"-195", "%1.ld",
__LINE__, -0x005291eL,	"-338206", "%+d",
__LINE__, 0xffb437a7L,	"FFB437A7", "%-0X",
__LINE__, 0xff8335cbL,	"ff8335cb", "%x",
__LINE__, 0x0000006aL,	"6A", "%2X",
__LINE__, -0x004f629L,	"-325161", "% .4d",
__LINE__, 0x003698efL,	"3578095", "%0ld",
__LINE__, 0x6b5cdf3aL,	"6b5cdf3a", "%-x",
__LINE__, 0xe9bc5c21L,	"e9bc5c21", "%+x",
__LINE__, -0x0000001L,	"    -1", "%+6.ld",
__LINE__, 0xfffeffc8L,	"FFFEFFC8", "%6.X",
__LINE__, 0xff070a73L,	"ff070a73", "%+.7x",
__LINE__, 0x0023f8aeL,	"2357422", "%07.4ld",
__LINE__, 0x00000000L,	"0", "%X",
__LINE__, 0x00000016L,	"16", "%0X",
__LINE__, -0x000005aL,	" -90", "%4d",
__LINE__, 0x00000116L,	"116", "% .3x",
__LINE__, 0xfffed024L,	"fffed024", "%-x",
__LINE__, 0xfb907950L,	"fb907950", "%.0x",
__LINE__, 0x0101a1e5L,	"101a1e5", "%x",
__LINE__, -0x09e7684L,	"-10385028", "%-#ld",
__LINE__, 0xffffffffL,	"ffffffff", "%1x",
__LINE__, 0xfffffff6L,	"fffffff6", "%x",
__LINE__, 0x00000078L,	"78", "%x",
__LINE__, 0xe6bca9c9L,	"0XE6BCA9C9", "%#.5X",
__LINE__, -0x0000010L,	"-16", "%d",
__LINE__, -0x1348f685L,	"-323548805", "%d",
__LINE__, 0x4dd85797L,	"1306023831", "%ld",
__LINE__, -0x0000080L,	"-128", "%.2d",
__LINE__, -0xaed13a7L,	"-183309223", "%+ld",
__LINE__, -0x000002fL,	"-47", "% d",
__LINE__, -0x679911fL,	"-108630303", "%ld",
__LINE__, 0xfffff221L,	"FFFFF221", "% .7X",
__LINE__, 0x0007476cL,	"7476c", "%x",
__LINE__, 0xffffe02aL,	"0xffffe02a", "%#7x",
__LINE__, 0x00000ebbL,	"0XEBB", "%#X",
__LINE__, 0xffffffffL,	"0XFFFFFFFF", "%-#X",
__LINE__, 0x00281896L,	"281896", "%+1.x",
__LINE__, 0x0000085dL,	" 0X85D", "%#6.3X",
__LINE__, 0x000112bfL,	"112BF", "%X",
__LINE__, 0xf5518fbfL,	"F5518FBF", "% X",
__LINE__, -0x00c945bL,	"-824411", "%ld",
__LINE__, 0x00001b43L,	"0x1b43", "%-#x",
__LINE__, -0x5872a246L,	"-1483907654", "%#7.7ld",
__LINE__, 0x00001f96L,	"8086", "%#d",
__LINE__, 0xfffffff9L,	"FFFFFFF9", "%X",
__LINE__, -0x006e244L,	"-451140", "% .3d",
__LINE__, -0x0382188L,	"-3678600", "%0.2ld",
__LINE__, 0x00000006L,	"6", "%-x",
__LINE__, 0x00000036L,	"54   ", "%-5.d",
__LINE__, -0x0000439L,	" -1081", "%#6.3ld",
__LINE__, 0xfff911c6L,	"FFF911C6", "%X",
__LINE__, -0x03454dcL,	"-3429596", "%d",
__LINE__, -0x0363e8dL,	"-3554957", "%-.2ld",
__LINE__, 0x00000000L,	"000", "%.3X",
__LINE__, -0x59bb030fL,	"-1505428239", "%0ld",
__LINE__, 0x073c94d8L,	"121410776", "%-d",
__LINE__, -0x001ef94L,	"-126868", "%5.1ld",
__LINE__, 0xfff65fc5L,	"FFF65FC5", "%0X",
__LINE__, 0xfffffff4L,	"fffffff4", "%-x",
__LINE__, 0x00001d83L,	"07555", "%5.5d",
__LINE__, 0x0012b40aL,	"1225738", "%ld",
__LINE__, -0x0000006L,	"-6", "%0ld",
__LINE__, 0xfffffffcL,	"fffffffc", "%06.0x",
__LINE__, -0x0000002L,	"-00002", "%#.5ld",
__LINE__, 0xf9932c1dL,	"f9932c1d", "%-x",
__LINE__, -0x46a31d9L,	"-74068441", "%.3ld",
__LINE__, 0x000987e9L,	"987E9", "%1X",
__LINE__, 0x0000000fL,	"15", "%-ld",
__LINE__, -0x0001c4dL,	"-7245", "%ld",
__LINE__, -0x007deeeL,	"-515822", "%2.6d",
__LINE__, 0xffffffa2L,	"FFFFFFA2", "%.6X",
__LINE__, 0x00000001L,	"1", "%-ld",
__LINE__, 0xfc106bdeL,	"fc106bde", "%.4x",
__LINE__, 0x0002f1f8L,	"0x2f1f8", "%#7.x",
__LINE__, -0x06a290bL,	"-6957323", "%-ld",
__LINE__, -0x0000037L,	" -55", "%4ld",
__LINE__, 0x0000152eL,	"5422", "%2.d",
__LINE__, 0xfffffcb2L,	"0XFFFFFCB2", "%#3.X",
__LINE__, 0x1b7ca086L,	"1b7ca086", "%+x",
__LINE__, 0x00000001L,	"1", "%ld",
__LINE__, 0x006775fcL,	"6775fc", "%3.2x",
__LINE__, 0x0000000eL,	"0XE", "%#3.X",
__LINE__, 0xffffffffL,	"0xffffffff", "%+#4.x",
__LINE__, 0x00001246L,	"1246", "%X",
__LINE__, 0xffffaed6L,	"ffffaed6", "%2x",
__LINE__, -0x3a2dec78L,	"-976088184", "% 0ld",
__LINE__, 0x0001423bL,	"1423b", "%01x",
__LINE__, 0x00000007L,	" 0X7", "%#4.X",
__LINE__, 0x01a7ff5aL,	"27787098", "%.4ld",
__LINE__, -0x0020d05L,	"-134405", "%-d",
__LINE__, 0xffffff9aL,	"ffffff9a", "%-.1x",
__LINE__, 0xffff3557L,	"ffff3557", "%x",
__LINE__, 0x08828e35L,	"8828e35", "%+.1x",
__LINE__, 0x000006b2L,	"001714", "%04.6ld",
__LINE__, 0x00000013L,	"19", "%.0ld",
__LINE__, -0x00341a5L,	"-213413", "%#d",
__LINE__, -0x0000043L,	"-67", "%d",
__LINE__, -0x074dce3L,	"-7658723", "%.1d",
__LINE__, -0x16de2df3L,	"-383659507", "% ld",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0x00000ce7L,	"ce7", "% 2.1x",
__LINE__, 0xffecd377L,	"ffecd377", "% 0x",
__LINE__, 0xa4e8465cL,	"a4e8465c", "% x",
__LINE__, 0x000005e8L,	"1512", "%d",
__LINE__, 0x00000513L,	"1299", "%d",
__LINE__, 0xffffffb8L,	"FFFFFFB8", "%X",
__LINE__, 0x00000003L,	"00003", "%3.5x",
__LINE__, -0x0000003L,	"-3 ", "%-3.ld",
__LINE__, 0xad53f01dL,	"ad53f01d", "%0x",
__LINE__, 0x0f1c1daeL,	"253500846", "%-#.0d",
__LINE__, 0xff1753c0L,	"0xff1753c0", "%#3.x",
__LINE__, -0x00389c5L,	"-231877", "%d",
__LINE__, 0x0000016eL,	"00016E", "%.6X",
__LINE__, -0x54d3310fL,	"-1423126799", "%-d",
__LINE__, 0x00000005L,	"0X5", "%#.1X",
__LINE__, 0xfffffffdL,	"0XFFFFFFFD", "%#5.3X",
__LINE__, 0xfffffe0eL,	"fffffe0e", "%-x",
__LINE__, 0xa3c02157L,	"a3c02157", "%.5x",
__LINE__, 0x00005765L,	"22373", "%d",
__LINE__, -0x12668cdL,	"-19294413", "%+ld",
__LINE__, -0x66544daL,	"-107300058", "%2d",
__LINE__, 0x8646c605L,	"0X8646C605", "% #X",
__LINE__, 0x000001f5L,	"1F5", "%X",
__LINE__, 0x01b33ae4L,	"28523236", "%5ld",
__LINE__, 0x000007ceL,	"7ce", "%3.x",
__LINE__, 0x00000355L,	"355", "%X",
__LINE__, 0x000001ceL,	"1CE", "% X",
__LINE__, 0xfffffccdL,	"fffffccd", "%7.0x",
__LINE__, -0x0000001L,	"-1", "%0ld",
__LINE__, 0x000640b6L,	"640b6", "%5.x",
__LINE__, 0x0038c4ecL,	"3720428", "%5.4d",
__LINE__, -0x0f10b5eL,	"-15797086", "%2ld",
__LINE__, 0x256c815fL,	"256c815f", "%4.x",
__LINE__, 0x00000682L,	"  1666", "%6ld",
__LINE__, -0x00000abL,	"-171", "%2ld",
__LINE__, 0x00000003L,	"3", "%0d",
__LINE__, 0x063f5075L,	"63F5075", "%X",
__LINE__, 0xff83b5d0L,	"FF83B5D0", "%7.X",
__LINE__, 0xffffffecL,	"ffffffec", "%x",
__LINE__, 0xffb551c4L,	"0XFFB551C4", "% #4.X",
__LINE__, -0x071f057L,	"-7467095", "%3.7d",
__LINE__, 0x00634879L,	"6506617", "%#ld",
__LINE__, 0x000001d7L,	"471", "%d",
__LINE__, 0x00a7da92L,	"A7DA92", "% .4X",
__LINE__, 0x00000003L,	"3 ", "%-2.ld",
__LINE__, -0x0000004L,	"-0004", "%.4d",
__LINE__, -0x01dea32L,	"-1960498", "% #7.d",
__LINE__, 0x53c4159fL,	"53C4159F", "%1.7X",
__LINE__, -0x1ad7904L,	"-28145924", "%#d",
__LINE__, -0x0000a85L,	"-2693", "%ld",
__LINE__, -0x0000c7dL,	"-3197", "%d",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%+0X",
__LINE__, 0x00000004L,	"00004", "%1.5d",
__LINE__, 0x0000b761L,	"46945", "%5ld",
__LINE__, -0x0ee3b2cL,	"-15612716", "%.6d",
__LINE__, 0x0677a73dL,	"677a73d", "% x",
__LINE__, -0x5f96020L,	"-100229152", "% d",
__LINE__, 0x00000000L,	"      0", "%#7X",
__LINE__, -0x5d1cb5bL,	"-97635163", "% ld",
__LINE__, -0x00a8d8bL,	"-691595", "%-0ld",
__LINE__, 0xffffffa2L,	"FFFFFFA2", "%X",
__LINE__, 0xffffffc9L,	"FFFFFFC9", "%X",
__LINE__, 0x0b180d35L,	"B180D35", "%X",
__LINE__, 0xfc0b94ceL,	"fc0b94ce", "%.1x",
__LINE__, 0x0012cd7bL,	"12CD7B", "% X",
__LINE__, -0x02f1da8L,	"-3087784", "%ld",
__LINE__, -0x000a6f9L,	"-42745", "%-ld",
__LINE__, -0x000006dL,	"-109  ", "%-6d",
__LINE__, 0x00000001L,	"+1", "%+0d",
__LINE__, 0x00000001L,	"1", "%1d",
__LINE__, 0xfffffff8L,	"fffffff8", "%5.x",
__LINE__, -0x00fc4d7L,	"-1033431", "%+0.5ld",
__LINE__, 0xffff41b4L,	"0xffff41b4", "%#x",
__LINE__, -0x0000d37L,	"-3383", "%ld",
__LINE__, 0xffc4e405L,	"ffc4e405", "%7x",
__LINE__, 0xffffffb0L,	"FFFFFFB0", "%04X",
__LINE__, -0x0054477L,	"-345207", "%01.ld",
__LINE__, 0x00512778L,	"0x512778", "%#3.0x",
__LINE__, 0x00000007L,	"      7", "%7.d",
__LINE__, 0x00000008L,	" 00008", "% .5ld",
__LINE__, 0x000053fdL,	"21501", "%.4ld",
__LINE__, 0x0000370cL,	"370c", "%2x",
__LINE__, -0x44670a7L,	"-71725223", "%3d",
__LINE__, 0x00000064L,	"   64", "%+5x",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%X",
__LINE__, 0xf7bbf094L,	"f7bbf094", "%3x",
__LINE__, 0xfffeb268L,	"FFFEB268", "%X",
__LINE__, 0x00001ef0L,	"1ef0", "%4.x",
__LINE__, 0x05ad9aa4L,	" 95263396", "% 0.ld",
__LINE__, 0xf294dca7L,	"F294DCA7", "% 4.X",
__LINE__, -0x0000003L,	"-000003", "%.6d",
__LINE__, 0xfff57471L,	"fff57471", "% x",
__LINE__, 0x0a848cfdL,	"176459005", "%d",
__LINE__, -0x000002eL,	"-46", "%.0d",
__LINE__, 0x00000051L,	"  +81", "%+5d",
__LINE__, -0x000072bL,	"-0001835", "%06.7d",
__LINE__, -0x0000002L,	"    -2", "%+#6ld",
__LINE__, 0x00000003L,	"3", "%x",
__LINE__, 0xfffd1799L,	"FFFD1799", "%6.X",
__LINE__, 0x00000005L,	"5", "%ld",
__LINE__, 0x0052138bL,	"5378955", "%#7.7ld",
__LINE__, 0x000000c0L,	"    192", "% 7ld",
__LINE__, 0x005b26cdL,	"5B26CD", "%X",
__LINE__, -0x008df17L,	"-581399", "%.4ld",
__LINE__, 0xfffffad8L,	"fffffad8", "%-x",
__LINE__, 0x000006a9L,	"6a9", "%.0x",
__LINE__, -0x003b7f9L,	"-243705", "%+0ld",
__LINE__, 0x005d7ea4L,	"6127268", "%ld",
__LINE__, -0x003cceaL,	"-249066", "%+.0ld",
__LINE__, 0x0000846fL,	"846F", "%X",
__LINE__, 0x00004f79L,	"4F79", "%4.X",
__LINE__, 0xe3e1409cL,	"E3E1409C", "%-X",
__LINE__, 0x07cce2f4L,	"7CCE2F4", "%2.X",
__LINE__, 0x004bcc8bL,	"4967563", "%-.5ld",
__LINE__, 0x7d49665eL,	"2101962334", "%ld",
__LINE__, 0xfffffffcL,	"FFFFFFFC", "%.5X",
__LINE__, 0x0000019eL,	"+000414", "%+.6d",
__LINE__, 0x000027efL,	"10223", "%d",
__LINE__, -0x0000261L,	"-609", "%3ld",
__LINE__, -0x000000eL,	"-14", "% 2.ld",
__LINE__, 0xff3ba3c7L,	"ff3ba3c7", "%+5.7x",
__LINE__, 0xffffffc4L,	"FFFFFFC4", "%-1.X",
__LINE__, 0xfffc5a70L,	"0xfffc5a70", "%#4.4x",
__LINE__, 0x0000d156L,	" 53590", "% d",
__LINE__, -0x0486258L,	"-4743768", "%0ld",
__LINE__, 0x00000000L,	"  ", "% 2.d",
__LINE__, 0x04a0ef9fL,	"77655967", "%0.6ld",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%X",
__LINE__, 0x00000019L,	"0000019", "%.7x",
__LINE__, -0x0058d3aL,	"-363834", "%ld",
__LINE__, 0xfffff6b3L,	"fffff6b3", "%x",
__LINE__, 0xfffffff5L,	"FFFFFFF5", "%.0X",
__LINE__, 0x005e1fcbL,	"5E1FCB", "%+6X",
__LINE__, 0xffc3c866L,	"0xffc3c866", "%-#.4x",
__LINE__, 0x00000003L,	"3", "%X",
__LINE__, 0xffa2e961L,	"FFA2E961", "%7.4X",
__LINE__, 0x00000029L,	"41", "%d",
__LINE__, -0x0000035L,	"-53", "%d",
__LINE__, 0x0001b033L,	"110643", "%ld",
__LINE__, 0x004dd51bL,	"5100827", "%-2ld",
__LINE__, -0x000252dL,	"-9517", "% d",
__LINE__, 0xffffdeb2L,	"ffffdeb2", "%4.x",
__LINE__, 0xffe94eabL,	"0xffe94eab", "%#x",
__LINE__, 0xf921edf6L,	"f921edf6", "%4.2x",
__LINE__, 0x0007df97L,	"515991", "%4.ld",
__LINE__, 0x00709bc5L,	"709BC5", "%0X",
__LINE__, -0x0000001L,	"-1", "%d",
__LINE__, 0xfffffffbL,	"FFFFFFFB", "%7.3X",
__LINE__, -0x0063f74L,	"-409460", "%+05.0d",
__LINE__, 0xfffffe9aL,	"FFFFFE9A", "%.2X",
__LINE__, -0x0001ce2L,	"-7394", "%.4d",
__LINE__, 0x000038c5L,	"14533", "%ld",
__LINE__, 0x000000adL,	"000ad", "% 5.5x",
__LINE__, 0xffffbcc4L,	"ffffbcc4", "%-5x",
__LINE__, 0x00000000L,	"0", "% X",
__LINE__, 0x00372877L,	"372877", "%.6X",
__LINE__, 0xffffffd7L,	"FFFFFFD7", "%1.X",
__LINE__, 0xfa58b14bL,	"fa58b14b", "%x",
__LINE__, 0xfffffd9fL,	"FFFFFD9F", "%0.7X",
__LINE__, 0x00000710L,	"+1808", "%+#.2ld",
__LINE__, 0x00000006L,	"    6", "%5.0ld",
__LINE__, 0x0fba9706L,	"263886598", "%-6.3d",
__LINE__, 0xffff420aL,	"ffff420a", "%-2x",
__LINE__, 0x14b9a825L,	"14b9a825", "%x",
__LINE__, 0x0077ffe4L,	"77FFE4", "%+.2X",
__LINE__, 0x00067108L,	"422152 ", "%-7.ld",
__LINE__, 0x00000001L,	" 00001", "%6.5X",
__LINE__, 0x00000000L,	"0", "%ld",
__LINE__, -0x0000001L,	"     -1", "% 7ld",
__LINE__, 0x01ddc7a3L,	"31311779", "%d",
__LINE__, -0x2a92f9bL,	"-44642203", "% 3ld",
__LINE__, 0xfffffff9L,	"fffffff9", "%4.6x",
__LINE__, 0x0279a274L,	"279a274", "%x",
__LINE__, 0x2e37ed8eL,	"775417230", "%d",
__LINE__, 0x5ba59f58L,	"1537580888", "%-ld",
__LINE__, 0xffffffe0L,	"ffffffe0", "%x",
__LINE__, 0x3110ae47L,	"0X3110AE47", "%+#X",
__LINE__, 0x000e00b9L,	"917689", "%d",
__LINE__, 0x0000002eL,	"   0046", "% 7.4d",
__LINE__, 0x00000363L,	"    867", "%7.d",
__LINE__, -0x000000bL,	"-0011", "% 0.4d",
__LINE__, 0x000349c8L,	"  349C8", "% 7.X",
__LINE__, -0x01358f1L,	"-1267953", "%d",
__LINE__, -0x0039d3cL,	"-236860", "%-.3d",
__LINE__, 0xffd6de19L,	"ffd6de19", "%04.0x",
__LINE__, -0x0003c54L,	"-0015444", "%1.7d",
__LINE__, -0x0000e17L,	"-3607", "%d",
__LINE__, 0xff0fa3a9L,	"ff0fa3a9", "%+3x",
__LINE__, 0x00000009L,	"0000009", "%1.7x",
__LINE__, 0xfffffc81L,	"FFFFFC81", "% X",
__LINE__, -0x4ef2df5L,	"-82783733", "%ld",
__LINE__, 0x00000013L,	"19", "%-ld",
__LINE__, 0x00000000L,	"      0", "%#7x",
__LINE__, -0x3b9485fdL,	"-999589373", "%1.d",
__LINE__, -0x0000006L,	"-00006", "%6.5d",
__LINE__, 0x0000003fL,	"+63", "%+ld",
__LINE__, 0x000004c5L,	"1221", "%1.d",
__LINE__, 0x003f8a8cL,	"4164236", "%d",
__LINE__, -0x000001eL,	"-30", "%-#3d",
__LINE__, 0xfff9d230L,	"FFF9D230", "%+07.3X",
__LINE__, 0x0147cf17L,	"147cf17", "% x",
__LINE__, 0xffffffebL,	"ffffffeb", "%x",
__LINE__, 0x0000007dL,	"00125", "%.5ld",
__LINE__, 0x000fff56L,	"1048406", "%#3d",
__LINE__, 0x064307a0L,	" 105056160", "% 0.3ld",
__LINE__, 0x007d2860L,	"8202336", "%-.2d",
__LINE__, 0x00a05711L,	"a05711", "%x",
__LINE__, 0x179a7f9eL,	"0x179a7f9e", "%+#.3x",
__LINE__, 0x00000003L,	"3", "%X",
__LINE__, -0x0001d7dL,	"-7549", "%#5d",
__LINE__, 0x0025d3f2L,	"+2479090", "%+2.d",
__LINE__, -0x0000001L,	"-1", "%#ld",
__LINE__, 0xfffffdd5L,	"fffffdd5", "%.7x",
__LINE__, 0x003462b9L,	"3433145", "%d",
__LINE__, 0x00005a81L,	"23169", "%d",
__LINE__, 0xfffffcdbL,	"fffffcdb", "%-x",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, 0xfff22085L,	"fff22085", "%x",
__LINE__, 0x00016d72L,	" 93554", "% d",
__LINE__, -0x0000002L,	"-2", "%0ld",
__LINE__, 0xfffffd21L,	"fffffd21", "% 0x",
__LINE__, 0x00000931L,	"2353", "%ld",
__LINE__, 0x00010021L,	"10021", "%5.1X",
__LINE__, -0x000007eL,	"-126", "%1.0ld",
__LINE__, 0xfffffff8L,	"fffffff8", "%01.x",
__LINE__, -0x001d148L,	"-119112", "%d",
__LINE__, -0x0000008L,	"-8", "%ld",
__LINE__, -0x000038eL,	"-910", "% ld",
__LINE__, 0x0039e3e5L,	"3793893", "%0.1d",
__LINE__, 0x0038fb8eL,	"38FB8E", "%.2X",
__LINE__, -0x002dafaL,	"-187130", "%ld",
__LINE__, -0xbec275bL,	"-200025947", "%ld",
__LINE__, 0x1a32f999L,	"1A32F999", "%05.4X",
__LINE__, 0x0000002fL,	"2f", "%x",
__LINE__, -0x0001a5bL,	"-6747", "%+3.ld",
__LINE__, 0x00000762L,	"   1890", "%7.ld",
__LINE__, 0x000000c2L,	"000194", "%0.6ld",
__LINE__, 0xffff002bL,	"FFFF002B", "%.4X",
__LINE__, -0x0019daeL,	"-105902", "% .2d",
__LINE__, 0x0000125fL,	"125f", "%+1x",
__LINE__, -0x000b688L,	" -46728", "%#7.d",
__LINE__, 0x000401caL,	"401ca", "%0x",
__LINE__, 0x00000192L,	"402", "%#ld",
__LINE__, 0xffffffffL,	"ffffffff", "%x",
__LINE__, 0x1e505a0cL,	"0X1E505A0C", "%#1.3X",
__LINE__, 0x000f8f6cL,	"1019756", "%d",
__LINE__, 0x0004a296L,	"4a296", "%5.2x",
__LINE__, 0x00000003L,	"3", "% x",
__LINE__, -0x000d44cL,	"-54348", "%#ld",
__LINE__, 0x00009ae2L,	"39650", "%-d",
__LINE__, 0xffffff3aL,	"FFFFFF3A", "% .7X",
__LINE__, 0x0042350bL,	"4338955", "%d",
__LINE__, 0x000071afL,	"71af", "%+.4x",
__LINE__, 0x00000001L,	"0x1", "%#0x",
__LINE__, 0x00000033L,	"00051", "%3.5d",
__LINE__, 0x00000001L,	"1", "%X",
__LINE__, -0xebfb0e7L,	"-247443687", "%+3ld",
__LINE__, 0x00000027L,	"27     ", "%-07.X",
__LINE__, -0x0004837L,	"-18487", "%01d",
__LINE__, 0x1a8c53daL,	"1A8C53DA", "%X",
__LINE__, -0x0bdb8a9L,	"-12433577", "%d",
__LINE__, -0x0000098L,	"-152", "%#ld",
__LINE__, -0x003b554L,	"-243028", "%d",
__LINE__, 0x000000cbL,	"00000CB", "%+.7X",
__LINE__, 0xfffffedaL,	"FFFFFEDA", "%X",
__LINE__, -0x0000010L,	"-16", "%-#d",
__LINE__, 0x00000006L,	"+6", "%+d",
__LINE__, 0x003c294aL,	"+3942730", "%+4.ld",
__LINE__, 0x00000009L,	"9", "%ld",
__LINE__, 0xfbbdd2bcL,	"FBBDD2BC", "% X",
__LINE__, 0x71c86678L,	"+1908958840", "%+0.6ld",
__LINE__, -0x0b49bffL,	"-11836415", "% 6.ld",
__LINE__, 0xfff416beL,	"fff416be", "%3.x",
__LINE__, 0x00000077L,	"+119", "%+d",
__LINE__, 0xfff1cfaaL,	"FFF1CFAA", "% 0.2X",
__LINE__, 0xfffffffbL,	"fffffffb", "% x",
__LINE__, 0x0000127eL,	"4734", "%d",
__LINE__, 0x00107ad2L,	"107ad2", "%+2.6x",
__LINE__, 0x0006b8e9L,	"440553", "%-#d",
__LINE__, 0x0000eb6fL,	"eb6f", "% x",
__LINE__, 0x00001f18L,	"7960", "%0d",
__LINE__, 0xfffff225L,	"fffff225", "%1.5x",
__LINE__, 0xfffffff9L,	"fffffff9", "%+6.x",
__LINE__, 0x000005b9L,	"01465", "%.5ld",
__LINE__, 0xfffc26b8L,	"FFFC26B8", "% X",
__LINE__, 0x540d580dL,	"0X540D580D", "%+#X",
__LINE__, 0x05ad7094L,	"5AD7094", "% 4.7X",
__LINE__, -0x000019bL,	"-411", "% d",
__LINE__, 0x00000006L,	"000006", "%6.6ld",
__LINE__, 0x0000026aL,	"+618", "%+ld",
__LINE__, 0x0000000bL,	"11", "%ld",
__LINE__, -0x26985d5L,	"-40469973", "%#.0ld",
__LINE__, 0x0000007dL,	"7D", "%+02.0X",
__LINE__, -0x0079ddfL,	"-0499167", "%+.7ld",
__LINE__, 0x0000375fL,	"14175", "%0d",
__LINE__, -0x18de7f99L,	"-417234841", "%ld",
__LINE__, -0x00507ccL,	"-329676", "%.0d",
__LINE__, 0x000029d5L,	"29D5", "%-2.1X",
__LINE__, 0x0000328cL,	"328C", "%-3.X",
__LINE__, 0x016f6234L,	"24076852", "%3.ld",
__LINE__, 0xfffffffcL,	"0XFFFFFFFC", "%#.5X",
__LINE__, 0xfe6163caL,	"FE6163CA", "%5.X",
__LINE__, 0xffffffc2L,	"FFFFFFC2", "%X",
__LINE__, 0x00000087L,	"+135", "%+ld",
__LINE__, 0x00310166L,	"310166", "% x",
__LINE__, 0x00e8c871L,	"15255665", "%d",
__LINE__, 0x000005eeL,	"1518", "%ld",
__LINE__, 0xfcb24306L,	"FCB24306", "%X",
__LINE__, 0x0000000bL,	"   11", "%5ld",
__LINE__, 0x006d11d0L,	"0x6d11d0", "%#.0x",
__LINE__, 0x0010d416L,	"1102870", "%#6.5d",
__LINE__, -0x0047cb3L,	"-294067", "%.3d",
__LINE__, 0x000000c0L,	"c0", "%x",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%+X",
__LINE__, -0x000000aL,	"-10", "%d",
__LINE__, -0x0000007L,	"-7", "% ld",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "%-X",
__LINE__, 0x00000014L,	"0x14", "%-#3.1x",
__LINE__, 0x00003319L,	"3319", "% x",
__LINE__, 0x00000000L,	"00", "%+#.2X",
__LINE__, -0x0000009L,	"-9", "% ld",
__LINE__, -0x0000001L,	"-1 ", "%-3ld",
__LINE__, 0x00262909L,	"2500873", "%.5ld",
__LINE__, 0x33e76560L,	"33e76560", "%7.0x",
__LINE__, -0x0000002L,	"-2", "%ld",
__LINE__, 0x00035ee9L,	"35EE9", "%-3.X",
__LINE__, -0x0000235L,	"-565", "%+4.ld",
__LINE__, -0x3ea63c5L,	"-65692613", "%d",
__LINE__, 0x00000003L,	"3", "%ld",
__LINE__, -0x003362fL,	"-210479", "% d",
__LINE__, -0x1a819f8aL,	"-444702602", "%.7d",
__LINE__, 0x027a4668L,	"41567848", "%d",
__LINE__, 0x0002b025L,	"2b025", "%x",
__LINE__, -0x0000001L,	"-001", "%.3ld",
__LINE__, 0xfffffff0L,	"fffffff0", "%-0x",
__LINE__, -0x0000d4fL,	"-3407", "%-ld",
__LINE__, 0x00000146L,	" 326", "% 1.d",
__LINE__, -0x0000006L,	"-6", "%d",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%06.4X",
__LINE__, 0x376fddaeL,	"+930078126", "%+#0ld",
__LINE__, 0x006d9da3L,	"6d9da3", "%1.x",
__LINE__, -0x0000f28L,	"-3880", "%3.2ld",
__LINE__, 0x0006962cL,	" 431660", "% 5d",
__LINE__, 0x000011dbL,	"  4571", "%6.ld",
__LINE__, 0xffffffa8L,	"ffffffa8", "%+x",
__LINE__, 0x0d886db3L,	"D886DB3", "%.7X",
__LINE__, 0x00000000L,	"000000", "%2.6ld",
__LINE__, 0xfffff6b6L,	"FFFFF6B6", "% X",
__LINE__, -0x0739068L,	"-7573608", "%+6.ld",
__LINE__, 0xfba62553L,	"0XFBA62553", "%#X",
__LINE__, -0x4474bc5L,	"-71781317", "%-2ld",
__LINE__, 0xffffff95L,	"FFFFFF95", "% 2.X",
__LINE__, -0x1d0e1caL,	"-30466506", "%+.0d",
__LINE__, -0x000f3aaL,	"-62378", "%ld",
__LINE__, 0x00000026L,	"26", "%1x",
__LINE__, 0x001c5400L,	"1856512", "%-#d",
__LINE__, 0x03808442L,	"3808442", "%X",
__LINE__, -0x0000081L,	"-129", "%+#ld",
__LINE__, 0x000004aeL,	" 1198", "% 3.4d",
__LINE__, -0x7f4ed54L,	"-133492052", "%d",
__LINE__, 0x00000000L,	"+0", "%+ld",
__LINE__, 0x00000000L,	"0", "%+x",
__LINE__, 0x004c7e46L,	"5013062", "%.0d",
__LINE__, -0x647d7a65L,	"-1685944933", "%0.2d",
__LINE__, 0x00003b59L,	"15193", "%-#1d",
__LINE__, 0xfff3e64dL,	"FFF3E64D", "%-X",
__LINE__, 0x00007022L,	"28706", "%-d",
__LINE__, 0xc28d0ad8L,	"c28d0ad8", "%+x",
__LINE__, -0x005c208L,	"-377352", "% ld",
__LINE__, 0x00cfbadcL,	"13613788", "%d",
__LINE__, 0x000016eaL,	"5866", "%0d",
__LINE__, 0x00000029L,	"29", "%X",
__LINE__, 0xffe16813L,	"0XFFE16813", "%+#X",
__LINE__, 0x00000004L,	"4", "%0X",
__LINE__, -0x0000096L,	" -150", "%5d",
__LINE__, 0x00027ac7L,	"162503", "%ld",
__LINE__, -0x0075de0L,	"-482784", "%d",
__LINE__, 0x005fcff6L,	"6279158", "%d",
__LINE__, 0xffffffefL,	"FFFFFFEF", "%3X",
__LINE__, 0x267b05ecL,	"645596652", "%4ld",
__LINE__, 0xa487b724L,	"a487b724", "%x",
__LINE__, 0x01da2a11L,	"31074833", "%-.0ld",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%X",
__LINE__, 0x0000037aL,	"37a", "%x",
__LINE__, 0x003d0314L,	"+3998484", "%+#1d",
__LINE__, 0x0000011bL,	"  283", "%5.2d",
__LINE__, 0x094f6066L,	"94f6066", "%x",
__LINE__, 0x00000004L,	"4", "%X",
__LINE__, -0x102e14bdL,	"-271455421", "% 7.ld",
__LINE__, 0x000048daL,	"0018650", "%07ld",
__LINE__, -0x24ae0390L,	"-615383952", "%0.6d",
__LINE__, 0xffff5159L,	"0XFFFF5159", "%#0X",
__LINE__, 0xfffd38c3L,	"fffd38c3", "%x",
__LINE__, 0xfffff9eaL,	"FFFFF9EA", "%-X",
__LINE__, -0x000fd28L,	"-64808", "% ld",
__LINE__, 0x002c1bf4L,	"2890740", "%-.1d",
__LINE__, 0x00d00ee7L,	"D00EE7", "%0.4X",
__LINE__, 0x00000cf9L,	"3321", "%0d",
__LINE__, -0x0000001L,	"-1", "%-#ld",
__LINE__, 0xfffffd75L,	"FFFFFD75", "%.2X",
__LINE__, 0x00000012L,	"18", "%-d",
__LINE__, 0xfd44b4b2L,	"fd44b4b2", "%+5.x",
__LINE__, -0x001c53fL,	"-116031", "%-#6.d",
__LINE__, 0x000ff6fdL,	"ff6fd", "%2x",
__LINE__, 0x00000001L,	"1", "%0d",
__LINE__, 0x0120b478L,	"120B478", "%.7X",
__LINE__, 0x0145591eL,	"145591E", "%1.4X",
__LINE__, 0x001f99b9L,	"1F99B9", "%.1X",
__LINE__, 0xffffd078L,	"ffffd078", "%-1.5x",
__LINE__, 0xffffff1aL,	"FFFFFF1A", "%-4.6X",
__LINE__, 0xfffffffaL,	"fffffffa", "%x",
__LINE__, -0x00000b9L,	"-185", "%3ld",
__LINE__, 0x00001cf0L,	"7408", "%-ld",
__LINE__, 0xffffffffL,	"FFFFFFFF", "%X",
__LINE__, 0x00151f30L,	"151F30", "%X",
__LINE__, -0x0000103L,	"-259", "%d",
__LINE__, -0x000303fL,	"-12351", "%d",
__LINE__, 0x000002caL,	"714", "%ld",
__LINE__, -0x0000c55L,	"-3157", "%1d",
__LINE__, 0x00000691L,	"01681", "%#.5ld",
__LINE__, 0x00230537L,	"2295095", "%#d",
__LINE__, 0x032a1faaL,	"53092266", "%.4d",
__LINE__, 0x000050d7L,	"20695", "%d",
__LINE__, -0x0c7ad4cL,	"-13086028", "%#.4ld",
__LINE__, -0x00009d9L,	"-2521", "%+d",
__LINE__, 0xfffffffeL,	"fffffffe", "%0x",
__LINE__, 0xffdec2d9L,	"FFDEC2D9", "%5.1X",
__LINE__, -0x000563cL,	"-22076", "%-.2ld",
__LINE__, 0x0073b36aL,	"0x73b36a", "%-#x",
__LINE__, 0xfffffffdL,	"fffffffd", "%x",
__LINE__, 0x0193ba5aL,	"193ba5a", "%1.x",
__LINE__, 0x00d147b5L,	"13715381", "%2.d",
__LINE__, 0xffffff10L,	"ffffff10", "%4x",
__LINE__, 0x000648d5L,	"648d5", "%1.3x",
__LINE__, 0x00000011L,	"11", "%X",
__LINE__, 0xff259f5bL,	"0xff259f5b", "% #.1x",
__LINE__, 0x00000175L,	"175", "%x",
__LINE__, 0x00000000L,	"0", "%ld",
__LINE__, 0x00000015L,	"21", "%#ld",
__LINE__, 0xfffffffeL,	"fffffffe", "%-x",
__LINE__, 0x00000013L,	" 19", "% 0ld",
__LINE__, -0x0000001L,	"-0000001", "% 5.7ld",
__LINE__, 0x0000139dL,	"139D", "%X",
__LINE__, 0x0041ad18L,	"41ad18", "%-.6x",
__LINE__, -0x00000f9L,	"-249", "% 3.d",
__LINE__, 0x00000076L,	"118", "%ld",
__LINE__, 0x000006f8L,	"1784", "%d",
__LINE__, -0x0000005L,	"-5", "%ld",
__LINE__, -0x00008e7L,	"-2279", "%+ld",
__LINE__, 0x00003f77L,	"3F77", "%+0X",
__LINE__, 0x000ca3f8L,	"0XCA3F8", "%+#X",
__LINE__, -0x00004bfL,	"-001215", "%#5.6ld",
__LINE__, 0x319129abL,	"0x319129ab", "%+#x",
__LINE__, -0x0000002L,	"-2", "%ld",
__LINE__, -0x0f6686eL,	"-16148590", "%.6ld",
__LINE__, 0x0329576bL,	"53041003", "%2.d",
__LINE__, -0x000179eL,	"-6046", "%d",
__LINE__, 0x000002ccL,	"+716", "%+1.3ld",
__LINE__, 0xfffffff7L,	"0xfffffff7", "% #x",
__LINE__, 0x0016eb40L,	"1502016", "%ld",
__LINE__, 0x00000003L,	"3", "%-0ld",
__LINE__, 0x0023e0d6L,	"23E0D6", "%-05.X",
__LINE__, 0xffffa6a4L,	"0XFFFFA6A4", "%#X",
__LINE__, 0x00087664L,	"87664", "% .2x",
__LINE__, -0x0000002L,	" -2", "%3.ld",
__LINE__, 0x003ad85dL,	"3AD85D", "%X",
__LINE__, 0x00002f20L,	"12064", "%ld",
__LINE__, 0x02030bfcL,	"2030BFC", "%02.3X",
__LINE__, 0xfffff36aL,	"FFFFF36A", "%X",
__LINE__, 0xfe0729ffL,	"0xfe0729ff", "% #.0x",
__LINE__, 0xfec15164L,	"FEC15164", "%0.2X",
__LINE__, -0x00169ecL,	"-92652", "%+d",
__LINE__, 0x006d7990L,	"0x6d7990", "%#x",
__LINE__, 0xffcc89e6L,	"ffcc89e6", "%x",
__LINE__, 0x002d7ccaL,	"2981066", "%7.7ld",
__LINE__, -0x1649692bL,	"-373909803", "%#ld",
__LINE__, 0x00664f47L,	"664f47", "%+6.x",
__LINE__, 0x00000000L,	"0", "% X",
__LINE__, 0x00000047L,	"000047", "%.6X",
__LINE__, 0x00000007L,	"0000007", "%.7ld",
__LINE__, 0x00000030L,	"30", "%-x",
__LINE__, -0x25bcbabbL,	"-633125563", "% ld",
__LINE__, 0xfe11c031L,	"FE11C031", "%4.6X",
__LINE__, -0x0000001L,	"-0000001", "%.7d",
__LINE__, 0x00b56d84L,	"11890052", "%ld",
__LINE__, -0x0000b01L,	"-0002817", "%+07.7ld",
__LINE__, 0xffffe4adL,	"ffffe4ad", "% 0.0x",
__LINE__, 0x007760fcL,	"7760fc", "%+x",
__LINE__, 0xffef44d8L,	"FFEF44D8", "%X",
__LINE__, 0xfcb6862eL,	"fcb6862e", "%+x",
__LINE__, -0x0000001L,	"-1", "%0d",
__LINE__, 0xffffffe6L,	"FFFFFFE6", "%3.1X",
__LINE__, 0xff816e27L,	"FF816E27", "% 6.X",
__LINE__, 0x00006415L,	"25621", "%ld",
__LINE__, -0xfae5449L,	"-263083081", "%0ld",
__LINE__, 0x00000001L,	" 1", "% 0d",
__LINE__, 0x00000009L,	" 9", "%2.X",
__LINE__, 0x002d7e18L,	"2981400", "%7d",
__LINE__, -0x00000fcL,	"-0000252", "%-#.7d",
__LINE__, 0x00000003L,	"3", "%0x",
__LINE__, 0x0d46e47fL,	"222749823", "%ld",
__LINE__, 0xfffcbc52L,	"FFFCBC52", "%+X",
__LINE__, 0x00000000L,	"0", "%-X",
__LINE__, 0xfffff0e5L,	"fffff0e5", "%x",
__LINE__, 0xffffffd9L,	"FFFFFFD9", "%07X",
__LINE__, 0x000004eeL,	"4ee", "%0x",
__LINE__, 0xffffffffL,	"ffffffff", "%0x",
__LINE__, -0x0008cb4L,	"-036020", "%+3.6ld",
__LINE__, 0x0000dadaL,	"0xdada", "%#0.x",
__LINE__, 0x0000001aL,	"26  ", "%-4d",
__LINE__, -0x000000cL,	" -12", "%04.d",
__LINE__, 0x0000025cL,	"    25c", "%7.x",
__LINE__, 0xfe9b091eL,	"FE9B091E", "%X",
__LINE__, 0x00000002L,	"      2", "%07.ld",
__LINE__, -0x0004930L,	"-18736", "% 6.d",
__LINE__, 0xffffffe9L,	"FFFFFFE9", "%X",
__LINE__, 0x00000003L,	" 3", "%2.ld",
__LINE__, 0x00000e00L,	"3584", "%.4d",
__LINE__, 0xffff38c2L,	"ffff38c2", "%0.x",
__LINE__, 0xffffffffL,	"FFFFFFFF", "% .3X",
__LINE__, 0xff7c1b2fL,	"FF7C1B2F", "%-3.2X",
__LINE__, -0x0000005L,	"-5", "%2d",
__LINE__, 0x00098775L,	"98775", "%x",
__LINE__, 0x000015ffL,	"  15FF", "%6.X",
__LINE__, 0xfffbe3efL,	"FFFBE3EF", "%0.3X",
__LINE__, -0x0000048L,	"-72", "%ld",
__LINE__, 0x0001488aL,	"84106", "%d",
__LINE__, 0x00000001L,	"1", "%x",
__LINE__, -0x0000002L,	"-2", "%-0.0ld",
__LINE__, -0x0000001L,	"-1", "%-d",
__LINE__, 0x0006616fL,	"6616f", "%x",
__LINE__, 0x3657856dL,	"911705453", "%6.d",
__LINE__, -0x0007222L,	"-0029218", "%.7d",
__LINE__, 0x00041606L,	"267782", "%04.5d",
__LINE__, 0x00000001L,	" 1", "%2.ld",
__LINE__, 0x00000219L,	"219", "%0x",
__LINE__, 0x0ae0184cL,	"ae0184c", "%x",
__LINE__, 0x00003a7dL,	"  14973", "%7.ld",
__LINE__, 0xffffffffL,	"0XFFFFFFFF", "%#X",
__LINE__, -0x0000002L,	"-2", "%0ld",
__LINE__, 0x00002cdfL,	"11487", "%0ld",
__LINE__, -0x000000cL,	"-12", "%d",
__LINE__, -0x000000eL,	"-14", "%-#2d",
__LINE__, 0x00000371L,	"881", "%#ld",
__LINE__, 0x000015beL,	" 5566", "%5.ld",
__LINE__, 0x01525b91L,	"22174609", "%#0.0ld",
__LINE__, 0xff8fc22fL,	"FF8FC22F", "% X",
__LINE__, -0x0007f7bL,	"-32635", "%4.ld",
__LINE__, 0x00007bcaL,	"7bca", "%x",
__LINE__, -0x0000582L,	"-1410", "%ld",
__LINE__, 0x00000047L,	" +71", "%+04.2d",
__LINE__, 0xf8a8dce2L,	"f8a8dce2", "%+.6x",
__LINE__, -0x000de2eL,	"-56878", "%.0d",
__LINE__, 0x019c03c1L,	"0X19C03C1", "%#X",
__LINE__, -0x0f3a43eL,	"-15967294", "%ld",
__LINE__, 0x00009e87L,	"40583", "%#5.1d",
__LINE__, 0x000000b8L,	"184", "%0ld",
__LINE__, -0x000befeL,	"-48894", "%2ld",
__LINE__, -0x002ee1aL,	"-192026", "%.2d",
__LINE__, 0x00004fd8L,	"4fd8", "%x",
__LINE__, 0x0006d57bL,	"447867", "%2d",
__LINE__, 0xfffffa9cL,	"FFFFFA9C", "%-X",
__LINE__, 0x0000000fL,	"15", "%ld",
__LINE__, 0x0005deb2L,	"5DEB2", "% X",
__LINE__, 0x00000007L,	"7", "%X",
__LINE__, 0xffffffc8L,	"0XFFFFFFC8", "% #.1X",
__LINE__, 0xfffff62fL,	"FFFFF62F", "%X",
__LINE__, -0x1a935bbaL,	"-445864890", "% 3.5d",
__LINE__, 0x000b34b4L,	"0x0b34b4", "%-#3.6x",
__LINE__, 0xfffff430L,	"FFFFF430", "%X",
__LINE__, 0x00000b5fL,	"+0002911", "%+#.7d",
__LINE__, 0x00000007L,	"  7", "%3ld",
__LINE__, 0xffffffd8L,	"FFFFFFD8", "% .7X",
__LINE__, 0xfffff544L,	"FFFFF544", "%0X",
__LINE__, -0x353667b9L,	"-892757945", "%d",
__LINE__, 0x00000058L,	"0x00058", "%+#.5x",
__LINE__, 0x39dbcc4aL,	"+970705994", "%+0.6ld",
__LINE__, 0xfffffffdL,	"fffffffd", "% 01x",
__LINE__, 0x00b1c28eL,	"+11649678", "%+0ld",
__LINE__, 0x000066c2L,	"0X66C2", "%-#4X",
__LINE__, 0x007171a2L,	"+7434658", "%+07.ld",
__LINE__, -0x0000001L,	"-1", "%-d",
__LINE__, 0x00000ae0L,	"+2784", "%+0d",
__LINE__, 0x13786a57L,	"326658647", "%#5d",
__LINE__, -0x0000001L,	"-1", "%2.ld",
__LINE__, -0x0168a16L,	"-1477142", "%d",
__LINE__, 0x12df7dd6L,	"316636630", "%ld",
__LINE__, 0x00000000L,	"000000", "%1.6d",
__LINE__, 0x266da2a9L,	"644719273", "%ld",
__LINE__, 0x0000004aL,	"74", "%d",
__LINE__, 0x000102ffL,	"00102FF", "%+06.7X",
__LINE__, 0x17916237L,	"0x17916237", "%#5x",
__LINE__, -0x0003cbbL,	"-0015547", "%-.7d",
__LINE__, 0xe7da2010L,	"e7da2010", "%2.4x",
__LINE__, 0xfffffff3L,	"fffffff3", "% .7x",
__LINE__, 0xfc9b64f8L,	"FC9B64F8", "% 7.X",
__LINE__, 0x000001afL,	"431", "%0d",
__LINE__, 0xffc81796L,	"0xffc81796", "%#.5x",
__LINE__, 0x057a1fbcL,	"+91889596", "%+04d",
__LINE__, 0x00001ae1L,	"6881", "%ld",
__LINE__, 0xfffffff6L,	"fffffff6", "%3.0x",
__LINE__, -0x6b7d5dbL,	"-112711131", "%-06.1d",
__LINE__, 0x008e8a5cL,	" 8e8a5c", "%7.0x",
__LINE__, 0xfe07a9bdL,	"fe07a9bd", "%.1x",
__LINE__, -0x00278e6L,	"-162022", "%0ld",
__LINE__, 0xf98709f5L,	"F98709F5", "%X",
__LINE__, -0x00000c9L,	"-201", "% 1.d",
__LINE__, -0x000001dL,	"-00029", "%+2.5ld",
__LINE__, 0x00000030L,	" 48", "% d",
__LINE__, 0xffd753f4L,	"FFD753F4", "%0X",
__LINE__, 0xfffffffdL,	"FFFFFFFD", "%X",
__LINE__, 0x0000a765L,	"a765", "%x",
__LINE__, 0x0026e2c8L,	"26E2C8", "%-0X",
__LINE__, -0x00003ebL,	"-1003", "%3.1ld",
__LINE__, 0x015d53caL,	"22893514", "%0ld",
__LINE__, -0x0000020L,	"-32", "%ld",
__LINE__, -0x03558ddL,	"-3496157", "%1.0ld",
__LINE__, -0x000007fL,	"-127", "%1.d",
__LINE__, 0xffffc737L,	"0xffffc737", "%+#x",
__LINE__, 0x0000a70dL,	"  a70d", "%6.x",
__LINE__, 0x01ea0e31L,	"0X1EA0E31", "% #1.X",
__LINE__, 0x00b5f406L,	"0X0B5F406", "%-#.7X",
__LINE__, 0x0e58fa9aL,	"240712346", "%.2d",
__LINE__, 0xf43ff8a9L,	"f43ff8a9", "%+0.6x",
__LINE__, -0x5d0d3d3L,	"-97571795", "%.3ld",
__LINE__, -0x000027aL,	"-634", "%0d",
__LINE__, 0xffcef248L,	"FFCEF248", "%07.X",
__LINE__, 0x000002dcL,	"2dc", "%0x",
__LINE__, -0x31fa6c1L,	"-52405953", "%.2d",
__LINE__, 0x00000014L,	"14", "%X",
__LINE__, -0x0282f98L,	"-2633624", "%ld",
__LINE__, 0x00005f55L,	"24405", "%#d",
__LINE__, -0x0000004L,	"-4", "%d",
__LINE__, 0x00000001L,	"1", "%+x",
__LINE__, 0x013f47ceL,	"13f47ce", "%0.x",
__LINE__, 0x00143fceL,	"1327054", "%.3d",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, 0x00001f9aL,	"1F9A", "% X",
__LINE__, 0x00000cf5L,	"cf5", "%x",
__LINE__, 0xffea9c24L,	"ffea9c24", "%x",
__LINE__, 0xf09f85a7L,	"F09F85A7", "%X",
__LINE__, 0x00001e04L,	"7684", "%ld",
__LINE__, 0xffffc82aL,	"ffffc82a", "%7x",
__LINE__, -0x0000a77L,	"-2679", "% d",
__LINE__, 0x0019a859L,	"+1681497", "%+2.6ld",
__LINE__, -0x00002d7L,	"-727", "%ld",
__LINE__, 0x00011b82L,	"72578", "%-#ld",
__LINE__, 0x00000c32L,	"3122", "%ld",
__LINE__, -0x0000337L,	"-823", "%1.d",
__LINE__, 0x00000004L,	"4", "%1ld",
__LINE__, 0x0000062cL,	"1580", "%.1ld",
__LINE__, 0xffffffd3L,	"FFFFFFD3", "% X",
__LINE__, -0x07b1bf8L,	"-8068088", "%#d",
__LINE__, 0xfffffff9L,	"fffffff9", "%x",
__LINE__, 0x159e6cfbL,	"159e6cfb", "%0.x",
__LINE__, 0x0001148dL,	"1148d", "%-.1x",
__LINE__, 0x003373b7L,	"3371959", "%#.0d",
__LINE__, 0x00001af2L,	"1af2", "%.4x",
__LINE__, -0x0000001L,	"-000001", "%+.6ld",
__LINE__, -0x00001a3L,	"-419", "%d",
__LINE__, 0xfdb232e7L,	"fdb232e7", "%5.4x",
__LINE__, -0x000000dL,	"-13", "%d",
__LINE__, 0x98ec1c74L,	"98ec1c74", "% 3x",
__LINE__, 0xfffffff8L,	"fffffff8", "%+1.4x",
__LINE__, -0x0000d58L,	"-3416", "%+#0ld",
__LINE__, -0x65d1973L,	"-106764659", "%.6d",
__LINE__, -0x0737641L,	"-7566913", "%-d",
__LINE__, 0x0000037cL,	"37c", "%+0x",
__LINE__, 0x0000012cL,	"0000300", "%#3.7d",
__LINE__, 0x00c12d9bL,	"12660123", "%1.5ld",
__LINE__, 0xe7e5e77dL,	"e7e5e77d", "%6x",
__LINE__, 0x1fe0e820L,	"1FE0E820", "%-4X",
__LINE__, 0xc85a793aL,	"C85A793A", "%X",
__LINE__, 0x05f9fe2cL,	"100269612", "%#ld",
__LINE__, 0x00000032L,	"0X32", "%+#4.1X",
__LINE__, 0xfab4ce81L,	"fab4ce81", "%3.x",
__LINE__, -0x0000009L,	"-9", "%2.d",
__LINE__, 0xffff8d2eL,	"ffff8d2e", "% 6x",
__LINE__, 0xfffffffeL,	"0xfffffffe", "%#x",
__LINE__, 0x02960f60L,	"2960f60", "%1.x",
__LINE__, 0x34cf3cbcL,	" 885996732", "% 5ld",
__LINE__, -0x000006eL,	"-110", "% d",
__LINE__, -0x0000001L,	"-1", "%-.0d",
__LINE__, 0x000000b1L,	"     B1", "%+7X",
__LINE__, 0xfffff5b4L,	"FFFFF5B4", "%01.7X",
__LINE__, 0x00000086L,	"86", "%0X",
__LINE__, 0x00074367L,	" 74367", "% 6x",
__LINE__, 0x001000d7L,	"+1048791", "%+ld",
__LINE__, 0x00000f35L,	" 3893", "% d",
__LINE__, -0x00000e1L,	"-225", "%d",
__LINE__, 0xffff6694L,	"FFFF6694", "%6.X",
__LINE__, 0x00019cf7L,	"19cf7", "%0.x",
__LINE__, 0x00000046L,	"0046", "%+.4X",
__LINE__, -0x000001fL,	"-31", "%ld",
__LINE__, 0xfff25859L,	"fff25859", "%6x",
__LINE__, 0x21884061L,	"562577505", "%#ld",
__LINE__, 0x01448b7aL,	"1448B7A", "%0.1X",
__LINE__, 0xffffffc0L,	"ffffffc0", "%x",
__LINE__, 0xfffffed5L,	"fffffed5", "% 1.0x",
__LINE__, 0x0e349767L,	"E349767", "%.5X",
__LINE__, 0x00000330L,	"816", "%0d",
__LINE__, -0x0000016L,	"-22", "%d",
__LINE__, 0xffff9babL,	"FFFF9BAB", "%X",
__LINE__, 0xffffee4eL,	"ffffee4e", "%x",
__LINE__, 0x0026beebL,	"2539243", "%6.d",
__LINE__, 0x00002c6cL,	"11372", "%.2d",
__LINE__, -0x000002cL,	"-44", "%ld",
__LINE__, -0x001dcfaL,	"-122106", "% d",
__LINE__, 0x0001683cL,	"92220", "%#4.ld",
__LINE__, 0x09b51fc9L,	"9b51fc9", "%+.7x",
__LINE__, 0x0000001dL,	"29", "%0ld",
__LINE__, -0x83f17e5L,	"-138352613", "%ld",
__LINE__, 0xfa4e2c1bL,	"fa4e2c1b", "%x",
__LINE__, 0x000001f3L,	"499", "%0ld",
__LINE__, 0xffff03e4L,	"ffff03e4", "%x",
__LINE__, 0x000000acL,	"+0172", "%+.4ld",
__LINE__, 0x03c3903bL,	"63148091", "%00d",
__LINE__, 0x0000000dL,	"13", "%#d",
__LINE__, 0x0000002eL,	"0X2E", "%#X",
__LINE__, 0x00006b2dL,	"6B2D", "%X",
__LINE__, 0x0000010bL,	"  0010b", "%7.5x",
__LINE__, 0x0000017aL,	" 17a", "%4x",
__LINE__, 0xfffffffbL,	"fffffffb", "%+x",
__LINE__, 0xffffac6aL,	"ffffac6a", "%-.3x",
__LINE__, -0x0005870L,	"-22640", "%0d",
__LINE__, 0x189c17bcL,	"189c17bc", "%x",
__LINE__, -0x01bbc38L,	"-1817656", "%#6.ld",
__LINE__, -0x3382b55L,	"-54012757", "%d",
__LINE__, -0x0000007L,	"-7", "%-ld",
__LINE__, -0x000c74bL,	"-51019", "%ld",
__LINE__, 0x0001a6f2L,	"+108274", "%+#1.ld",
__LINE__, 0x00077448L,	"77448", "%x",
__LINE__, 0x00000000L,	"0", "%x",
__LINE__, 0xfffff056L,	"FFFFF056", "%.3X",
__LINE__, -0x6f3f9451L,	"-1866437713", "%-#3.0ld",
__LINE__, 0x000000acL,	"AC", "%X",
__LINE__, 0xffc8752fL,	"ffc8752f", "%-x",
__LINE__, 0xfffffe6dL,	"FFFFFE6D", "%2.X",
__LINE__, -0x377f1a5L,	"-58192293", "% .2d",
__LINE__, -0x0000294L,	"-660", "%d",
__LINE__, 0xfffffffeL,	"fffffffe", "%-x",
__LINE__, 0xfffcbbe8L,	"0xfffcbbe8", "%-#4.x",
__LINE__, 0x0022e510L,	"+2286864", "%+ld",
__LINE__, 0xfffffe2aL,	"FFFFFE2A", "%0.3X",
__LINE__, 0xfe29f7c0L,	"fe29f7c0", "%x",
__LINE__, 0xfffe957eL,	"FFFE957E", "%X",
__LINE__, 0x000080f8L,	"33016", "%ld",
__LINE__, 0x0003ee2cL,	" 257580", "%7d",
__LINE__, 0x000003a1L,	"929", "%d",
__LINE__, 0x0000021fL,	"21f", "%+x",
__LINE__, 0xffffffffL,	"ffffffff", "%.5x",
__LINE__, -0x040a988L,	"-4237704", "%-d",
__LINE__, 0x027c8b69L,	"41716585", "%ld",
__LINE__, 0x00000003L,	"3", "%-X",
__LINE__, -0x0000368L,	"   -872", "%7.d",
__LINE__, 0x00000d3cL,	"3388", "%0.2d",
__LINE__, -0x33734ccL,	"-53949644", "%2ld",
__LINE__, 0x000003dbL,	"3DB", "%X",
__LINE__, -0x00f154dL,	"-988493", "%5d",
__LINE__, 0x0000000bL,	"  11", "%4.ld",
__LINE__, 0x00000067L,	"103", "%-ld",
__LINE__, -0x0199fceL,	"-1679310", "%4d",
__LINE__, 0x02b6266bL,	"2b6266b", "% x",
__LINE__, -0x006b39dL,	"-439197", "%+d",
__LINE__, 0x00000007L,	"7", "%ld",
__LINE__, 0x0141fc98L,	"21101720", "%0ld",
__LINE__, -0x0008420L,	"-33824", "%d",
__LINE__, 0x0011622bL,	"1139243", "%6ld",
__LINE__, 0x0000001bL,	"27", "%-d",
__LINE__, -0x0030935L,	"-198965", "%3d",
__LINE__, 0x0000001fL,	"  1f", "%4.x",
__LINE__, -0x10782a19L,	"-276310553", "%#ld",
__LINE__, -0x007eac4L,	"-518852", "%06.ld",
__LINE__, 0x0bc4c681L,	"197445249", "%6ld",
__LINE__, 0x000000f5L,	"245", "%.3ld",
__LINE__, 0x00000197L,	"197", "%X",
__LINE__, 0xfffffeabL,	"FFFFFEAB", "% X",
__LINE__, 0x00000f05L,	"F05", "%+X",
__LINE__, 0xffe1b785L,	"0xffe1b785", "%#x",
__LINE__, -0x02d3581L,	"-2962817", "%05d",
__LINE__, 0xffffb994L,	"FFFFB994", "%X",
__LINE__, 0x03d139a3L,	"64043427", "%ld",
__LINE__, -0x0000002L,	"  -2", "%+4.d",
__LINE__, -0x043da83L,	"-4446851", "%#ld",
__LINE__, -0x6aad891L,	"-111859857", "%7.ld",
__LINE__, 0x00003e68L,	"15976", "%-4.5ld",
__LINE__, 0xffe4d3eeL,	"FFE4D3EE", "%X",
__LINE__, 0x00000002L,	"000002", "%4.6ld",
__LINE__, 0xffffee32L,	"ffffee32", "%4x",
__LINE__, 0x0cb7dd25L,	"cb7dd25", "%3x",
__LINE__, 0xf773d422L,	"F773D422", "%X",
__LINE__, -0x0b590f7L,	"-11899127", "%#d",
__LINE__, -0x0002c45L,	"-11333", "%-#5ld",
__LINE__, -0x1efc9e4L,	"-32492004", "%ld",
__LINE__, -0x0003b9cL,	"-15260", "%d",
__LINE__, 0x000001b6L,	"0X1B6", "%#4X",
__LINE__, 0x3ce93ec3L,	"1021918915", "%.6d",
__LINE__, 0xffffffffL,	"ffffffff", "%-x",
__LINE__, 0xfffaf0e4L,	"fffaf0e4", "%2.x",
__LINE__, 0x00000002L,	"0x2", "%#x",
__LINE__, 0x0000e806L,	"e806", "%4x",
__LINE__, 0xfffffff0L,	"fffffff0", "% 2.x",
__LINE__, 0xfffffc0eL,	"fffffc0e", "%+.4x",
__LINE__, 0xfd45716eL,	"FD45716E", "%.4X",
__LINE__, 0xfff96fdaL,	"FFF96FDA", "%-X",
__LINE__, 0xff99d08aL,	"FF99D08A", "%.5X",
__LINE__, 0x00000002L,	"2", "%-00.d",
__LINE__, -0x000000fL,	"   -15", "%6.ld",
__LINE__, -0x00d321cL,	"-864796", "%#1ld",
__LINE__, 0xff19ff8dL,	"ff19ff8d", "%1.5x",
__LINE__, 0x00000000L,	"0000000", "%-.7x",
__LINE__, 0x0000f50dL,	" F50D", "%5X",
__LINE__, 0x00001688L,	"   5768", "%7.ld",
__LINE__, 0x00000157L,	"343", "%2ld",
__LINE__, 0xfffffffdL,	"0xfffffffd", "%+#3x",
__LINE__, 0x00000d52L,	"3410", "%ld",
__LINE__, 0x00000003L,	"3", "%d",
__LINE__, 0x0001c6d2L,	"01c6d2", "%.6x",
__LINE__, 0x242d65d2L,	"606954962", "%#7.ld",
__LINE__, 0x00000e9fL,	"0000E9F", "%5.7X",
__LINE__, 0x0002d785L,	"2D785", "%0X",
__LINE__, 0x00000167L,	"167", "%0X",
__LINE__, 0xfffff5e5L,	"fffff5e5", "% x",
__LINE__, 0xffb69a04L,	"0xffb69a04", "%#0.x",
__LINE__, 0xfffa012eL,	"FFFA012E", "%X",
__LINE__, 0x0000001aL,	"0x1a", "% #x",
__LINE__, 0xfffb26d3L,	"fffb26d3", "%+x",
__LINE__, -0x00003e6L,	"   -998", "%7ld",
__LINE__, 0x00000004L,	"4", "%-d",
__LINE__, 0xfffffd76L,	"0XFFFFFD76", "%#7X",
__LINE__, 0x00000035L,	"53", "%ld",
__LINE__, 0xffc6c190L,	"0XFFC6C190", "%#X",
__LINE__, 0xffffffe2L,	"ffffffe2", "%7.0x",
__LINE__, 0x03ff1b87L,	"67050375", "%2.d",
__LINE__, 0x00020c47L,	"0X20C47", "%#X",
__LINE__, 0x00000000L,	"0", "%d",
__LINE__, 0x0000000eL,	"0X000E", "% #.4X",
__LINE__, -0x00035cdL,	"-13773", "%+2.d",
__LINE__, 0x00005eecL,	"5eec", "%1x",
__LINE__, 0x001da0ffL,	"1941759", "%0d",
__LINE__, 0xf8a9e96aL,	"f8a9e96a", "%+x",
__LINE__, -0x0000120L,	"-288  ", "%-#6.d",
__LINE__, 0x00000000L,	"0", "%-X",
__LINE__, 0x0000152eL,	"152E", "%+X",
__LINE__, -0x0001077L,	"-4215", "% 0d",
__LINE__, 0xffffffd7L,	"FFFFFFD7", "%0X",
__LINE__, 0xfffe097dL,	"FFFE097D", "%2X",
__LINE__, 0xcb982712L,	"cb982712", "%x",
__LINE__, 0xfff39f2eL,	"FFF39F2E", "%.5X",
__LINE__, -0x0058caeL,	"-363694", "%+.1d",
__LINE__, -0x000002bL,	"-043", "%#1.3d",
__LINE__, -0x001e989L,	"-125321", "%1d",
__LINE__, 0x00959ecdL,	"9805517", "%d",
__LINE__, 0xf49df846L,	"F49DF846", "%+3X",
__LINE__, 0xfffffffdL,	"fffffffd", "%+.5x",
__LINE__, -0x000ac76L,	"-44150", "%3.ld",
__LINE__, 0x00000028L,	"  0028", "%06.4x",
__LINE__, 0x000003e8L,	"3E8", "%-02X",
__LINE__, 0x00000012L,	"012", "%.3X",
__LINE__, 0x00000006L,	"0X6", "%#X",
__LINE__, 0x00ef8479L,	"+15697017", "%+0.6d",
__LINE__, 0xffffffe8L,	"FFFFFFE8", "%-X",
__LINE__, 0x773a90f7L,	"773a90f7", "%3.5x",
__LINE__, 0x00096d44L,	"96D44", "%-X",
__LINE__, -0x08a3d96L,	"-9059734", "%ld",
__LINE__, -0x000001aL,	"-26", "%00.ld",
__LINE__, 0x32f57585L,	"32f57585", "% x",
__LINE__, 0x2825f175L,	"2825F175", "%X",
__LINE__, 0x000054ffL,	"21759", "%-2d",
__LINE__, -0x0266cdcL,	"-2518236", "%ld",
__LINE__, 0x0000031dL,	"0X31D", "%+#4X",
__LINE__, 0x0003fc99L,	"3fc99", "%x",
__LINE__, -0x0064624L,	"-411172", "%-#d",
__LINE__, 0x0001b2d9L,	"111321", "%-ld",
__LINE__, -0x000007cL,	"-124", "%#d",
__LINE__, 0xfffffffaL,	"FFFFFFFA", "%+X",
__LINE__, -0x007a5b8L,	"-501176", "%+ld",
__LINE__, 0x0213b583L,	"213B583", "%2.X",
__LINE__, 0xfff12e51L,	"FFF12E51", "%+X",
__LINE__, 0x00052403L,	"0336899", "%-0.7d",
__LINE__, 0xffffffffL,	"ffffffff", "%-04.4x",
__LINE__, 0x00000010L,	"0010", "%0.4X",
__LINE__, 0xffffffb5L,	"FFFFFFB5", "%-1.3X",
__LINE__, -0x0000001L,	"-1", "%d",
__LINE__, 0x0003a2d1L,	"3a2d1", "% x",
__LINE__, 0x00000424L,	"1060", "%0ld",
__LINE__, -0x0000078L,	"-120", "%1d",
__LINE__, 0x00000000L,	"0", "%ld",
__LINE__, 0x00000414L,	"1044", "%ld",
__LINE__, 0x00000072L,	"0x072", "%#5.3x",
__LINE__, 0x0000007aL,	"7A", "% X",
__LINE__, 0x081542a3L,	"135611043", "%0d",
__LINE__, 0xfffb4ce6L,	"fffb4ce6", "%4.6x",
__LINE__, 0x00002ab2L,	"2ab2", "%-1x",
__LINE__, 0x00000000L,	" 0", "% 2x",
__LINE__, 0xfffffa59L,	"FFFFFA59", "%2.X",
__LINE__, 0xffffe22bL,	"ffffe22b", "%-x",
__LINE__, 0xfffffd52L,	"FFFFFD52", "%+.2X",
__LINE__, 0x0000039fL,	"927", "%-d",
__LINE__, 0x0002dea6L,	"2dea6", "%0x",
__LINE__, 0x000216dbL,	"136923", "%ld",
__LINE__, 0x00000013L,	"19", "%0d",
__LINE__, 0x000047ccL,	"18380", "%2.2ld",
__LINE__, -0x0007d10L,	"-32016", "%d",
__LINE__, 0xff9af906L,	"FF9AF906", "%0X",
__LINE__, 0x02cfa224L,	"+47161892", "%+0.7d",
__LINE__, -0x0000022L,	"-34", "%1.d",
__LINE__, 0xfffffff0L,	"FFFFFFF0", "%-4X",
__LINE__, 0x00000029L,	"    41", "%6.ld",
__LINE__, 0xffffff76L,	"ffffff76", "%x",
__LINE__, 0x00000000L,	"0", "%+X",
__LINE__, 0x00000001L,	"1", "%d",
__LINE__, 0xfff6de5aL,	"FFF6DE5A", "%X",
__LINE__, 0x00000002L,	"2", "%ld",
__LINE__, 0x00000025L,	"25", "%+x",
__LINE__, 0xfffffffbL,	"FFFFFFFB", "%5.0X",
__LINE__, 0x0011bbb5L,	"1162165", "%0.0ld",
__LINE__, 0xfffcdc96L,	"0XFFFCDC96", "%#X",
__LINE__, 0x00008f5fL,	"8f5f", "%3.1x",
__LINE__, 0xffa0fa5dL,	"0XFFA0FA5D", "%#X",
__LINE__, 0x00004534L,	"4534", "% 0X",
__LINE__, 0xfffffff9L,	"fffffff9", "%.2x",
__LINE__, 0xffeeae50L,	"ffeeae50", "%-x",
__LINE__, 0x00002964L,	" 0010596", "% 0.7d",
__LINE__, 0x000021c9L,	"  21c9", "%6x",
__LINE__, 0x00000001L,	" 1", "% d",
__LINE__, 0x0002abd8L,	"+175064", "%+d",
__LINE__, 0xffffffadL,	"FFFFFFAD", "%+0X",
__LINE__, 0x00000003L,	"3", "%ld",
__LINE__, 0x0c036da3L,	" 201551267", "% .3d",
__LINE__, -0x004343cL,	"-275516", "%+ld",
__LINE__, 0x00000003L,	"003", "% .3x",
__LINE__, 0xffffe34eL,	"ffffe34e", "%x",
__LINE__, 0x0000e118L,	"e118", "%x",
__LINE__, -0x007d945L,	"-514373", "%+#0ld",
__LINE__, 0x277f1cc5L,	"277f1cc5", "% x",
__LINE__, 0x00003befL,	"03bef", "% 0.5x",
__LINE__, 0xfffffcb9L,	"fffffcb9", "%x",
__LINE__, 0x0003311aL,	"209178", "%ld",
__LINE__, 0x00000000L,	"   ", "%3.ld",
__LINE__, 0x05942225L,	"5942225", "%x",
__LINE__, 0xfffceb4cL,	"FFFCEB4C", "%-X",
__LINE__, 0xffd08633L,	"ffd08633", "%2.x",
__LINE__, -0x0000001L,	"    -1", "%6d",
__LINE__, 0x000fdb12L,	"1039122", "%d",
__LINE__, 0x00000003L,	"3", "% 0X",
__LINE__, -0x2fd5bf1L,	"-50158577", "% 5.ld",
__LINE__, -0x0089a03L,	"-563715", "%-d",
__LINE__, 0xfffffffeL,	"FFFFFFFE", "% X",
__LINE__, 0x29fdb2baL,	"29fdb2ba", "% 0x",
__LINE__, 0x0000008fL,	"8F", "% X",
__LINE__, 0x00000003L,	"3", "%ld",
__LINE__, 0xffc58445L,	"FFC58445", "%.2X",
__LINE__, -0x00023f6L,	"-9206", "%+d",
__LINE__, 0x00000011L,	"11", "%X",
__LINE__, -0x0000003L,	"-0000003", "%-.7d",
__LINE__, -0x0000003L,	"-3", "%#ld",
__LINE__, 0x001242d9L,	"1242D9", "%X",
__LINE__, -0x48d0c81L,	"-76352641", "%7.d",
__LINE__, -0x001b675L,	"-112245", "%#ld",
__LINE__, 0x00000003L,	"3", "%-d",
__LINE__, 0xfff93fdfL,	"0XFFF93FDF", "% #X",
__LINE__, 0x001a9414L,	"1741844", "%#ld",
__LINE__, 0x0001fd86L,	"130438", "%ld",
__LINE__, 0x010f37a8L,	"17774504", "%4.7d",
__LINE__, 0x00382838L,	"0382838", "%3.7X",
__LINE__, -0x47fd56c2L,	"-1207785154", "%ld",
__LINE__, 0x001981ddL,	"1981dd", "%x",
__LINE__, 0xffffefbaL,	"ffffefba", "% 06.x",
__LINE__, -0x3f402b29L,	"-1061169961", "%+#ld",
__LINE__, -0x395aae44L,	"-962244164", "%-1d",
__LINE__, 0x1fa39f42L,	"530816834", "%#d",
__LINE__, -0x000358dL,	"-13709", "%d",
__LINE__, -0xdc17b8fL,	"-230783887", "%ld",
__LINE__, -0x23c41583L,	"-600053123", "%+3.d",
__LINE__, 0xfffffc16L,	"fffffc16", "%x",
__LINE__, 0x003f1364L,	"4133732", "%7.ld",
__LINE__, 0xffffe691L,	"FFFFE691", "%07X",
__LINE__, 0x07b31d71L,	"129178993", "%.7d",
__LINE__, -0x0019732L,	"-104242", "% ld",
__LINE__, 0x02428167L,	"0x2428167", "%#x",
__LINE__, -0x06c1ecdL,	"-7085773", "%.7ld",
__LINE__, 0xfb01cb4eL,	"fb01cb4e", "%x",
__LINE__, 0x00005a41L,	"+23105", "%+ld",
__LINE__, 0xfffffff4L,	"FFFFFFF4", "%-5.X",
__LINE__, 0x00000005L,	"   5", "%4.ld",
__LINE__, 0xf4ab4b2dL,	"F4AB4B2D", "%0.X",
__LINE__, -0x000fce3L,	"-64739", "%+#3.ld",
__LINE__, 0x000076eaL,	" 30442", "%6.2ld",
__LINE__, 0x00000cb9L,	" cb9", "%4.x",
__LINE__, 0x002f43efL,	"3097583", "%1.1ld",
__LINE__, 0xf5bd0105L,	"F5BD0105", "%+X",
__LINE__, 0x0037954aL,	"3642698", "%d",
__LINE__, 0xfffffff7L,	"0XFFFFFFF7", "%-#X",
__LINE__, 0xffffcedfL,	"0xffffcedf", "%#6.7x",
__LINE__, 0xfffffde4L,	"FFFFFDE4", "%2.4X",
__LINE__, 0x01a6f103L,	"1a6f103", "%5.x",
__LINE__, 0x00000191L,	"    191", "%7.0X",
__LINE__, 0x00000003L,	"03", "% .2X",
__LINE__, -0xd4e3219L,	"-223228441", "%6.ld",
__LINE__, 0x00b0efbdL,	"11595709", "%d",
__LINE__, -0x00000eaL,	"-234", "%#3d",
__LINE__, 0x00000be8L,	"BE8  ", "%-5X",
__LINE__, 0xffffffffL,	"ffffffff", "%5.3x",
__LINE__, -0x267f8c6L,	"-40368326", "%d",
__LINE__, 0x000006edL,	"6ED", "%X",
__LINE__, 0xfdd6c9b6L,	"FDD6C9B6", "%X",
__LINE__, 0x0007ac29L,	"7ac29", "%-x",
__LINE__, 0x00000014L,	"14", "%2x",
__LINE__, 0x123ca563L,	"+305964387", "%+ld",
__LINE__, 0x00000004L,	"    4", "%5.d",
__LINE__, 0xffff877aL,	"ffff877a", "%x",
__LINE__, -0x00003e7L,	"-999", "%+0.3d",
__LINE__, 0x0a68ba6eL,	"a68ba6e", "%3.1x",
__LINE__, 0xfe29c810L,	"FE29C810", "%+X",
#endif

__LINE__, 0x00000000L,	"0", "%o",
__LINE__, 0000000123L,	"123", "%o",
__LINE__, 0000123456L,	"0123456", "%#o",
__LINE__, 0000123456L,	"00123456", "%#.8o",
__LINE__, 0000123456L,	"  00123456", "%#10.8o",
__LINE__, 0x00000123L,	"0x00123", "%#07x",

0,
};

int main()
{
    int errcount = 0;
    int testcount = 0;
#define BSIZE 1024
    char buffer[BSIZE];
    sprint_int_type *iptr;
#if defined(__cplusplus) && !defined(TEST_LIBIO)

    ostrstream sstr(buffer, BSIZE);

    for (iptr = sprint_ints; iptr->line; iptr++) {
	sstr.seekp(0);
	sstr.form(iptr->format_string, iptr->value);
	sstr << ends;
	if (strcmp(buffer, iptr->result) != 0) {
	    errcount++;
	    cerr << "Error in line " << iptr->line;
	    cerr << " using \"" << iptr->format_string;
	    cerr << "\".  Result is \"" << buffer << "\"; should be: \"";
	    cerr << iptr->result << "\".\n";
	}
	testcount++;
    }


    if (errcount == 0) {
	cerr << "Encountered no errors in " << testcount << " tests.\n";
	return 0;
    }
    else {
	cerr << "Encountered " << errcount << " errors in "
	    << testcount << " tests.\n";
	return 1;
    }
#else
    for (iptr = sprint_ints; iptr->line; iptr++) 
      {
	if (sizeof(int)==2) 
	  {
	    /* Cheezy, but effective. */
	    char buf[30];
	    int len = strlen(iptr->format_string);
	  
	    strcpy(buf, iptr->format_string);
	    if(buf[len-2] != 'l') {
	      buf[len] = buf[len-1];
	      buf[len-1] = 'l';
	      buf[len+1] = 0;
	    }
	    sprintf(buffer, buf, iptr->value);
	  }
	else
	  {
	sprintf(buffer, iptr->format_string, iptr->value);
	  }
	if (strcmp(buffer, iptr->result) != 0) {
	    errcount++;
	    fprintf(stderr,
    "Error in line %d using \"%s\".  Result is \"%s\"; should be: \"%s\".\n",
		    iptr->line, iptr->format_string, buffer, iptr->result);
	    fprintf(stderr,"%ld\n",iptr->value);
	}
	testcount++;
    }

    if (errcount == 0) {
	fprintf(stderr, "Encountered no errors in %d tests.\n", testcount);
	return 0;
    }
    else {
	fprintf(stderr, "Encountered %d errors in %d tests.\n",
		errcount, testcount);
	return 1;
    }
#endif
}
