/* ---
 * f77 bit functions.
 * are not part of f2c but heavily used by HEP code. CERNLIB includes them
 * however there are HEP programs linked without CERNLIB - so we have to
 * provide them again.
 * ----------------------------------------------------------------------
 * (C) Wolfgang Wander 1996
 */

unsigned
ibits_( unsigned *pattern, int *position, int *len )
{
  unsigned mask = ~(0xffffffff << (*len));
  return (*pattern >> *position) & mask;
}

#ifdef TEST
main( )
{
  int v,k;
  unsigned p;
  
  while( scanf("%x %d %d",&p,&v,&k) == 3 ) {
    printf("%x\n", ibits_(&p, &v, &k));
  }
}
#endif
